/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.j2c;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.ProviderFailureException;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.IdentityPrincipal;
import com.ibm.websphere.security.auth.MappingAuthData;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.audit.utils.DataHelper;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.j2c.WSAuthDataSubjectComparator;
import com.ibm.ws.security.auth.j2c.WSPrincipalMappingCallbackHandler;
import com.ibm.ws.security.common.auth.WSPrincipalImpl;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.cred.AuthDataCredential;
import com.ibm.ws.security.util.AuthData;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.ContextHandler;
import com.ibm.wsspi.security.auth.callback.WSMappingCallbackHandler;
import com.ibm.wsspi.security.auth.callback.WSMappingCallbackHandlerFactory;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;

public class WSDefaultPrincipalMapping {
    private static final TraceComponent tc;
    private static final WebSphereRuntimePermission perm;
    private static HashMap authDataPasswordCredentialSubjectMap;
    public static String DEFAULT_PRINCIPAL_MAPPING;
    public static String TRUSTED_CONNECTION_MAPPING;
    public static String KERBEROS_MAPPING;
    public static String UNAUTHENTICATED;
    private static boolean isFineGrained;
    private static WSMappingCallbackHandlerFactory cbkFactory;
    private static Subject unauthSubject;
    private static ContextHandler contextHandler;
    private static final String providerName = "WebSphere";
    private static final String componentName = "WAS.security";
    private static String activeUserRegistry;
    private static AuditService auditService;
    private static ConcurrentHashMap auditOutcome;
    private static boolean cacheReadOnlyAuthDataSubjects;
    private static int readOnlyAuthDataSubjectCacheSize;
    private static long cushion;
    private static final Class thisClass;

    private WSDefaultPrincipalMapping() {
        Tr.warning(tc, "security.j2c.invalidWSDefaultPrincipalMapping");
    }

    public static Subject getMappedSubject(ManagedConnectionFactory mcf, String loginConfig, Map properties) throws IOException, LoginException, SecurityException, Exception {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "getMappedSubject(ManagedConnectionFactory, " + loginConfig + ", Map properties)");
        }
        String mappingModule = loginConfig == null ? DEFAULT_PRINCIPAL_MAPPING : loginConfig.trim();
        boolean defaultPrincipalMapping = DEFAULT_PRINCIPAL_MAPPING.equals(mappingModule);
        boolean trustedConnectionMapping = TRUSTED_CONNECTION_MAPPING.equals(mappingModule);
        boolean kerberosMapping = KERBEROS_MAPPING.equals(mappingModule);
        if (isAnyTracingEnabled && tc.isDebugEnabled()) {
            if (defaultPrincipalMapping) {
                Tr.debug(tc, "defaultPrncipalMapping");
            } else if (trustedConnectionMapping) {
                Tr.debug(tc, "trustedConnectionMapping");
            } else if (kerberosMapping) {
                Tr.debug(tc, "kerberosMapping");
            } else {
                Tr.debug(tc, "unknown login config >>" + mappingModule + "<<");
            }
        }
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        if (auditService == null && (auditService = ctxMgr.getAuditService()) != null && (contextHandler = auditService.getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            auditService.processAuditFailure(msg, null);
        }
        String lastTrailId = null;
        String[] eventTrailIds = null;
        if (auditService != null) {
            lastTrailId = auditService.getLastTrailId();
            eventTrailIds = auditService.getEventTrailIds();
        }
        String authDataAlias = null;
        if (defaultPrincipalMapping || trustedConnectionMapping || kerberosMapping) {
            boolean isAliasEmpty;
            if (properties == null) {
                if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug(tc, "security.j2c.missingParameter", new Object[]{"properties"});
                }
            } else {
                if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                    Tr.entry(tc, "Getting authDataAlias.");
                }
                if ((authDataAlias = (String)properties.get("com.ibm.mapping.authDataAlias")) == null) {
                    if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                        Tr.debug(tc, "security.j2c.missingParameter", new Object[]{"alias"});
                    }
                } else {
                    authDataAlias = authDataAlias.trim();
                }
            }
            boolean bl = isAliasEmpty = authDataAlias == null || authDataAlias.equals("");
            if (!ctxMgr.isCellSecurityEnabled() && isAliasEmpty) {
                if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security disabled and no authdata alias, returning Unauthenticated Subject.");
                }
                if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMappedSubject");
                }
                return WSDefaultPrincipalMapping.getUnauthenticatedSubjectWithoutCredentials();
            }
            if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating Subject.");
            }
            WSCredential cred = null;
            Subject subject = new Subject();
            WSPrincipalImpl principal = null;
            String principal_name = null;
            try {
                cred = ctxMgr.getInvocationCredential();
            }
            catch (WSSecurityException e) {
                Tr.debug(tc, "Exception caught in getInvocationCredential. Continue: " + e);
                cred = null;
            }
            if (cred != null && cred.getExpiration() > 0L && cred.getExpiration() - System.currentTimeMillis() < cushion) {
                final Subject subj0 = ctxMgr.getInvocationSubject();
                try {
                    principal = (WSPrincipalImpl)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return subj0.getPrincipals(WSPrincipalImpl.class).iterator().next();
                        }
                    });
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (isAliasEmpty && principal == null) {
                    if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                        Tr.debug(tc, "No authdata alias and current Subject is null or unauthenticated.");
                    }
                    if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMappedSubject");
                    }
                    return WSDefaultPrincipalMapping.getUnauthenticatedSubjectWithoutCredentials();
                }
                if (principal != null) {
                    principal_name = principal.getName();
                } else {
                    principal_name = UNAUTHENTICATED;
                    principal = new WSPrincipalImpl(principal_name);
                }
            } else {
                if (isAliasEmpty && (cred == null || cred.isUnauthenticated())) {
                    if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                        Tr.debug(tc, "No authdata alias and current Subject is null or unauthenticated.");
                    }
                    if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMappedSubject");
                    }
                    return WSDefaultPrincipalMapping.getUnauthenticatedSubjectWithoutCredentials();
                }
                principal_name = cred != null && !cred.isUnauthenticated() ? cred.getSecurityName() : UNAUTHENTICATED;
                principal = new WSPrincipalImpl(principal_name);
            }
            if (principal != null && principal_name != null) {
                Subject cacheSubject = null;
                if (cacheReadOnlyAuthDataSubjects && defaultPrincipalMapping && authDataAlias != null && !authDataAlias.equals("")) {
                    WSAuthDataSubjectComparator comparator = new WSAuthDataSubjectComparator(principal_name, authDataAlias, mcf);
                    if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting Subject authData uniqueID: " + comparator.hashCode());
                    }
                    cacheSubject = (Subject)authDataPasswordCredentialSubjectMap.get(comparator);
                }
                if (cacheSubject == null) {
                    if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Did not find subject in the authDataPasswordCredentialSubjectMap cache.");
                    }
                    subject.getPrincipals().add(principal);
                } else {
                    if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found subject in the authDataPasswordCredentialSubjectMap cache.");
                    }
                    if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMappedSubject");
                    }
                    subject = cacheSubject;
                    return subject;
                }
            }
            String assertIdentity = null;
            if (trustedConnectionMapping) {
                if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating identity principal.");
                }
                IdentityPrincipal identityPrincipal = WSDefaultPrincipalMapping.getIdentityPrincipal(properties);
                identityPrincipal.setManagedConnectionFactory(mcf);
                subject.getPrincipals().add(identityPrincipal);
            }
            if (kerberosMapping) {
                Subject callerSubject = WSSubject.getCallerSubject();
                if (callerSubject != null) {
                    GSSCredential gssCredential = SubjectHelper.getGSSCredentialFromSubject(callerSubject);
                    KRBAuthnToken krbAuthnToken = SubjectHelper.getKerberosAuthnTokenFromSubject(callerSubject);
                    if (gssCredential != null) {
                        SubjectHelper.putGSSCredentialInSubject(gssCredential, subject);
                    }
                    if (krbAuthnToken != null) {
                        SubjectHelper.putKerberosAuthnTokenToSubject(krbAuthnToken, subject);
                    }
                    if (gssCredential != null || krbAuthnToken != null) {
                        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                            Tr.exit(tc, "getMappedSubject - GSSCredential/KRBAuthnToken");
                        }
                        return subject;
                    }
                    if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                        Tr.debug(tc, "No GSSCredential and KerberosTicket in caller subject, fall back to " + DEFAULT_PRINCIPAL_MAPPING);
                    }
                    defaultPrincipalMapping = true;
                } else {
                    if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                        Tr.debug(tc, "No caller subject, fall back to " + DEFAULT_PRINCIPAL_MAPPING);
                    }
                    defaultPrincipalMapping = true;
                }
            }
            if (isAliasEmpty) {
                if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No authdatalias, returning subject.");
                }
                if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMappedSubject");
                }
                return subject;
            }
            AuthData ad = null;
            try {
                ad = WSDefaultPrincipalMapping.getAuthDataInt(authDataAlias);
                if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got authdata info.");
                }
            }
            catch (NullPointerException e) {
                Tr.warning(tc, "security.j2c.mappingFailed", new Object[]{e});
                if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMappedSubject");
                }
                return subject;
            }
            if (ad == null) {
                Tr.warning(tc, "security.j2c.mappingUnsuccessful");
                throw new LoginException("Incorrect authDataEntry and alias is: " + authDataAlias);
            }
            if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating password credential.");
            }
            PasswordCredential passwordCredential = new PasswordCredential(ad.uid, ad.psw.toCharArray());
            passwordCredential.setManagedConnectionFactory(mcf);
            subject.getPrivateCredentials().add(passwordCredential);
            if (cacheReadOnlyAuthDataSubjects) {
                if (authDataPasswordCredentialSubjectMap.size() > readOnlyAuthDataSubjectCacheSize) {
                    authDataPasswordCredentialSubjectMap.clear();
                }
                if (principal_name != null && authDataAlias != null) {
                    WSAuthDataSubjectComparator comparator = new WSAuthDataSubjectComparator(principal_name, authDataAlias, mcf);
                    Hashtable<String, String> uniqueTable = new Hashtable<String, String>();
                    uniqueTable.put("com.ibm.wsspi.security.cred.cacheKey", Integer.toString(comparator.hashCode()));
                    if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting Subject authData uniqueID: " + comparator.hashCode());
                    }
                    subject.getPublicCredentials().add(uniqueTable);
                    subject.setReadOnly();
                    boolean success = false;
                    int attempts = 0;
                    do {
                        try {
                            authDataPasswordCredentialSubjectMap.put(comparator, subject);
                            success = true;
                        }
                        catch (ConcurrentModificationException e) {
                            if (!isAnyTracingEnabled || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Got a ConcurrentModificationException, retry a few times and then give up.");
                        }
                    } while (!success && ++attempts <= 5);
                }
            }
            if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN_MAPPING", "SUCCESS")) {
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                if (defaultPrincipalMapping) {
                    data = DataHelper.buildAccessData(loginConfig, "authMapping", ad.uid, principal_name, "mappingSuccess", null, null, new Long(0L), null, null, null, null);
                } else if (trustedConnectionMapping) {
                    data = DataHelper.buildAccessData(loginConfig, "authMapping", assertIdentity, principal_name, "mappingSuccess", null, null, new Long(0L), null, null, null, null);
                }
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), ctxMgr.getDefaultRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = activeUserRegistry == null ? DataHelper.buildRegistryData(null) : DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildAuthnMappingData(null, ctxMgr.getDefaultRealm(), principal_name);
                contextHandler.buildContextObject("AUTHN_MAPPING_CONTEXT", data);
                data = DataHelper.buildProviderData(loginConfig, "providerSuccess");
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 7L);
                try {
                    auditService.sendEvent("SECURITY_AUTHN_MAPPING", auditOutcome);
                }
                catch (ProviderFailureException e) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                    String msg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(msg, e);
                }
            }
            if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit(tc, "getMappedSubject");
            }
            return subject;
        }
        if (isAnyTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug(tc, "Logging into mapping module: " + mappingModule);
        }
        ManagedConnectionFactory fmcf = mcf;
        try {
            LoginContext lc = null;
            if (cbkFactory != null) {
                lc = new LoginContext(mappingModule, cbkFactory.getInstance().getCallbackHandler(properties, fmcf));
            } else {
                Tr.warning(tc, "security.j2c.initFailureRecovery");
                lc = new LoginContext(mappingModule, new WSMappingCallbackHandler(properties, fmcf));
            }
            lc.login();
            if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit(tc, "getMappedSubject(ManagedConnectionFactory, loginEntry, authDataAlias)");
            }
            if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN_MAPPING", "SUCCESS")) {
                WSCredential cred = null;
                try {
                    cred = ctxMgr.getInvocationCredential();
                }
                catch (WSSecurityException e) {
                    Tr.debug(tc, "Exception caught in getInvocationCredential. Continue: " + e);
                    cred = null;
                }
                String principal_name = null;
                String realm = ctxMgr.getDefaultRealm();
                if (cred != null && !cred.isUnauthenticated()) {
                    principal_name = cred.getSecurityName();
                }
                String mapped_id = null;
                String realmName = null;
                String origUser = null;
                byte[] opaqueToken = null;
                Subject subj = lc.getSubject();
                if (subj != null) {
                    PasswordCredential privateObject;
                    Iterator<?> privateCreds;
                    IdentityPrincipal privateObject2;
                    Class<?> identityPrincipalClass = Class.forName("com.ibm.websphere.security.auth.IdentityPrincipal");
                    Iterator<?> principals = subj.getPrincipals(identityPrincipalClass).iterator();
                    if (principals.hasNext() && (privateObject2 = (IdentityPrincipal)principals.next()) != null) {
                        mapped_id = privateObject2.getName();
                        realmName = privateObject2.getRealm();
                        origUser = privateObject2.getOriginalUser();
                        opaqueToken = privateObject2.getToken();
                    }
                    if (mapped_id == null && (privateCreds = subj.getPrivateCredentials(Class.forName("javax.resource.spi.security.PasswordCredential")).iterator()).hasNext() && (privateObject = (PasswordCredential)privateCreds.next()) != null) {
                        mapped_id = privateObject.getUserName();
                    }
                    if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                        Tr.debug(tc, "IdentityPrincipal current user identity  = " + mapped_id);
                        Tr.debug(tc, "IdentityPrincipal current user realm     = " + realmName);
                        Tr.debug(tc, "IdentityPrincipal original user identity = " + origUser);
                        if (opaqueToken != null) {
                            Tr.debug(tc, "IdentityPrincipal token length           = " + opaqueToken.length);
                        }
                    }
                }
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData(loginConfig, "authMapping", mapped_id, origUser, "mappingSuccess", null, null, new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), realm);
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildAuthnMappingData(null, realmName, mapped_id);
                contextHandler.buildContextObject("AUTHN_MAPPING_CONTEXT", data);
                data = DataHelper.buildProviderData(loginConfig, "providerSuccess");
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 7L);
                try {
                    auditService.sendEvent("SECURITY_AUTHN_MAPPING", auditOutcome);
                }
                catch (ProviderFailureException e) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                    String msg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(msg, e);
                }
            }
            if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning login subject.");
            }
            if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit(tc, "getMappedSubject");
            }
            return lc.getSubject();
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, thisClass, "com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping.getSubject", "351");
            if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught: " + ex);
            }
            throw ex;
        }
    }

    public static Subject getSubject(ManagedConnectionFactory mcf, String loginEntry, String uidpswEntry) throws IOException, LoginException, SecurityException, Exception {
        String mappingModule;
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubject(ManagedConnectionFactory, " + loginEntry + ", " + uidpswEntry + ")");
        }
        String authDataAlias = null;
        if (uidpswEntry != null) {
            authDataAlias = uidpswEntry.trim();
        }
        String string = mappingModule = loginEntry == null ? DEFAULT_PRINCIPAL_MAPPING : loginEntry.trim();
        if (mappingModule.equals(DEFAULT_PRINCIPAL_MAPPING)) {
            Subject subject = new Subject();
            final Subject subj0 = ContextManagerFactory.getInstance().getInvocationSubject();
            WSPrincipalImpl principal = null;
            try {
                principal = (WSPrincipalImpl)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return subj0.getPrincipals(WSPrincipalImpl.class).iterator().next();
                    }
                });
            }
            catch (Exception e) {
                // empty catch block
            }
            if (principal != null) {
                subject.getPrincipals().add(principal);
            }
            if (authDataAlias == null || authDataAlias.equals("")) {
                return subject;
            }
            AuthData ad = null;
            try {
                ad = WSDefaultPrincipalMapping.getAuthDataInt(authDataAlias);
            }
            catch (NullPointerException e) {
                Tr.warning(tc, "security.j2c.mappingFailed", new Object[]{e});
                return subject;
            }
            if (ad == null) {
                Tr.warning(tc, "security.j2c.mappingUnsuccessful");
                throw new LoginException("Incorrect authDataEntry and alias is: " + authDataAlias);
            }
            PasswordCredential passwordCredential = new PasswordCredential(ad.uid, ad.psw.toCharArray());
            passwordCredential.setManagedConnectionFactory(mcf);
            subject.getPrivateCredentials().add(passwordCredential);
            return subject;
        }
        ManagedConnectionFactory fmcf = mcf;
        try {
            LoginContext lc = null;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("com.ibm.mapping.authDataAlias", authDataAlias);
            if (cbkFactory != null) {
                lc = new LoginContext(mappingModule, cbkFactory.getInstance().getCallbackHandler(map, fmcf));
            } else {
                Tr.warning(tc, "security.j2c.initFailureRecovery");
                lc = new LoginContext(mappingModule, new WSPrincipalMappingCallbackHandler(authDataAlias, fmcf));
            }
            lc.login();
            if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit(tc, "getSubject(ManagedConnectionFactory, loginEntry, authDataAlias)");
            }
            return lc.getSubject();
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, thisClass, "com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping.getSubject", "351");
            if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught: " + ex);
            }
            throw ex;
        }
    }

    public static AuthDataCredential getAuthData(String uidpswEntry) throws LoginException, SecurityException {
        AuthData ad;
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug(tc, "getAuthData(uidpswEntry = " + uidpswEntry + ")");
        }
        if (uidpswEntry == null) {
            return null;
        }
        if (uidpswEntry.length() == 0) {
            return null;
        }
        try {
            ad = WSDefaultPrincipalMapping.getAuthDataInt(uidpswEntry);
        }
        catch (NullPointerException e) {
            return new AuthDataCredential(null, null, 3);
        }
        if (ad != null) {
            return new AuthDataCredential(ad.uid, ad.psw, 0);
        }
        if (isAnyTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug(tc, "Alias not defined on server; local search not enabled or auth.data.props not loaded.");
        }
        return new AuthDataCredential(null, null, 1);
    }

    public static void refreshAuthData(HashMap map) throws SecurityException {
        boolean isAnyTracingEnabled;
        block16: {
            SecurityManager sm;
            isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
            if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                Tr.entry(tc, "refreshAuthData", map);
            }
            if ((sm = System.getSecurityManager()) != null) {
                if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + perm.toString());
                }
                sm.checkPermission(perm);
            }
            try {
                if (map != null && !map.isEmpty()) {
                    if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Mapping auth data has " + map.size() + " entries");
                    }
                    Set ks = map.keySet();
                    Iterator i = ks.iterator();
                    Class<?> internal = Class.forName("com.ibm.ws.security.util.AuthData");
                    Class<?> external = Class.forName("com.ibm.websphere.security.auth.MappingAuthData");
                    while (i.hasNext()) {
                        Object value;
                        Object key = i.next();
                        if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Mapping auth data alias = " + key);
                        }
                        if ((value = map.get(key)) == null) continue;
                        if (external.isInstance(value)) {
                            if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Mapping auth data Class is MappingAuthData");
                            }
                            map.put(key, new AuthData(((MappingAuthData)value).getUserName(), ((MappingAuthData)value).getPassword()));
                            continue;
                        }
                        if (internal.isInstance(value)) continue;
                        if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Mapping auth data Class is neither AuthData nor MappingAuthData; set to null");
                        }
                        map.put(key, null);
                    }
                }
            }
            catch (Exception ex) {
                Manager.Ffdc.log(ex, thisClass, "com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping.refreshAuthData", "569");
                if (!isAnyTracingEnabled || !tc.isDebugEnabled()) break block16;
                Tr.debug(tc, "Exception caught: " + ex);
            }
        }
        if (map != null) {
            SecurityObjectLocator.getSecurityConfig().getJAASLoginConfig().refreshAuthDataEntries(map);
        } else {
            SecurityObjectLocator.getSecurityConfig("Security").getJAASLoginConfig().refreshAuthDataEntries(map);
            SecurityConfig domainConfig = SecurityObjectLocator.getSecurityConfig("AppSecurity");
            if (domainConfig != null) {
                domainConfig.getJAASLoginConfig().refreshAuthDataEntries(map);
            }
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshAuthData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthData getAuthDataInt(String uidpswEntry) throws SecurityException {
        SecurityManager sm;
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug(tc, "get one AuthDataEntry: getAuthDataInt(uidpswEntry = " + uidpswEntry + ")");
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (!isFineGrained) {
                if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + perm.toString());
                }
                sm.checkPermission(perm);
            } else {
                WebSphereRuntimePermission fgperm = new WebSphereRuntimePermission("getPasswordCredential." + uidpswEntry);
                if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check (Fine Grained) ...");
                    Tr.debug(tc, "Expecting : " + fgperm.toString());
                }
                sm.checkPermission(fgperm);
            }
        }
        AuthData value = (AuthData)SecurityObjectLocator.getSecurityConfig().getJAASLoginConfig().getAuthData(uidpswEntry);
        boolean pushed = false;
        if (value == null && SecurityObjectLocator.getSecurityConfigManager().isMultiDomainDefined()) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "<getAuthDataInt> attempting to retrieve authn alias from the domain config.");
                }
                pushed = false;
                pushed = SecurityObjectLocator.pushAppContext("");
                value = (AuthData)SecurityObjectLocator.getSecurityConfig().getJAASLoginConfig().getAuthData(uidpswEntry);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "<getAuthDataInt> unexpected exception getting domain-level authentication alias for");
                }
            }
            finally {
                if (pushed) {
                    SecurityObjectLocator.popContext();
                }
            }
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthDataInt");
        }
        return value;
    }

    private static Subject getUnauthenticatedSubjectWithoutCredentials() {
        if (unauthSubject == null) {
            unauthSubject = new Subject();
            WSPrincipalImpl principal = new WSPrincipalImpl("UNAUTHENTICATED");
            unauthSubject.getPrincipals().add(principal);
        }
        return unauthSubject;
    }

    public static IdentityPrincipal getIdentityPrincipal(Map properties) throws WSSecurityException, CredentialDestroyedException, WSLoginFailedException, ClassNotFoundException, CredentialExpiredException {
        boolean useCallerIdentity = false;
        boolean propagateSecAttrs = false;
        WSCredential cred = null;
        Subject assertSubject = null;
        String realmName = null;
        String origUser = null;
        String assertIdentity = null;
        byte[] opaqueToken = null;
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting useCallerIdentity.");
        }
        String s = (String)properties.get("com.ibm.mapping.useCallerIdentity");
        String t = "true";
        if (s != null) {
            s = s.trim();
            useCallerIdentity = t.equalsIgnoreCase(s);
        }
        if (useCallerIdentity) {
            if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug(tc, "useCallerIdentity is true");
            }
        } else if (isAnyTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug(tc, "useCallerIdentity is either false or not specified");
        }
        if (isAnyTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting propagateSecAttrs.");
        }
        if ((s = (String)properties.get("com.ibm.mapping.propagateSecAttrs")) != null) {
            s = s.trim();
            propagateSecAttrs = t.equalsIgnoreCase(s);
        }
        if (propagateSecAttrs) {
            if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug(tc, "propagateSecAttrs is true");
            }
        } else if (isAnyTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug(tc, "propagateSecAttrs is either false or not specified");
        }
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        cred = ctxMgr.getInvocationCredential();
        String principalName = null;
        if (useCallerIdentity) {
            Iterator<?> pCreds;
            assertSubject = ctxMgr.getCallerSubject();
            if (assertSubject != null && (pCreds = assertSubject.getPublicCredentials(Class.forName("com.ibm.websphere.security.cred.WSCredential")).iterator()) != null && pCreds.hasNext()) {
                cred = (WSCredential)pCreds.next();
            }
        } else {
            assertSubject = ctxMgr.getInvocationSubject();
        }
        if (cred != null && !cred.isUnauthenticated()) {
            principalName = cred.getSecurityName();
            realmName = cred.getRealmName();
            if (principalName != null) {
                int iu = principalName.indexOf(UNAUTHENTICATED);
                if (iu > -1 && iu < principalName.length()) {
                    assertIdentity = new String((String)properties.get("com.ibm.mapping.unauthenticatedUser"));
                } else {
                    assertIdentity = principalName;
                    int index = assertIdentity.indexOf(47);
                    if (index > -1 && index < assertIdentity.length()) {
                        assertIdentity = assertIdentity.substring(index + 1);
                    }
                }
            } else {
                assertIdentity = (String)properties.get("com.ibm.mapping.unauthenticatedUser");
            }
        } else {
            assertIdentity = (String)properties.get("com.ibm.mapping.unauthenticatedUser");
        }
        assertIdentity = assertIdentity == null || assertIdentity != null && assertIdentity.length() == 0 ? UNAUTHENTICATED : assertIdentity.trim();
        String targetRealm = (String)properties.get("com.ibm.mapping.targetRealmName");
        if (targetRealm != null) {
            if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug(tc, "targetRealm is \"" + targetRealm + "\" length = " + targetRealm.length());
            }
        } else if (isAnyTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug(tc, "targetRealm is either null or undefined");
        }
        if (targetRealm != null && targetRealm.length() > 0) {
            targetRealm = targetRealm.trim();
        }
        if (targetRealm != null && targetRealm.length() == 0) {
            targetRealm = null;
        }
        if (targetRealm == null || targetRealm.equals("") || targetRealm.equals("\"\"")) {
            if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug(tc, "targetRealm is null, setting current realm to null.");
            }
            realmName = null;
        } else if (targetRealm != null && realmName != null && targetRealm.length() > 0 && realmName.length() > 0 && targetRealm.equalsIgnoreCase(realmName)) {
            if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug(tc, "targetRealm is identical to current realm = " + targetRealm);
            }
            realmName = null;
        }
        origUser = WSSecurityHelper.getFirstCaller();
        if (origUser == null) {
            origUser = UNAUTHENTICATED;
        }
        if (assertSubject != null && propagateSecAttrs) {
            ctxMgr.renew(assertSubject, 50, false);
            opaqueToken = WSOpaqueTokenHelper.getInstance().createOpaqueTokenFromSubject(assertSubject);
        }
        IdentityPrincipal identityPrincipal = new IdentityPrincipal(assertIdentity, realmName, origUser, opaqueToken);
        if (isAnyTracingEnabled && tc.isDebugEnabled()) {
            Tr.debug(tc, "current user identity  = " + assertIdentity);
            Tr.debug(tc, "current user realm     = " + realmName);
            Tr.debug(tc, "original user identity = " + origUser);
            Tr.debug(tc, "propagate security attributes = " + propagateSecAttrs);
            if (opaqueToken != null) {
                Tr.debug(tc, "opaque token length = " + opaqueToken.length);
            } else {
                Tr.debug(tc, "opaque token is null");
            }
        }
        return identityPrincipal;
    }

    public static Map getDefaultTrustedConnectionProperties() {
        HashMap<String, String> m = new HashMap<String, String>(4);
        m.put("com.ibm.mapping.useCallerIdentity", "false");
        m.put("com.ibm.mapping.propagateSecAttrs", "false");
        m.put("com.ibm.mapping.targetRealmName", null);
        m.put("com.ibm.mapping.unauthenticatedUser", UNAUTHENTICATED);
        return m;
    }

    static {
        block10: {
            tc = Tr.register(WSDefaultPrincipalMapping.class, null, "com.ibm.ejs.resources.security");
            perm = new WebSphereRuntimePermission("getPasswordCredential");
            authDataPasswordCredentialSubjectMap = new HashMap();
            DEFAULT_PRINCIPAL_MAPPING = "DefaultPrincipalMapping";
            TRUSTED_CONNECTION_MAPPING = "TrustedConnectionMapping";
            KERBEROS_MAPPING = "KerberosMapping";
            UNAUTHENTICATED = "UNAUTHENTICATED";
            isFineGrained = false;
            cbkFactory = null;
            unauthSubject = null;
            contextHandler = null;
            activeUserRegistry = null;
            auditService = null;
            auditOutcome = new ConcurrentHashMap();
            cacheReadOnlyAuthDataSubjects = false;
            readOnlyAuthDataSubjectCacheSize = 50;
            cushion = 180000L;
            thisClass = WSDefaultPrincipalMapping.class;
            try {
                SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
                isFineGrained = security2.getBoolean("enforceFineGrainedJCASecurity");
                String cbkFactoryName = security2.getProperty("security.mappingCallbackHandlerFactoryClass");
                cbkFactory = WSMappingCallbackHandlerFactory.getInstance(cbkFactoryName);
                long cushionValue = 0L;
                try {
                    String cushionStr = security2.getProperty("com.ibm.ws.security.cacheCushionMin");
                    cushionValue = Integer.valueOf(cushionStr) * 60 * 1000;
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (cushionValue != 0L) {
                    cushion = cushionValue;
                }
                String readOnlyAuthDataSubjectCacheSizeProperty = null;
                if (security2 == null) break block10;
                cacheReadOnlyAuthDataSubjects = security2.getPropertyBool("com.ibm.websphere.security.auth.j2c.cacheReadOnlyAuthDataSubjects");
                if (cacheReadOnlyAuthDataSubjects) {
                    System.setProperty("security.CacheCushionMin", "true");
                }
                readOnlyAuthDataSubjectCacheSizeProperty = security2.getProperty("com.ibm.websphere.security.auth.j2c.readOnlyAuthDataSubjectCacheSize");
                try {
                    if (readOnlyAuthDataSubjectCacheSizeProperty != null) {
                        readOnlyAuthDataSubjectCacheSize = Integer.parseInt(readOnlyAuthDataSubjectCacheSizeProperty);
                    }
                }
                catch (NumberFormatException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception parsing com.ibm.websphere.security.auth.j2c.readOnlyAuthDataSubjectCacheSize value of " + readOnlyAuthDataSubjectCacheSizeProperty + ".  Setting the default cache sizing to 50.");
                    }
                    readOnlyAuthDataSubjectCacheSize = 50;
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping.static", "133");
                Tr.error(tc, "security.j2c.initFailure", new Object[]{e});
            }
        }
    }
}

