/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.callback;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.FFDC_OMIT;
import com.ibm.security.auth.callback.CcacheFileTextInputCallback;
import com.ibm.security.auth.callback.DefaultCcacheTextInputCallback;
import com.ibm.websphere.security.auth.callback.WSAuthMechOidCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSIdentityCallback;
import com.ibm.wsspi.security.auth.callback.WSProtocolPolicyCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WSCallbackHandler
implements CallbackHandler {
    private String userName = null;
    @FFDC_OMIT
    private String password = null;
    private String realm = null;
    private String authMechOid = null;
    private String _defaultCcache = null;
    private String _ccacheFile = null;
    private byte[] credToken = null;
    private X509Certificate[] certChain;
    private Map _appContext = null;
    private HttpServletRequest _req = null;
    private HttpServletResponse _resp = null;
    private String _identity = null;
    private List _tokenHolderList = null;
    private Object _protocolPolicy = null;
    private static final TraceComponent tc = Tr.register(WSCallbackHandler.class, null, "com.ibm.ejs.resources.security");

    public WSCallbackHandler(String userName, String password) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandler(userName = \"" + userName + "\", password = \"********\")");
        }
        this.userName = userName;
        this.password = password;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WsCallbackHandler(userName, password)");
        }
    }

    public WSCallbackHandler(String userName, String realmName, String password) {
        this(userName, password);
        this.realm = realmName;
    }

    public WSCallbackHandler(String userName, String realmName, String ccacheFile, String defaultCcache) {
        this.userName = userName;
        this.realm = realmName;
        this._ccacheFile = ccacheFile;
        this._defaultCcache = defaultCcache;
    }

    public WSCallbackHandler(String userName, String realmName, String password, List tokenHolderList) {
        this(userName, password);
        this.realm = realmName;
        this._tokenHolderList = tokenHolderList;
    }

    public WSCallbackHandler(String userName, String realmName, String password, HttpServletRequest req, HttpServletResponse resp, Map appContext) {
        this(userName, password);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandler(userName, realmName = " + realmName + " ,password, req, resp, appContext)");
        }
        this._req = req;
        this._resp = resp;
        this._appContext = appContext;
        this.realm = realmName;
    }

    public WSCallbackHandler(String userName, String realmName, List tokenHolderList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandler(userName, realmName, tokenHolderList)");
        }
        this.userName = userName;
        this.realm = realmName;
        this._tokenHolderList = tokenHolderList;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCallbackHandler(userName, realmName, tokenHolderList)");
        }
    }

    public WSCallbackHandler(byte[] credToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandler(credToken)");
        }
        this.credToken = CredentialsHelper.copyCredToken(credToken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCallbackHandler(credToken)");
        }
    }

    public WSCallbackHandler(byte[] credToken, String authMechOid) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandler(credToken, authMechOid) " + authMechOid);
        }
        this.credToken = CredentialsHelper.copyCredToken(credToken);
        this.authMechOid = authMechOid;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCallbackHandler(credToken, authMechOid)");
        }
    }

    public WSCallbackHandler(byte[] credToken, HttpServletRequest req, HttpServletResponse resp, List tokenHolderList, Map appContext, String authMechOid) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandler(credToken, req, resp, tokenHolderList, appContext, authMechOid).  req, resp, appContext, authMechOid: " + new Object[]{req, resp, appContext, authMechOid});
        }
        this.credToken = CredentialsHelper.copyCredToken(credToken);
        if (req != null) {
            this._req = req;
        }
        if (resp != null) {
            this._resp = resp;
        }
        if (tokenHolderList != null) {
            this._tokenHolderList = tokenHolderList;
        }
        if (appContext != null) {
            this._appContext = appContext;
        }
        if (authMechOid != null) {
            this.authMechOid = authMechOid;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCallbackHandler(credToken, req, resp, tokenHolderList, appContext, authMechOid)");
        }
    }

    public WSCallbackHandler(byte[] credToken, HttpServletRequest req, HttpServletResponse resp, Map appContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandler(credToken, req, resp, appContext)");
        }
        this.credToken = CredentialsHelper.copyCredToken(credToken);
        this._req = req;
        this._resp = resp;
        this._appContext = appContext;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCallbackHandler(credToken, req, resp, appContext)");
        }
    }

    public WSCallbackHandler(byte[] credToken, HttpServletRequest req, HttpServletResponse resp, Map appContext, List tokenHolderList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandler(credToken, req, resp, appContext, tokenHolderList)");
        }
        this.credToken = CredentialsHelper.copyCredToken(credToken);
        this._req = req;
        this._resp = resp;
        this._appContext = appContext;
        this._tokenHolderList = tokenHolderList;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCallbackHandler(credToken, req, resp, appContext, tokenHolderList)");
        }
    }

    public WSCallbackHandler(byte[] credToken, List tokenHolderList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandler(credToken, tokenHolderList)");
        }
        this.credToken = CredentialsHelper.copyCredToken(credToken);
        this._tokenHolderList = tokenHolderList;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCallbackHandler(credToken, tokenHolderList)");
        }
    }

    public WSCallbackHandler(byte[] credToken, List tokenHolderList, String authMechOid) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandler(credToken, tokenHolderList, authMechOid) " + authMechOid);
        }
        this.credToken = CredentialsHelper.copyCredToken(credToken);
        this._tokenHolderList = tokenHolderList;
        this.authMechOid = authMechOid;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCallbackHandler(credToken, tokenHolderList, authMechOid)");
        }
    }

    public WSCallbackHandler(Object policy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandler(protocolPolicy)");
        }
        this._protocolPolicy = policy;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCallbackHandler(protocolPolicy)");
        }
    }

    public WSCallbackHandler(String realmName, X509Certificate[] chain) {
        this.realm = realmName;
        this.certChain = chain;
    }

    public WSCallbackHandler(String realmName, X509Certificate[] chain, List tokenHolderList) {
        this.realm = realmName;
        this.certChain = chain;
        this._tokenHolderList = tokenHolderList;
    }

    public WSCallbackHandler(String realmName, X509Certificate[] chain, HttpServletRequest req, HttpServletResponse resp, Map appContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandler(realmName,certChain = " + realmName + " ,certChain, req, resp, appContext)");
        }
        this.realm = realmName;
        this.certChain = chain;
        this._req = req;
        this._resp = resp;
        this._appContext = appContext;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        int len = 0;
        if (callbacks == null || (len = callbacks.length) == 0) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handle(callbacks = \"{ }\")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handle(callbacks)");
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("{ ");
            for (int i = 0; i < len; ++i) {
                sb.append(callbacks[i].getClass().getName());
                if (i >= len - 1) continue;
                sb.append(", ");
            }
            sb.append(" }");
            Tr.entry(tc, "handle(callbacks = \"" + sb.toString() + "\")");
        }
        for (int i = 0; i < len; ++i) {
            Callback c = callbacks[i];
            if (c instanceof NameCallback) {
                ((NameCallback)c).setName(this.userName);
                continue;
            }
            if (c instanceof PasswordCallback) {
                ((PasswordCallback)c).setPassword(this.password == null ? null : this.password.toCharArray());
                continue;
            }
            if (c instanceof WSCredTokenCallbackImpl) {
                ((WSCredTokenCallbackImpl)c).setCredToken(this.credToken);
                continue;
            }
            if (c instanceof WSRealmNameCallbackImpl) {
                ((WSRealmNameCallbackImpl)c).setRealmName(this.realm);
                continue;
            }
            if (c instanceof WSAppContextCallback) {
                ((WSAppContextCallback)c).setContext(this._appContext);
                continue;
            }
            if (c instanceof WSIdentityCallback) {
                ((WSIdentityCallback)c).setClientIdentity(this._identity);
                continue;
            }
            if (c instanceof WSServletRequestCallback) {
                ((WSServletRequestCallback)c).setHttpServletRequest(this._req);
                continue;
            }
            if (c instanceof WSServletResponseCallback) {
                ((WSServletResponseCallback)c).setHttpServletResponse(this._resp);
                continue;
            }
            if (c instanceof WSTokenHolderCallback) {
                ((WSTokenHolderCallback)c).setTokenHolderList(this._tokenHolderList);
                continue;
            }
            if (c instanceof WSProtocolPolicyCallback) {
                ((WSProtocolPolicyCallback)c).setProtocolPolicy(this._protocolPolicy);
                continue;
            }
            if (c instanceof WSX509CertificateChainCallback) {
                ((WSX509CertificateChainCallback)c).setX509CertificateChain(this.certChain);
                continue;
            }
            if (c instanceof WSAuthMechOidCallbackImpl) {
                ((WSAuthMechOidCallbackImpl)c).setAuthMechOid(this.authMechOid);
                continue;
            }
            if (c instanceof DefaultCcacheTextInputCallback) {
                ((DefaultCcacheTextInputCallback)c).setText(this._defaultCcache);
                continue;
            }
            if (c instanceof CcacheFileTextInputCallback) {
                ((CcacheFileTextInputCallback)c).setText(this._ccacheFile);
                continue;
            }
            throw new UnsupportedCallbackException(c, "Unsupported callback");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(callbacks)");
        }
    }
}

