/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;

public class showAuditLogEncryptionInfo
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(showAuditLogEncryptionInfo.class, "showAuditLogEncryptionInfo", "com.ibm.ws.security.audit.tools");
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    String fileName = null;

    public showAuditLogEncryptionInfo(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public showAuditLogEncryptionInfo(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.fileName = (String)this.getParameter("fileName");
        if (this.fileName == null || this.fileName != null && this.fileName.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidBinaryAuditLog", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        String outputStream = new String();
        try {
            FileReader file_reader = new FileReader(this.fileName);
            BufferedReader buffered_reader = new BufferedReader(file_reader);
            String s = new String();
            while ((s = buffered_reader.readLine()) != null && !s.contains("End Display Current Environment")) {
            }
            boolean encryptedLog = false;
            boolean foundCertAlias = false;
            boolean foundKeyStore = false;
            while ((s = buffered_reader.readLine()) != null) {
                if (encryptedLog) {
                    int index2;
                    int index1;
                    if (s.contains("encryptionCertAlias")) {
                        foundCertAlias = true;
                        index1 = s.indexOf(">");
                        index2 = s.indexOf("</encryptionCertAlias>");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "index1: " + index1 + " index2: " + index2);
                        }
                        outputStream = outputStream.concat("certAlias = ").concat(s.substring(index1 + 1, index2));
                        outputStream = outputStream.concat("\n");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "outputStream: " + outputStream);
                        }
                    } else if (s.contains("encryptionKeyStore")) {
                        foundKeyStore = true;
                        index1 = s.indexOf(">");
                        index2 = s.indexOf("</encryptionKeyStore>");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "index1: " + index1 + " index2: " + index2);
                        }
                        outputStream = outputStream.concat("keyStore = ").concat(s.substring(index1 + 1, index2));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "outputStream: " + outputStream);
                        }
                        outputStream = outputStream.concat("\n");
                    }
                    if (foundCertAlias && foundKeyStore) break;
                }
                if (!s.contains("Encryption")) continue;
                encryptedLog = true;
            }
        }
        catch (IOException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.audit.tools.showAuditLogEncryptionInfo.afterStepsExecuted", "%");
            String msg = this.getMsg(resBundle, "security.admintask.IOErrorBinaryLog", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ").concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setException(new CommandException(msg));
            return;
        }
        result.setResult(outputStream);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

