/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.ws.security.admintask.audit.utils.AuditCommandHelper;
import com.ibm.ws.security.audit.tools.Controller;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class binaryAuditLogReader
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(binaryAuditLogReader.class, "binaryAuditLogReader", "com.ibm.ws.security.audit.tools");
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    String eventFilter = null;
    String outcomeFilter = null;
    String sequenceFilter = null;
    String timeStampFilter = null;
    String fileName = null;
    String reportMode = null;
    String keyStorePassword = null;
    Vector eventsList = new Vector();
    Vector outcomesList = new Vector();
    String outputLocation = null;
    String dataPoints = null;
    Vector dataPointsList = new Vector();

    public binaryAuditLogReader(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public binaryAuditLogReader(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public boolean validReportMode(String reportMode) {
        return reportMode.equals("basic") || reportMode.equals("complete") || reportMode.equals("custom");
    }

    public void validate() throws CommandValidationException {
        String msg;
        String token;
        String[] st;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.fileName = (String)this.getParameter("fileName");
        if (this.fileName == null || this.fileName != null && this.fileName.length() == 0) {
            String msg2 = this.getMsg(resBundle, "security.admintask.InvalidBinaryAuditLog", null);
            throw new CommandValidationException(msg2);
        }
        this.reportMode = (String)this.getParameter("reportMode");
        if (this.reportMode == null) {
            this.reportMode = new String("basic");
        } else if (this.reportMode.length() == 0) {
            String msg3 = this.getMsg(resBundle, "security.admintask.InvalidReportMode", null);
            throw new CommandValidationException(msg3);
        }
        if (this.reportMode != null && this.reportMode.length() != 0 && !this.validReportMode(this.reportMode)) {
            String msg4 = this.getMsg(resBundle, "security.admintask.InvalidReportMode", null);
            throw new CommandValidationException(msg4);
        }
        this.outputLocation = (String)this.getParameter("outputLocation");
        if (this.outputLocation == null || this.outputLocation != null && this.outputLocation.length() == 0) {
            String msg5 = this.getMsg(resBundle, "security.admintask.InvalidOutputLocation", null);
            throw new CommandValidationException(msg5);
        }
        if (!this.outputLocation.endsWith(".html")) {
            String msg6 = this.getMsg(resBundle, "security.admintask.OutputLocationNotHTML", null);
            throw new CommandValidationException(msg6);
        }
        this.dataPoints = (String)this.getParameter("dataPoints");
        this.dataPointsList = new Vector();
        if (this.dataPoints != null && this.dataPoints.length() != 0) {
            if (this.dataPoints.contains(":")) {
                st = new StringTokenizer(this.dataPoints, ",;: ");
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (token.equals("Event type") || token.equals("Outcome") || token.equals("Seq")) {
                        String msg7 = this.getMsg(resBundle, "security.admintask.DataPointsContainsSpecial", null);
                        throw new CommandValidationException(msg7);
                    }
                    this.dataPointsList.add(token);
                }
            } else {
                this.dataPointsList.add(this.dataPoints);
            }
        }
        if (this.reportMode.equals("custom") && (this.dataPoints == null || this.dataPoints != null && this.dataPoints.length() == 0)) {
            msg = this.getMsg(resBundle, "security.admintask.CustomReportNoDataPoints", null);
            throw new CommandValidationException(msg);
        }
        this.keyStorePassword = (String)this.getParameter("keyStorePassword");
        this.eventFilter = (String)this.getParameter("eventFilter");
        this.outcomeFilter = (String)this.getParameter("outcomeFilter");
        this.eventsList = new Vector();
        if (this.eventFilter != null && this.eventFilter.length() != 0) {
            if (this.eventFilter.contains(":")) {
                st = new StringTokenizer(this.eventFilter, ",;: ");
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (!AuditCommandHelper.isValidEventType(token)) {
                        String msg8 = this.getMsg(resBundle, "security.admintask.InvalidEventType", null);
                        throw new CommandValidationException(msg8);
                    }
                    this.eventsList.add(token);
                }
            } else {
                if (!AuditCommandHelper.isValidEventType(this.eventFilter)) {
                    msg = this.getMsg(resBundle, "security.admintask.InvalidEventType", null);
                    throw new CommandValidationException(msg);
                }
                this.eventsList.add(this.eventFilter);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "eventsList: " + this.eventsList.toString());
            }
        }
        this.outcomesList = new Vector();
        if (this.outcomeFilter != null && this.outcomeFilter.length() != 0) {
            if (this.outcomeFilter.contains(":")) {
                st = new StringTokenizer(this.outcomeFilter, ",;: ");
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (!AuditCommandHelper.isValidOutcome(token)) {
                        String msg9 = this.getMsg(resBundle, "security.admintask.InvalidOutcome", null);
                        throw new CommandValidationException(msg9);
                    }
                    this.outcomesList.add(token);
                }
            } else {
                if (!AuditCommandHelper.isValidOutcome(this.outcomeFilter)) {
                    msg = this.getMsg(resBundle, "security.admintask.InvalidOutcome", null);
                    throw new CommandValidationException(msg);
                }
                this.outcomesList.add(this.outcomeFilter);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "outcomesList: " + this.outcomesList.toString());
            }
        }
        this.sequenceFilter = (String)this.getParameter("sequenceFilter");
        if (this.sequenceFilter != null && this.sequenceFilter.length() == 0) {
            msg = this.getMsg(resBundle, "security.admintask.InvalidSequenceSet", null);
            throw new CommandValidationException(msg);
        }
        if (this.sequenceFilter != null) {
            String msg10;
            if (this.sequenceFilter != null && this.sequenceFilter.contains(":")) {
                st = this.sequenceFilter.split(":");
                if (st.length > 2) {
                    msg10 = this.getMsg(resBundle, "security.admintask.InvalidSequenceSet", null);
                    throw new CommandValidationException(msg10);
                }
                int beginSeq = -1;
                int endSeq = -1;
                try {
                    Integer i = new Integer(st[0]);
                    beginSeq = i;
                    i = new Integer(st[1]);
                    endSeq = i;
                }
                catch (NumberFormatException nfe) {
                    String msg11 = this.getMsg(resBundle, "security.admintask.InvalidSequenceSet", null);
                    throw new CommandValidationException(msg11);
                }
                if (beginSeq > endSeq) {
                    String msg12 = this.getMsg(resBundle, "security.admintask.SequenceSetOutOfOrder", null);
                    throw new CommandValidationException(msg12);
                }
            } else {
                try {
                    Integer i = new Integer(this.sequenceFilter);
                }
                catch (NumberFormatException nfe) {
                    msg10 = this.getMsg(resBundle, "security.admintask.InvalidSequenceNumber", null);
                    throw new CommandValidationException(msg10);
                }
            }
        }
        this.timeStampFilter = (String)this.getParameter("timeStampFilter");
        if (this.timeStampFilter != null && this.timeStampFilter.length() == 0) {
            msg = this.getMsg(resBundle, "security.admintask.InvalidTimeStampRange", null);
            throw new CommandValidationException(msg);
        }
        if (this.timeStampFilter != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "timeStampFilter: " + this.timeStampFilter);
            }
            Date beginTimeStamp = null;
            Date endTimeStamp = null;
            SimpleDateFormat df = new SimpleDateFormat("MMddhhmmyyyy");
            if (this.timeStampFilter != null && this.timeStampFilter.contains(":")) {
                String[] st2 = this.timeStampFilter.split(":");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "st.length: " + st2.length + " st[0]: " + st2[0] + " st[1]: " + st2[1]);
                }
                if (st2.length > 2) {
                    String msg13 = this.getMsg(resBundle, "security.admintask.InvalidTimeStampRange", null);
                    throw new CommandValidationException(msg13);
                }
                try {
                    beginTimeStamp = df.parse(st2[0]);
                    endTimeStamp = df.parse(st2[1]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "beginTimeStamp: " + beginTimeStamp.toString() + " endTimeStamp: " + endTimeStamp.toString());
                    }
                }
                catch (NullPointerException pe) {
                    String msg14 = this.getMsg(resBundle, "security.admintask.InvalidTimeStampRange", null);
                    throw new CommandValidationException(msg14);
                }
                catch (ParseException pee) {
                    String msg15 = this.getMsg(resBundle, "security.admintask.InvalidTimeStamp", null);
                    throw new CommandValidationException(msg15);
                }
                if (beginTimeStamp.after(endTimeStamp)) {
                    String msg16 = this.getMsg(resBundle, "security.admintask.TimeStampRangeOutOfOrder", null);
                    throw new CommandValidationException(msg16);
                }
            } else {
                try {
                    endTimeStamp = beginTimeStamp = df.parse(this.timeStampFilter);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "beginTimeStamp: " + beginTimeStamp.toString() + " endTimeStamp: " + endTimeStamp.toString());
                    }
                }
                catch (NullPointerException pe) {
                    String msg17 = this.getMsg(resBundle, "security.admintask.InvalidTimeStampRange", null);
                    throw new CommandValidationException(msg17);
                }
                catch (ParseException pee) {
                    String msg18 = this.getMsg(resBundle, "security.admintask.InvalidTimeStamp", null);
                    throw new CommandValidationException(msg18);
                }
            }
        }
        super.validate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        Locale locale = this.getLocale();
        Object pattern = null;
        Object matches = null;
        Object variableMap = null;
        Object wasHome = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            Controller controller = new Controller();
            Controller.run(session, locale, this.fileName, this.reportMode, this.eventsList, this.outcomesList, this.sequenceFilter, this.timeStampFilter, this.keyStorePassword, this.dataPointsList, this.outputLocation);
            result.setResult(true);
        }
        catch (Throwable th) {
            result.setException(new CommandException(th, "binary Audit Log Reader command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

