/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.security.audit.AccessContextObj;
import com.ibm.ws.security.audit.Attributes;
import com.ibm.ws.security.audit.AuthnContextObj;
import com.ibm.ws.security.audit.AuthnMappingContextObj;
import com.ibm.ws.security.audit.AuthnTermContextObj;
import com.ibm.ws.security.audit.CustomPropertyContextObj;
import com.ibm.ws.security.audit.DelegationContextObj;
import com.ibm.ws.security.audit.EventContextObj;
import com.ibm.ws.security.audit.KeyContextObj;
import com.ibm.ws.security.audit.MgmtContextObj;
import com.ibm.ws.security.audit.PolicyContextObj;
import com.ibm.ws.security.audit.ProcessContextObj;
import com.ibm.ws.security.audit.PropagationContextObj;
import com.ibm.ws.security.audit.ProviderContextObj;
import com.ibm.ws.security.audit.RegistryContextObj;
import com.ibm.ws.security.audit.ResponseContextObj;
import com.ibm.ws.security.audit.SessionContextObj;
import com.ibm.ws.security.audit.TargetAttributes;
import com.ibm.wsspi.security.audit.ContextHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ContextHandlerImpl
implements ContextHandler {
    private static final TraceComponent tc = Tr.register(ContextHandlerImpl.class, "Security", "com.ibm.ejs.resources.security");
    public SessionContextObj _sessionContextObj = null;
    public PropagationContextObj _propagationContextObj = null;
    public RegistryContextObj _registryContextObj = null;
    public ProcessContextObj _processContextObj = null;
    public DelegationContextObj _delegationContextObj = null;
    public AuthnContextObj _authnContextObj = null;
    public AuthnMappingContextObj _authnMappingContextObj = null;
    public AuthnTermContextObj _authnTermContextObj = null;
    public AccessContextObj _accessContextObj = null;
    public EventContextObj _eventContextObj = null;
    public ProviderContextObj _providerContextObj = null;
    public PolicyContextObj _policyContextObj = null;
    public KeyContextObj _keyContextObj = null;
    public MgmtContextObj _mgmtContextObj = null;
    public ResponseContextObj _responseContextObj = null;
    public CustomPropertyContextObj _customPropertyContextObj = null;

    public ContextHandlerImpl() throws WSSecurityException {
        this.initialize();
    }

    public void initialize() throws WSSecurityException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this._sessionContextObj = new SessionContextObj();
        this._propagationContextObj = new PropagationContextObj();
        this._registryContextObj = new RegistryContextObj();
        this._processContextObj = new ProcessContextObj();
        this._delegationContextObj = new DelegationContextObj();
        this._authnContextObj = new AuthnContextObj();
        this._authnMappingContextObj = new AuthnMappingContextObj();
        this._authnTermContextObj = new AuthnTermContextObj();
        this._accessContextObj = new AccessContextObj();
        this._eventContextObj = new EventContextObj();
        this._providerContextObj = new ProviderContextObj();
        this._policyContextObj = new PolicyContextObj();
        this._keyContextObj = new KeyContextObj();
        this._mgmtContextObj = new MgmtContextObj();
        this._responseContextObj = new ResponseContextObj();
        this._customPropertyContextObj = new CustomPropertyContextObj();
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void buildContextObject(String auditContextObjType, HashMap data) {
        if (auditContextObjType.equalsIgnoreCase("SESSION_CONTEXT")) {
            this.buildSessionContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("PROPAGATION_CONTEXT")) {
            this.buildPropagationContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("REGISTRY_CONTEXT")) {
            this.buildRegistryContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("PROCESS_CONTEXT")) {
            this.buildProcessContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("APPLICATION_DELEGATION")) {
            this.buildDelegationContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("AUTHN_CONTEXT")) {
            this.buildAuthnContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("AUTHN_PROVIDER_CONTEXT")) {
            this.buildProviderContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("AUTHN_MAPPING_CONTEXT")) {
            this.buildAuthnMappingContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("AUTHN_TERM_CONTEXT")) {
            this.buildAuthnTermContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("ACCESS_CONTEXT")) {
            this.buildAccessContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("EVENT_CONTEXT")) {
            this.buildEventContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("POLICY_CONTEXT")) {
            this.buildPolicyContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("KEY_CONTEXT")) {
            this.buildKeyContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("MGMT_CONTEXT")) {
            this.buildMgmtContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("RESPONSE_CONTEXT")) {
            this.buildResponseContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("CUSTOM_PROPERTY_CONTEXT")) {
            this.buildCustomPropertyContext(data);
        }
    }

    public void buildCustomPropertyContext(HashMap data) {
        if (!this._customPropertyContextObj.getMap().isEmpty()) {
            this._customPropertyContextObj.getMap().clear();
        }
        Set dataSet = data.entrySet();
        for (Map.Entry mapEntry : dataSet) {
            String key = mapEntry.getKey().toString();
            if (mapEntry.getValue() != null) {
                this._customPropertyContextObj.setEntry(key, mapEntry.getValue());
                continue;
            }
            this._customPropertyContextObj.setEntry(key, "null");
        }
    }

    public void buildSessionContext(HashMap data) {
        if (data.get("SessionId") != null) {
            this._sessionContextObj.setSessionId((String)data.get("SessionId"));
        }
        if (data.get("RemoteAddr") != null) {
            this._sessionContextObj.setRemoteAddr((String)data.get("RemoteAddr"));
        }
        if (data.get("RemotePort") != null) {
            this._sessionContextObj.setRemotePort((String)data.get("RemotePort"));
        }
        if (data.get("RemoteHost") != null) {
            this._sessionContextObj.setRemoteHost((String)data.get("RemoteHost"));
        }
    }

    public void buildPropagationContext(HashMap data) {
        if (data.get("FirstCaller") != null) {
            this._propagationContextObj.setFirstCaller((String)data.get("FirstCaller"));
        }
        if (data.get("CallerList") != null) {
            this._propagationContextObj.setCallerList((String[])data.get("CallerList"));
        }
    }

    public void buildRegistryContext(HashMap data) {
        if (data.get("RegistryType") != null) {
            this._registryContextObj.setType((String)data.get("RegistryType"));
        }
    }

    public void buildProcessContext(HashMap data) {
        if (data.get("Domain") != null) {
            this._processContextObj.setDomain((String)data.get("Domain"));
        }
        if (data.get("Realm") != null) {
            this._processContextObj.setRealm((String)data.get("Realm"));
        }
    }

    public void buildDelegationContext(HashMap data) {
        if (data.get("DelegationType") != null) {
            this._delegationContextObj.setDelegationType((String)data.get("DelegationType"));
        }
        if (data.get("RoleName") != null) {
            this._delegationContextObj.setRoleName((String)data.get("RoleName"));
        }
        if (data.get("IdentityName") != null) {
            this._delegationContextObj.setIdentityName((String)data.get("IdentityName"));
        }
    }

    public void buildAuthnContext(HashMap data) {
        if (data.get("AuthnType") != null) {
            this._authnContextObj.setAuthnType((String)data.get("AuthnType"));
        }
    }

    public void buildProviderContext(HashMap data) {
        if (data.get("Provider") != null) {
            this._providerContextObj.setProvider((String)data.get("Provider"));
        }
        if (data.get("ProviderStatus") != null) {
            this._providerContextObj.setProviderStatus((String)data.get("ProviderStatus"));
        }
    }

    public void buildAuthnMappingContext(HashMap data) {
        if (data.get("MappedSecurityDomain") != null) {
            this._authnMappingContextObj.setMappedSecurityDomain((String)data.get("MappedSecurityDomain"));
        }
        if (data.get("MappedRealm") != null) {
            this._authnMappingContextObj.setMappedRealm((String)data.get("MappedRealm"));
        }
        if (data.get("MappedUserName") != null) {
            this._authnMappingContextObj.setMappedUserName((String)data.get("MappedUserName"));
        }
    }

    public void buildAuthnTermContext(HashMap data) {
        if (data.get("TerminateReason") != null) {
            this._authnTermContextObj.setTerminateReason((String)data.get("TerminateReason"));
        }
    }

    public void buildAccessContext(HashMap data) {
        if (data.get("ProgName") != null) {
            this._accessContextObj.setProgName((String)data.get("ProgName"));
        }
        if (data.get("Action") != null) {
            this._accessContextObj.setAction((String)data.get("Action"));
        }
        if (data.get("RegistryUserName") != null) {
            this._accessContextObj.setRegistryUserName((String)data.get("RegistryUserName"));
        }
        if (data.get("AppUserName") != null) {
            this._accessContextObj.setAppUserName((String)data.get("AppUserName"));
        }
        if (data.get("AccessDecision") != null) {
            this._accessContextObj.setAccessDecision((String)data.get("AccessDecision"));
        }
        if (data.get("NameInApp") != null) {
            this._accessContextObj.setNameInApp((String)data.get("NameInApp"));
        }
        if (data.get("ResourceType") != null) {
            this._accessContextObj.setResourceType((String)data.get("ResourceType"));
        }
        if (data.get("ResourceUniqueId") != null) {
            this._accessContextObj.setResourceUniqueId((Long)data.get("ResourceUniqueId"));
        }
        if (data.get("PermissionsChecked") != null) {
            this._accessContextObj.setPermissionsChecked((String[])data.get("PermissionsChecked"));
        }
        if (data.get("PermissionsGranted") != null) {
            this._accessContextObj.setPermissionsGranted((String[])data.get("PermissionsGranted"));
        }
        if (data.get("RolesChecked") != null) {
            this._accessContextObj.setRolesChecked((String[])data.get("RolesChecked"));
        }
        if (data.get("RolesGranted") != null) {
            this._accessContextObj.setRolesGranted((String[])data.get("RolesGranted"));
        }
    }

    public void buildEventContext(HashMap data) {
        if (data.get("LastEventTrailId") != null) {
            this._eventContextObj.setLastEventTrailId((String)data.get("LastEventTrailId"));
        }
        if (data.get("EventTrailId") != null) {
            this._eventContextObj.setEventTrailId((String[])data.get("EventTrailId"));
        }
        if (data.get("CreationTime") != null) {
            this._eventContextObj.setCreationTime((Date)data.get("CreationTime"));
        }
        if (data.get("GlobalInstanceId") != null) {
            this._eventContextObj.setGlobalInstanceId((long)((Long)data.get("GlobalInstanceId")));
        }
    }

    public void buildPolicyContext(HashMap data) {
        if (data.get("PolicyName") != null) {
            this._policyContextObj.setPolicyName((String)data.get("PolicyName"));
        }
        if (data.get("PolicyType") != null) {
            this._policyContextObj.setPolicyType((String)data.get("PolicyType"));
        }
    }

    public void buildKeyContext(HashMap data) {
        if (data.get("KeyLabel") != null) {
            this._keyContextObj.setKeyLabel((String)data.get("KeyLabel"));
        }
        if (data.get("KeyLocation") != null) {
            this._keyContextObj.setKeyLocation((String)data.get("KeyLocation"));
        }
        if (data.get("CertLifetime") != null) {
            this._keyContextObj.setCertLifetime((Date)data.get("CertLifetime"));
        }
    }

    public void buildMgmtContext(HashMap data) {
        if (data.get("MgmtType") != null) {
            this._mgmtContextObj.setMgmtType((String)data.get("MgmtType"));
        }
        if (data.get("MgmtCommand") != null) {
            this._mgmtContextObj.setMgmtCommand((String)data.get("MgmtCommand"));
        }
        if (data.get("TargetInfoAttributes") != null) {
            this._mgmtContextObj.setTargetInfoAttributes((TargetAttributes[])data.get("TargetInfoAttributes"));
        }
    }

    public void buildResponseContext(HashMap data) {
        if (data.get("Url") != null) {
            this._responseContextObj.setUrl((String)data.get("Url"));
        }
        if (data.get("HttpRequestHeaders") != null) {
            this._responseContextObj.setHttpRequestHeaders((Attributes[])data.get("HttpRequestHeaders"));
        }
        if (data.get("HttpResponseHeaders") != null) {
            this._responseContextObj.setHttpResponseHeaders((Attributes[])data.get("HttpResponseHeaders"));
        }
    }

    public Object getContextObject(String auditContextObjType) {
        if (auditContextObjType.equalsIgnoreCase("SESSION_CONTEXT")) {
            return this._sessionContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("PROPAGATION_CONTEXT")) {
            return this._propagationContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("REGISTRY_CONTEXT")) {
            return this._registryContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("PROCESS_CONTEXT")) {
            return this._processContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("APPLICATION_DELEGATION")) {
            return this._delegationContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("AUTHN_CONTEXT")) {
            return this._authnContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("AUTHN_PROVIDER_CONTEXT")) {
            return this._providerContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("AUTHN_MAPPING_CONTEXT")) {
            return this._authnMappingContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("AUTHN_TERM_CONTEXT")) {
            return this._authnTermContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("ACCESS_CONTEXT")) {
            return this._accessContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("EVENT_CONTEXT")) {
            return this._eventContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("POLICY_CONTEXT")) {
            return this._policyContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("KEY_CONTEXT")) {
            return this._keyContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("MGMT_CONTEXT")) {
            return this._mgmtContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("RESPONSE_CONTEXT")) {
            return this._responseContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("CUSTOM_PROPERTY_CONTEXT")) {
            return this._customPropertyContextObj;
        }
        return null;
    }
}

