/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.certclient.util.PkSsCertFactory;
import com.ibm.security.certclient.util.PkSsCertificate;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.AuditCrypto;
import com.ibm.ws.security.audit.AuditKeyEncryptor;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import com.ibm.wsspi.security.audit.AuditDecryptException;
import com.ibm.wsspi.security.audit.AuditEncryptException;
import com.ibm.wsspi.security.audit.AuditSignException;
import com.ibm.wsspi.security.audit.AuditSigning;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class AuditSigningImpl
implements AuditSigning {
    private static final TraceComponent tc = Tr.register(AuditSigningImpl.class, null, "com.ibm.ejs.resources.security");
    AuditCrypto crypto = null;
    String cellName = null;
    String nodeName = null;
    String serverName = null;
    int aliasIncrement = 1;
    private static AuditSigningImpl as = null;
    private static String subjectDN = "CN=auditsigner, OU=SWG, O=IBM, C=US";
    private static String keyStoreName = "auditSignerKeyStore_";
    private static String certLabelPrefix = "auditcert";
    private static String CRYPTO_ALGORITHM = "SHA256withRSA";
    private Signature signature = null;
    private byte[] sigBytes = null;
    private int signerKeyStoreIncrement = 1;
    private CertReqInfo certInfo = null;
    private ObjectName mgmScopeObjName = null;
    AuditKeyEncryptor encryptor = null;
    private String signerName = null;
    private String signerType = null;
    private String signerProvider = null;
    private String expandedConfigRoot = KeyStoreManager.getInstance().expand("${CONFIG_ROOT}");
    private String signerKeyFileLocation = null;
    private String signerPassword = null;
    private String signerAlias = null;

    public AuditSigningImpl(String _signerKeyStoreName, String _signer_keyStoreScope, String _signerCertAlias) throws AuditSignException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AuditSigningImpl");
        }
        try {
            this.initialize(_signerKeyStoreName, _signer_keyStoreScope, _signerCertAlias);
        }
        catch (Exception e) {
            Tr.error(tc, "security.audit.signing.init.error", new Object[]{e});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AuditSigningImpl");
        }
    }

    public void initEncryptionCipher(Key sharedKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initEncryptionCipher : " + new String(sharedKey.getEncoded()));
        }
        this.crypto.initEncryptCipher(sharedKey.getEncoded());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initEncryptionCipher : " + new String(sharedKey.getEncoded()));
        }
    }

    public void initDecryptionCipher(Key sharedKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initDecryptionCipher : " + new String(sharedKey.getEncoded()));
        }
        this.crypto.initDecryptCipher(sharedKey.getEncoded());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initDecryptionCipher : " + new String(sharedKey.getEncoded()));
        }
    }

    public void initialize(String _signerKeyStoreName, String _signerKeyStoreScope, String _signerCertAlias) throws AuditSignException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.cellName = SecurityObjectLocator.getAdminData().getString("cellname");
        this.nodeName = SecurityObjectLocator.getAdminData().getString("nodename");
        this.serverName = SecurityObjectLocator.getAdminData().getString("shortservername");
        this.signerAlias = _signerCertAlias;
        this.crypto = new AuditCrypto();
        String JCEProvider = null;
        try {
            JCEProvider = Security.getProperty("DEFAULT_JCE_PROVIDER");
            this.signature = Signature.getInstance(CRYPTO_ALGORITHM, JCEProvider);
        }
        catch (Exception e) {
            Tr.error(tc, "security.audit.signing.init.error", new Object[]{e});
            throw new AuditSignException(e.getMessage());
        }
        try {
            this.initSignerKeyStore(_signerKeyStoreName, _signerKeyStoreScope, _signerCertAlias);
        }
        catch (Exception e) {
            throw new AuditSignException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public Key generateSharedKey() throws java.security.KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateSharedKey");
        }
        SecretKeySpec sharedKey = null;
        try {
            if (this.crypto != null) {
                AuditSigningImpl auditSigningImpl = this;
                sharedKey = new SecretKeySpec(auditSigningImpl.crypto.generate3DESKey(), 0, 24, "3DES");
            }
            if (sharedKey != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "generateSharedKey");
                }
                return sharedKey;
            }
            throw new KeyException("Key could not be generated.");
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.audit.AuditEncryptionImpl.generateKey", "98", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error generating key.", new Object[]{e});
            }
            if (e instanceof java.security.KeyException) {
                throw (java.security.KeyException)e;
            }
            throw new java.security.KeyException(e.getMessage(), e);
        }
    }

    public String generateAliasForSharedKey() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateAliasForSharedKey");
        }
        String alias = null;
        if (this.cellName != null && this.nodeName != null && this.serverName != null) {
            alias = this.cellName + this.nodeName + this.serverName + "Alias" + new Integer(this.aliasIncrement).toString();
        }
        ++this.aliasIncrement;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateAliasForSharedKey: alias = " + alias);
        }
        return alias;
    }

    public byte[] encryptSharedKey(Key sharedKey, Key publicKey) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptSharedKey");
        }
        byte[] encryptedSharedKey = null;
        if (sharedKey == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR!!! shared key is null!");
            }
            return null;
        }
        byte[] encodedPublicKey = publicKey.getEncoded();
        this.encryptor = new AuditKeyEncryptor(encodedPublicKey);
        byte[] encodedSharedKey = sharedKey.getEncoded();
        encryptedSharedKey = this.encryptor.encrypt(encodedSharedKey);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptedSharedKey");
        }
        return encryptedSharedKey;
    }

    public byte[] decryptSharedKey(byte[] sharedKey, Key pKey) throws IOException {
        byte[] encodedPublicKey;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decryptSharedKey");
        }
        byte[] decryptedSharedKey = null;
        if (sharedKey == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR!!! shared key is null!");
            }
            return null;
        }
        if (this.encryptor == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "encryptor is null");
            }
            encodedPublicKey = pKey.getEncoded();
            this.encryptor = new AuditKeyEncryptor(encodedPublicKey);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "encryptor is not null, reusing connection");
        }
        encodedPublicKey = pKey.getEncoded();
        decryptedSharedKey = this.encryptor.decrypt(sharedKey);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decryptSharedKey");
        }
        return decryptedSharedKey;
    }

    public X509Certificate retrieveSignerCertificate() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveSignerCertificate");
        }
        Object publicKey = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "signerAlias: " + this.signerAlias + " signerType: " + this.signerType + " signerProvider: " + this.signerProvider + " signerKeyFileLocation: " + this.signerKeyFileLocation);
        }
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance(this.signerType, this.signerProvider);
            InputStream is = AuditSigningImpl.openKeyStore(this.signerKeyFileLocation);
            ks.load(is, this.signerPassword.toCharArray());
            X509Certificate cert = (X509Certificate)ks.getCertificate(this.signerAlias);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "retrieveSignerCertificate");
            }
            return cert;
        }
        catch (NoSuchProviderException ne) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore: no such provider.", ne.getMessage());
            }
            throw new Exception(ne.getMessage());
        }
        catch (MalformedURLException me) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore: malformed URL", me.getMessage());
            }
            throw new Exception(me.getMessage());
        }
        catch (KeyStoreException ke) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", ke.getMessage());
            }
            throw new Exception(ke.getMessage());
        }
        catch (NoSuchAlgorithmException ae) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore: no such algorithm", ae.getMessage());
            }
            throw new Exception(ae.getMessage());
        }
        catch (CertificateException ce) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting certificate.", ce.getMessage());
            }
            throw new Exception(ce.getMessage());
        }
        catch (IOException ioe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", ioe.getMessage());
            }
            throw new Exception(ioe.getMessage());
        }
    }

    public Key retrievePrivateSignerKey() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrievePrivateSignerKey");
        }
        KeyStore ks = null;
        Key k = null;
        try {
            ks = KeyStore.getInstance(this.signerType, this.signerProvider);
            InputStream is = AuditSigningImpl.openKeyStore(this.signerKeyFileLocation);
            ks.load(is, this.signerPassword.toCharArray());
            k = ks.getKey(this.signerAlias, this.signerPassword.toCharArray());
        }
        catch (NoSuchProviderException ne) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore: no such provider.", ne.getMessage());
            }
            throw new Exception(ne.getMessage());
        }
        catch (MalformedURLException me) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore: malformed URL", me.getMessage());
            }
            throw new Exception(me.getMessage());
        }
        catch (KeyStoreException ke) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", ke.getMessage());
            }
            throw new Exception(ke.getMessage());
        }
        catch (UnrecoverableKeyException uke) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", uke.getMessage());
            }
            throw new Exception(uke.getMessage());
        }
        catch (NoSuchAlgorithmException ae) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore: no such algorithm", ae.getMessage());
            }
            throw new Exception(ae.getMessage());
        }
        catch (CertificateException ce) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting certificate.", ce.getMessage());
            }
            throw new Exception(ce.getMessage());
        }
        catch (IOException ioe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", ioe.getMessage());
            }
            throw new Exception(ioe.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrievePrivateSignerKey");
        }
        return k;
    }

    public Key retrievePublicSignerKey() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrievePublicSignerKey");
        }
        PublicKey publicKey = null;
        try {
            X509Certificate cert = this.retrieveSignerCertificate();
            publicKey = cert.getPublicKey();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "retrievePublicSignerKey");
            }
            return publicKey;
        }
        catch (MalformedURLException me) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", me.getMessage());
            }
            throw new Exception(me.getMessage());
        }
        catch (IOException ioe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", ioe.getMessage());
            }
            throw new Exception(ioe.getMessage());
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", e.getMessage());
            }
            throw new Exception(e.getMessage());
        }
    }

    public byte[] encrypt(byte[] data, Key sharedKey) throws AuditEncryptException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encrypt");
        }
        if (data == null) {
            Tr.error(tc, "security.audit.encryption.data.error");
            throw new AuditEncryptException("Invalid data passed into the encryption algorithm.");
        }
        if (sharedKey == null) {
            Tr.error(tc, "security.audit.invalid.shared.key.error");
            throw new AuditEncryptException("Invalid shared key has been encountered.");
        }
        byte[] encryptedData = this.crypto.encrypt(data, sharedKey.getEncoded());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encrypt");
        }
        return encryptedData;
    }

    public byte[] decrypt(byte[] data, Key sharedKey) throws AuditDecryptException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decrypt");
        }
        if (data == null) {
            Tr.error(tc, "security.audit.decryption.data.error");
            throw new AuditDecryptException("Invalid data passed into the decryption algorithm.");
        }
        if (sharedKey == null) {
            Tr.error(tc, "security.audit.invalid.shared.key.error");
            throw new AuditDecryptException("An invalid shared key was detected.");
        }
        byte[] decryptedData = this.crypto.decrypt(data, sharedKey.getEncoded());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decrypt");
        }
        return decryptedData;
    }

    public byte[] unsign(byte[] data, Key key) throws AuditSignException {
        byte[] unsignedData = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsign");
        }
        if (data != null) {
            try {
                unsignedData = this.decrypt(data, key);
            }
            catch (AuditDecryptException ade) {
                throw new AuditSignException(ade);
            }
        } else {
            Tr.error(tc, "security.audit.message.digest.error");
            throw new AuditSignException("MessageDigest is invalid");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unsignedData: " + new String(unsignedData));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsign");
        }
        return unsignedData;
    }

    public byte[] sign(byte[] data, Key key) throws AuditSignException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sign");
        }
        byte[] messageDigest = null;
        byte[] signedData = null;
        MessageDigest md2 = null;
        try {
            md2 = MessageDigest.getInstance("SHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AuditSignException(e);
        }
        if (data == null) {
            Tr.error(tc, "security.audit.signing.data.error");
            throw new AuditSignException("Invalid data passed into signing algorithm");
        }
        md2.reset();
        md2.update(data);
        messageDigest = md2.digest();
        if (messageDigest != null) {
            try {
                signedData = this.encrypt(messageDigest, key);
            }
            catch (AuditEncryptException aee) {
                throw new AuditSignException(aee);
            }
        } else {
            Tr.error(tc, "security.audit.message.digest.error");
            throw new AuditSignException("MessageDigest is invalid");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "signedData: " + new String(signedData));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sign");
        }
        return signedData;
    }

    public boolean verify(byte[] data, Key key) throws AuditSignException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verify");
        }
        if (this.signature != null) {
            try {
                this.signature.initVerify((PublicKey)key);
                this.signature.update(data);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "verify");
                }
                return this.signature.verify(this.sigBytes);
            }
            catch (Exception ex) {
                throw new AuditSignException(ex);
            }
        }
        String msg = "Signature is null.  Cannot verify data.";
        throw new AuditSignException(msg);
    }

    public String getSignerKeyFileLocation() {
        return this.signerKeyFileLocation;
    }

    public void initSignerKeyStore(String _signerKeyStoreName, String _signerKeyStoreScope, String _signerCertAlias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initSignerKeyStore");
        }
        String keyStoreScope = _signerKeyStoreScope;
        Object nodeName = null;
        Object certLabel = null;
        ConfigService cs = null;
        Session session = null;
        ObjectName securityName = null;
        ObjectName auditName = null;
        Object ksInfo = null;
        AttributeList attrList = new AttributeList();
        ObjectName keyStoreObj = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
            cs = ConfigServiceFactory.getConfigService();
            session = new Session();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                securityName = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            CommandHelper commandHelper = new CommandHelper();
            if (keyStoreScope == null) {
                keyStoreScope = commandHelper.defaultCellScope(cell);
            }
            attrList.clear();
            ConfigServiceHelper.setAttributeValue(attrList, "name", _signerKeyStoreName);
            keyStoreObj = commandHelper.getObjectName(cs, session, securityName, "keyStores", attrList, _signerKeyStoreScope);
            this.signerType = (String)cs.getAttribute(session, keyStoreObj, "type");
            this.signerProvider = (String)cs.getAttribute(session, keyStoreObj, "provider");
            this.signerKeyFileLocation = (String)cs.getAttribute(session, keyStoreObj, "location");
            this.signerPassword = (String)cs.getAttribute(session, keyStoreObj, "password");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not using same keyfile as for encryption: signerType: " + this.signerType + " signerProvider: " + this.signerProvider + " signerKeyFileLocation: " + this.signerKeyFileLocation + " signerPassword: " + this.signerPassword);
            }
        }
        catch (Exception e) {
            try {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
                cs = ConfigServiceFactory.getConfigService();
                session = new Session();
                ObjectName cell = cs.resolve(session, "Cell=")[0];
                auditName = cs.queryConfigObjects(session, null, pattern, null)[0];
                CommandHelper commandHelper = new CommandHelper();
                if (keyStoreScope == null) {
                    keyStoreScope = commandHelper.defaultCellScope(cell);
                }
                attrList.clear();
                ConfigServiceHelper.setAttributeValue(attrList, "name", _signerKeyStoreName);
                keyStoreObj = commandHelper.getObjectName(cs, session, auditName, "keyStores", attrList, _signerKeyStoreScope);
                this.signerType = (String)cs.getAttribute(session, keyStoreObj, "type");
                this.signerProvider = (String)cs.getAttribute(session, keyStoreObj, "provider");
                this.signerKeyFileLocation = (String)cs.getAttribute(session, keyStoreObj, "location");
                this.signerPassword = (String)cs.getAttribute(session, keyStoreObj, "password");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using same keyfile as for encryption: signerType: " + this.signerType + " signerProvider: " + this.signerProvider + " signerKeyFileLocation: " + this.signerKeyFileLocation + " signerPassword: " + this.signerPassword);
                }
            }
            catch (Exception try_two_e) {
                throw new Exception(try_two_e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initSignerKeyStore");
        }
    }

    public boolean personalCertificateCreate(CertReqInfo ssCertInfo) throws Exception {
        boolean certCreated;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "personalCertificateCreate");
            }
            certCreated = false;
            String alias = null;
            String subjectDN = null;
            int size = 0;
            boolean validDays = false;
            KeyStoreInfo keyStoreInfo = null;
            String keyStoreProvider = null;
            String password = null;
            String filePath = null;
            String reqFilePath = null;
            subjectDN = ssCertInfo.getSubjectDN();
            alias = ssCertInfo.getLabel();
            size = ssCertInfo.getSize();
            reqFilePath = ssCertInfo.getFilename();
            filePath = "file://" + reqFilePath;
            keyStoreInfo = ssCertInfo.getKsInfo();
            keyStoreProvider = keyStoreInfo.getProvider();
            password = keyStoreInfo.getPassword();
            WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(keyStoreInfo);
            PkSsCertificate ssCertificate = null;
            X509Certificate certificate = null;
            PrivateKey privateKey = null;
            String reqName = alias + "_certreq";
            String locKeyType = "RSA";
            String provider = "IBMJCE";
            String randomNoGenerator = "IBMSecureRandom";
            ArrayList<String> attrs = new ArrayList<String>();
            attrs.add("certreq@us.ibm.com");
            attrs.add("CERTREQUEST");
            attrs.add(filePath);
            String cn = subjectDN.substring(0, subjectDN.indexOf(","));
            String dn = subjectDN.substring(subjectDN.indexOf(",") + 1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cn: " + cn + " dn: " + dn);
            }
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(locKeyType, provider);
                SecureRandom secureRandom = SecureRandom.getInstance(randomNoGenerator, provider);
                keyPairGenerator.initialize(size, secureRandom);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                Date deltaDate = new Date();
                deltaDate.setTime(deltaDate.getTime() - 86400000L);
                ssCertificate = PkSsCertFactory.newSsCert((int)size, (String)subjectDN, (int)365, (Date)deltaDate, (boolean)true, (boolean)true, attrs, null, null, (String)"IBMJCE", (KeyPair)keyPair);
                if (ssCertificate != null) {
                    certificate = ssCertificate.getCertificate();
                    privateKey = ssCertificate.getKey();
                    String method2 = "setKeyEntryOverwrite";
                    Object[] parms = new Object[]{alias, privateKey, password.toCharArray(), new X509Certificate[]{certificate}};
                    wsksr.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
                    certCreated = true;
                    try {
                        Tr.audit(tc, "Self Signed Certificate: notBefore time: " + certificate.getNotBefore().toString() + " notAfter time: " + certificate.getNotAfter().toString());
                    }
                    catch (Throwable t) {}
                    break block8;
                }
                String msg = "SelfSigned create failed.";
                throw new Exception(msg);
            }
            catch (Throwable e) {
                e.printStackTrace();
                String msg = "Failed to create certificate";
                throw new Exception(e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "personalCertificateCreate");
        }
        return certCreated;
    }

    public static AttributeList createKeyStoreAttrList(KeyStoreInfo ksInfo) {
        String hostList;
        String provider;
        String password;
        String type;
        String location;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createKeyStoreAttrList");
        }
        AttributeList attrList = new AttributeList();
        Integer slotNumber = null;
        String name = ksInfo.getName();
        if (name != null) {
            attrList.add(new Attribute("name", name));
        }
        if ((location = ksInfo.getLocation()) != null) {
            attrList.add(new Attribute("location", location));
        }
        if ((type = ksInfo.getType()) != null) {
            attrList.add(new Attribute("type", type));
        }
        if ((password = ksInfo.getPassword()) != null) {
            attrList.add(new Attribute("password", password));
        }
        if ((provider = ksInfo.getProvider()) != null) {
            attrList.add(new Attribute("provider", provider));
        }
        if ((hostList = ksInfo.getHostList()) != null) {
            attrList.add(new Attribute("hostList", hostList));
        }
        if ((slotNumber = ksInfo.getSlot()) != null) {
            attrList.add(new Attribute("slot", slotNumber));
        }
        attrList.add(new Attribute("managementScope", ksInfo.getScopeName()));
        attrList.add(new Attribute("fileBased", ksInfo.getFileBased()));
        attrList.add(new Attribute("readOnly", ksInfo.getReadOnly()));
        attrList.add(new Attribute("initializeAtStartup", ksInfo.getInitializeAtStartup()));
        attrList.add(new Attribute("createStashFileForCMS", ksInfo.getStashFile()));
        attrList.add(new Attribute("useForAcceleration", ksInfo.getAccelerator()));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createKeyStoreAttrList");
        }
        return attrList;
    }

    protected static InputStream openKeyStore(String fileName) throws MalformedURLException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "openKeyStore" + fileName);
        }
        try {
            String expandedFilename = KeyStoreManager.getInstance().expand(fileName);
            OpenKeyStoreAction action = new OpenKeyStoreAction(expandedFilename);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "openKeyStore");
            }
            return (InputStream)AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", new Object[]{ex});
            }
            if (ex instanceof MalformedURLException) {
                throw (MalformedURLException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex.getMessage());
        }
    }

    static class OpenKeyStoreAction
    implements PrivilegedExceptionAction {
        private String file = null;

        public OpenKeyStoreAction(String fileName) {
            this.file = fileName;
        }

        public Object run() throws MalformedURLException, IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "OpenKeyStoreAction.run");
            }
            InputStream fis = null;
            URL urlFile = null;
            File kfile = new File(this.file);
            if (kfile.exists() && kfile.length() == 0L) {
                throw new IOException("Keystore file exists, but is empty: " + this.file);
            }
            urlFile = !kfile.exists() ? new URL(this.file) : new URL("file:" + kfile.getCanonicalPath());
            fis = urlFile.openStream();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "OpenKeyStoreAction.run");
            }
            return fis;
        }
    }
}

