/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.security.audit.AuditOutcome;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AuditActiveSettings {
    private static final TraceComponent tc = Tr.register(AuditActiveSettings.class, null, "com.ibm.ejs.resources.security");
    public String[] _outcomes = AuditOutcome.getOutcomeList();
    private ConcurrentHashMap outcomeSettings = new ConcurrentHashMap();

    public ConcurrentHashMap getOutcomeSettingsMap() {
        return this.outcomeSettings;
    }

    public void printOutcomes() {
        if (tc.isDebugEnabled() && this.outcomeSettings != null) {
            Tr.debug(tc, "outcomeSettings: " + this.outcomeSettings.toString());
        }
    }

    public void setActiveSetting(String auditOutcome) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "setActiveSetting: " + auditOutcome);
        }
        if (this.outcomeSettings == null) {
            this.outcomeSettings = new ConcurrentHashMap();
        }
        this.outcomeSettings.put(auditOutcome, "ACTIVE");
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "setActiveSetting");
        }
    }

    public void resetActiveSetting(String auditOutcome) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "resetActiveSetting: " + auditOutcome);
        }
        if (this.outcomeSettings != null) {
            this.outcomeSettings.remove(auditOutcome);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "resetActiveSetting");
        }
    }

    public boolean isActive(String auditOutcome) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "isActive: " + auditOutcome);
        }
        if (this.outcomeSettings.containsKey(auditOutcome)) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "isActive(true)");
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "isActive(false)");
        }
        return false;
    }

    public String[] getActive() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getActive");
        }
        String[] outcomeStr = new String[this.outcomeSettings.size()];
        Set keys = this.outcomeSettings.keySet();
        outcomeStr = (String[])keys.toArray();
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getActive: " + outcomeStr.toString());
        }
        return outcomeStr;
    }
}

