/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.securityDomain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.Result;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.securityDomain.SecConfigTaskHelper;
import com.ibm.ws.security.config.securitydomain.SecDomainHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.security.registry.UserRegistryImpl;
import com.ibm.ws.security.securitydomain.DomainCheckerExtensionsProcessor;
import com.ibm.ws.security.securitydomain.ServerProcessNotFoundException;
import com.ibm.ws.security.util.ConfigUtils;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class SecurityRealmProvider
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(SecurityRealmProvider.class, "security", "com.ibm.ws.security.admintask.securityDomain");
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public List listSecurityRealms(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listSecurityRealms");
        }
        ObjectName secObj = null;
        List realmList = new ArrayList();
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            secObj = SecConfigTaskHelper.getSecurityObjectName(session, configService);
            realmList = this.getCellRealms(session, configService, secObj);
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "104");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listSecurityRealms");
            }
        }
        return realmList;
    }

    public List listRegistryUsers(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listRegistryUsers");
        }
        List userList = new ArrayList();
        ArrayList<String> users = new ArrayList<String>();
        String process = null;
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String method2 = "getUsers";
            String realmName = (String)cmd.getParameter("securityRealmName");
            String resourceName = (String)cmd.getParameter("resourceName");
            String domainName = (String)cmd.getParameter("securityDomainName");
            Boolean displayAccessId = (Boolean)cmd.getParameter("displayAccessIds");
            String userFilter = (String)cmd.getParameter("userFilter");
            Integer numberOfUsers = (Integer)cmd.getParameter("numberOfUsers");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityRealmName name is " + realmName);
            }
            if (realmName != null && realmName.length() == 0) {
                realmName = null;
            }
            if (resourceName != null && resourceName.length() == 0) {
                resourceName = null;
            }
            if (domainName != null && domainName.length() == 0) {
                domainName = null;
            }
            if (numberOfUsers < 1) {
                String msg = this.getMsg(resBundle, "security.admintask.greater.SECJ7756E", new Object[]{"numberOfUsers"});
                throw new CommandValidationException(msg);
            }
            if (realmName != null && (resourceName != null || domainName != null) || resourceName != null && (realmName != null || domainName != null) || domainName != null && (resourceName != null || realmName != null)) {
                String msg = this.getMsg(resBundle, "security.admintask.dupType.SECJ7761E", null);
                throw new CommandValidationException(msg);
            }
            AttributeList regAttrs = null;
            if (realmName != null) {
                regAttrs = this.getSecurityAttrsForRealm(session, configService, realmName);
                process = this.getResourceOfRealm(session, configService, realmName);
            } else if (resourceName != null) {
                regAttrs = this.getSecurityAttrsForResource(session, configService, resourceName);
                process = this.findProcessForResource(session, configService, resourceName);
            } else if (domainName != null) {
                regAttrs = this.getSecurityAttrsForDomain(session, configService, domainName);
                process = this.getResourceOfDomain(session, configService, domainName);
            } else {
                regAttrs = this.getSecurityAttrsForDomain(session, configService, null);
                process = this.getResourceOfDomain(session, configService, null);
            }
            if (regAttrs != null) {
                String registryType = (String)ConfigServiceHelper.getAttributeValue(regAttrs, "_Websphere_Config_Data_Type");
                if (registryType.equals("LocalOSUserRegistry")) {
                    userList = this.getLocalOSList(regAttrs, method2, displayAccessId, userFilter, numberOfUsers, process);
                } else if (registryType.equals("CustomUserRegistry")) {
                    userList = this.getCustomList(regAttrs, method2, displayAccessId, userFilter, numberOfUsers, process);
                } else if (registryType.equals("LDAPUserRegistry")) {
                    userList = this.getLDAPList(regAttrs, method2, displayAccessId, userFilter, numberOfUsers, process);
                } else if (registryType.equals("WIMUserRegistry")) {
                    userList = this.getWIMList(regAttrs, method2, displayAccessId, userFilter, numberOfUsers, process);
                }
            } else {
                String msg = this.getMsg(resBundle, "security.admintask.noUserReg.SECJ7762E", null);
                throw new CommandValidationException(msg);
            }
            if (userList != null && realmName != null) {
                for (int i = 0; i < userList.size(); ++i) {
                    Object user;
                    if (displayAccessId.booleanValue()) {
                        String name;
                        user = (AttributeList)userList.get(i);
                        if (user == null || (name = (String)ConfigServiceHelper.getAttributeValue((AttributeList)user, "name")) == null) continue;
                        ConfigServiceHelper.setAttributeValue((AttributeList)user, "name", name + "@" + realmName);
                        continue;
                    }
                    user = (String)userList.get(i);
                    if (user == null) continue;
                    users.add((String)user + "@" + realmName);
                }
                if (!users.isEmpty()) {
                    userList.clear();
                    userList = users;
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "168");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listRegistryUsers");
            }
        }
        return userList;
    }

    public List listRegistryGroups(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listGroupsInRealm");
        }
        List groupList = new ArrayList();
        ArrayList<String> groups = new ArrayList<String>();
        String process = null;
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String method2 = "getGroups";
            String realmName = (String)cmd.getParameter("securityRealmName");
            String resourceName = (String)cmd.getParameter("resourceName");
            String domainName = (String)cmd.getParameter("securityDomainName");
            Boolean displayAccessId = (Boolean)cmd.getParameter("displayAccessIds");
            String groupFilter = (String)cmd.getParameter("groupFilter");
            Integer numberOfGroups = (Integer)cmd.getParameter("numberOfGroups");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityRealmName name is " + realmName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resourceName name is " + resourceName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + domainName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "displayAccessIds name is " + displayAccessId);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "groupFilter name is " + groupFilter);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "numberOfGroups name is " + numberOfGroups);
            }
            if (realmName != null && realmName.length() == 0) {
                realmName = null;
            }
            if (resourceName != null && resourceName.length() == 0) {
                resourceName = null;
            }
            if (domainName != null && domainName.length() == 0) {
                domainName = null;
            }
            if (numberOfGroups < 1) {
                String msg = this.getMsg(resBundle, "security.admintask.greater.SECJ7756E", new Object[]{"numberOfGroups"});
                throw new CommandValidationException(msg);
            }
            if (realmName != null && (resourceName != null || domainName != null) || resourceName != null && (realmName != null || domainName != null) || domainName != null && (resourceName != null || realmName != null)) {
                String msg = this.getMsg(resBundle, "security.admintask.dupType.SECJ7761E", null);
                throw new CommandValidationException(msg);
            }
            AttributeList regAttrs = null;
            if (realmName != null) {
                regAttrs = this.getSecurityAttrsForRealm(session, configService, realmName);
                process = this.getResourceOfRealm(session, configService, realmName);
            } else if (resourceName != null) {
                regAttrs = this.getSecurityAttrsForResource(session, configService, resourceName);
                process = this.findProcessForResource(session, configService, resourceName);
            } else if (domainName != null) {
                regAttrs = this.getSecurityAttrsForDomain(session, configService, domainName);
                process = this.getResourceOfDomain(session, configService, domainName);
            } else {
                regAttrs = this.getSecurityAttrsForDomain(session, configService, null);
                process = this.getResourceOfDomain(session, configService, null);
            }
            if (regAttrs != null) {
                String registryType = (String)ConfigServiceHelper.getAttributeValue(regAttrs, "_Websphere_Config_Data_Type");
                if (registryType.equals("LocalOSUserRegistry")) {
                    groupList = this.getLocalOSList(regAttrs, method2, displayAccessId, groupFilter, numberOfGroups, process);
                } else if (registryType.equals("CustomUserRegistry")) {
                    groupList = this.getCustomList(regAttrs, method2, displayAccessId, groupFilter, numberOfGroups, process);
                } else if (registryType.equals("LDAPUserRegistry")) {
                    groupList = this.getLDAPList(regAttrs, method2, displayAccessId, groupFilter, numberOfGroups, process);
                } else if (registryType.equals("WIMUserRegistry")) {
                    groupList = this.getWIMList(regAttrs, method2, displayAccessId, groupFilter, numberOfGroups, process);
                }
            } else {
                String msg = this.getMsg(resBundle, "security.admintask.noUserReg.SECJ7762E", null);
                throw new CommandValidationException(msg);
            }
            if (groupList != null && realmName != null) {
                for (int i = 0; i < groupList.size(); ++i) {
                    Object group;
                    if (displayAccessId.booleanValue()) {
                        String name;
                        group = (AttributeList)groupList.get(i);
                        if (group == null || (name = (String)ConfigServiceHelper.getAttributeValue((AttributeList)group, "name")) == null) continue;
                        ConfigServiceHelper.setAttributeValue((AttributeList)group, "name", name + "@" + realmName);
                        continue;
                    }
                    group = (String)groupList.get(i);
                    if (group == null) continue;
                    groups.add((String)group + "@" + realmName);
                }
                if (!groups.isEmpty()) {
                    groupList.clear();
                    groupList = groups;
                }
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "229");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listGroupsInRealm");
            }
        }
        return groupList;
    }

    public void configureTrustedRealms(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureTrustedRealm");
        }
        ObjectName secObj = null;
        AttributeList attrList = new AttributeList();
        String type = null;
        try {
            ObjectName trustedRealmObj;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String secDomain = (String)cmd.getParameter("securityDomainName");
            String commoType = (String)cmd.getParameter("communicationType");
            String realmList = (String)cmd.getParameter("realmList");
            Boolean trustAllRealms = (Boolean)cmd.getParameter("trustAllRealms");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomain name is " + secDomain);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "realmList name is " + realmList);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "trustAllRealms name is " + trustAllRealms);
            }
            if (secDomain != null) {
                secObj = SecConfigTaskHelper.getSecDomain(session, configService, secDomain);
                if (secObj == null) {
                    String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomain});
                    throw new CommandValidationException(msg);
                }
            } else {
                secObj = SecConfigTaskHelper.getSecurityObjectName(session, configService);
            }
            if (commoType.equalsIgnoreCase("inbound")) {
                type = "inboundTrustedAuthenticationRealm";
            } else if (commoType.equalsIgnoreCase("outbound")) {
                type = "outboundTrustedAuthenticationRealm";
            } else {
                String msg = this.getMsg(resBundle, "security.admintask.invalidCommoType.SECJ7752E", null);
                throw new CommandValidationException(msg);
            }
            if (realmList != null) {
                attrList.add(new Attribute("realmList", realmList));
            }
            if (trustAllRealms != null) {
                attrList.add(new Attribute("trustAllRealms", trustAllRealms));
            }
            if ((trustedRealmObj = SecConfigTaskHelper.getTrustedRealms(session, configService, secObj, type)) != null) {
                configService.setAttributes(session, trustedRealmObj, attrList);
            } else {
                configService.createConfigData(session, secObj, type, "TrustedAuthenticationRealm", attrList);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "315");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "configureTrustedRealm");
            }
        }
    }

    public void addTrustedRealms(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTrustedRealm");
        }
        ObjectName secObj = null;
        AttributeList attrList = new AttributeList();
        String type = null;
        String realms = null;
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String commoType = (String)cmd.getParameter("communicationType");
            String secDomain = (String)cmd.getParameter("securityDomainName");
            String realmList = (String)cmd.getParameter("realmList");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomain name is " + secDomain);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "realmList name is " + realmList);
            }
            if (secDomain != null) {
                secObj = SecConfigTaskHelper.getSecDomain(session, configService, secDomain);
                if (secObj == null) {
                    String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomain});
                    throw new CommandValidationException(msg);
                }
            } else {
                secObj = SecConfigTaskHelper.getSecurityObjectName(session, configService);
            }
            if (commoType.equalsIgnoreCase("inbound")) {
                type = "inboundTrustedAuthenticationRealm";
            } else if (commoType.equalsIgnoreCase("outbound")) {
                type = "outboundTrustedAuthenticationRealm";
            } else {
                String msg = this.getMsg(resBundle, "security.admintask.invalidCommoType.SECJ7752E", null);
                throw new CommandValidationException(msg);
            }
            ObjectName trustedRealmObj = SecConfigTaskHelper.getTrustedRealms(session, configService, secObj, type);
            if (realmList != null && realmList.length() > 0) {
                realms = SecurityRealmProvider.addRealmsToList(session, configService, trustedRealmObj, realmList);
            }
            if (realms == null || realms.length() <= 0) {
                String msg = this.getMsg(resBundle, "security.admintask.noRealms.SECJ7753E", null);
                throw new CommandValidationException(msg);
            }
            attrList.add(new Attribute("realmList", realms));
            if (trustedRealmObj != null) {
                configService.setAttributes(session, trustedRealmObj, attrList);
            } else {
                configService.createConfigData(session, secObj, type, "TrustedAuthenticationRealm", attrList);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "398");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addTrustedRealm");
            }
        }
    }

    public List listTrustedRealms(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listTrustedRealms");
        }
        List realms = new ArrayList();
        String type = null;
        String gsRealm = null;
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String commoType = (String)cmd.getParameter("communicationType");
            String realmName = (String)cmd.getParameter("securityRealmName");
            String resourceName = (String)cmd.getParameter("resourceName");
            String domainName = (String)cmd.getParameter("securityDomainName");
            Boolean expandRealmList = (Boolean)cmd.getParameter("expandRealmList");
            Boolean includeCurrentRealm = (Boolean)cmd.getParameter("includeCurrentRealm");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "communicationType name is " + commoType);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityRealmName name is " + realmName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resourceName name is " + resourceName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + domainName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expandRealmList name is " + expandRealmList);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expandRealmList name is " + expandRealmList);
            }
            if (realmName != null && realmName.length() == 0) {
                realmName = null;
            }
            if (resourceName != null && resourceName.length() == 0) {
                resourceName = null;
            }
            if (domainName != null && domainName.length() == 0) {
                domainName = null;
            }
            if (commoType.equalsIgnoreCase("inbound")) {
                type = "inboundTrustedAuthenticationRealm";
            } else if (commoType.equalsIgnoreCase("outbound")) {
                type = "outboundTrustedAuthenticationRealm";
            } else {
                String msg = this.getMsg(resBundle, "security.admintask.invalidCommoType.SECJ7752E", null);
                throw new CommandValidationException(msg);
            }
            if (realmName != null && (resourceName != null || domainName != null) || resourceName != null && (realmName != null || domainName != null) || domainName != null && (resourceName != null || realmName != null)) {
                String msg = this.getMsg(resBundle, "security.admintask.dupType.SECJ7761E", null);
                throw new CommandValidationException(msg);
            }
            if (!type.equals("outboundTrustedAuthenticationRealm")) {
                gsRealm = this.getGlobalSecurityRealm(session, configService);
            }
            realms = realmName != null ? this.findTrustedRealmAttrs(session, configService, realmName, type, gsRealm, expandRealmList, includeCurrentRealm) : (resourceName != null ? this.findTrustedRealmAttrsForResource(session, configService, resourceName, type, gsRealm, expandRealmList, includeCurrentRealm) : (domainName != null ? this.findTrustedRealmAttrsForDomain(session, configService, domainName, type, gsRealm, expandRealmList, includeCurrentRealm) : this.findTrustedRealmAttrsForDomain(session, configService, null, type, gsRealm, expandRealmList, includeCurrentRealm)));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listTrustedRealms", new Object[]{realms});
            }
            return realms;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "483");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
    }

    public void removeTrustedRealms(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTrustedRealm");
        }
        ObjectName secObj = null;
        AttributeList attrList = new AttributeList();
        String type = null;
        try {
            String realm;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String commoType = (String)cmd.getParameter("communicationType");
            String secDomain = (String)cmd.getParameter("securityDomainName");
            String realmList = (String)cmd.getParameter("realmList");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomain name is " + secDomain);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "realmList name is " + realmList);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "communicationType name is " + commoType);
            }
            if (secDomain != null) {
                secObj = SecConfigTaskHelper.getSecDomain(session, configService, secDomain);
                if (secObj == null) {
                    String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomain});
                    throw new CommandValidationException(msg);
                }
            } else {
                secObj = SecConfigTaskHelper.getSecurityObjectName(session, configService);
            }
            if (commoType.equalsIgnoreCase("inbound")) {
                type = "inboundTrustedAuthenticationRealm";
            } else if (commoType.equalsIgnoreCase("outbound")) {
                type = "outboundTrustedAuthenticationRealm";
            } else {
                String msg = this.getMsg(resBundle, "security.admintask.invalidCommoType.SECJ7752E", null);
                throw new CommandValidationException(msg);
            }
            String gsRealm = this.getGlobalSecurityRealm(session, configService);
            if (gsRealm != null && this.isRealmInRealmList(gsRealm, realmList)) {
                String msg = this.getMsg(resBundle, "security.admintask.cannotRemoveRealm.SECJ7795E", new Object[]{gsRealm});
                throw new CommandValidationException(msg);
            }
            ObjectName aur = (ObjectName)configService.getAttribute(session, secObj, "activeUserRegistry");
            if (aur != null && this.isRealmInRealmList(realm = (String)configService.getAttribute(session, aur, "realm"), realmList)) {
                String msg = this.getMsg(resBundle, "security.admintask.cannotRemoveRealm.SECJ7796E", new Object[]{realm});
                throw new CommandValidationException(msg);
            }
            ObjectName trustedRealmObj = SecConfigTaskHelper.getTrustedRealms(session, configService, secObj, type);
            if (trustedRealmObj != null) {
                if (realmList != null && realmList.length() > 0) {
                    String realms = SecConfigTaskHelper.updateRealmList(session, configService, trustedRealmObj, realmList);
                    attrList.add(new Attribute("realmList", realms));
                }
            } else {
                String msg = this.getMsg(resBundle, "security.admintask.noTrustedRealm.SECJ7755E", null);
                throw new CommandValidationException(msg);
            }
            if (trustedRealmObj != null && !attrList.isEmpty()) {
                configService.setAttributes(session, trustedRealmObj, attrList);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "652");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeTrustedRealm");
            }
        }
    }

    public void unconfigureTrustedRealms(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unconfigureTrustedRealms");
        }
        ObjectName secObj = null;
        String type = null;
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String commoType = (String)cmd.getParameter("communicationType");
            String secDomain = (String)cmd.getParameter("securityDomainName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "commoType name is " + commoType);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "secDomain name is " + secDomain);
            }
            if (secDomain != null) {
                secObj = SecConfigTaskHelper.getSecDomain(session, configService, secDomain);
                if (secObj == null) {
                    String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomain});
                    throw new CommandValidationException(msg);
                }
            } else {
                secObj = SecConfigTaskHelper.getSecurityObjectName(session, configService);
            }
            if (commoType.equalsIgnoreCase("inbound")) {
                type = "inboundTrustedAuthenticationRealm";
            } else if (commoType.equalsIgnoreCase("outbound")) {
                type = "outboundTrustedAuthenticationRealm";
            } else {
                String msg = this.getMsg(resBundle, "security.admintask.invalidCommoType.SECJ7752E", null);
                throw new CommandValidationException(msg);
            }
            ObjectName trustedRealmObj = SecConfigTaskHelper.getTrustedRealms(session, configService, secObj, type);
            if (trustedRealmObj != null) {
                configService.deleteConfigData(session, trustedRealmObj);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "315");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "unconfigureTrustedRealms");
            }
        }
    }

    private List getList(Properties props, String method2, Boolean getAccessIds, String filter, int number, String process) throws Exception {
        List userList = null;
        List<AttributeList> returnList = new ArrayList();
        boolean isUser = true;
        try {
            if (method2.equals("getGroups")) {
                isUser = false;
            }
            if (filter == null) {
                filter = "*";
            }
            String processName = null;
            ObjectName on = null;
            processName = process != null && process.indexOf("Server=") >= 0 ? process.substring(process.indexOf("Server=") + 7) : AdminServiceFactory.getAdminService().getProcessName();
            on = new ObjectName("WebSphere:type=SecurityAdmin,process=" + processName + ",*");
            Iterator it = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
            if (!it.hasNext()) {
                String msg = "Server process not found for " + processName;
                throw new ServerProcessNotFoundException(msg);
            }
            on = (ObjectName)it.next();
            Result results = (Result)AdminServiceFactory.getAdminService().invoke(on, method2, new Object[]{filter, new Integer(number), props}, new String[]{"java.lang.String", "java.lang.Integer", "java.util.Properties"});
            if (results != null && results.getList() != null) {
                userList = results.getList();
                if (getAccessIds != null && getAccessIds.booleanValue()) {
                    for (int i = 0; i < userList.size(); ++i) {
                        String name = (String)userList.get(i);
                        String id = (String)AdminServiceFactory.getAdminService().invoke(on, "getAccessIds", new Object[]{new Boolean(isUser), name, props}, new String[]{Boolean.TYPE.getName(), String.class.getName(), Properties.class.getName()});
                        if (id == null) continue;
                        AttributeList attrs = new AttributeList();
                        attrs.add(new Attribute("name", name));
                        attrs.add(new Attribute("accessId", id));
                        returnList.add(attrs);
                    }
                } else {
                    returnList = userList;
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "710");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while trying get the userList", e);
            }
            throw e;
        }
        return returnList;
    }

    private AttributeList getSecurityAttrsForRealm(Session session, ConfigService configService, String realmName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityAttrsForRealm", realmName);
        }
        try {
            ArrayList registries;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName security2 = configService.queryConfigObjects(session, null, pattern, null)[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security ObjectName is " + security2 + ". Cell Name is " + ConfigServiceHelper.getDisplayName(security2));
            }
            if ((registries = (ArrayList)configService.getAttribute(session, security2, "userRegistries")) != null) {
                for (int i = 0; i < registries.size(); ++i) {
                    AttributeList urAttrs = (AttributeList)registries.get(i);
                    String realm = (String)ConfigServiceHelper.getAttributeValue(urAttrs, "realm");
                    if (realm == null || !realm.equals(realmName)) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSecurityObjectName");
                    }
                    return urAttrs;
                }
            }
            pattern = ConfigServiceHelper.createObjectName(null, "AppSecurity");
            ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
            for (int i = 0; i < domains.length; ++i) {
                ObjectName domain = domains[i];
                registries = (ArrayList)configService.getAttribute(session, domain, "userRegistries");
                if (registries == null) continue;
                for (int j = 0; j < registries.size(); ++j) {
                    AttributeList urAttrs = (AttributeList)registries.get(j);
                    String realm = (String)ConfigServiceHelper.getAttributeValue(urAttrs, "realm");
                    if (realm == null || !realm.equals(realmName)) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSecurityObjectName");
                    }
                    return urAttrs;
                }
            }
            PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
            if (platformHelper.isZOS()) {
                Properties props;
                String zRealm;
                AttributeList activeRegAttrs;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Looking to see if the ZOS realm is a match");
                }
                String aurType = null;
                ObjectName aur = (ObjectName)configService.getAttribute(session, security2, "activeUserRegistry");
                if (aur != null && (aurType = (String)ConfigServiceHelper.getAttributeValue(activeRegAttrs = configService.getAttributes(session, aur, null, false), "_Websphere_Config_Data_Type")).equalsIgnoreCase("LocalOSUserRegistry") && (zRealm = SecConfigTaskHelper.getDefaultRealm(props = this.getLocalOSProps(activeRegAttrs))).equals(realmName)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSecurityObjectName - ZOS realm");
                    }
                    return activeRegAttrs;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Realm not found in Zos");
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "772");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityObjectName");
        }
        return null;
    }

    private AttributeList getSecurityAttrsForDomain(Session session, ConfigService configService, String domainName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityAttrsForDomain", domainName);
        }
        try {
            AttributeList registryAttrs = null;
            if (domainName == null) {
                ObjectName registry;
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
                ObjectName security2 = configService.queryConfigObjects(session, null, pattern, null)[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security ObjectName is " + security2 + ". Cell Name is " + ConfigServiceHelper.getDisplayName(security2));
                }
                if ((registry = (ObjectName)configService.getAttribute(session, security2, "activeUserRegistry")) != null) {
                    registryAttrs = configService.getAttributes(session, registry, null, true);
                    return registryAttrs;
                }
            } else {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
                ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
                for (int i = 0; i < domains.length; ++i) {
                    ObjectName registry;
                    ObjectName[] apps;
                    ObjectName domain = domains[i];
                    String name = (String)configService.getAttribute(session, domain, "name");
                    if (!name.equals(domainName) || (apps = configService.queryConfigObjects(session, domain, pattern = ConfigServiceHelper.createObjectName(null, "AppSecurity"), null))[0] == null || (registry = (ObjectName)configService.getAttribute(session, apps[0], "activeUserRegistry")) == null) continue;
                    registryAttrs = configService.getAttributes(session, registry, null, true);
                    return registryAttrs;
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "772");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityAttrsForDomain");
        }
        return null;
    }

    private AttributeList getSecurityAttrsForResource(Session session, ConfigService configService, String resourceName) throws Exception {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecurityAttrsForResource", resourceName);
            }
            try {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
                ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
                String resource = null;
                AttributeList registryAttrs = null;
                ObjectName[] resourceObjectName = configService.resolve(session, resourceName);
                if (resourceObjectName.length > 0) {
                    String resConfigID = ConfigServiceHelper.getConfigDataId(resourceObjectName[0]).toString();
                    String resourceType = ConfigServiceHelper.getConfigDataType(resourceObjectName[0]);
                    if (!DomainCheckerExtensionsProcessor.getProcessor().processHandleResource(resourceType)) {
                        String msg = this.getMsg(resBundle, "security.admintask.scopeNotValid.SECJ7718E", new Object[]{resourceName});
                        throw new CommandValidationException(msg);
                    }
                    resource = resConfigID != null && resConfigID.lastIndexOf(124) > 0 ? resConfigID.substring(0, resConfigID.lastIndexOf(124)) : resConfigID;
                    for (int i = 0; i < domains.length; ++i) {
                        ObjectName domain = domains[i];
                        List members = (List)configService.getAttribute(session, domain, "members");
                        for (int j = 0; j < members.size(); ++j) {
                            ObjectName registry;
                            ObjectName[] apps;
                            AttributeList member = (AttributeList)members.get(j);
                            String resourceMember = (String)ConfigServiceHelper.getAttributeValue(member, "resourceName");
                            if (!resourceMember.equalsIgnoreCase(resource) || (apps = configService.queryConfigObjects(session, domain, pattern = ConfigServiceHelper.createObjectName(null, "AppSecurity"), null))[0] == null || (registry = (ObjectName)configService.getAttribute(session, apps[0], "activeUserRegistry")) == null) continue;
                            registryAttrs = configService.getAttributes(session, registry, null, true);
                            return registryAttrs;
                        }
                    }
                    break block9;
                }
                String msg = this.getMsg(resBundle, "security.admintask.scopeNotValid.SECJ7718E", new Object[]{resourceName});
                throw new CommandValidationException(msg);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "772");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", e);
                }
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityAttrsForResource");
        }
        return null;
    }

    private List getCellRealms(Session session, ConfigService cs, ObjectName secObj) throws Exception {
        List realmList = new ArrayList();
        try {
            realmList = this.getRealmNames(session, cs, secObj, realmList);
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "AppSecurity");
            ObjectName[] domains = cs.queryConfigObjects(session, null, pattern, null);
            for (int i = 0; i < domains.length; ++i) {
                ObjectName domain = domains[i];
                realmList = this.getRealmNames(session, cs, domain, realmList);
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "971");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listSecurityRealms");
            }
        }
        return realmList;
    }

    private List getRealmNames(Session session, ConfigService cs, ObjectName secObj, List realmList) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealmNames");
        }
        try {
            ArrayList registries = (ArrayList)cs.getAttribute(session, secObj, "userRegistries");
            if (registries != null) {
                for (int i = 0; i < registries.size(); ++i) {
                    AttributeList urAttrs = (AttributeList)registries.get(i);
                    String realm = (String)ConfigServiceHelper.getAttributeValue(urAttrs, "realm");
                    if (realm == null || realm.length() <= 0 || realmList.contains(realm)) continue;
                    realmList.add(realm);
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "839");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealmNames");
        }
        return realmList;
    }

    private List getLocalOSList(AttributeList attrs, String method2, Boolean getAccessIds, String filter, int number, String process) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalOSList");
        }
        List list = null;
        Properties props = this.getLocalOSProps(attrs);
        if (props != null) {
            list = this.getList(props, method2, getAccessIds, filter, number, process);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalOSList");
        }
        return list;
    }

    private Properties getLocalOSProps(AttributeList attrs) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalOSProps");
        }
        Properties props = new Properties();
        props = this.getCustomProperties(attrs, props);
        props.setProperty("activeRegistry", "LOCALOS");
        Boolean ignoreCase = (Boolean)ConfigServiceHelper.getAttributeValue(attrs, "ignoreCase");
        if (ignoreCase != null) {
            props.setProperty("security.registry.IgnoreCase", ignoreCase.toString());
        }
        Boolean useRegistryRealm = (Boolean)ConfigServiceHelper.getAttributeValue(attrs, "useRegistryRealm");
        String myRealm = (String)ConfigServiceHelper.getAttributeValue(attrs, "realm");
        if (useRegistryRealm != null && myRealm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting WAS_UseRegistryRealm = " + useRegistryRealm.toString() + " and WAS_Realm = " + myRealm);
            }
            props.setProperty("WAS_UseRegistryRealm", useRegistryRealm.toString());
            props.setProperty("WAS_Realm", myRealm);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalOSProps");
        }
        return props;
    }

    private List getWIMList(AttributeList attrs, String method2, Boolean getAccessIds, String filter, int number, String process) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWIMList");
        }
        List list = null;
        Properties props = this.getWIMProps(attrs);
        if (props != null) {
            list = this.getList(props, method2, getAccessIds, filter, number, process);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWIMList");
        }
        return list;
    }

    private Properties getWIMProps(AttributeList attrs) throws Exception {
        Boolean ignoreCase;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWIMList");
        }
        Properties props = new Properties();
        props = this.getCustomProperties(attrs, props);
        String registryClassName = (String)ConfigServiceHelper.getAttributeValue(attrs, "registryClassName");
        if (registryClassName != null) {
            props.setProperty("CustUserRegImplClass", registryClassName);
        }
        if ((ignoreCase = (Boolean)ConfigServiceHelper.getAttributeValue(attrs, "ignoreCase")) != null) {
            props.setProperty("security.registry.IgnoreCase", ignoreCase.toString());
        }
        props.setProperty("activeRegistry", "WIM");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWIMList");
        }
        return props;
    }

    private List getCustomList(AttributeList attrs, String method2, Boolean getAccessIds, String filter, int number, String process) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomList");
        }
        List list = null;
        Properties props = this.getCustomProps(attrs);
        if (props != null) {
            list = this.getList(props, method2, getAccessIds, filter, number, process);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomList");
        }
        return list;
    }

    private Properties getCustomProps(AttributeList attrs) throws Exception {
        Boolean ignoreCase;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomProps");
        }
        Properties props = new Properties();
        props = this.getCustomProperties(attrs, props);
        props.setProperty("activeRegistry", "CUSTOM");
        String customRegClass = (String)ConfigServiceHelper.getAttributeValue(attrs, "customRegistryClassName");
        if (customRegClass != null) {
            props.setProperty("CustUserRegImplClass", customRegClass);
        }
        if ((ignoreCase = (Boolean)ConfigServiceHelper.getAttributeValue(attrs, "ignoreCase")) != null) {
            props.setProperty("security.registry.IgnoreCase", ignoreCase.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomProps");
        }
        return props;
    }

    private List getLDAPList(AttributeList attrs, String method2, Boolean getAccessIds, String filter, int number, String process) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLDAPList");
        }
        List list = null;
        Properties props = this.getLDAPProps(attrs);
        if (props != null) {
            list = this.getList(props, method2, getAccessIds, filter, number, process);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLDAPList");
        }
        return list;
    }

    private Properties getLDAPProps(AttributeList attrs) throws Exception {
        AttributeList hostAttrs;
        List hosts;
        Boolean ignoreCase;
        String realm;
        Boolean sslEnabled;
        String type;
        Long timeout;
        Boolean reuseConnection;
        String bindPwd;
        String bindDN;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLDAPProps");
        }
        Properties props = new Properties();
        props = this.getCustomProperties(attrs, props);
        props.setProperty("activeRegistry", "LDAP");
        String baseDN = (String)ConfigServiceHelper.getAttributeValue(attrs, "baseDN");
        if (baseDN != null) {
            props.setProperty("ldap.basedn", baseDN);
        }
        if ((bindDN = (String)ConfigServiceHelper.getAttributeValue(attrs, "bindDN")) != null) {
            props.setProperty("java.naming.security.principal", bindDN);
        }
        if ((bindPwd = (String)ConfigServiceHelper.getAttributeValue(attrs, "bindPassword")) != null) {
            props.setProperty("java.naming.security.credentials", bindPwd);
        }
        if ((reuseConnection = (Boolean)ConfigServiceHelper.getAttributeValue(attrs, "reuseConnection")) != null) {
            props.setProperty("security.registry.ldap.reuseConn", reuseConnection.toString());
        }
        if ((timeout = (Long)ConfigServiceHelper.getAttributeValue(attrs, "searchTimeout")) != null) {
            props.setProperty("security.registry.ldap.searchTimeLimit", timeout.toString());
        }
        if ((type = (String)ConfigServiceHelper.getAttributeValue(attrs, "type")) != null) {
            props.setProperty("dirType", type);
        }
        if ((sslEnabled = (Boolean)ConfigServiceHelper.getAttributeValue(attrs, "sslEnabled")) != null) {
            props.put("sslEnabled", sslEnabled);
        }
        if ((realm = (String)ConfigServiceHelper.getAttributeValue(attrs, "realm")) != null) {
            props.setProperty("LDAP.server.realm", realm);
        }
        if ((ignoreCase = (Boolean)ConfigServiceHelper.getAttributeValue(attrs, "ignoreCase")) != null) {
            props.setProperty("security.registry.IgnoreCase", ignoreCase.toString());
        }
        if ((hosts = (List)ConfigServiceHelper.getAttributeValue(attrs, "hosts")) != null && (hostAttrs = (AttributeList)hosts.get(0)) != null) {
            String host = (String)ConfigServiceHelper.getAttributeValue(hostAttrs, "host");
            Integer port = (Integer)ConfigServiceHelper.getAttributeValue(hostAttrs, "port");
            if (host != null && port != null) {
                String ldapProtocol = "ldap://";
                StringBuffer ldapUrl = new StringBuffer();
                if (host.indexOf(":") != -1) {
                    ldapUrl.append(ldapProtocol).append("[" + host + "]");
                } else {
                    ldapUrl.append(ldapProtocol).append(host);
                }
                if (port != null && port > 0) {
                    ldapUrl.append(":" + port);
                }
                props.setProperty("java.naming.provider.url", ldapUrl.toString());
            }
        }
        props.setProperty("CustUserRegImplClass", "com.ibm.ws.security.registry.ldap.LdapRegistryImpl");
        AttributeList searchAttrs = (AttributeList)ConfigServiceHelper.getAttributeValue(attrs, "searchFilter");
        if (searchAttrs != null) {
            String certFilter;
            String certMode;
            String groupMemberIdMap;
            String groupIdMap;
            String userIdMap;
            String groupFilter;
            String userFilter = (String)ConfigServiceHelper.getAttributeValue(searchAttrs, "userFilter");
            if (userFilter != null) {
                props.setProperty("user.filter", userFilter);
            }
            if ((groupFilter = (String)ConfigServiceHelper.getAttributeValue(searchAttrs, "groupFilter")) != null) {
                props.setProperty("group.filter", groupFilter);
            }
            if ((userIdMap = (String)ConfigServiceHelper.getAttributeValue(searchAttrs, "userIdMap")) != null) {
                props.setProperty("user.idmap", userIdMap);
            }
            if ((groupIdMap = (String)ConfigServiceHelper.getAttributeValue(searchAttrs, "groupIdMap")) != null) {
                props.setProperty("group.idmap", groupIdMap);
            }
            if ((groupMemberIdMap = (String)ConfigServiceHelper.getAttributeValue(searchAttrs, "groupMemberIdMap")) != null) {
                props.setProperty("groupmember.idmap", groupMemberIdMap);
            }
            if ((certMode = (String)ConfigServiceHelper.getAttributeValue(searchAttrs, "certificateMapMode")) != null) {
                if (certMode.equals("EXACT_DN")) {
                    props.setProperty("certificate.map.mode", "exactDNMode");
                } else {
                    props.setProperty("certificate.map.mode", certMode);
                }
            }
            if ((certFilter = (String)ConfigServiceHelper.getAttributeValue(searchAttrs, "certificateFilter")) != null) {
                props.setProperty("certificate.map.filter", certFilter);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLDAPProps");
        }
        return props;
    }

    private Properties getCustomProperties(AttributeList attrs, Properties props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomProperties");
        }
        List regProps = (List)ConfigServiceHelper.getAttributeValue(attrs, "properties");
        if (regProps != null) {
            for (int i = 0; i < regProps.size(); ++i) {
                AttributeList property = (AttributeList)regProps.get(i);
                String name = (String)ConfigServiceHelper.getAttributeValue(property, "name");
                String value = (String)ConfigServiceHelper.getAttributeValue(property, "value");
                props.setProperty(name, value);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomProperties");
        }
        return props;
    }

    private static String addRealmsToList(Session session, ConfigService configService, ObjectName trustedRealmObj, String realmList) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRealmsToList");
        }
        String realmsFromConfig = null;
        if (trustedRealmObj != null) {
            realmsFromConfig = (String)configService.getAttribute(session, trustedRealmObj, "realmList");
        }
        if (realmsFromConfig != null && realmsFromConfig.length() > 0) {
            String[] cfgRealms = realmsFromConfig.split("\\|");
            String[] cmdRealms = realmList.split("\\|");
            for (int i = 0; i < cmdRealms.length; ++i) {
                String addRealm = null;
                for (int j = 0; j < cfgRealms.length; ++j) {
                    addRealm = cmdRealms[i];
                    if (!cfgRealms[j].equals(addRealm)) continue;
                    addRealm = null;
                    break;
                }
                if (addRealm == null) continue;
                realmsFromConfig = realmsFromConfig + "|" + addRealm;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addRealmsToList");
            }
            return realmsFromConfig;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRealmsToList");
        }
        return realmList;
    }

    private List findTrustedRealmAttrs(Session session, ConfigService configService, String realmName, String type, String gsRealm, boolean expandRealmList, boolean includeCurrentRealm) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findTrustedRealmAttrs", new Object[]{realmName, type, gsRealm});
        }
        List<String> realms = new ArrayList();
        AttributeList trustedRealms = new AttributeList();
        String realm = null;
        String realmString = null;
        try {
            ArrayList registries;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName security2 = configService.queryConfigObjects(session, null, pattern, null)[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security ObjectName is " + security2 + ". Cell Name is " + ConfigServiceHelper.getDisplayName(security2));
            }
            if ((registries = (ArrayList)configService.getAttribute(session, security2, "userRegistries")) != null) {
                for (int i = 0; i < registries.size(); ++i) {
                    AttributeList urAttrs = (AttributeList)registries.get(i);
                    realm = (String)ConfigServiceHelper.getAttributeValue(urAttrs, "realm");
                    if (realm == null || !realm.equals(realmName)) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "findTrustedRealmAttrs");
                    }
                    trustedRealms = (AttributeList)configService.getAttribute(session, security2, type);
                    if (!includeCurrentRealm) {
                        realm = null;
                    }
                    if (trustedRealms != null && !trustedRealms.isEmpty()) {
                        Boolean trustAllRealms = (Boolean)ConfigServiceHelper.getAttributeValue(trustedRealms, "trustAllRealms");
                        if (trustAllRealms != null && trustAllRealms.booleanValue()) {
                            if (expandRealmList) {
                                realms = this.getAllRealms(session, configService, realm, gsRealm);
                            } else {
                                realms.add("trustAllRealms");
                            }
                            return realms;
                        }
                        realmString = (String)ConfigServiceHelper.getAttributeValue(trustedRealms, "realmList");
                    }
                    realms = this.makeRealmList(realmString, realm, gsRealm);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "findTrustedRealmAttrs", realms);
                    }
                    return realms;
                }
            }
            pattern = ConfigServiceHelper.createObjectName(null, "AppSecurity");
            ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
            for (int i = 0; i < domains.length; ++i) {
                ObjectName domain = domains[i];
                registries = (ArrayList)configService.getAttribute(session, domain, "userRegistries");
                if (registries == null) continue;
                for (int j = 0; j < registries.size(); ++j) {
                    AttributeList urAttrs = (AttributeList)registries.get(j);
                    realm = (String)ConfigServiceHelper.getAttributeValue(urAttrs, "realm");
                    if (realm == null || !realm.equals(realmName)) continue;
                    trustedRealms = (AttributeList)configService.getAttribute(session, security2, type);
                    if (!includeCurrentRealm) {
                        realm = null;
                    }
                    if (trustedRealms != null && !trustedRealms.isEmpty()) {
                        Boolean trustAllRealms = (Boolean)ConfigServiceHelper.getAttributeValue(trustedRealms, "trustAllRealms");
                        if (trustAllRealms != null && trustAllRealms.booleanValue()) {
                            if (expandRealmList) {
                                realms = this.getAllRealms(session, configService, realm, gsRealm);
                            } else {
                                realms.add("trustAllRealms");
                            }
                            return realms;
                        }
                        realmString = (String)ConfigServiceHelper.getAttributeValue(trustedRealms, "realmList");
                    }
                    realms = this.makeRealmList(realmString, realm, gsRealm);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "findTrustedRealmAttrs", realms);
                    }
                    return realms;
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "1219");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findTrustedRealmAttrs");
        }
        return realms;
    }

    private List findTrustedRealmAttrsForResource(Session session, ConfigService configService, String resourceName, String type, String gsRealm, boolean expandRealmList, boolean includeCurrentRealm) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findTrustedRealmAttrsForResource", new Object[]{resourceName, type, gsRealm});
        }
        List<String> realms = new ArrayList();
        AttributeList trustedRealms = new AttributeList();
        String resource = null;
        ObjectName cellApps = null;
        String realm = null;
        String realmString = null;
        try {
            ObjectName[] resourceObjectName = null;
            resourceObjectName = configService.resolve(session, resourceName);
            if (resourceObjectName.length > 0) {
                String resConfigID = ConfigServiceHelper.getConfigDataId(resourceObjectName[0]).toString();
                resource = resConfigID != null && resConfigID.lastIndexOf(124) > 0 ? resConfigID.substring(0, resConfigID.lastIndexOf(124)) : resConfigID;
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
                ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
                for (int i = 0; i < domains.length; ++i) {
                    ObjectName domain = domains[i];
                    List members = (List)configService.getAttribute(session, domain, "members");
                    for (int j = 0; j < members.size(); ++j) {
                        String resourceType;
                        AttributeList member = (AttributeList)members.get(j);
                        String resourceMember = (String)ConfigServiceHelper.getAttributeValue(member, "resourceName");
                        if (resourceMember.equalsIgnoreCase(resource)) {
                            pattern = ConfigServiceHelper.createObjectName(null, "AppSecurity");
                            ObjectName apps = configService.queryConfigObjects(session, domain, pattern, null)[0];
                            if (apps == null) continue;
                            ObjectName aur = (ObjectName)configService.getAttribute(session, apps, "activeUserRegistry");
                            if (aur != null && includeCurrentRealm) {
                                realm = (String)configService.getAttribute(session, aur, "realm");
                            }
                            if ((trustedRealms = (AttributeList)configService.getAttribute(session, apps, type)) != null && !trustedRealms.isEmpty()) {
                                Boolean trustAllRealms = (Boolean)ConfigServiceHelper.getAttributeValue(trustedRealms, "trustAllRealms");
                                if (trustAllRealms != null && trustAllRealms.booleanValue()) {
                                    if (expandRealmList) {
                                        realms = this.getAllRealms(session, configService, realm, gsRealm);
                                    } else {
                                        realms.add("trustAllRealms");
                                    }
                                    return realms;
                                }
                                realmString = (String)ConfigServiceHelper.getAttributeValue(trustedRealms, "realmList");
                            }
                            realms = this.makeRealmList(realmString, realm, gsRealm);
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "findTrustedRealmAttrsForResource", realms);
                            }
                            return realms;
                        }
                        ObjectName[] resourceObject = configService.resolve(session, SecDomainHelper.convertResource(resourceMember));
                        if (resourceObject.length <= 0 || !(resourceType = ConfigServiceHelper.getConfigDataType(resourceObject[0])).equalsIgnoreCase("Cell")) continue;
                        pattern = ConfigServiceHelper.createObjectName(null, "AppSecurity");
                        cellApps = configService.queryConfigObjects(session, domain, pattern, null)[0];
                    }
                }
                if (cellApps != null) {
                    ObjectName aur = (ObjectName)configService.getAttribute(session, cellApps, "activeUserRegistry");
                    if (aur != null && includeCurrentRealm) {
                        realm = (String)configService.getAttribute(session, aur, "realm");
                    }
                    if ((trustedRealms = (AttributeList)configService.getAttribute(session, cellApps, type)) != null && !trustedRealms.isEmpty()) {
                        Boolean trustAllRealms = (Boolean)ConfigServiceHelper.getAttributeValue(trustedRealms, "trustAllRealms");
                        if (trustAllRealms != null && trustAllRealms.booleanValue()) {
                            if (expandRealmList) {
                                realms = this.getAllRealms(session, configService, realm, gsRealm);
                            } else {
                                realms.add("trustAllRealms");
                            }
                            return realms;
                        }
                        realmString = (String)ConfigServiceHelper.getAttributeValue(trustedRealms, "realmList");
                    }
                    realms = this.makeRealmList(realmString, realm, gsRealm);
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "1288");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findTrustedRealmAttrsForResource", realms);
        }
        return realms;
    }

    private List findTrustedRealmAttrsForDomain(Session session, ConfigService configService, String domainName, String type, String gsRealm, boolean expandRealmList, boolean includeCurrentRealm) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findTrustedRealmAttrsForDomain", new Object[]{domainName, type, gsRealm});
        }
        List<String> realms = new ArrayList();
        AttributeList trustedRealms = new AttributeList();
        String realm = null;
        String realmString = null;
        try {
            if (domainName != null) {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
                ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
                for (int i = 0; i < domains.length; ++i) {
                    ObjectName[] apps;
                    ObjectName domain = domains[i];
                    String name = (String)configService.getAttribute(session, domain, "name");
                    if (!name.equals(domainName) || (apps = configService.queryConfigObjects(session, domain, pattern = ConfigServiceHelper.createObjectName(null, "AppSecurity"), null))[0] == null) continue;
                    ObjectName aur = (ObjectName)configService.getAttribute(session, apps[0], "activeUserRegistry");
                    if (aur != null && includeCurrentRealm) {
                        realm = (String)configService.getAttribute(session, aur, "realm");
                    }
                    if ((trustedRealms = (AttributeList)configService.getAttribute(session, apps[0], type)) != null && !trustedRealms.isEmpty()) {
                        Boolean trustAllRealms = (Boolean)ConfigServiceHelper.getAttributeValue(trustedRealms, "trustAllRealms");
                        if (trustAllRealms != null && trustAllRealms.booleanValue()) {
                            if (expandRealmList) {
                                realms = this.getAllRealms(session, configService, realm, gsRealm);
                            } else {
                                realms.add("trustAllRealms");
                            }
                            return realms;
                        }
                        realmString = (String)ConfigServiceHelper.getAttributeValue(trustedRealms, "realmList");
                    }
                    realms = this.makeRealmList(realmString, realm, gsRealm);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "findTrustedRealmAttrsForDomain", realms);
                    }
                    return realms;
                }
            } else {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
                ObjectName security2 = configService.queryConfigObjects(session, null, pattern, null)[0];
                if (security2 != null) {
                    ObjectName aur = (ObjectName)configService.getAttribute(session, security2, "activeUserRegistry");
                    if (aur != null && includeCurrentRealm) {
                        realm = (String)configService.getAttribute(session, aur, "realm");
                    }
                    if ((trustedRealms = (AttributeList)configService.getAttribute(session, security2, type)) != null && !trustedRealms.isEmpty()) {
                        Boolean trustAllRealms = (Boolean)ConfigServiceHelper.getAttributeValue(trustedRealms, "trustAllRealms");
                        if (trustAllRealms != null && trustAllRealms.booleanValue()) {
                            if (expandRealmList) {
                                realms = this.getAllRealms(session, configService, realm, gsRealm);
                            } else {
                                realms.add("trustAllRealms");
                            }
                            return realms;
                        }
                        realmString = (String)ConfigServiceHelper.getAttributeValue(trustedRealms, "realmList");
                    }
                    realms = this.makeRealmList(realmString, realm, gsRealm);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "findTrustedRealmAttrsForDomain", realms);
                    }
                    return realms;
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "1288");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findTrustedRealmAttrsForDomain");
        }
        return realms;
    }

    private List makeRealmList(String realmString, String realm, String gsRealm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeRealmList");
        }
        ArrayList<String> realmList = new ArrayList<String>();
        if (realmString != null && realmString.length() > 0) {
            String[] realms = realmString.split("\\|");
            for (int i = 0; i < realms.length; ++i) {
                realmList.add(realms[i]);
            }
        }
        if (realm != null && realm.length() > 0) {
            if (realmList.contains(realm)) {
                realmList.remove(realm);
            }
            realmList.add(0, realm);
        }
        if (gsRealm != null && gsRealm.length() > 0) {
            if (realmList.contains(gsRealm)) {
                realmList.remove(gsRealm);
            }
            if (realm != null && realm.length() > 0 && realmList.size() > 0) {
                realmList.add(1, gsRealm);
            } else {
                realmList.add(0, gsRealm);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeRealmList");
        }
        return realmList;
    }

    private String getGlobalSecurityRealm(Session session, ConfigService configService) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGlobalSecurityRealm");
        }
        ObjectName secObj = null;
        String realm = null;
        try {
            secObj = SecConfigTaskHelper.getSecurityObjectName(session, configService);
            ObjectName regObj = (ObjectName)configService.getAttribute(session, secObj, "activeUserRegistry");
            if (regObj != null) {
                realm = (String)configService.getAttribute(session, regObj, "realm");
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "1713");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGlobalSecurityRealm");
            }
        }
        return realm;
    }

    public Boolean checkRegistryUserPassword(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkRegistryUserPassword");
        }
        boolean authPassed = false;
        Boolean passed = null;
        String process = null;
        try {
            Properties props;
            String registryType;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String realmName = (String)cmd.getParameter("realmName");
            String domainName = (String)cmd.getParameter("securityDomainName");
            String resourceName = (String)cmd.getParameter("resourceName");
            String username = (String)cmd.getParameter("username");
            String password = (String)cmd.getParameter("password");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "realmName name is " + realmName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + domainName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resourceName name is " + resourceName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "username name is " + username);
            }
            if (realmName != null && realmName.length() == 0) {
                realmName = null;
            }
            if (domainName != null && domainName.length() == 0) {
                domainName = null;
            }
            if (realmName != null && (resourceName != null || domainName != null) || resourceName != null && (realmName != null || domainName != null) || domainName != null && (resourceName != null || realmName != null)) {
                String msg = this.getMsg(resBundle, "security.admintask.dupType.SECJ7761E", null);
                throw new CommandValidationException(msg);
            }
            AttributeList regAttrs = null;
            if (realmName != null) {
                regAttrs = this.getSecurityAttrsForRealm(session, configService, realmName);
                process = this.getResourceOfRealm(session, configService, realmName);
            } else if (resourceName != null) {
                regAttrs = this.getSecurityAttrsForResource(session, configService, resourceName);
                process = this.findProcessForResource(session, configService, resourceName);
            } else if (domainName != null) {
                regAttrs = this.getSecurityAttrsForDomain(session, configService, domainName);
                process = this.getResourceOfDomain(session, configService, domainName);
            } else {
                regAttrs = this.getSecurityAttrsForDomain(session, configService, null);
                process = this.getResourceOfDomain(session, configService, null);
            }
            if (regAttrs != null) {
                registryType = (String)ConfigServiceHelper.getAttributeValue(regAttrs, "_Websphere_Config_Data_Type");
                props = null;
                if (registryType.equals("LocalOSUserRegistry")) {
                    props = this.getLocalOSProps(regAttrs);
                } else if (registryType.equals("CustomUserRegistry")) {
                    props = this.getCustomProps(regAttrs);
                } else if (registryType.equals("LDAPUserRegistry")) {
                    props = this.getLDAPProps(regAttrs);
                } else if (registryType.equals("WIMUserRegistry")) {
                    props = this.getWIMProps(regAttrs);
                }
            } else {
                String msg = this.getMsg(resBundle, "security.admintask.noUserReg.SECJ7762E", null);
                throw new CommandValidationException(msg);
            }
            authPassed = SecConfigTaskHelper.authenticateUser(session, username, password, registryType, props, process);
            passed = authPassed ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "168");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkRegistryUserPassword");
            }
        }
        return passed;
    }

    public Boolean checkRegistryRunAsUser(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkRegistryRunAsUser");
        }
        boolean userChecked = false;
        Boolean passed = null;
        String process = null;
        try {
            Properties props;
            int i;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            ArrayList<String> userlist = new ArrayList<String>();
            ArrayList<String> grouplist = new ArrayList<String>();
            String realmName = (String)cmd.getParameter("realmName");
            String domainName = (String)cmd.getParameter("securityDomainName");
            String resourceName = (String)cmd.getParameter("resourceName");
            String userList = (String)cmd.getParameter("userList");
            String groupList = (String)cmd.getParameter("groupList");
            String username = (String)cmd.getParameter("username");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "realmName name is " + realmName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + domainName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resourceName name is " + resourceName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "userList name is " + userList);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "groupList name is " + groupList);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "username name is " + username);
            }
            if (realmName != null && realmName.length() == 0) {
                realmName = null;
            }
            if (domainName != null && domainName.length() == 0) {
                domainName = null;
            }
            if (resourceName != null && resourceName.length() == 0) {
                resourceName = null;
            }
            if (username != null && username.length() == 0) {
                username = null;
            }
            if (realmName != null && (resourceName != null || domainName != null) || resourceName != null && (realmName != null || domainName != null) || domainName != null && (resourceName != null || realmName != null)) {
                String msg = this.getMsg(resBundle, "security.admintask.dupType.SECJ7761E", null);
                throw new CommandValidationException(msg);
            }
            AttributeList regAttrs = null;
            if (realmName != null) {
                regAttrs = this.getSecurityAttrsForRealm(session, configService, realmName);
                process = this.getResourceOfRealm(session, configService, realmName);
            } else if (resourceName != null) {
                regAttrs = this.getSecurityAttrsForResource(session, configService, resourceName);
                process = this.findProcessForResource(session, configService, resourceName);
            } else if (domainName != null) {
                regAttrs = this.getSecurityAttrsForDomain(session, configService, domainName);
                process = this.getResourceOfDomain(session, configService, domainName);
            } else {
                regAttrs = this.getSecurityAttrsForDomain(session, configService, null);
                process = this.getResourceOfDomain(session, configService, null);
            }
            if (userList != null && userList.length() > 0) {
                String[] users = userList.split("\\|");
                for (i = 0; i < users.length; ++i) {
                    userlist.add(users[i]);
                }
            }
            if (groupList != null && groupList.length() > 0) {
                String[] groups = groupList.split("\\|");
                for (i = 0; i < groups.length; ++i) {
                    grouplist.add(groups[i]);
                }
            }
            if (regAttrs != null) {
                String registryType = (String)ConfigServiceHelper.getAttributeValue(regAttrs, "_Websphere_Config_Data_Type");
                props = null;
                if (registryType.equals("LocalOSUserRegistry")) {
                    props = this.getLocalOSProps(regAttrs);
                } else if (registryType.equals("CustomUserRegistry")) {
                    props = this.getCustomProps(regAttrs);
                } else if (registryType.equals("LDAPUserRegistry")) {
                    props = this.getLDAPProps(regAttrs);
                } else if (registryType.equals("WIMUserRegistry")) {
                    props = this.getWIMProps(regAttrs);
                }
            } else {
                String msg = this.getMsg(resBundle, "security.admintask.noUserReg.SECJ7762E", null);
                throw new CommandValidationException(msg);
            }
            userChecked = SecConfigTaskHelper.checkRunAsUser(session, userlist, grouplist, username, props, process);
            passed = userChecked ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "1976");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkRegistryRunAsUser");
            }
        }
        return passed;
    }

    public String getAccessIdFromServerId(AbstractAdminCommand cmd) throws Exception {
        String accessId;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getRegistryObj");
            }
            accessId = null;
            try {
                CommandProviderHelper helper = this.getCommandProviderHelper();
                ConfigService configService = helper.getConfigService();
                Session session = cmd.getConfigSession();
                String serverId = null;
                String realmName = (String)cmd.getParameter("realmName");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "realmName name is " + realmName);
                }
                if (realmName != null && realmName.length() == 0) {
                    realmName = null;
                }
                AttributeList regAttrs = null;
                regAttrs = realmName != null ? this.getSecurityAttrsForRealm(session, configService, realmName) : this.getSecurityAttrsForDomain(session, configService, null);
                if (regAttrs != null) {
                    String registryType = (String)ConfigServiceHelper.getAttributeValue(regAttrs, "_Websphere_Config_Data_Type");
                    Properties props = null;
                    serverId = (String)ConfigServiceHelper.getAttributeValue(regAttrs, "serverId");
                    if (serverId != null && serverId.length() > 0) {
                        if (registryType.equals("LocalOSUserRegistry")) {
                            props = this.getLocalOSProps(regAttrs);
                        } else if (registryType.equals("CustomUserRegistry")) {
                            props = this.getCustomProps(regAttrs);
                        } else if (registryType.equals("LDAPUserRegistry")) {
                            props = this.getLDAPProps(regAttrs);
                        } else if (registryType.equals("WIMUserRegistry")) {
                            props = this.getWIMProps(regAttrs);
                        }
                        if (props != null) {
                            accessId = this.getServerAccessId(serverId, props);
                        }
                    }
                    break block16;
                }
                String msg = this.getMsg(resBundle, "security.admintask.noUserReg.SECJ7762E", null);
                throw new CommandValidationException(msg);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "168");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", e);
                }
                throw e;
            }
        }
        return accessId;
    }

    private String getServerAccessId(String serverId, Properties props) throws Exception {
        if (tc.isEntryEnabled()) {
            Properties props1 = ConfigUtils.maskPasswords(props);
            Tr.entry(tc, "getServerAccessId " + props1);
        }
        String accessId = null;
        try {
            Boolean sslEnabled;
            Properties newProps = null;
            if (props != null) {
                newProps = new Properties();
                Enumeration<Object> e = props.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    newProps.put(key, props.get(key));
                }
            }
            if (newProps != null && (sslEnabled = (Boolean)newProps.get("sslEnabled")) != null && sslEnabled.booleanValue()) {
                Properties ssl2;
                block16: {
                    ssl2 = null;
                    try {
                        ssl2 = (Properties)newProps.get("sslConfig");
                    }
                    catch (ClassCastException e) {
                        SecureSocketLayer sslObject = (SecureSocketLayer)newProps.get("sslConfig");
                        if (sslObject == null) break block16;
                        try {
                            SSLConfig config = SSLConfigManager.getInstance().parseSecureSocketLayer(null, null, sslObject, true);
                            ssl2 = config;
                        }
                        catch (Exception ex) {
                            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.core.SecurityAdmin.createPropertiesFromSecureSocketLayer", "1814", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception converting the properties.", new Object[]{ex});
                            }
                            return null;
                        }
                    }
                }
                if (ssl2 != null) {
                    newProps.put("sslConfig", ssl2);
                }
            }
            UserRegistryImpl regImpl = new UserRegistryImpl();
            regImpl.initialize(newProps);
            String uniqueName = regImpl.getUniqueUserId(serverId);
            if (uniqueName != null) {
                accessId = uniqueName;
            }
        }
        catch (RemoteException re2) {
            FFDCFilter.processException((Throwable)re2, "com.ibm.ws.security.core.SecurityAdmin.getRegistry", "1778", this);
            Tr.error(tc, "security.registry.createerror", new Object[]{re2});
            throw re2;
        }
        catch (CustomRegistryException cre) {
            FFDCFilter.processException((Throwable)cre, "com.ibm.ws.security.core.SecurityAdmin.getRegistry", "1784", this);
            Tr.error(tc, "security.registry.createerror", new Object[]{cre});
            throw cre;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.getRegistry", "1790", this);
            Tr.error(tc, "security.registry.createerror", new Object[]{e});
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerAccessId", accessId);
        }
        return accessId;
    }

    private String getResourceOfDomain(Session session, ConfigService configService, String domainName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceOfDomain", domainName);
        }
        String process = null;
        try {
            Object registryAttrs = null;
            if (domainName != null) {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
                ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
                for (int i = 0; i < domains.length; ++i) {
                    AttributeList member;
                    String resourceName;
                    List members;
                    ObjectName domain = domains[i];
                    String name = (String)configService.getAttribute(session, domain, "name");
                    if (!name.equals(domainName)) continue;
                    pattern = ConfigServiceHelper.createObjectName(null, "AppSecurity");
                    ObjectName apps = configService.queryConfigObjects(session, domain, pattern, null)[0];
                    String propValue = (String)SecConfigTaskHelper.getPropertyValue(session, configService, apps, "properties", "com.ibm.websphere.lookupRegistryOnProcess");
                    if (propValue == null) {
                        ObjectName secObj = SecConfigTaskHelper.getSecurityObjectName(session, configService);
                        propValue = (String)SecConfigTaskHelper.getPropertyValue(session, configService, secObj, "properties", "com.ibm.websphere.lookupRegistryOnProcess");
                    }
                    if (propValue == null || !propValue.equalsIgnoreCase("true") || (members = (List)configService.getAttribute(session, domain, "members")).size() <= 0 || (resourceName = (String)ConfigServiceHelper.getAttributeValue(member = (AttributeList)members.get(0), "resourceName")) == null) continue;
                    process = SecDomainHelper.convertResource(resourceName);
                    return process;
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "2247");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityAttrsForDomain");
        }
        return process;
    }

    private String getResourceOfRealm(Session session, ConfigService configService, String realmName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceOfRealm", realmName);
        }
        String process = null;
        try {
            ArrayList registries;
            ObjectName security2 = SecConfigTaskHelper.getSecurityObjectName(session, configService);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security ObjectName is " + security2 + ". Cell Name is " + ConfigServiceHelper.getDisplayName(security2));
            }
            if ((registries = (ArrayList)configService.getAttribute(session, security2, "userRegistries")) != null) {
                for (int i = 0; i < registries.size(); ++i) {
                    AttributeList urAttrs = (AttributeList)registries.get(i);
                    String realm = (String)ConfigServiceHelper.getAttributeValue(urAttrs, "realm");
                    if (realm == null || !realm.equals(realmName)) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getResourceOfRealm");
                    }
                    return process;
                }
            }
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
            ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
            for (int i = 0; i < domains.length; ++i) {
                ObjectName domain = domains[i];
                pattern = ConfigServiceHelper.createObjectName(null, "AppSecurity");
                ObjectName apps = configService.queryConfigObjects(session, domain, pattern, null)[0];
                if (apps == null || (registries = (ArrayList)configService.getAttribute(session, apps, "userRegistries")) == null) continue;
                for (int j = 0; j < registries.size(); ++j) {
                    AttributeList urAttrs = (AttributeList)registries.get(j);
                    String realm = (String)ConfigServiceHelper.getAttributeValue(urAttrs, "realm");
                    if (realm == null || !realm.equals(realmName)) continue;
                    String propValue = (String)SecConfigTaskHelper.getPropertyValue(session, configService, apps, "properties", "com.ibm.websphere.lookupRegistryOnProcess");
                    if (propValue == null) {
                        propValue = (String)SecConfigTaskHelper.getPropertyValue(session, configService, security2, "properties", "com.ibm.websphere.lookupRegistryOnProcess");
                    }
                    if (propValue != null && propValue.equalsIgnoreCase("true")) {
                        AttributeList member;
                        String resourceName;
                        List members = (List)configService.getAttribute(session, domain, "members");
                        if (members.size() <= 0 || (resourceName = (String)ConfigServiceHelper.getAttributeValue(member = (AttributeList)members.get(0), "resourceName")) == null) continue;
                        process = SecDomainHelper.convertResource(resourceName);
                        return process;
                    }
                    return process;
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "772");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceOfRealm");
        }
        return process;
    }

    private String findProcessForResource(Session session, ConfigService configService, String resourceName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findProcessForResource", new Object[]{resourceName});
        }
        Object domainName = null;
        String resource = null;
        ObjectName[] resourceObjectName = configService.resolve(session, resourceName);
        if (resourceObjectName.length > 0) {
            String resConfigID = ConfigServiceHelper.getConfigDataId(resourceObjectName[0]).toString();
            resource = resConfigID != null && resConfigID.lastIndexOf(124) > 0 ? resConfigID.substring(0, resConfigID.lastIndexOf(124)) : resConfigID;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
            ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
            for (int j = 0; j < domains.length; ++j) {
                ObjectName domain = domains[j];
                List members = (List)configService.getAttribute(session, domain, "members");
                for (int k = 0; k < members.size(); ++k) {
                    AttributeList member = (AttributeList)members.get(k);
                    String resourceMember = (String)ConfigServiceHelper.getAttributeValue(member, "resourceName");
                    if (!resourceMember.equalsIgnoreCase(resource)) continue;
                    pattern = ConfigServiceHelper.createObjectName(null, "AppSecurity");
                    ObjectName apps = configService.queryConfigObjects(session, domain, pattern, null)[0];
                    String propValue = (String)SecConfigTaskHelper.getPropertyValue(session, configService, apps, "properties", "com.ibm.websphere.lookupRegistryOnProcess");
                    if (propValue == null) {
                        ObjectName security2 = SecConfigTaskHelper.getSecurityObjectName(session, configService);
                        propValue = (String)SecConfigTaskHelper.getPropertyValue(session, configService, security2, "properties", "com.ibm.websphere.lookupRegistryOnProcess");
                    }
                    if (propValue == null || !propValue.equalsIgnoreCase("true")) continue;
                    return resourceName;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findProcessForResource", new Object[]{domainName});
        }
        return null;
    }

    private List getAllRealms(Session session, ConfigService cs, String realm, String gsRealm) {
        ArrayList<String> realmList;
        block12: {
            realmList = new ArrayList<String>();
            ObjectName sec2 = null;
            try {
                sec2 = SecConfigTaskHelper.getSecurityObjectName(session, cs);
                ArrayList registries = (ArrayList)cs.getAttribute(session, sec2, "userRegistries");
                if (registries != null) {
                    for (int i = 0; i < registries.size(); ++i) {
                        AttributeList urAttrs = (AttributeList)registries.get(i);
                        String realmName = (String)ConfigServiceHelper.getAttributeValue(urAttrs, "realm");
                        if (realmName == null || realmName.length() <= 0 || realmList.contains(realmName)) continue;
                        realmList.add(realmName);
                    }
                }
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
                ObjectName[] domains = cs.queryConfigObjects(session, null, pattern, null);
                for (int i = 0; i < domains.length; ++i) {
                    ObjectName domain = domains[i];
                    pattern = ConfigServiceHelper.createObjectName(null, "AppSecurity");
                    ObjectName apps = cs.queryConfigObjects(session, domain, pattern, null)[0];
                    if (apps == null || (registries = (ArrayList)cs.getAttribute(session, apps, "userRegistries")) == null) continue;
                    for (int j = 0; j < registries.size(); ++j) {
                        AttributeList urAttrs = (AttributeList)registries.get(j);
                        String realmName = (String)ConfigServiceHelper.getAttributeValue(urAttrs, "realm");
                        if (realmName == null || realmName.length() <= 0 || realmList.contains(realmName)) continue;
                        realmList.add(realmName);
                    }
                }
                if (realm != null && realm.length() > 0) {
                    if (realmList.contains(realm)) {
                        realmList.remove(realm);
                    }
                    realmList.add(0, realm);
                }
                if (gsRealm != null && gsRealm.length() > 0) {
                    if (realmList.contains(gsRealm)) {
                        realmList.remove(gsRealm);
                    }
                    if (realm != null && realm.length() > 0 && realmList.size() > 0) {
                        realmList.add(1, gsRealm);
                    } else {
                        realmList.add(0, gsRealm);
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityRealmProvider", "2512");
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "exception caught while getting list of all realms ", e);
            }
        }
        return realmList;
    }

    private boolean isRealmInRealmList(String realm, String realmList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRealmInRealmList");
        }
        Object realmsFromConfig = null;
        String[] realms = realmList.split("\\|");
        for (int i = 0; i < realms.length; ++i) {
            if (!realm.equals(realms[i])) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isRealmInRealmList");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRealmInRealmList");
        }
        return false;
    }
}

