/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.securityDomain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.securityDomain.ConfigureLTPAAuthMechanism;
import com.ibm.ws.security.admintask.securityDomain.SecConfigTaskHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ConfigureAuthzConfig
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ConfigureLTPAAuthMechanism.class, "ConfigureAuthzConfig", "com.ibm.ws.security.admintask.securityDomain");
    private ObjectName secObj;
    private ObjectName globalSecObj;
    private ConfigService configService;
    private Session session;
    private String secDomain = null;
    private Boolean useJACCProvider = null;
    private String name = null;
    private String description = null;
    private String j2eePolicyImplClassName = null;
    private String policyConfigurationFactoryImplClassName = null;
    private String roleConfigurationFactoryImplClassName = null;
    private String initializeJACCProviderClassName = null;
    private Boolean requiresEJBArgumentsPolicyContextHandler = null;
    private Boolean supportsDynamicModuleUpdates = null;
    private String customProperties = null;

    public ConfigureAuthzConfig(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ConfigureAuthzConfig(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    private void configureAuthzConfig() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureAuthzConfig");
        }
        ObjectName authObj = null;
        AttributeList attrlist = new AttributeList();
        ObjectName entry = this.getAuthzConfigObj();
        if (entry != null) {
            ArrayList providers;
            if (this.useJACCProvider != null) {
                attrlist.add(new Attribute("useJACCProvider", this.useJACCProvider));
                this.configService.setAttributes(this.session, entry, attrlist);
                attrlist.clear();
            }
            if (this.name != null && this.name.length() > 0) {
                attrlist.add(new Attribute("name", this.name));
            }
            if (this.description != null) {
                attrlist.add(new Attribute("description", this.description));
            }
            if (this.j2eePolicyImplClassName != null) {
                attrlist.add(new Attribute("j2eePolicyImplClassName", this.j2eePolicyImplClassName));
            }
            if (this.policyConfigurationFactoryImplClassName != null) {
                attrlist.add(new Attribute("policyConfigurationFactoryImplClassName", this.policyConfigurationFactoryImplClassName));
            }
            if (this.roleConfigurationFactoryImplClassName != null) {
                attrlist.add(new Attribute("roleConfigurationFactoryImplClassName", this.roleConfigurationFactoryImplClassName));
            }
            if (this.initializeJACCProviderClassName != null) {
                attrlist.add(new Attribute("initializeJACCProviderClassName", this.initializeJACCProviderClassName));
            }
            if (this.requiresEJBArgumentsPolicyContextHandler != null) {
                attrlist.add(new Attribute("requiresEJBArgumentsPolicyContextHandler", this.requiresEJBArgumentsPolicyContextHandler));
            }
            if (this.supportsDynamicModuleUpdates != null) {
                attrlist.add(new Attribute("supportsDynamicModuleUpdates", this.supportsDynamicModuleUpdates));
            }
            ObjectName providerObj = null;
            if (!(attrlist.isEmpty() && this.customProperties == null || (providers = (ArrayList)this.configService.getAttribute(this.session, entry, "authorizationProviders")).size() <= 0)) {
                AttributeList provider = (AttributeList)providers.get(0);
                providerObj = this.configService.queryConfigObjects(this.session, authObj, ConfigServiceHelper.createObjectName(provider), null)[0];
                if (!attrlist.isEmpty()) {
                    this.configService.setAttributes(this.session, providerObj, attrlist);
                }
                if (this.customProperties != null && this.customProperties.length() > 0) {
                    SecConfigTaskHelper.addCustomProperties(this.session, this.configService, providerObj, this.customProperties);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configureAuthzConfig");
        }
    }

    private void unconfigureAuthzConfig() throws Exception {
        ObjectName authzConfigObj;
        AttributeList authzConfig;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unconfigureAuthzConfig");
        }
        if ((authzConfig = (AttributeList)this.configService.getAttribute(this.session, this.secObj, "authConfig")) != null && (authzConfigObj = this.configService.queryConfigObjects(this.session, this.secObj, ConfigServiceHelper.createObjectName(authzConfig), null)[0]) != null) {
            this.configService.deleteConfigData(this.session, authzConfigObj);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unconfigureAuthzConfig");
        }
    }

    private AttributeList getAuthzConfigInfo() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthzConfigInfo");
        }
        AttributeList authzConfig = new AttributeList();
        AttributeList attrList = (AttributeList)this.configService.getAttribute(this.session, this.secObj, "authConfig");
        if (attrList != null) {
            authzConfig = attrList;
            authzConfig.remove(new Attribute("defaultAuthorizationProvider", null));
            authzConfig.remove(new Attribute("useNativeAuthorization", Boolean.FALSE));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthzConfigInfo");
        }
        return authzConfig;
    }

    private ObjectName getAuthzConfigObj() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthzConfigObj");
        }
        ObjectName authzConfigObj = null;
        AttributeList authzConfig = (AttributeList)this.configService.getAttribute(this.session, this.secObj, "authConfig");
        if (authzConfig != null) {
            authzConfigObj = this.configService.queryConfigObjects(this.session, this.secObj, ConfigServiceHelper.createObjectName(authzConfig), null)[0];
        } else {
            AttributeList config = this.configService.getAttributes(this.session, this.globalSecObj, new String[]{"authConfig"}, true);
            if (config != null) {
                this.configService.setAttributes(this.session, this.secObj, config);
                AttributeList configAttrs = this.configService.getAttributes(this.session, this.secObj, new String[]{"authConfig"}, true);
                authzConfigObj = this.configService.queryConfigObjects(this.session, this.secObj, ConfigServiceHelper.createObjectName(null, "AuthorizationConfig"), null)[0];
                if (authzConfigObj != null) {
                    AttributeList attrlist = new AttributeList();
                    attrlist.add(new Attribute("useNativeAuthorization", null));
                    this.configService.setAttributes(this.session, authzConfigObj, attrlist);
                }
            } else {
                String msg = this.getMsg(resBundle, "security.admintask.noAuthConfig.SECJ7764E", null);
                throw new CommandValidationException(msg);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthzConfigObj");
        }
        return authzConfigObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        String commandName = this.getName();
        try {
            this.configService = this.getConfigService();
            this.session = this.getConfigSession();
            try {
                this.secDomain = (String)this.getParameter("securityDomainName");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.name = (String)this.getParameter("name");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.description = (String)this.getParameter("description");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.useJACCProvider = (Boolean)this.getParameter("useJACCProvider");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.j2eePolicyImplClassName = (String)this.getParameter("j2eePolicyImplClassName");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.policyConfigurationFactoryImplClassName = (String)this.getParameter("policyConfigurationFactoryImplClassName");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.roleConfigurationFactoryImplClassName = (String)this.getParameter("roleConfigurationFactoryImplClassName");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.initializeJACCProviderClassName = (String)this.getParameter("initializeJACCProviderClassName");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.requiresEJBArgumentsPolicyContextHandler = (Boolean)this.getParameter("requiresEJBArgumentsPolicyContextHandler");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.supportsDynamicModuleUpdates = (Boolean)this.getParameter("supportsDynamicModuleUpdates");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            try {
                this.customProperties = (String)this.getParameter("customProperties");
            }
            catch (InvalidParameterNameException e) {
                // empty catch block
            }
            this.globalSecObj = SecConfigTaskHelper.getSecurityObjectName(this.session, this.configService);
            if (this.secDomain != null) {
                String msg;
                if ((commandName.equals("configureAuthzConfig") || commandName.equals("unconfigureAuthzConfig")) && this.secDomain.equals("PassThroughToGlobalSecurity")) {
                    msg = this.getMsg(resBundle, "security.admintask.unableToRunCommand.SECJ7810E", new Object[]{commandName, this.secDomain});
                    throw new CommandValidationException(msg);
                }
                this.secObj = SecConfigTaskHelper.getSecDomain(this.session, this.configService, this.secDomain);
                if (this.secObj == null) {
                    msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{this.secDomain});
                    throw new CommandValidationException(msg);
                }
            } else {
                this.secObj = this.globalSecObj;
            }
            if (commandName.equals("configureAuthzConfig")) {
                this.configureAuthzConfig();
            }
            if (commandName.equals("unconfigureAuthzConfig")) {
                this.unconfigureAuthzConfig();
            }
            if (commandName.equals("getAuthzConfigInfo")) {
                result.setResult(this.getAuthzConfigInfo());
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.ConfigureAuthData", "206");
            Tr.debug(tc, "exception caught", cse);
            result.setException(new CommandValidationException(cse, cse.getMessage()));
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
        }
    }
}

