/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.notification;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifyAuditNotification
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ModifyAuditNotification.class, "AUDIT", "com.ibm.ws.security.admintask.audit.notification");
    private String notificationRef = null;
    private Boolean logToSystemOut = null;
    private Boolean sendEmail = null;
    private String emailList = null;
    private String emailFormat = null;
    private String emailListConfig = null;
    private Boolean sendEmailConfig = null;

    public ModifyAuditNotification(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ModifyAuditNotification(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        boolean wsNotificationRefFound = false;
        super.validate();
        this.notificationRef = (String)this.getParameter("notificationRef");
        if (this.notificationRef == null || this.notificationRef.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidNotificationRef", null);
            throw new CommandValidationException(msg);
        }
        this.logToSystemOut = (Boolean)this.getParameter("logToSystemOut");
        this.sendEmail = (Boolean)this.getParameter("sendEmail");
        this.emailList = (String)this.getParameter("emailList");
        this.emailFormat = (String)this.getParameter("emailFormat");
        if (this.logToSystemOut == null && this.sendEmail == null && this.emailList == null && this.emailFormat == null) {
            String msg = this.getMsg(resBundle, "security.admintask.MissingModifyParms", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "notificationRef: " + this.notificationRef);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            if (this.emailFormat != null && this.emailFormat.length() > 0) {
                if (this.emailFormat.equalsIgnoreCase("html")) {
                    this.emailFormat = "HTML";
                } else if (this.emailFormat.equalsIgnoreCase("text")) {
                    this.emailFormat = "TEXT";
                } else {
                    String msg = this.getMsg(resBundle, "security.admintask.InvalidEmailFormat", null);
                    throw new CommandValidationException(msg);
                }
            }
            ObjectName notificationObj = null;
            boolean foundNotification = false;
            ArrayList nList = new ArrayList();
            ArrayList notificationArray = (ArrayList)cs.getAttribute(session, audit, "wsNotifications");
            if (notificationArray == null) {
                result.setResult(new Boolean(false));
                return;
            }
            for (int k = 0; k < notificationArray.size(); ++k) {
                AttributeList notificationAttrs = (AttributeList)notificationArray.get(k);
                notificationObj = ConfigServiceHelper.createObjectName(notificationAttrs);
                String notifRef = ConfigServiceHelper.getConfigDataId(notificationObj).toString().split("#")[1];
                if (!notifRef.equals(this.notificationRef)) continue;
                foundNotification = true;
                break;
            }
            if (!foundNotification) {
                String msg = this.getMsg(resBundle, "security.admintask.InvalidNotificationRef", null);
                result.addWarnings(msg);
                result.setException(new CommandException(msg));
                result.setResult(new Boolean(false));
                throw new CommandValidationException(msg);
            }
            this.emailListConfig = (String)cs.getAttribute(session, notificationObj, "emailList");
            this.sendEmailConfig = (Boolean)cs.getAttribute(session, notificationObj, "sendEmail");
            if (this.sendEmail != null && this.sendEmail.booleanValue()) {
                if (this.emailList == null && this.emailListConfig == null) {
                    String msg = this.getMsg(resBundle, "security.admintask.MissingEmailList", null);
                    throw new CommandValidationException(msg);
                }
                if (this.emailList != null && this.emailList.length() == 0) {
                    String msg = this.getMsg(resBundle, "security.admintask.MissingEmailList", null);
                    throw new CommandValidationException(msg);
                }
            } else if (this.sendEmail == null && this.sendEmailConfig != null && this.sendEmailConfig.booleanValue()) {
                if (this.emailList == null && this.emailListConfig == null) {
                    String msg = this.getMsg(resBundle, "security.admintask.MissingEmailList", null);
                    throw new CommandValidationException(msg);
                }
                if (this.emailList != null && this.emailList.length() == 0) {
                    String msg = this.getMsg(resBundle, "security.admintask.MissingEmailList", null);
                    throw new CommandValidationException(msg);
                }
            }
            AttributeList attrList = new AttributeList();
            if (this.emailList != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "emailList", this.emailList);
            }
            if (this.logToSystemOut != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "logToSystemOut", this.logToSystemOut);
            }
            if (this.sendEmail != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "sendEmail", this.sendEmail);
            }
            if (this.emailFormat != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "emailFormat", this.emailFormat);
            }
            cs.setAttributes(session, notificationObj, attrList);
            result.setResult(new Boolean(true));
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.ModifyAuditNotification.afterStepsExecuted", "147");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.ModifyAuditNotification.afterStepsExecuted", "147");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

