/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.notification;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateAuditNotification
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(CreateAuditNotification.class, "AUDIT", "com.ibm.ws.security.admintask.audit.notification");
    private String notificationName = null;
    private Boolean logToSystemOut = null;
    private Boolean sendEmail = null;
    private String emailList = null;
    private String emailFormat = null;

    public CreateAuditNotification(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateAuditNotification(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        Object security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            ObjectName audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            this.notificationName = (String)this.getParameter("notificationName");
            if (this.notificationName == null || this.notificationName.length() == 0) {
                String msg = this.getMsg(resBundle, "security.admintask.InvalidNotificationName", null);
                throw new CommandValidationException(msg);
            }
            this.logToSystemOut = (Boolean)this.getParameter("logToSystemOut");
            this.sendEmail = (Boolean)this.getParameter("sendEmail");
            if (this.sendEmail != null && tc.isDebugEnabled()) {
                Tr.debug(tc, "sendEmail: " + this.sendEmail);
            }
            this.emailList = (String)this.getParameter("emailList");
            if (this.emailList != null && tc.isDebugEnabled()) {
                Tr.debug(tc, "emailList: " + this.emailList);
            }
            this.emailFormat = (String)this.getParameter("emailFormat");
            if (this.emailFormat != null && tc.isDebugEnabled()) {
                Tr.debug(tc, "emailFormat: " + this.emailFormat);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "notificationName: " + this.notificationName);
            }
            if (this.sendEmail.booleanValue() && (this.emailList == null || this.emailList != null && this.emailList.length() == 0)) {
                String msg = this.getMsg(resBundle, "security.admintask.MissingEmailList", null);
                throw new CommandValidationException(msg);
            }
            if (this.emailFormat != null && this.emailFormat.length() > 0) {
                if (this.emailFormat.equalsIgnoreCase("html")) {
                    this.emailFormat = "HTML";
                } else if (this.emailFormat.equalsIgnoreCase("text")) {
                    this.emailFormat = "TEXT";
                } else {
                    String msg = this.getMsg(resBundle, "security.admintask.InvalidEmailFormat", null);
                    throw new CommandValidationException(msg);
                }
            }
            ObjectName notificationObj = null;
            boolean foundNotification = false;
            ArrayList nList = new ArrayList();
            ArrayList notificationArray = (ArrayList)cs.getAttribute(session, audit, "wsNotifications");
            for (int k = 0; k < notificationArray.size(); ++k) {
                AttributeList notificationAttrs = (AttributeList)notificationArray.get(k);
                notificationObj = ConfigServiceHelper.createObjectName(notificationAttrs);
                String uniqueName = (String)cs.getAttribute(session, notificationObj, "name");
                if (!uniqueName.equals(this.notificationName)) continue;
                foundNotification = true;
                break;
            }
            if (foundNotification) {
                String msg = this.getMsg(resBundle, "security.admintask.NotificationConfigured", null);
                result.addWarnings(msg);
                result.setException(new CommandException(msg));
                result.setResult(new Boolean(false));
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.CreateAuditNotification.validate", "140");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName audit = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            AttributeList attrList = new AttributeList();
            attrList.add(new Attribute("name", this.notificationName));
            attrList.add(new Attribute("logToSystemOut", this.logToSystemOut));
            attrList.add(new Attribute("sendEmail", this.sendEmail));
            if (this.emailList != null) {
                attrList.add(new Attribute("emailList", this.emailList));
            }
            if (this.emailFormat != null) {
                attrList.add(new Attribute("emailFormat", this.emailFormat));
            }
            ObjectName auditNotification = cs.createConfigData(session, audit, "wsNotifications", "WSNotification", attrList);
            AttributeList newAttrs = cs.getAttributes(session, auditNotification, null, true);
            String nRef = ConfigServiceHelper.getAttributeValue(newAttrs, "_Websphere_Config_Data_Id").toString();
            nRef = nRef.split("#")[1];
            if (auditNotification != null) {
                result.setResult(nRef);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.CreateAuditNotification.afterStepsExecuted", "147");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

