/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListAuditKeyStores
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListAuditKeyStores.class, "Audit", "com.ibm.ws.security.admintask.audit.keyStores");
    private String scopeName = null;
    private Boolean allScopes = null;

    public ListAuditKeyStores(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListAuditKeyStores(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName audit = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (cs == null) {
                AdminClient adminClient = AdminServiceFactory.getAdminService().getDeploymentManagerAdminClient();
                cs = new ConfigServiceProxy(adminClient);
            }
            CommandHelper commandHelper = new CommandHelper();
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.allScopes = (Boolean)this.getParameter(CommandConstants.ALL);
            if (this.allScopes == null) {
                this.allScopes = Boolean.FALSE;
            }
            if (this.scopeName == null && !this.allScopes.booleanValue()) {
                this.scopeName = commandHelper.defaultScope();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scopeName: " + this.scopeName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "allScopes: " + this.allScopes);
            }
            if (this.allScopes.booleanValue()) {
                this.scopeName = null;
            }
            List keyStores = (List)cs.getAttribute(session, audit, CommandConstants.KEY_STORES);
            ArrayList<AttributeList> keyStoreList = new ArrayList<AttributeList>(keyStores.size());
            for (AttributeList keyStore : keyStores) {
                ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(keyStore), null);
                if (this.scopeName != null) {
                    boolean inScope = commandHelper.withInScope(cs, session, keyStore, this.scopeName);
                    if (!inScope) continue;
                    AttributeList newAttrs = cs.getAttributes(session, matches[0], null, true);
                    for (int i = 0; i < newAttrs.size(); ++i) {
                        Attribute a = (Attribute)newAttrs.get(i);
                        if (!a.getName().equals("password")) continue;
                        String pwd = (String)a.getValue();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "a.getValue(): " + pwd);
                        }
                        if (pwd != "" && pwd.length() == 0) {
                            if (!tc.isDebugEnabled()) break;
                            Tr.debug(tc, "password is {xor}");
                            break;
                        }
                        if (pwd != "" && pwd.length() != 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "password not {xor} and not null");
                            }
                            Attribute b = new Attribute("password", new String("***"));
                            newAttrs.remove(a);
                            newAttrs.add(b);
                            break;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "password field is unset");
                    }
                    String keyRef = ConfigServiceHelper.getAttributeValue(newAttrs, "_Websphere_Config_Data_Id").toString();
                    keyRef = keyRef.split("#")[1];
                    Attribute refAttr = new Attribute("keyStoreRef", keyRef);
                    newAttrs.add(refAttr);
                    keyStoreList.add(newAttrs);
                    continue;
                }
                AttributeList newAttrs = cs.getAttributes(session, matches[0], null, true);
                for (int i = 0; i < newAttrs.size(); ++i) {
                    Attribute a = (Attribute)newAttrs.get(i);
                    if (!a.getName().equals("password")) continue;
                    String pwd = (String)a.getValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "a.getValue(): " + pwd);
                    }
                    if (pwd != "" && pwd.length() == 0) {
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "password is {xor}");
                        break;
                    }
                    if (pwd != "" && pwd.length() != 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "password not {xor} and not null");
                        }
                        Attribute b = new Attribute("password", new String("***"));
                        newAttrs.remove(a);
                        newAttrs.add(b);
                        break;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "password field is unset");
                }
                String keyRef = ConfigServiceHelper.getAttributeValue(newAttrs, "_Websphere_Config_Data_Id").toString();
                keyRef = keyRef.split("#")[1];
                Attribute refAttr = new Attribute("keyStoreRef", keyRef);
                newAttrs.add(refAttr);
                keyStoreList.add(newAttrs);
            }
            result.setResult(keyStoreList);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

