/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class KeyStoreHelper {
    private static TraceComponent tc = Tr.register(KeyStoreHelper.class, "Audit", "com.ibm.ws.security.admintask.audit.keyStores");

    public static int checkKeyFile(String keyFileType, String keyFileName, String filePassword) {
        int status;
        block11: {
            block10: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "checkKeyFile");
                }
                status = 0;
                KeyStore ks = null;
                File libFile = new File(keyFileName);
                if (libFile == null || !libFile.isFile() || !libFile.canRead()) {
                    status = 1;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "fileName not found.");
                    }
                }
                if (status == 0) {
                    try {
                        ks = KeyStore.getInstance(keyFileType);
                    }
                    catch (Exception ex) {
                        status = 2;
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "invalid fileType.");
                    }
                }
            }
            if (status == 0) {
                try {
                    WSKeyStore.loadKeyStore(keyFileName, keyFileType, filePassword);
                }
                catch (Exception ex) {
                    status = 3;
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "invalid password.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkKeyFile");
        }
        return status;
    }

    public static boolean verifyKeyStoreType(String keyStoreType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyKeyStoreType", new Object[]{keyStoreType});
        }
        Set<String> keyStoreTypes = Security.getAlgorithms("KeyStore");
        for (String type : keyStoreTypes) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type: " + type);
            }
            if (!type.equalsIgnoreCase(keyStoreType)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "verifyKeyStoreType -> true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyKeyStoreType -> false");
        }
        return false;
    }

    public static boolean passwordVerify(String password, String passwordVerify) {
        return password.equals(passwordVerify);
    }

    public static KeyStoreInfo makeKsInfo(AttributeList info, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeKsInfo");
        }
        KeyStoreInfo ksInfo = new KeyStoreInfo();
        try {
            ksInfo.setName((String)ConfigServiceHelper.getAttributeValue(info, "name"));
            ksInfo.setType((String)ConfigServiceHelper.getAttributeValue(info, "type"));
            ksInfo.setPassword((String)ConfigServiceHelper.getAttributeValue(info, "password"));
            ksInfo.setProvider((String)ConfigServiceHelper.getAttributeValue(info, "provider"));
            ksInfo.setLocation((String)ConfigServiceHelper.getAttributeValue(info, "location"));
            ksInfo.setFileBased((Boolean)ConfigServiceHelper.getAttributeValue(info, "fileBased"));
            ksInfo.setHostList((String)ConfigServiceHelper.getAttributeValue(info, "hostList"));
            ksInfo.setInitializeAtStartup((Boolean)ConfigServiceHelper.getAttributeValue(info, "initializeAtStartup"));
            ksInfo.setStashFile((Boolean)ConfigServiceHelper.getAttributeValue(info, "createStashFileForCMS"));
            ksInfo.setReadOnly((Boolean)ConfigServiceHelper.getAttributeValue(info, "readOnly"));
            ksInfo.setScopeName((ObjectName)ConfigServiceHelper.getAttributeValue(info, "managementScope"));
            ksInfo.setSlot((Integer)ConfigServiceHelper.getAttributeValue(info, "slot"));
            ksInfo.setAccelerator((Boolean)ConfigServiceHelper.getAttributeValue(info, "useForAcceleration"));
            ksInfo.setDescription((String)ConfigServiceHelper.getAttributeValue(info, "description"));
            ConfigService cs = ConfigServiceFactory.getConfigService();
            ObjectName scope = (ObjectName)ConfigServiceHelper.getAttributeValue(info, "managementScope");
            String scopeString = (String)cs.getAttribute(session, scope, CommandConstants.SCOPE_NAME);
            if (scopeString != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Management scope name going into the ksinfo is " + scopeString);
                }
                ksInfo.setScopeNameString(scopeString);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while create KeyStoreInfo " + e.getMessage());
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeKsInfo");
        }
        return ksInfo;
    }

    public static KeyStoreInfo makeKsInfo(com.ibm.websphere.models.config.ipc.ssl.KeyStore ks) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeKsInfo");
        }
        KeyStoreInfo ksInfo = new KeyStoreInfo();
        try {
            ksInfo.setName(ks.getName());
            ksInfo.setType(ks.getType());
            ksInfo.setPassword(ks.getPassword());
            ksInfo.setProvider(ks.getProvider());
            ksInfo.setLocation(ks.getLocation());
            ksInfo.setHostList(ks.getHostList());
            ksInfo.setScopeNameString(ks.getManagementScope().getScopeName());
            ksInfo.setDescription(ks.getDescription());
            int slot = ks.getSlot();
            ksInfo.setSlot(new Integer(slot));
            boolean fileBased = ks.isFileBased();
            if (fileBased) {
                ksInfo.setFileBased(Boolean.TRUE);
            } else {
                ksInfo.setFileBased(Boolean.FALSE);
            }
            boolean readOnly = ks.isReadOnly();
            if (readOnly) {
                ksInfo.setReadOnly(Boolean.TRUE);
            } else {
                ksInfo.setReadOnly(Boolean.FALSE);
            }
            boolean acceleration = ks.isUseForAcceleration();
            if (acceleration) {
                ksInfo.setAccelerator(Boolean.TRUE);
            } else {
                ksInfo.setAccelerator(Boolean.FALSE);
            }
            boolean initAtStart = ks.isInitializeAtStartup();
            if (initAtStart) {
                ksInfo.setInitializeAtStartup(Boolean.TRUE);
            } else {
                ksInfo.setInitializeAtStartup(Boolean.FALSE);
            }
            boolean stash = ks.isCreateStashFileForCMS();
            if (stash) {
                ksInfo.setStashFile(Boolean.TRUE);
            } else {
                ksInfo.setStashFile(Boolean.FALSE);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while create KeyStoreInfo " + e.getMessage());
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeKsInfo");
        }
        return ksInfo;
    }

    public static ObjectName createKeyStoreCmd(Session session, KeyStoreInfo ksInfo, boolean createKeyFile) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Audit CreateKeyStoreCmd");
        }
        ObjectName keyStoreCreated = null;
        String hostList = null;
        String expandLocation = null;
        String expandLocationStash = null;
        Boolean stash = ksInfo.getStashFile();
        String stashFileName = null;
        String keyFileName = KeyStoreManager.getInstance().expand(ksInfo.getLocation());
        hostList = ksInfo.getHostList();
        try {
            keyStoreCreated = KeyStoreHelper.createKeyStoreObjectName(session, ksInfo);
            if (keyStoreCreated == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to create KeyStore ObjectName.");
                }
                throw new KeyStoreException("Failed to create KeyStore file ObjectName.");
            }
            if (createKeyFile) {
                WorkSpace ws;
                if (hostList == null || hostList != null && hostList.equals("")) {
                    ws = WorkSpaceManagerFactory.getManager().getWorkSpace(session.toString());
                    String expandedWorkspaceRoot = ws.getPath();
                    expandLocation = KeyStoreHelper.fixLocation(expandedWorkspaceRoot, KeyStoreManager.getInstance().expand(ksInfo.getLocation()));
                    ksInfo.setLocation(expandLocation);
                    if (stash.booleanValue()) {
                        int index = keyFileName.lastIndexOf(".");
                        stashFileName = index != -1 ? keyFileName.substring(0, index + 1) + "sth" : keyFileName + ".sth";
                        expandLocationStash = KeyStoreHelper.fixLocation(expandedWorkspaceRoot, stashFileName);
                    }
                }
                if (!KeyStoreHelper.createKeyStoreFile(ksInfo)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to create KeyStore file.");
                    }
                    throw new KeyStoreException("Failed to create KeyStore file " + ksInfo.getLocation() + ".");
                }
                if (hostList == null || hostList != null && hostList.equals("")) {
                    ws = WorkSpaceManagerFactory.getManager().getWorkSpace(session.toString());
                    String cell = "cells/" + ManagementScopeManager.getInstance().getCellName();
                    RepositoryContext cellC = ws.findContext(cell);
                    int index = expandLocation.indexOf(cell);
                    if (index != -1) {
                        expandLocation = expandLocation.substring(index + cell.length());
                    }
                    if (cellC != null) {
                        cellC.notifyChanged(0, expandLocation);
                    }
                    if (stash.booleanValue()) {
                        index = expandLocationStash.indexOf(cell);
                        if (index != -1) {
                            expandLocationStash = expandLocationStash.substring(index + cell.length());
                        }
                        if (cellC != null) {
                            cellC.notifyChanged(0, expandLocationStash);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            if (keyStoreCreated != null) {
                ConfigService cs = ConfigServiceFactory.getConfigService();
                cs.deleteConfigData(session, keyStoreCreated);
            }
            throw new KeyStoreException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CreateKeyStoreCmd");
        }
        return keyStoreCreated;
    }

    public static ObjectName createKeyStoreObjectName(Session session, KeyStoreInfo ksInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Audit CreateKeyStoreObjectName");
        }
        ObjectName keyStoreObj = null;
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
        ConfigService cs = ConfigServiceFactory.getConfigService();
        ObjectName audit = cs.queryConfigObjects(session, null, pattern, null)[0];
        AttributeList attrList = KeyStoreHelper.createKeyStoreAttrList(ksInfo);
        if (attrList == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to create KeyStore ObjectName.");
            }
            throw new KeyStoreException("Failed to create KeyStore ObjectName.");
        }
        keyStoreObj = cs.createConfigData(session, audit, "keyStores", "KeyStore", attrList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CreateKeyStoreObjectName: " + keyStoreObj.toString());
        }
        return keyStoreObj;
    }

    public static AttributeList createKeyStoreAttrList(KeyStoreInfo ksInfo) {
        String description;
        String hostList;
        String provider;
        String password;
        String type;
        String location;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createKeyStoreAttrList");
        }
        AttributeList attrList = new AttributeList();
        Integer slotNumber = null;
        String name = ksInfo.getName();
        if (name != null) {
            attrList.add(new Attribute("name", name));
        }
        if ((location = ksInfo.getLocation()) != null) {
            attrList.add(new Attribute("location", location));
        }
        if ((type = ksInfo.getType()) != null) {
            attrList.add(new Attribute("type", type));
        }
        if ((password = ksInfo.getPassword()) != null) {
            attrList.add(new Attribute("password", password));
        }
        if ((provider = ksInfo.getProvider()) != null) {
            attrList.add(new Attribute("provider", provider));
        }
        if ((hostList = ksInfo.getHostList()) != null) {
            attrList.add(new Attribute("hostList", hostList));
        }
        if ((slotNumber = ksInfo.getSlot()) != null) {
            attrList.add(new Attribute("slot", slotNumber));
        }
        if ((description = ksInfo.getDescription()) != null) {
            attrList.add(new Attribute("description", description));
        }
        attrList.add(new Attribute("fileBased", ksInfo.getFileBased()));
        attrList.add(new Attribute("readOnly", ksInfo.getReadOnly()));
        attrList.add(new Attribute("initializeAtStartup", ksInfo.getInitializeAtStartup()));
        attrList.add(new Attribute("createStashFileForCMS", ksInfo.getStashFile()));
        attrList.add(new Attribute("useForAcceleration", ksInfo.getAccelerator()));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createKeyStoreAttrList");
        }
        return attrList;
    }

    public static boolean createKeyStoreFile(KeyStoreInfo keyStore) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CreateKeyStoreFile");
        }
        boolean keyCreated = false;
        X509Certificate clientCert = null;
        X509Certificate serverCert = null;
        String hostList = keyStore.getHostList();
        String type = keyStore.getType();
        String name = keyStore.getLocation();
        String password = keyStore.getPassword();
        if (hostList != null && hostList.equals("")) {
            hostList = null;
        }
        clientCert = KeyStoreHelper.getCertFromArmFile("client");
        serverCert = KeyStoreHelper.getCertFromArmFile("server");
        keyStore.setReadOnly(false);
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(keyStore);
        try {
            String method2 = null;
            Object[] parms = null;
            if (hostList != null) {
                method2 = "createRemoteKeyStore";
                parms = new Object[]{keyStore.getName(), keyStore.getType(), keyStore.getProvider(), keyStore.getLocation(), keyStore.getPassword(), "dummyClientSigner", clientCert, "dummyServerSigner", serverCert};
                wsksr.invokeKeyStoreCommand(method2, parms);
                keyCreated = true;
            } else if (type.equals("JCERACFKS") || type.equals("JCECCARACFKS")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trying to load RACF key store.");
                }
                try {
                    WSKeyStore.loadKeyStore(name, type, password);
                    keyCreated = true;
                }
                catch (Exception ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failure loading key ring.  The key ring needs to be created on RACF .");
                    }
                }
            } else {
                if (clientCert != null) {
                    method2 = "setCertificateEntry";
                    parms = new Object[]{"dummyClientSigner", clientCert};
                    wsksr.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
                    keyCreated = true;
                }
                if (serverCert != null) {
                    method2 = "setCertificateEntry";
                    parms = new Object[]{"dummyServerSigner", serverCert};
                    wsksr.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
                    keyCreated = true;
                }
                if (clientCert == null && serverCert == null) {
                    wsksr.store();
                    keyCreated = true;
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception cought " + e.getMessage());
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CreateKeyStoreFile");
        }
        return keyCreated;
    }

    public static boolean createKeyStoreFile(com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CreateKeyStoreFile");
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(keyStore);
        KeyStore ks = null;
        boolean keyCreated = false;
        X509Certificate clientCert = null;
        X509Certificate serverCert = null;
        String hostList = keyStore.getHostList();
        if (hostList != null && hostList.equals("")) {
            hostList = null;
        }
        clientCert = KeyStoreHelper.getCertFromArmFile("client");
        serverCert = KeyStoreHelper.getCertFromArmFile("server");
        try {
            String method2 = null;
            Object[] parms = null;
            if (hostList != null) {
                method2 = "createRemoteKeyStore";
                parms = new Object[]{keyStore.getName(), keyStore.getType(), keyStore.getProvider(), keyStore.getLocation(), keyStore.getPassword(), "dummyClientSigner", clientCert, "dummyServerSigner", serverCert};
                wsksr.invokeKeyStoreCommand(method2, parms);
                keyCreated = true;
            } else {
                if (clientCert != null) {
                    method2 = "setCertificateEntry";
                    parms = new Object[]{"dummyClientSigner", clientCert};
                    wsksr.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
                    keyCreated = true;
                }
                if (serverCert != null) {
                    method2 = "setCertificateEntry";
                    parms = new Object[]{"dummyServerSigner", serverCert};
                    wsksr.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
                    keyCreated = true;
                }
                if (clientCert == null && serverCert == null) {
                    ks = wsksr.getKeyStore(false, true);
                    wsksr.store();
                    keyCreated = true;
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception cought " + e.getMessage());
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CreateKeyStoreFile");
        }
        return keyCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate getCertFromArmFile(String type) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertFromArmFile");
        }
        String fileName = null;
        String filePath = null;
        X509Certificate cert = null;
        if (type.equals("server")) {
            fileName = "serverCert.arm";
        } else if (type.equals("client")) {
            fileName = "clientCert.arm";
        } else {
            return null;
        }
        FileInputStream fis = null;
        String profilePath = System.getProperty("user.install.root");
        filePath = profilePath + "/etc/" + fileName;
        try {
            CertificateFactory certificatefactory = null;
            Collection<? extends Certificate> collection = null;
            fis = new FileInputStream(filePath);
            certificatefactory = CertificateFactory.getInstance("X509");
            collection = certificatefactory.generateCertificates(fis);
            X509Certificate[] certFromReqFile = new X509Certificate[collection.size()];
            Iterator<? extends Certificate> iterator = collection.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                certFromReqFile[i] = (X509Certificate)iterator.next();
                ++i;
            }
            cert = certFromReqFile[0];
        }
        catch (FileNotFoundException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, filePath + " does not exist.  Certificate will no be used.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCertFromArmFile");
            }
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception recieve while trying to get certificate from arm file: " + e.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCertFromArmFile");
            }
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertFromArmFile");
        }
        return cert;
    }

    private static String fixLocation(String repositoryRoot, String location) {
        location = location.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixLocation", new Object[]{repositoryRoot, location});
        }
        int index = location.indexOf("/cells/" + ManagementScopeManager.getInstance().getCellName());
        String newPath = location;
        if (index != -1) {
            String lastPart = location.substring(index);
            newPath = repositoryRoot + lastPart;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixLocation -> " + newPath);
        }
        return newPath;
    }

    public static void changePassword(WSKeyStoreRemotable wsksr, String password, String newPassword) throws Exception {
        try {
            String method2 = "aliases";
            Object[] parms = null;
            Object[] aliases = wsksr.invokeKeyStoreCommand(method2, parms);
            for (int i = 0; i < aliases.length; ++i) {
                method2 = "isKeyEntry";
                String alias = (String)aliases[i];
                parms = new Object[]{alias};
                Object[] isKeyEntry = wsksr.invokeKeyStoreCommand(method2, parms);
                if (!((Boolean)isKeyEntry[0]).booleanValue()) continue;
                method2 = "getCertificateChain";
                parms = new Object[]{alias};
                Object[] certChain = wsksr.invokeKeyStoreCommand(method2, parms);
                method2 = "getKey";
                parms = new Object[]{alias, password.toCharArray()};
                Object[] key = wsksr.invokeKeyStoreCommand(method2, parms);
                if (certChain[0] != null && key[0] != null) {
                    method2 = "setKeyEntryOverwrite";
                    parms = new Object[]{alias, (Key)key[0], newPassword.toCharArray(), (Certificate[])certChain[0]};
                    wsksr.invokeKeyStoreCommand(method2, parms);
                    Tr.debug(tc, "reset " + alias + " with new new key store password");
                }
                if (certChain[0] != null || key[0] == null || !(key[0] instanceof SecretKeySpec)) continue;
                method2 = "setKeyEntryOverwrite";
                parms = new Object[]{alias, (Key)key[0], newPassword.toCharArray(), null};
                wsksr.invokeKeyStoreCommand(method2, parms);
            }
            method2 = "store";
            parms = new Object[]{newPassword};
            wsksr.invokeKeyStoreCommand(method2, parms);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public static void changePasswordPKCS12(KeyStoreInfo info, String newPassword) throws Exception {
        String keyStorePassword = null;
        String keyStorePath = null;
        String tempFileName = null;
        keyStorePassword = info.getPassword();
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
        keyStorePath = info.getLocation();
        keyStorePath = KeyStoreManager.getInstance().expand(keyStorePath);
        File path = new File(keyStorePath);
        String fileName = path.getName();
        File fileDir = path.getParentFile();
        File passwordTempFile = File.createTempFile(fileName, null, fileDir);
        tempFileName = passwordTempFile.getAbsolutePath();
        passwordTempFile.delete();
        info.setLocation(tempFileName);
        info.setPassword(newPassword);
        WSKeyStoreRemotable wsksr_temp = new WSKeyStoreRemotable(info);
        String method2 = "aliases";
        Object[] parms = null;
        Object[] aliases = wsksr.invokeKeyStoreCommand(method2, parms);
        for (int i = 0; i < aliases.length; ++i) {
            Object[] isCertEntry;
            method2 = "isKeyEntry";
            String alias = (String)aliases[i];
            parms = new Object[]{alias};
            Object[] isKeyEntry = wsksr.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)isKeyEntry[0]).booleanValue()) {
                Tr.debug(tc, "key alias " + alias);
                method2 = "getCertificateChain";
                parms = new Object[]{alias};
                Object[] certChain = wsksr.invokeKeyStoreCommand(method2, parms);
                method2 = "getKey";
                parms = new Object[]{alias, keyStorePassword.toCharArray()};
                Object[] key = wsksr.invokeKeyStoreCommand(method2, parms);
                if (certChain[0] != null && key[0] != null) {
                    method2 = "setKeyEntry";
                    parms = new Object[]{alias, (Key)key[0], newPassword.toCharArray(), (Certificate[])certChain[0]};
                    wsksr_temp.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
                    Tr.debug(tc, "reset " + alias + " with new new key store password");
                }
                if (certChain[0] == null && key[0] != null && key[0] instanceof SecretKeySpec) {
                    method2 = "setKeyEntry";
                    parms = new Object[]{alias, (Key)key[0], newPassword.toCharArray(), null};
                    wsksr_temp.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
                }
            }
            if (!((Boolean)(isCertEntry = wsksr.invokeKeyStoreCommand(method2 = "isCertificateEntry", parms = new Object[]{alias}))[0]).booleanValue()) continue;
            Tr.debug(tc, "key certificate " + alias);
            method2 = "getCertificate";
            parms = new Object[]{alias};
            Object[] cert = wsksr.invokeKeyStoreCommand(method2, parms);
            X509Certificate signer = (X509Certificate)cert[0];
            if (signer == null) continue;
            method2 = "setCertificateEntry";
            parms = new Object[]{alias, signer};
            wsksr_temp.invokeKeyStoreCommand(method2, parms, Boolean.TRUE);
        }
        if (tempFileName != null) {
            File keyFilePath = new File(keyStorePath);
            keyFilePath.delete();
            File tempFilePath = new File(tempFileName);
            tempFilePath.renameTo(keyFilePath);
        }
    }

    public static void changePasswordCMS(KeyStoreInfo info, String newPassword) throws Exception {
        try {
            WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
            String method2 = "store";
            Object[] parms = new Object[]{newPassword};
            wsksr.invokeKeyStoreCommand(method2, parms);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }
}

