/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.security.admintask.audit.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateAuditKeyStore
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateAuditKeyStore.class, "Audit", "com.ibm.ws.security.admintask.audit.keyStores");
    private String keyStoreName = null;
    private String keyStoreLocation = null;
    private String keyStoreType = null;
    private String keyStorePassword = null;
    private String keyStorePasswordVerify = null;
    private String keyStoreHostList = null;
    private String keyStoreProvider = null;
    private Boolean keyStoreIsFileBased = null;
    private Boolean keyStoreReadOnly = null;
    private Boolean keyStoreInitAtStartup = null;
    private String keyStoreCustomProvider = null;
    private Boolean keyStoreStashFile = null;
    private String scopeName = null;
    private Boolean keyStoreForAcceleration = null;
    private boolean createKeyFile = true;
    private String keyStoreDescription = null;
    private ObjectName mgmScopeObjName = null;
    private boolean createMgmScope = false;

    public CreateAuditKeyStore(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateAuditKeyStore(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName pattern = null;
        ObjectName matches = null;
        ObjectName audit = null;
        Object keyFileName = null;
        boolean keyStoreFound = false;
        try {
            String msg;
            pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreLocation = (String)this.getParameter(CommandConstants.KEY_STORE_LOCATION);
            this.keyStoreType = (String)this.getParameter(CommandConstants.KEY_STORE_TYPE);
            this.keyStorePassword = (String)this.getParameter(CommandConstants.KEY_STORE_PASSWORD);
            this.keyStorePasswordVerify = (String)this.getParameter(CommandConstants.KEY_STORE_PASSWORD_VERIFY);
            this.keyStoreHostList = (String)this.getParameter(CommandConstants.KEY_STORE_HOST_LIST);
            this.keyStoreProvider = (String)this.getParameter(CommandConstants.KEY_STORE_PROVIDER);
            this.keyStoreIsFileBased = (Boolean)this.getParameter(CommandConstants.KEY_STORE_IS_FILE_BASED);
            this.keyStoreReadOnly = (Boolean)this.getParameter(CommandConstants.KEY_STORE_READ_ONLY);
            this.keyStoreInitAtStartup = (Boolean)this.getParameter(CommandConstants.KEY_STORE_INIT_AT_STARTUP);
            this.keyStoreStashFile = (Boolean)this.getParameter(CommandConstants.KEY_STORE_STASH_FILE);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.keyStoreForAcceleration = (Boolean)this.getParameter(CommandConstants.KEY_STORE_ACCELERATION);
            this.keyStoreDescription = (String)this.getParameter(CommandConstants.KEY_STORE_DESCRIPTION);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyStoreLocation=" + this.keyStoreLocation + " keyStoreType=" + this.keyStoreType + " keyStorePassword=" + this.keyStorePassword + " keyStoreHostList=" + this.keyStoreHostList + " keyStoreProvider=" + this.keyStoreProvider + " keyStoreIsFileBased=" + this.keyStoreIsFileBased + " keyStoreReadOnly=" + this.keyStoreReadOnly + " keyStoreInitAtStartup=" + this.keyStoreInitAtStartup + " keyStoreCustomProvider=" + this.keyStoreCustomProvider + " keyStoreStashFile=" + this.keyStoreStashFile + " scopeName=" + this.scopeName + " keyStoreForAcceleration=" + this.keyStoreForAcceleration + " keyStoreDescription=" + this.keyStoreDescription);
            }
            if (this.keyStoreDescription != null && this.keyStoreDescription.equals("")) {
                this.keyStoreDescription = null;
            }
            CommandHelper commandHelper = new CommandHelper();
            matches = cs.resolve(session, "Cell=")[0];
            if (this.scopeName != null && this.scopeName.length() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String msg2 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                throw new CommandValidationException(msg2);
            }
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "scopeName: " + this.scopeName);
                }
                if (!ManagementScopeHelper.validScopeName(session, cs, this.scopeName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                    }
                    String msg3 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                    throw new CommandValidationException(msg3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Passed ManagementScopeHelper.validScopeName");
                }
            }
            if (this.keyStoreType.indexOf("(PKCS11)") >= 0) {
                this.keyStoreType = "PKCS11";
            }
            if (this.keyStoreType.equals("PKCS11") || this.keyStoreType.equals("JCERACFKS") || this.keyStoreType.equals("JCECCARACFKS")) {
                this.keyStoreIsFileBased = Boolean.FALSE;
            }
            if (this.keyStoreType.equals("JCERACFKS") || this.keyStoreType.equals("JCECCARACFKS")) {
                this.keyStoreReadOnly = Boolean.TRUE;
            }
            if (this.keyStoreForAcceleration == null || !this.keyStoreForAcceleration.booleanValue()) {
                if (this.keyStorePassword != null && this.keyStorePasswordVerify == null || this.keyStorePassword == null && this.keyStorePasswordVerify != null || this.keyStorePassword == null && this.keyStorePasswordVerify == null) {
                    String msg4 = TraceNLSHelper.getInstance().getString("ssl.command.password.missing.CWPKI0632E", "Both password and verify password were not supplied.");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Both password and verify password were not supplied.");
                    }
                    throw new CommandValidationException(msg4);
                }
                if (!KeyStoreHelper.passwordVerify(this.keyStorePassword, this.keyStorePasswordVerify)) {
                    String msg5 = TraceNLSHelper.getInstance().getString("ssl.command.keyStore.password.not.confirm.CWPKI0619E", "Passwords do not match.");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Password did not verify.");
                    }
                    throw new CommandValidationException(msg5);
                }
            }
            if (this.keyStoreProvider == null) {
                if (this.keyStoreType.equals("CMSKS")) {
                    this.keyStoreProvider = "IBMCMSProvider";
                } else if (this.keyStoreType.equals("IBMi5OSKeyStore")) {
                    this.keyStoreProvider = "IBMi5OSJSSEProvider";
                } else if (this.keyStoreType.equals("PKCS11")) {
                    this.keyStoreProvider = "PKCS11";
                } else if (this.keyStoreType.equals("PKCS12") || this.keyStoreType.equals("JKS") || this.keyStoreType.equals("JCEKS")) {
                    this.keyStoreProvider = "IBMJCE";
                } else if (this.keyStoreType.equals("JCECCAKS") || this.keyStoreType.equals("JCECCARACFKS")) {
                    this.keyStoreProvider = "IBMJCECCA";
                }
            }
            if (this.keyStoreIsFileBased != null && !this.keyStoreIsFileBased.booleanValue()) {
                this.createKeyFile = false;
            }
            if (this.keyStoreHostList == null) {
                if (this.keyStoreIsFileBased.booleanValue()) {
                    File libFile;
                    int status = KeyStoreHelper.checkKeyFile(this.keyStoreType, KeyStoreManager.getInstance().expand(this.keyStoreLocation), this.keyStorePassword);
                    if (status == 1 && !(libFile = new File(KeyStoreManager.getInstance().expand(this.keyStoreLocation))).isAbsolute()) {
                        this.keyStoreLocation = KeyStoreManager.getInstance().expand("${USER_INSTALL_ROOT}" + File.separator + "etc" + File.separator + libFile);
                        status = KeyStoreHelper.checkKeyFile(this.keyStoreType, KeyStoreManager.getInstance().expand(this.keyStoreLocation), this.keyStorePassword);
                    }
                    if (status == 1) {
                        this.createKeyFile = true;
                    } else if (status == 0) {
                        this.createKeyFile = false;
                    } else if (status == 2 || status == 3) {
                        msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keyStore.check.key.file.CWPKI0663E", new Object[]{this.keyStoreLocation}, "Key store file \"" + this.keyStoreLocation + "\" did not verify, check key store type and password.");
                        throw new CommandValidationException(msg);
                    }
                }
                if (this.keyStoreReadOnly != null && this.keyStoreReadOnly.booleanValue()) {
                    if (this.keyStoreType.equalsIgnoreCase("PKCS11")) {
                        File keyFile = new File(KeyStoreManager.getInstance().expand(this.keyStoreLocation));
                        if (keyFile == null || !keyFile.isFile() || !keyFile.canRead()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Key store file \"" + this.keyStoreLocation + "\" does not exist.");
                            }
                            msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.check.file.CWPKI0673E", new Object[]{this.keyStoreLocation}, "Creating a read only key store object.  File \"" + this.keyStoreLocation + "\" should already exist.");
                            throw new CommandValidationException(msg);
                        }
                        this.createKeyFile = false;
                    }
                    if (this.createKeyFile) {
                        String msg6 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.check.key.file.CWPKI0656E", new Object[]{this.keyStoreLocation}, "Creating a read only key store object.  File \"" + this.keyStoreLocation + "\" should already exist, check the key store password and key store type.");
                        throw new CommandValidationException(msg6);
                    }
                }
                if (this.keyStoreForAcceleration != null && this.keyStoreForAcceleration.booleanValue()) {
                    File accelerationFile = new File(KeyStoreManager.getInstance().expand(this.keyStoreLocation));
                    if (accelerationFile == null || !accelerationFile.isFile() || !accelerationFile.canRead()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "File \"" + this.keyStoreLocation + "\" does not exist.");
                        }
                        if (this.keyStoreForAcceleration != null && this.keyStoreForAcceleration.booleanValue()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Crypto operations config file does not exist.");
                            }
                            msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.check.acceleration.file.CWPKI0664E", new Object[]{this.keyStoreLocation}, "Cryptographic operations configuration file \"" + this.keyStoreLocation + "\"does not exist.");
                            throw new Exception(msg);
                        }
                    }
                    this.createKeyFile = false;
                }
            } else {
                AdminService adminService = AdminServiceFactory.getAdminService();
                String processType = adminService.getProcessType();
                if (processType != null && processType.equals("UnManagedProcess")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Can not remotely manage key stores from a base application server.");
                    }
                    String msg7 = TraceNLSHelper.getInstance().getString("ssl.command.not.remote.CWPKI0669E", "Key stores and certificates can not be remotely managed from a base application server.");
                    throw new Exception(msg7);
                }
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keyStoreName);
            keyStoreFound = commandHelper.exists(cs, session, audit, CommandConstants.KEY_STORES, queryAttrs, this.scopeName);
            if (keyStoreFound) {
                msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.already.exists.CWPKI0601E", new Object[]{this.keyStoreName, this.scopeName}, this.keyStoreName + " in the management scope " + this.scopeName + " already exists.");
                throw new CommandValidationException(msg);
            }
            if (this.keyStoreForAcceleration != null && this.keyStoreForAcceleration.booleanValue() && !this.keyStoreType.equals("PKCS11")) {
                msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.keystore.hardware.CWPKI0658E", new Object[]{"PKCS11"}, "Key store types for hardware devices must be PKCS11");
                throw new CommandValidationException(msg);
            }
            queryAttrs.clear();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.SCOPE_NAME, this.scopeName);
            boolean mgmScopeNameFound = commandHelper.exists(cs, session, audit, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
            if (!mgmScopeNameFound) {
                this.createMgmScope = true;
            } else {
                this.mgmScopeObjName = commandHelper.getObjectName(cs, session, audit, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "mgmScopeObjName: " + this.mgmScopeObjName);
                }
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService exception is" + e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName objectCreated = null;
        ObjectName audit = null;
        AttributeList attrList = new AttributeList();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (this.createMgmScope) {
                ManagementScopeData scopeData = new ManagementScopeData(this.scopeName);
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SCOPE_NAME, this.scopeName);
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SCOPE_TYPE, scopeData.getScopeType());
                this.mgmScopeObjName = cs.createConfigData(session, audit, CommandConstants.MANAGEMENT_SCOPES, null, attrList);
                attrList.clear();
            }
            KeyStoreInfo ksInfo = new KeyStoreInfo(this.keyStoreName, this.keyStoreLocation, this.keyStorePassword, this.keyStoreProvider, this.keyStoreType, this.keyStoreIsFileBased, this.keyStoreHostList, this.scopeName, this.mgmScopeObjName, this.keyStoreReadOnly, this.keyStoreInitAtStartup, this.keyStoreStashFile, this.keyStoreCustomProvider, null, this.keyStoreForAcceleration, null, this.keyStoreDescription);
            objectCreated = KeyStoreHelper.createKeyStoreCmd(session, ksInfo, this.createKeyFile);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.MANAGEMENT_SCOPE, this.mgmScopeObjName);
            cs.setAttributes(session, objectCreated, attrList);
            attrList.clear();
            AttributeList newAttrs = cs.getAttributes(session, objectCreated, null, true);
            String nRef = ConfigServiceHelper.getAttributeValue(newAttrs, "_Websphere_Config_Data_Id").toString();
            nRef = nRef.split("#")[1];
            result.setResult(nRef);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

