/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.filter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListAuditFiltersByEvent
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ListAuditFiltersByEvent.class, "AUDIT", "com.ibm.ws.security.admintask.audit.filter");

    public ListAuditFiltersByEvent(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListAuditFiltersByEvent(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        String filters = new String();
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            ArrayList filterArray = (ArrayList)cs.getAttribute(session, audit, "auditSpecifications");
            for (int i = 0; i < filterArray.size(); ++i) {
                AttributeList filterAttrs = (AttributeList)filterArray.get(i);
                ObjectName auditSpec = ConfigServiceHelper.createObjectName(filterAttrs);
                ArrayList eventAttrs = (ArrayList)cs.getAttribute(session, auditSpec, "event");
                ArrayList outcomeAttrs = (ArrayList)cs.getAttribute(session, auditSpec, "outcome");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "eventAttrs: " + eventAttrs.toString());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "outcomeAttrs: " + outcomeAttrs.toString());
                }
                String filterRef = ConfigServiceHelper.getConfigDataId(auditSpec).toString().split("#")[1];
                for (int j = 0; j < eventAttrs.size(); ++j) {
                    String event2 = (String)eventAttrs.get(j);
                    filters = filters.concat("{").concat(filterRef).concat(" ");
                    for (int k = 0; k < outcomeAttrs.size(); ++k) {
                        String outcome = (String)outcomeAttrs.get(k);
                        filters = filters.concat(event2).concat(":").concat(outcome).concat(";");
                    }
                    filters = filters.substring(0, filters.length() - 1);
                    filters = filters.concat("}");
                }
            }
            result.setResult(filters);
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.filter.ListAuditFiltersByEvent.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.filter.ListAuditFiltersByEvent.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

