/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.filter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.audit.utils.AuditCommandHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class IsAuditFilterEnabled
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(IsAuditFilterEnabled.class, "AUDIT", "com.ibm.ws.security.admintask.audit.filter");
    String eventType = null;
    String outcome = null;
    boolean enabledState = false;

    public IsAuditFilterEnabled(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public IsAuditFilterEnabled(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.eventType = (String)this.getParameter("eventType");
        if (this.eventType == null || this.eventType.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidEventType", null);
            throw new CommandValidationException(msg);
        }
        if (!AuditCommandHelper.isValidEventType(this.eventType)) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidEventType", null);
            throw new CommandValidationException(msg);
        }
        this.outcome = (String)this.getParameter("outcome");
        if (this.outcome == null || this.outcome.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidOutcome", null);
            throw new CommandValidationException(msg);
        }
        if (!AuditCommandHelper.isValidOutcome(this.outcome)) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidOutcome", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            ArrayList filterArray = (ArrayList)cs.getAttribute(session, audit, "auditSpecifications");
            boolean foundMatchingEvent = false;
            boolean foundMatchingOutcome = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Looking for event: " + this.eventType + " outcome: " + this.outcome);
            }
            for (int i = 0; i < filterArray.size(); ++i) {
                AttributeList filterAttrs = (AttributeList)filterArray.get(i);
                ObjectName filterObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(filterAttrs), null)[0];
                Boolean enabledCheck = (Boolean)cs.getAttribute(session, filterObject, "enabled");
                this.enabledState = enabledCheck;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "enabledState: " + this.enabledState);
                }
                foundMatchingEvent = false;
                foundMatchingOutcome = false;
                Iterator iter = filterAttrs.iterator();
                while (iter.hasNext()) {
                    boolean index;
                    StringTokenizer st;
                    int j;
                    ArrayList eventsList = null;
                    ArrayList outcomesList = null;
                    Attribute a = (Attribute)iter.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attr: " + a.getName() + " : " + a.getValue().toString());
                    }
                    if (a.getName().equals("event")) {
                        eventsList = (ArrayList)a.getValue();
                    }
                    if (a.getName().equals("outcome")) {
                        outcomesList = (ArrayList)a.getValue();
                    }
                    if (eventsList != null) {
                        for (j = 0; j < eventsList.size(); ++j) {
                            String auditEvents = eventsList.get(j).toString();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "list of events: " + auditEvents);
                            }
                            st = new StringTokenizer(auditEvents, ",; ");
                            index = false;
                            while (st.hasMoreTokens() && !foundMatchingEvent) {
                                String event2 = st.nextToken();
                                if (!event2.equals(this.eventType)) continue;
                                foundMatchingEvent = true;
                            }
                            if (foundMatchingEvent) break;
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " foundMatchingEvent: " + foundMatchingEvent);
                    }
                    if (foundMatchingEvent && outcomesList != null) {
                        for (j = 0; j < outcomesList.size(); ++j) {
                            String outcomes = outcomesList.get(j).toString();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "list of outcomes: " + outcomes);
                            }
                            st = new StringTokenizer(outcomes, ",; ");
                            index = false;
                            while (st.hasMoreTokens() && !foundMatchingOutcome) {
                                String oc = st.nextToken();
                                if (!oc.equals(this.outcome)) continue;
                                foundMatchingOutcome = true;
                            }
                            if (foundMatchingOutcome) break;
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " foundMatchingOutcome: " + foundMatchingOutcome);
                    }
                    if (!foundMatchingEvent || !foundMatchingOutcome) continue;
                    if (this.enabledState) {
                        result.setResult(new Boolean(true));
                    } else {
                        result.setResult(new Boolean(false));
                    }
                    return;
                }
            }
            if (!foundMatchingEvent || !foundMatchingOutcome) {
                result.setResult(new Boolean(false));
                return;
            }
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.filter.IsAuditFilterEnabled.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.filter.IsAuditFilterEnabled.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

