/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.filter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.audit.utils.AuditCommandHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteAuditFilter
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(DeleteAuditFilter.class, "AUDIT", "com.ibm.ws.security.admintask.audit.filter");
    String eventType = null;
    String outcome = null;

    public DeleteAuditFilter(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public DeleteAuditFilter(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.eventType = (String)this.getParameter("eventType");
        if (this.eventType == null || this.eventType.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidEventType", null);
            throw new CommandValidationException(msg);
        }
        if (!AuditCommandHelper.isValidEventType(this.eventType)) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidEventType", null);
            throw new CommandValidationException(msg);
        }
        this.outcome = (String)this.getParameter("outcome");
        if (this.outcome == null || this.outcome.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidOutcome", null);
            throw new CommandValidationException(msg);
        }
        if (!AuditCommandHelper.isValidOutcome(this.outcome)) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidOutcome", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            AttributeList policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
            ObjectName policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
            ArrayList filterArray = (ArrayList)cs.getAttribute(session, audit, "auditSpecifications");
            boolean found = false;
            for (int i = 0; i < filterArray.size(); ++i) {
                AttributeList filterAttrs = (AttributeList)filterArray.get(i);
                ObjectName auditSpec = ConfigServiceHelper.createObjectName(filterAttrs);
                ArrayList eventAttrs = (ArrayList)cs.getAttribute(session, auditSpec, "event");
                ArrayList outcomeAttrs = (ArrayList)cs.getAttribute(session, auditSpec, "outcome");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "eventAttrs: " + eventAttrs.toString());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "outcomeAttrs: " + outcomeAttrs.toString());
                }
                if (eventAttrs.indexOf(this.eventType) == -1 || outcomeAttrs.indexOf(this.outcome) == -1) continue;
                found = true;
                if (eventAttrs.size() == 1 && outcomeAttrs.size() == 1) {
                    cs.deleteConfigData(session, auditSpec);
                    break;
                }
                if (eventAttrs.size() == 1 && outcomeAttrs.size() > 1) {
                    outcomeAttrs.remove(outcomeAttrs.indexOf(this.outcome));
                    ConfigServiceHelper.setAttributeValue(filterAttrs, "outcome", outcomeAttrs);
                    cs.setAttributes(session, auditSpec, filterAttrs);
                    break;
                }
                if (eventAttrs.size() > 1 && outcomeAttrs.size() == 1) {
                    eventAttrs.remove(eventAttrs.indexOf(this.eventType));
                    ConfigServiceHelper.setAttributeValue(filterAttrs, "event", eventAttrs);
                    cs.setAttributes(session, auditSpec, filterAttrs);
                    break;
                }
                if (eventAttrs.size() <= 1 || outcomeAttrs.size() <= 1) continue;
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Unsupported operation: cannot delete a subset of a multiset filter.");
                }
                String msg = this.getMsg(resBundle, "security.admintask.UnsupportedFilterOp", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            if (!found) {
                String msg = this.getMsg(resBundle, "security.admintask.InvalidAuditFilters", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            result.setResult(new Boolean(true));
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.filter.DeleteAuditFilter.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.filter.DeleteAuditFilter.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

