/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.filter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.audit.utils.AuditCommandHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateAuditFilter
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(CreateAuditFilter.class, "AUDIT", "com.ibm.ws.security.admintask.audit.filter");
    String eventType = null;
    String outcome = null;
    String name = null;

    public CreateAuditFilter(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateAuditFilter(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.eventType = (String)this.getParameter("eventType");
        if (this.eventType == null || this.eventType.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidEventType", null);
            throw new CommandValidationException(msg);
        }
        this.outcome = (String)this.getParameter("outcome");
        if (this.outcome == null || this.outcome.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidOutcome", null);
            throw new CommandValidationException(msg);
        }
        this.name = (String)this.getParameter("name");
        if (this.name == null || this.name.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.NoNameForFilter", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        try {
            ArrayList<String> outcomesList;
            ArrayList<String> eventsList;
            ArrayList outcomeAttrs;
            ArrayList eventAttrs;
            AttributeList attrs;
            ObjectName auditSpec;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            AttributeList policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
            ObjectName policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
            AttributeList settings = new AttributeList();
            settings.add(new Attribute("enabled", Boolean.TRUE));
            settings.add(new Attribute("name", this.name));
            if (settings != null) {
                auditSpec = cs.createConfigData(session, audit, "auditSpecifications", "AuditSpecification", settings);
                attrs = cs.getAttributes(session, auditSpec, null, true);
                eventAttrs = (ArrayList)cs.getAttribute(session, auditSpec, "event");
                outcomeAttrs = (ArrayList)cs.getAttribute(session, auditSpec, "outcome");
                eventsList = new ArrayList<String>();
                if (this.eventType != null) {
                    StringTokenizer st = new StringTokenizer(this.eventType, ",;: ");
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if (!AuditCommandHelper.isValidEventType(token)) {
                            String msg = this.getMsg(resBundle, "security.admintask.InvalidEventType", null);
                            result.addWarnings(msg);
                            result.setResult(new Boolean(false));
                            result.setException(new CommandException(msg));
                            return;
                        }
                        eventsList.add(token);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "eventsList: " + eventsList.toString());
                    }
                }
                outcomesList = new ArrayList<String>();
                if (this.outcome != null) {
                    StringTokenizer st = new StringTokenizer(this.outcome, ",;: ");
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if (!AuditCommandHelper.isValidOutcome(token)) {
                            String msg = this.getMsg(resBundle, "security.admintask.InvalidOutcome", null);
                            result.addWarnings(msg);
                            result.setResult(new Boolean(false));
                            result.setException(new CommandException(msg));
                            return;
                        }
                        outcomesList.add(token);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "outcomesList: " + outcomesList.toString());
                    }
                }
            } else {
                String msg = this.getMsg(resBundle, "security.admintask.CreateObjFailure", null);
                msg = msg.concat(": AuditSpecification");
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            eventAttrs.addAll(eventsList);
            ConfigServiceHelper.setAttributeValue(attrs, "event", eventAttrs);
            outcomeAttrs.addAll(outcomesList);
            ConfigServiceHelper.setAttributeValue(attrs, "outcome", outcomeAttrs);
            cs.setAttributes(session, auditSpec, attrs);
            AttributeList newAttrs = cs.getAttributes(session, auditSpec, null, true);
            String nRef = ConfigServiceHelper.getAttributeValue(newAttrs, "_Websphere_Config_Data_Id").toString();
            nRef = nRef.split("#")[1];
            result.setResult(nRef);
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.filter.CreateAuditFilter.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.filter.CreateAuditFilter.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

