/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.filter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.audit.utils.AuditCommandHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ConvertFilterStringToRef
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ConvertFilterStringToRef.class, "AUDIT", "com.ibm.ws.security.admintask.audit.filter");
    static String prefix = "SECURITY_";
    String filter = null;
    String event = null;
    String outcome = null;

    public ConvertFilterStringToRef(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ConvertFilterStringToRef(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.filter = (String)this.getParameter("filter");
        if (this.filter == null || this.filter.length() == 0 || !this.filter.contains(":")) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidFilterRef", null);
            throw new CommandValidationException(msg);
        }
        if (this.filter.contains(" ") || this.filter.contains(",") || this.filter.contains(";")) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidFilterRef", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "filter: " + this.filter);
        }
        this.event = new String(this.filter.split(":")[0]);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "event: " + this.event);
        }
        if (!AuditCommandHelper.isValidEventType(this.event)) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidEventType", null);
            throw new CommandValidationException(msg);
        }
        this.outcome = this.filter.split(":")[1];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "outcome: " + this.outcome);
        }
        if (!AuditCommandHelper.isValidOutcome(this.outcome)) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidOutcome", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "event: " + this.event + " outcome: " + this.outcome);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        Object conversion = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            ArrayList filterArray = (ArrayList)cs.getAttribute(session, audit, "auditSpecifications");
            for (int i = 0; i < filterArray.size(); ++i) {
                AttributeList filterAttrs = (AttributeList)filterArray.get(i);
                ObjectName auditSpec = ConfigServiceHelper.createObjectName(filterAttrs);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "auditSpec: " + auditSpec.toString());
                }
                ArrayList eventsList = (ArrayList)cs.getAttribute(session, auditSpec, "event");
                ArrayList outcomesList = (ArrayList)cs.getAttribute(session, auditSpec, "outcome");
                if (eventsList == null) continue;
                for (int j = 0; j < eventsList.size(); ++j) {
                    String auditEvents = eventsList.get(j).toString();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, j + " list of events: " + auditEvents);
                    }
                    StringTokenizer st = new StringTokenizer(auditEvents, ",; ");
                    boolean index = false;
                    while (st.hasMoreTokens()) {
                        String thisEvent = st.nextToken();
                        if (!thisEvent.equals(this.event) || outcomesList == null) continue;
                        for (int k = 0; k < outcomesList.size(); ++k) {
                            String outcomes = outcomesList.get(k).toString();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, k + " list of outcomes: " + outcomes);
                            }
                            StringTokenizer stt = new StringTokenizer(outcomes, ",; ");
                            boolean indexx = false;
                            while (stt.hasMoreTokens()) {
                                String thisOutcome = stt.nextToken();
                                if (!thisOutcome.equals(this.outcome)) continue;
                                String auditSpecRef = ConfigServiceHelper.getAttributeValue(filterAttrs, "_Websphere_Config_Data_Id").toString();
                                auditSpecRef = auditSpecRef.split("#")[1];
                                result.setResult(auditSpecRef);
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "afterStepsExecuted");
                                }
                                return;
                            }
                        }
                    }
                }
            }
            result.setResult(null);
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.filter.ConvertFilterRefToString.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.filter.ConvertFilterRefToString.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
    }
}

