/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.emitter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.audit.utils.AuditCommandHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifyAuditEmitter
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ModifyAuditEmitter.class, "AUDIT", "com.ibm.ws.security.admintask.audit.emitter");
    String emitterRef = null;
    String className = null;
    String eventFormatterClassName = null;
    String fileLocation = null;
    Integer maxFileSize = -1;
    Integer maxLogs = -1;
    String auditFilters = null;
    String customProperties = null;
    String[] customPropName = new String[10];
    String[] customPropValue = new String[10];
    boolean removeAll = false;

    public ModifyAuditEmitter(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ModifyAuditEmitter(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        String clName;
        String emitterFactoryRef;
        ObjectName emitterFactory;
        AttributeList emitterAttrs;
        int i;
        ArrayList emitterList;
        boolean found;
        ObjectName policyObject;
        AttributeList policyAttrs;
        String msg;
        ObjectName pattern;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.emitterRef = (String)this.getParameter("emitterRef");
        if (this.emitterRef == null || this.emitterRef.length() == 0) {
            String msg2 = this.getMsg(resBundle, "security.admintask.InvalidProvider", null);
            throw new CommandValidationException(msg2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "emitterRef: " + this.emitterRef);
        }
        this.className = (String)this.getParameter("className");
        if (this.className != null && this.className.length() == 0) {
            String msg3 = this.getMsg(resBundle, "security.admintask.InvalidClassName", null);
            throw new CommandValidationException(msg3);
        }
        if (this.className != null && this.className.length() != 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "className: " + this.className);
            }
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName audit = null;
            try {
                ObjectName pattern2 = ConfigServiceHelper.createObjectName(null, "Audit");
                audit = cs.queryConfigObjects(session, null, pattern2, null)[0];
                if (audit == null) {
                    String msg4 = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                    throw new CommandValidationException(msg4);
                }
                AttributeList policyAttrs2 = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
                ObjectName policyObject2 = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs2), null)[0];
                ArrayList emitterList2 = (ArrayList)cs.getAttribute(session, policyObject2, "auditServiceProviders");
                for (int i2 = 0; i2 < emitterList2.size(); ++i2) {
                    AttributeList emitterAttrs2 = (AttributeList)emitterList2.get(i2);
                    ObjectName emitterFactory2 = ConfigServiceHelper.createObjectName(emitterAttrs2);
                    String emitterFactoryRef2 = ConfigServiceHelper.getAttributeValue(emitterAttrs2, "_Websphere_Config_Data_Id").toString();
                    if (!(emitterFactoryRef2 = emitterFactoryRef2.split("#")[1]).equals(this.emitterRef)) continue;
                    String clName2 = (String)cs.getAttribute(session, emitterFactory2, "className");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "class name: " + clName2);
                    }
                    if (!clName2.equals("com.ibm.ws.security.audit.BinaryEmitterImpl") || clName2.equals(this.className)) continue;
                    String msg5 = this.getMsg(resBundle, "security.admintask.ClassNotDefaultEmitter", null);
                    throw new CommandValidationException(msg5);
                }
            }
            catch (Exception e) {
                throw new CommandValidationException(e.getMessage());
            }
        }
        this.eventFormatterClassName = (String)this.getParameter("eventFormatterClass");
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        try {
            pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                throw new CommandValidationException(msg);
            }
            policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
            policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
            found = false;
            emitterList = (ArrayList)cs.getAttribute(session, policyObject, "auditServiceProviders");
            for (i = 0; i < emitterList.size(); ++i) {
                emitterAttrs = (AttributeList)emitterList.get(i);
                emitterFactory = ConfigServiceHelper.createObjectName(emitterAttrs);
                emitterFactoryRef = ConfigServiceHelper.getAttributeValue(emitterAttrs, "_Websphere_Config_Data_Id").toString();
                if (!(emitterFactoryRef = emitterFactoryRef.split("#")[1]).equals(this.emitterRef)) continue;
                clName = (String)cs.getAttribute(session, emitterFactory, "className");
                if (!clName.equals("com.ibm.ws.security.audit.BinaryEmitterImpl") && this.eventFormatterClassName != null && this.eventFormatterClassName.length() == 0) {
                    String msg6 = this.getMsg(resBundle, "security.admintask.InvalidEventFormatterClassName", null);
                    throw new CommandValidationException(msg6);
                }
                break;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.emitter.ModifyAuditEmitter.validate", "%");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            throw new CommandValidationException(msg);
        }
        if (this.eventFormatterClassName != null && this.eventFormatterClassName.length() != 0 && tc.isDebugEnabled()) {
            Tr.debug(tc, "eventFormatterClassName: " + this.eventFormatterClassName);
        }
        this.fileLocation = (String)this.getParameter("fileLocation");
        try {
            pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                throw new CommandValidationException(msg);
            }
            policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
            policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
            found = false;
            emitterList = (ArrayList)cs.getAttribute(session, policyObject, "auditServiceProviders");
            for (i = 0; i < emitterList.size(); ++i) {
                emitterAttrs = (AttributeList)emitterList.get(i);
                emitterFactory = ConfigServiceHelper.createObjectName(emitterAttrs);
                emitterFactoryRef = ConfigServiceHelper.getAttributeValue(emitterAttrs, "_Websphere_Config_Data_Id").toString();
                if (!(emitterFactoryRef = emitterFactoryRef.split("#")[1]).equals(this.emitterRef)) continue;
                clName = (String)cs.getAttribute(session, emitterFactory, "className");
                if (clName.equals("com.ibm.ws.security.audit.BinaryEmitterImpl") && this.fileLocation != null && this.fileLocation.length() == 0) {
                    String msg7 = this.getMsg(resBundle, "security.admintask.InvalidFileLocation", null);
                    throw new CommandValidationException(msg7);
                }
                break;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.emitter.ModifyAuditEmitter.validate", "%");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            throw new CommandValidationException(msg);
        }
        if (this.fileLocation != null && this.fileLocation.length() != 0) {
            int index = this.fileLocation.indexOf("${PROFILE_ROOT}");
            if (index != -1) {
                String firstPart = this.fileLocation.substring(0, index);
                String lastPart = this.fileLocation.substring(index + "${PROFILE_ROOT}".length());
                String userRoot = System.getProperty("user.install.root");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "User install root: " + userRoot);
                }
                if (userRoot != null) {
                    this.fileLocation = firstPart != null && !firstPart.equals("") ? firstPart + userRoot + lastPart : userRoot + lastPart;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adjusted fileLocation: " + this.fileLocation);
                }
            }
            try {
                File file = new File(this.fileLocation);
                if (!file.exists()) {
                    file.mkdirs();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "successfully mkdir for: " + this.fileLocation);
                    }
                    file.delete();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "successfully delete for: " + this.fileLocation);
                    }
                }
            }
            catch (Exception e) {
                String msg8 = this.getMsg(resBundle, "security.admintask.FilePathException", null);
                if (e.getMessage() != null) {
                    msg8 = msg8.concat(": " + e.getMessage());
                }
                throw new CommandValidationException(msg8);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fileLocation: " + this.fileLocation);
            }
        }
        if (this.getParameter("maxFileSize") != null) {
            this.maxFileSize = (Integer)this.getParameter("maxFileSize");
            if (this.maxFileSize < 1) {
                String msg9 = this.getMsg(resBundle, "security.admintask.InvalidMaxSizeValue", null);
                throw new CommandValidationException(msg9);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "maxFileSize: " + this.maxFileSize);
            }
        }
        if (this.getParameter("maxLogs") != null) {
            this.maxLogs = (Integer)this.getParameter("maxLogs");
            if (this.maxLogs < 1) {
                String msg10 = this.getMsg(resBundle, "security.admintask.InvalidMaxLogsValue", null);
                throw new CommandValidationException(msg10);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "maxLogs: " + this.maxLogs);
            }
        }
        this.customProperties = (String)this.getParameter("customProperties");
        if (this.customProperties != null && this.customProperties.length() == 0) {
            this.removeAll = true;
        }
        if (this.customProperties != null && this.customProperties.length() != 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "customProperties: " + this.customProperties);
            }
            if (this.customProperties.indexOf("=") == -1) {
                String msg11 = this.getMsg(resBundle, "security.admintask.InvalidCustomProperty", null);
                throw new CommandValidationException(msg11);
            }
            if (this.customProperties.endsWith("=") || this.customProperties.endsWith(",")) {
                String msg12 = this.getMsg(resBundle, "security.admintask.InvalidCustomProperty", null);
                throw new CommandValidationException(msg12);
            }
        }
        this.auditFilters = (String)this.getParameter("auditFilters");
        if (this.auditFilters != null && this.auditFilters.length() == 0) {
            String msg13 = this.getMsg(resBundle, "security.admintask.InvalidAuditFilters", null);
            throw new CommandValidationException(msg13);
        }
        if (this.auditFilters != null && this.auditFilters.length() != 0 && tc.isDebugEnabled()) {
            Tr.debug(tc, "auditFilters: " + this.auditFilters);
        }
        if (this.eventFormatterClassName == null && this.className == null && this.fileLocation == null && this.maxFileSize == -1 && this.maxLogs == -1 && this.auditFilters == null && this.customProperties == null) {
            String msg14 = this.getMsg(resBundle, "security.admintask.MissingModifyParms", null);
            throw new CommandValidationException(msg14);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            AttributeList policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
            ObjectName policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
            boolean found = false;
            ArrayList emitterList = (ArrayList)cs.getAttribute(session, policyObject, "auditServiceProviders");
            for (int i = 0; i < emitterList.size(); ++i) {
                String[] aList;
                AttributeList emitterAttrs = (AttributeList)emitterList.get(i);
                ObjectName emitterFactory = ConfigServiceHelper.createObjectName(emitterAttrs);
                String emitterFactoryRef = ConfigServiceHelper.getAttributeValue(emitterAttrs, "_Websphere_Config_Data_Id").toString();
                if (!(emitterFactoryRef = emitterFactoryRef.split("#")[1]).equals(this.emitterRef)) continue;
                found = true;
                String clName = (String)cs.getAttribute(session, emitterFactory, "className");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "clName: " + clName);
                }
                if (this.className != null && this.className.length() != 0) {
                    ConfigServiceHelper.setAttributeValue(emitterAttrs, "className", this.className);
                }
                if (this.eventFormatterClassName != null && this.eventFormatterClassName.length() == 0 && !clName.equals("com.ibm.ws.security.audit.BinaryEmitterImpl")) {
                    String msg = this.getMsg(resBundle, "security.admintask.InvalidEventFormatterClass", null);
                    result.addWarnings(msg);
                    result.setResult(new Boolean(false));
                    result.setException(new CommandException(msg));
                    return;
                }
                ConfigServiceHelper.setAttributeValue(emitterAttrs, "eventFormatterClass", this.eventFormatterClassName);
                if (this.fileLocation != null) {
                    if (!clName.equals("com.ibm.ws.security.audit.BinaryEmitterImpl")) {
                        String msg = this.getMsg(resBundle, "security.admintask.NotBinaryImpl", null);
                        result.addWarnings(msg);
                        result.setResult(new Boolean(false));
                        result.setException(new CommandException(msg));
                        return;
                    }
                    if (this.fileLocation.length() == 0) {
                        String msg = this.getMsg(resBundle, "security.admintask.InvalidFileLocation", null);
                        result.addWarnings(msg);
                        result.setResult(new Boolean(false));
                        result.setException(new CommandException(msg));
                        return;
                    }
                    ConfigServiceHelper.setAttributeValue(emitterAttrs, "fileLocation", this.fileLocation);
                }
                if (this.maxFileSize != -1) {
                    if (!clName.equals("com.ibm.ws.security.audit.BinaryEmitterImpl")) {
                        String msg = this.getMsg(resBundle, "security.admintask.NotBinaryImpl", null);
                        result.addWarnings(msg);
                        result.setResult(new Boolean(false));
                        result.setException(new CommandException(msg));
                        return;
                    }
                    ConfigServiceHelper.setAttributeValue(emitterAttrs, "maxFileSize", this.maxFileSize);
                }
                if (this.maxLogs != -1) {
                    if (!clName.equals("com.ibm.ws.security.audit.BinaryEmitterImpl")) {
                        String msg = this.getMsg(resBundle, "security.admintask.NotBinaryImpl", null);
                        result.addWarnings(msg);
                        result.setResult(new Boolean(false));
                        result.setException(new CommandException(msg));
                        return;
                    }
                    ConfigServiceHelper.setAttributeValue(emitterAttrs, "maxLogs", this.maxLogs);
                }
                if (this.auditFilters != null) {
                    aList = new ArrayList();
                    StringTokenizer st = new StringTokenizer(this.auditFilters, ",; ");
                    boolean index = false;
                    while (st.hasMoreTokens()) {
                        String filter = st.nextToken();
                        boolean foundFilter = false;
                        ArrayList filterArray = (ArrayList)cs.getAttribute(session, audit, "auditSpecifications");
                        for (int k = 0; k < filterArray.size(); ++k) {
                            AttributeList filterAttrs = (AttributeList)filterArray.get(k);
                            ObjectName auditSpec = ConfigServiceHelper.createObjectName(filterAttrs);
                            String filterR = ConfigServiceHelper.getConfigDataId(auditSpec).toString().split("#")[1];
                            if (!filterR.equals(filter)) continue;
                            foundFilter = true;
                            aList.add(auditSpec);
                            break;
                        }
                        if (foundFilter) continue;
                        String msg = this.getMsg(resBundle, "security.admintask.InvalidFilterRef", null);
                        result.addWarnings(msg);
                        result.setResult(new Boolean(false));
                        result.setException(new CommandException(msg));
                        return;
                    }
                    ArrayList auditSpecs = (ArrayList)cs.getAttribute(session, emitterFactory, "auditSpecifications");
                    auditSpecs.clear();
                    auditSpecs.addAll(aList);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "auditSpecs: " + auditSpecs.toString());
                    }
                    ConfigServiceHelper.setAttributeValue(emitterAttrs, "auditSpecifications", auditSpecs);
                }
                cs.setAttributes(session, emitterFactory, emitterAttrs);
                if (this.removeAll) {
                    aList = new String[]{"properties"};
                    cs.unsetAttributes(session, emitterFactory, aList);
                } else if (this.customProperties != null) {
                    AuditCommandHelper.addCustomProperties(session, cs, emitterFactory, this.customProperties);
                }
                result.setResult(new Boolean(true));
                break;
            }
            if (!found) {
                String msg = this.getMsg(resBundle, "security.admintask.InvalidProvider", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
            }
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.emitter.ModifyAuditEmitter.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.emitter.ModifyAuditEmitter.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

