/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.emitter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class GetAuditEmitterFilters
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(GetAuditEmitterFilters.class, "AUDIT", "com.ibm.ws.security.admintask.audit.emitter");
    String emitterRef = null;
    static String prefix = "SECURITY_";

    public GetAuditEmitterFilters(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public GetAuditEmitterFilters(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.emitterRef = (String)this.getParameter("emitterRef");
        if (this.emitterRef == null || this.emitterRef.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidProvider", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        String s = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            AttributeList policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
            ObjectName policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
            boolean found = false;
            ArrayList emitterList = (ArrayList)cs.getAttribute(session, policyObject, "auditServiceProviders");
            for (int i = 0; i < emitterList.size(); ++i) {
                AttributeList emitterAttrs = (AttributeList)emitterList.get(i);
                ObjectName emitterFactory = ConfigServiceHelper.createObjectName(emitterAttrs);
                String emitterFactoryRef = ConfigServiceHelper.getAttributeValue(emitterAttrs, "_Websphere_Config_Data_Id").toString();
                if (!(emitterFactoryRef = emitterFactoryRef.split("#")[1]).equals(this.emitterRef)) continue;
                found = true;
                ArrayList auditSpecs = (ArrayList)cs.getAttribute(session, emitterFactory, "auditSpecifications");
                for (int j = 0; j < auditSpecs.size(); ++j) {
                    String auditSpecRef = auditSpecs.get(j).toString();
                    auditSpecRef = auditSpecRef.split("#")[1];
                    auditSpecRef = auditSpecRef.split(",")[0];
                    try {
                        CommandMgr commandMgr = CommandMgr.getCommandMgr();
                        AdminCommand getUserCmd = commandMgr.createCommand("convertFilterRefToString");
                        getUserCmd.setConfigSession(session);
                        getUserCmd.setParameter("filterRef", auditSpecRef);
                        getUserCmd.execute();
                        CommandResult cmdResult = getUserCmd.getCommandResult();
                        if (cmdResult.isSuccessful()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "success");
                            }
                            if (s == null) {
                                s = new String();
                            }
                            if (!s.contains(cmdResult.getResult().toString())) {
                                s = s.concat(cmdResult.getResult().toString()).concat(",");
                            }
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "cmdResult.getException().getMessage() = " + cmdResult.getException().getMessage());
                        }
                        if (cmdResult.getException() == null || cmdResult.getException().getMessage() == null || cmdResult.getException().getMessage().indexOf("CWWIM4501E") != -1) continue;
                        String msg = this.getMsg(resBundle, "security.admintask.InvalidFilterRef", null);
                        result.addWarnings(msg);
                        result.setResult(s);
                        result.setException(new CommandException(msg));
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "afterStepsExecuted");
                        }
                        return;
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "exception = " + e.getMessage().toString());
                        }
                        result.setResult(s);
                        String msg = this.getMsg(resBundle, "security.profiletask.failAddingAdminToWim", null);
                        result.setException(new CommandException(e, msg));
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "afterStepsExecuted");
                        }
                        return;
                    }
                }
            }
            if (!found) {
                String msg = this.getMsg(resBundle, "security.admintask.InvalidProvider", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
            }
            if (s != null) {
                result.setResult(s.substring(0, s.length() - 1));
            } else {
                result.setResult(null);
            }
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.emitter.GetAuditEmitterFilters.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(s);
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.emitter.GetAuditEmitterFilters.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(s);
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

