/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.emitter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateBinaryEmitter
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(CreateBinaryEmitter.class, "AUDIT", "com.ibm.ws.security.admintask.audit.emitter");
    String uniqueName = null;
    String className = null;
    String eventFormatterClassName = null;
    String fileLocation = null;
    Integer maxFileSize = 10;
    Integer maxLogs = 100;
    String auditFilters = null;

    public CreateBinaryEmitter(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateBinaryEmitter(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.uniqueName = (String)this.getParameter("uniqueName");
        if (this.uniqueName == null || this.uniqueName.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidUniqueName", null);
            throw new CommandValidationException(msg);
        }
        this.className = (String)this.getParameter("className");
        if (this.className == null || this.className.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidClassName", null);
            throw new CommandValidationException(msg);
        }
        this.eventFormatterClassName = (String)this.getParameter("eventFormatterClass");
        this.fileLocation = (String)this.getParameter("fileLocation");
        if (this.fileLocation == null || this.fileLocation.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidFileLocation", null);
            throw new CommandValidationException(msg);
        }
        if (this.fileLocation != null && this.fileLocation.length() != 0) {
            int index = this.fileLocation.indexOf("${PROFILE_ROOT}");
            if (index != -1) {
                String firstPart = this.fileLocation.substring(0, index);
                String lastPart = this.fileLocation.substring(index + "${PROFILE_ROOT}".length());
                String userRoot = System.getProperty("user.install.root");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "User install root: " + userRoot);
                }
                if (userRoot != null) {
                    this.fileLocation = firstPart != null && !firstPart.equals("") ? firstPart + userRoot + lastPart : userRoot + lastPart;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adjusted fileLocation: " + this.fileLocation);
                }
            }
            try {
                File file = new File(this.fileLocation);
                if (!file.exists()) {
                    file.mkdirs();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "successfully mkdir for: " + this.fileLocation);
                    }
                    file.delete();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "successfully delete for: " + this.fileLocation);
                    }
                }
            }
            catch (Exception e) {
                String msg = this.getMsg(resBundle, "security.admintask.FilePathException", null);
                if (e.getMessage() != null) {
                    msg = msg.concat(": " + e.getMessage());
                }
                throw new CommandValidationException(msg);
            }
        }
        if (this.getParameter("maxFileSize") != null) {
            this.maxFileSize = (Integer)this.getParameter("maxFileSize");
            if (this.maxFileSize < 1) {
                String msg = this.getMsg(resBundle, "security.admintask.InvalidMaxSizeValue", null);
                throw new CommandValidationException(msg);
            }
        }
        if (this.getParameter("maxLogs") != null) {
            this.maxLogs = (Integer)this.getParameter("maxLogs");
            if (this.maxLogs < 1) {
                String msg = this.getMsg(resBundle, "security.admintask.InvalidMaxLogsValue", null);
                throw new CommandValidationException(msg);
            }
        }
        this.auditFilters = (String)this.getParameter("auditFilters");
        if (this.auditFilters == null || this.auditFilters.length() == 0) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidAuditFilters", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName audit = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            if (audit == null) {
                String msg = this.getMsg(resBundle, "security.admintask.NoAuditXML", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            AttributeList policyAttrs = (AttributeList)cs.getAttribute(session, audit, "auditPolicy");
            ObjectName policyObject = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(policyAttrs), null)[0];
            ArrayList emitterList = (ArrayList)cs.getAttribute(session, policyObject, "auditServiceProviders");
            for (int i = 0; i < emitterList.size(); ++i) {
                AttributeList emitterAttrs = (AttributeList)emitterList.get(i);
                ObjectName emitterFactory = ConfigServiceHelper.createObjectName(emitterAttrs);
                String emitterName = (String)cs.getAttribute(session, emitterFactory, "name");
                if (!emitterName.equals(this.uniqueName)) continue;
                String msg = this.getMsg(resBundle, "security.admintask.EmitterExists", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            AttributeList settings = new AttributeList();
            settings.add(new Attribute("name", this.uniqueName));
            settings.add(new Attribute("className", this.className));
            if (this.eventFormatterClassName != null) {
                settings.add(new Attribute("eventFormatterClass", this.eventFormatterClassName));
            }
            settings.add(new Attribute("fileLocation", this.fileLocation));
            settings.add(new Attribute("maxFileSize", this.maxFileSize));
            settings.add(new Attribute("maxLogs", this.maxLogs));
            ArrayList<ObjectName> aList = new ArrayList<ObjectName>();
            StringTokenizer st = new StringTokenizer(this.auditFilters, ",; ");
            boolean index = false;
            while (st.hasMoreTokens()) {
                String filter = st.nextToken();
                boolean found = false;
                ArrayList filterArray = (ArrayList)cs.getAttribute(session, audit, "auditSpecifications");
                for (int k = 0; k < filterArray.size(); ++k) {
                    String filterR;
                    AttributeList filterAttrs = (AttributeList)filterArray.get(k);
                    ObjectName auditSpec = ConfigServiceHelper.createObjectName(filterAttrs);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "auditSpec: " + auditSpec.toString());
                    }
                    if (!(filterR = ConfigServiceHelper.getConfigDataId(auditSpec).toString().split("#")[1]).equals(filter)) continue;
                    found = true;
                    aList.add(auditSpec);
                    break;
                }
                if (found) continue;
                String msg = this.getMsg(resBundle, "security.admintask.InvalidAuditFilters", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            settings.add(new Attribute("auditSpecifications", aList));
            if (settings == null) {
                String msg = this.getMsg(resBundle, "security.admintask.CreateObjFailure", null);
                msg = msg.concat(": AuditServiceProvider");
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                return;
            }
            ObjectName serviceProviderObj = cs.createConfigData(session, policyObject, "auditServiceProviders", "AuditServiceProvider", settings);
            AttributeList newAttrs = cs.getAttributes(session, serviceProviderObj, null, true);
            String nRef = ConfigServiceHelper.getAttributeValue(newAttrs, "_Websphere_Config_Data_Id").toString();
            nRef = nRef.split("#")[1];
            result.setResult(nRef);
        }
        catch (ConfigServiceException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.emitter.CreateBinaryEmitter.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.admintask.audit.emitter.CreateBinaryEmitter.afterStepsExecuted", "154");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.admintask.ConfigurationError", null);
            if (e.getMessage() != null) {
                msg = msg.concat(": ");
                msg = msg.concat(e.getMessage());
            }
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

