/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.certificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.security.admintask.audit.certificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStoreHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class RenewAuditCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(RenewAuditCertificate.class, "SSL", "com.ibm.ws.security.admintask.audit.certificates");
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String certificateAlias = null;
    private Boolean deleteSigners = false;
    private KeyStoreInfo ksInfo = null;
    private KeyStoreInfo rootKsInfo = null;
    private String rootKeyStoreName = null;
    private KeyStoreInfo deletedKsInfo = null;
    private String configType = null;
    private Session session = null;

    public RenewAuditCertificate(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public RenewAuditCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName pattern = null;
        ObjectName audit = null;
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            this.session = this.getConfigSession();
            pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            ObjectName cell = cs.resolve(this.session, "Cell=")[0];
            if (cell != null) {
                audit = cs.queryConfigObjects(this.session, cell, pattern, null)[0];
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certificateAlias = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyStoreScope= " + this.keyStoreScope + " certAlias=" + this.certificateAlias);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(cell);
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(this.session, cs, this.keyStoreName, this.keyStoreScope);
            if (this.ksInfo.getReadOnly().booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.readonly.keystore.CWPKI0699E", new Object[]{this.ksInfo.getName()}, this.ksInfo.getName() + " is marked as a read only key store.  Unable to perform write operations to the key store file.");
                throw new CommandValidationException(msg);
            }
            this.deletedKsInfo = commandHelper.getDeletedKeyStore(this.session, cs, this.keyStoreName);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            String rResult = this.personalCertificateRenew(this.session, this.ksInfo, this.certificateAlias, this.keyStoreScope);
            result.setResult(rResult);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public String personalCertificateRenew(Session session, KeyStoreInfo info, String certAlias, String scope) throws Exception {
        StringBuffer rResult;
        block30: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "personalCertificateRenew");
            }
            rResult = new StringBuffer();
            WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
            boolean fileBased = info.getFileBased();
            boolean readOnly = info.getReadOnly();
            String password = info.getPassword();
            Certificate[] certChain = null;
            X509Certificate cert = null;
            PrivateKey certKey = null;
            boolean isCA = false;
            String certificateType = "self-signed";
            try {
                String method2 = "isKeyEntry";
                Object[] parms = new Object[]{certAlias};
                Object[] isKeyEntry = wsksr.invokeKeyStoreCommand(method2, parms);
                if (((Boolean)isKeyEntry[0]).booleanValue()) {
                    method2 = "getCertificateChain";
                    parms = new Object[]{certAlias};
                    Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
                    certChain = (Certificate[])certArray[0];
                    cert = (X509Certificate)certChain[0];
                    method2 = "getKey";
                    parms = new Object[]{certAlias, password.toCharArray()};
                    Object[] key = wsksr.invokeKeyStoreCommand(method2, parms);
                    certKey = (PrivateKey)key[0];
                    if (CertificateRequestHelper.isKeyCertReq(cert, certAlias) != null) {
                        String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.cert.CWPKI0666E", new Object[]{certAlias}, "Certificate \"" + certAlias + "\" is not a personal certificate.");
                        throw new Exception(msg);
                    }
                } else {
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.cert.CWPKI0666E", new Object[]{certAlias}, "Certificate \"" + certAlias + "\" is not a personal certificate.");
                    throw new Exception(msg);
                }
                if (cert.getBasicConstraints() != -1) {
                    isCA = true;
                }
                if (cert != null && certKey != null) {
                    Locale currentLocale;
                    block28: {
                        try {
                            cert.verify(cert.getPublicKey());
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Certificate to be renewed is self-signed");
                            }
                        }
                        catch (SignatureException e) {
                            certificateType = "chained";
                            if (!tc.isDebugEnabled()) break block28;
                            Tr.debug(tc, "Certificate to be renewed is chained");
                        }
                    }
                    boolean issuedByWebSphere = true;
                    if (certificateType.equalsIgnoreCase("chained")) {
                        issuedByWebSphere = PersonalCertificateHelper.signedByWebSphere((X509Certificate)certChain[certChain.length - 1], this.rootKsInfo);
                    }
                    if (!issuedByWebSphere) {
                        ObjectName certRefObj;
                        block29: {
                            ConfigService cs = ConfigServiceFactory.getConfigService();
                            ObjectName audit = null;
                            ObjectName cell = cs.resolve(session, "Cell=")[0];
                            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
                            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
                            CommandHelper commandHelper = new CommandHelper();
                            certRefObj = null;
                            try {
                                certRefObj = commandHelper.getObjectName(cs, session, audit, CommandConstants.CACERTIFICATES, CommandConstants.ALIAS, certAlias);
                            }
                            catch (CommandValidationException e) {
                                if (!tc.isDebugEnabled()) break block29;
                                Tr.debug(tc, "Error obtaining certificate object: " + e.getMessage());
                            }
                        }
                        if (certRefObj != null) {
                            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.ca.norenew.CWPKI0702E", new Object[]{certAlias}, "Certificate specified as alias " + certAlias + " is a certificate authority (CA) certificate and must be renewed manually.");
                            throw new Exception(msg);
                        }
                        String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.not.issued.by.was.CWPKI0703E", new Object[]{certAlias}, "Certificate specified as alias " + certAlias + " was not issued by WebSphere and is unable to be renewed.");
                        throw new Exception(msg);
                    }
                    PublicKey publicKey = cert.getPublicKey();
                    int keySize = -1;
                    keySize = publicKey instanceof RSAPublicKey ? ((RSAPublicKey)publicKey).getModulus().bitLength() : ((DSAPublicKey)publicKey).getParams().getP().bitLength();
                    if (keySize % 2 != 0) {
                        ++keySize;
                    }
                    Date begin = cert.getNotBefore();
                    Date end = cert.getNotAfter();
                    long difference = end.getTime() - begin.getTime();
                    long differenceDays = difference / 86400000L;
                    int validDays = new Long(differenceDays).intValue();
                    String subjectDN = ((Object)cert.getSubjectDN()).toString();
                    CertReqInfo certInfo = new CertReqInfo(certAlias, keySize, subjectDN, validDays, this.ksInfo, null);
                    X509Certificate signer = null;
                    String newAlias = certAlias;
                    WSKeyStoreHelper target_wsks = new WSKeyStoreHelper(this.ksInfo);
                    WSKeyStoreHelper root_wsks = new WSKeyStoreHelper(this.rootKsInfo);
                    if (!certificateType.equals("chained") && certificateType.equals("self-signed")) {
                        newAlias = target_wsks.createSelfSignedCertificate(certInfo, isCA, false);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "newAlias: " + newAlias);
                        }
                        signer = target_wsks.getSigner(newAlias);
                    }
                    if (newAlias != certAlias) {
                        ConfigService cs = ConfigServiceFactory.getConfigService();
                        ObjectName audit = null;
                        ObjectName cell = cs.resolve(session, "Cell=")[0];
                        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
                        audit = cs.queryConfigObjects(session, null, pattern, null)[0];
                        ArrayList certList = (ArrayList)cs.getAttribute(session, audit, "certificates");
                        ObjectName certObj = null;
                        if (certList.size() > 0) {
                            for (int i = 0; i < certList.size(); ++i) {
                                AttributeList certAttrs = (AttributeList)certList.get(i);
                                certObj = ConfigServiceHelper.createObjectName(certAttrs);
                                AttributeList newSettings = new AttributeList();
                                newSettings.add(new Attribute("alias", newAlias));
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Set the certificates alias to " + newAlias);
                                }
                                cs.setAttributes(session, certObj, newSettings);
                            }
                        }
                    }
                    if ((currentLocale = this.getLocale()) == null) {
                        currentLocale = Locale.getDefault();
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "locale is null, use system locale:" + currentLocale);
                        }
                    }
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.renewed.CWPKI0704I", new Object[]{certAlias, info.getName()}, "Personal certificate with alias \"" + certAlias + "\" in KeyStore \"" + info.getName() + "\" was RENEWED.", currentLocale);
                    rResult.append(System.getProperty("line.separator"));
                    rResult.append(msg);
                    if (info.getFileBased().booleanValue()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "info.getLocation: " + info.getLocation());
                        }
                        PersonalCertificateHelper.setWorkspaceUpdated(session, info.getLocation());
                    }
                    break block30;
                }
                String msg = "Certificate not found in keyStore.";
                throw new KeyStoreException(msg);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "personalCertificateRenew");
        }
        return rResult.toString();
    }
}

