/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.audit.certificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.audit.certificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class DeleteAuditCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteAuditCertificate.class, "SSL", "com.ibm.ws.ssl.commands.personalCertificates");
    private String keyStoreName = null;
    private String certAlias = null;
    private String keyStoreScope = null;
    private KeyStoreInfo ksInfo = null;
    private KeyStoreInfo deletedKsInfo = null;

    public DeleteAuditCertificate(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public DeleteAuditCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certAlias = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyStoreScope=" + this.keyStoreScope + " certAlias=" + this.certAlias);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultScope();
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
            this.deletedKsInfo = commandHelper.getDeletedKeyStore(session, cs, this.keyStoreName);
            if (this.ksInfo.getName().endsWith("DefaultRootStore") && this.isLastCert(session, cs, this.ksInfo)) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.last.cert.CWPKI0707E", new Object[]{this.ksInfo.getName()}, "Can not remove the last certificate form " + this.ksInfo.getName() + ".");
                throw new CommandValidationException(msg);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.DeleteCAClient.validate", "118", this);
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    private boolean isLastCert(Session session, ConfigService cs, KeyStoreInfo info) throws Exception {
        boolean isLastCert = false;
        int keyEntry = 0;
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
        String method2 = "aliases";
        Object[] parms = null;
        Object[] aliases = wsksr.invokeKeyStoreCommand(method2, parms);
        if (aliases != null) {
            for (int i = 0; i < aliases.length; ++i) {
                String alias = (String)aliases[i];
                method2 = "isKeyEntry";
                parms = new Object[]{alias};
                Object[] isKeyEntry = wsksr.invokeKeyStoreCommand(method2, parms);
                if (!((Boolean)isKeyEntry[0]).booleanValue()) continue;
                ++keyEntry;
            }
        }
        if (keyEntry == 1) {
            isLastCert = true;
        }
        return isLastCert;
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            this.certificateDelete(this.ksInfo, this.deletedKsInfo, this.certAlias);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.DeleteCertificate.validate", "%c%", this);
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public void certificateDelete(KeyStoreInfo info, KeyStoreInfo deletedInfo, String alias) throws Exception {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "certificateDelete");
            }
            WSKeyStoreRemotable wsksrDeleted = null;
            WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
            if (deletedInfo != null && !deletedInfo.getReadOnly().booleanValue()) {
                wsksrDeleted = new WSKeyStoreRemotable(deletedInfo);
            }
            try {
                String method2 = "containsAlias";
                Object[] parms = new Object[]{alias};
                Object[] exists = wsksr.invokeKeyStoreCommand(method2, parms);
                method2 = "isKeyEntry";
                parms = new Object[]{alias};
                Object[] isKeyEntry = wsksr.invokeKeyStoreCommand(method2, parms);
                if (((Boolean)exists[0]).booleanValue() && ((Boolean)isKeyEntry[0]).booleanValue()) {
                    Session session = this.getConfigSession();
                    method2 = "getCertificate";
                    parms = new Object[]{alias};
                    Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
                    X509Certificate cert = (X509Certificate)certArray[0];
                    if (CertificateRequestHelper.isKeyCertReq(cert, alias) == null) {
                        if (wsksrDeleted != null && !deletedInfo.getType().equals("JCERACFKS") && !deletedInfo.getType().equals("JCECCARACFKS")) {
                            method2 = "getCertificateChain";
                            parms = new Object[]{alias};
                            Object[] certChain = wsksr.invokeKeyStoreCommand(method2, parms);
                            method2 = "getKey";
                            parms = new Object[]{alias, info.getPassword().toCharArray()};
                            Object[] key = wsksr.invokeKeyStoreCommand(method2, parms);
                            String deletedAlias = info.getName() + "_" + alias;
                            method2 = "setKeyEntry";
                            parms = new Object[]{deletedAlias, (Key)key[0], deletedInfo.getPassword() != null ? deletedInfo.getPassword().toCharArray() : null, (Certificate[])certChain[0]};
                            wsksrDeleted.invokeKeyStoreCommand(method2, parms);
                            PersonalCertificateHelper.setWorkspaceUpdated(session, deletedInfo.getLocation());
                        }
                        method2 = "deleteEntry";
                        parms = new Object[]{alias};
                        wsksr.invokeKeyStoreCommand(method2, parms);
                    }
                    PersonalCertificateHelper.handleCACertReference(session, info, alias);
                    if (this.ksInfo.getFileBased().booleanValue()) {
                        PersonalCertificateHelper.setWorkspaceUpdated(session, info.getLocation());
                    }
                    break block9;
                }
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.no.cert.CWPKI0696E", new Object[]{alias}, "Certificate alias " + alias + " either does not exist of is not a personal certificate.");
                throw new CommandValidationException(msg);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.DeleteCertificate", "267", this);
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "certificateDelete");
        }
    }
}

