/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.security.Result;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.wim.registry.util.UserRegistryValidator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ValidateAdminName
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ValidateAdminName.class, "ValidateAdminName", "com.ibm.ws.security.admintask");
    private String adminUser = null;
    private String registryType = null;
    private String ldapServerType = null;
    ConfigService cs = null;
    Session session = null;
    static final String ldapUR = "LDAPUserRegistry";
    static final String wimUR = "WIMUserRegistry";
    static final String customUR = "CustomUserRegistry";
    static final String localOSUR = "LocalOSUserRegistry";
    static String ldapPropsFile = "/com/ibm/websphere/security/ldap/LdapConfig.properties";

    public ValidateAdminName(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ValidateAdminName(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public boolean validUserRegType(String userRegType) {
        return userRegType.equalsIgnoreCase(ldapUR) || userRegType.equalsIgnoreCase(wimUR) || userRegType.equalsIgnoreCase(customUR) || userRegType.equalsIgnoreCase(localOSUR);
    }

    public boolean validLdapServerType(String ldapServerType) {
        return ldapServerType.equalsIgnoreCase("IBM_DIRECTORY_SERVER") || ldapServerType.equalsIgnoreCase("IPLANET") || ldapServerType.equalsIgnoreCase("NETSCAPE") || ldapServerType.equalsIgnoreCase("NDS") || ldapServerType.equalsIgnoreCase("DOMINO502") || ldapServerType.equalsIgnoreCase("SECUREWAY") || ldapServerType.equalsIgnoreCase("ACTIVE_DIRECTORY") || ldapServerType.equalsIgnoreCase("CUSTOM");
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.adminUser = (String)this.getParameter("adminUser");
        this.registryType = (String)this.getParameter("registryType");
        if (!this.validUserRegType(this.registryType)) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidUserRegType", null);
            throw new CommandValidationException(msg);
        }
        this.ldapServerType = (String)this.getParameter("ldapServerType");
        if (this.ldapServerType != null && !this.validLdapServerType(this.ldapServerType)) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidLDAPServerType", null);
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        block98: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "afterStepsExecuted");
            }
            super.afterStepsExecuted();
            TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
            if (!result.isSuccessful()) {
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "unsuccessful at getting TaskCommandResultImpl afterStepsExecuted");
                }
                return;
            }
            ObjectName security2 = null;
            try {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
                ConfigService cs = ConfigServiceFactory.getConfigService();
                this.session = this.getConfigSession();
                ObjectName cellName = cs.resolve(this.session, "Cell=")[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cell = " + cellName.toString());
                }
                if (cellName != null) {
                    security2 = cs.queryConfigObjects(this.session, cellName, pattern, null)[0];
                }
                ObjectName[] matches = null;
                ArrayList urs = (ArrayList)cs.getAttribute(this.session, security2, "userRegistries");
                for (int i = 0; i < urs.size(); ++i) {
                    AttributeList urAttrs = (AttributeList)urs.get(i);
                    Object urObj = ConfigServiceHelper.getAttributeValue(urAttrs, "_Websphere_Config_Data_Type");
                    if (!urObj.toString().equals(this.registryType)) continue;
                    matches = cs.queryConfigObjects(this.session, null, ConfigServiceHelper.createObjectName(urAttrs), null);
                }
                ArrayList<String> cNameProps = new ArrayList<String>();
                ArrayList<String> cValueProps = new ArrayList<String>();
                Properties userRegProps = new Properties();
                AttributeList regAttrs = cs.getAttributes(this.session, (ObjectName)matches[0], null, true);
                for (int i = 0; i < regAttrs.size(); ++i) {
                    Attribute a = (Attribute)regAttrs.get(i);
                    if (a.getValue() == null) continue;
                    if (tc.isDebugEnabled()) {
                        String name = a.getName();
                        Tr.debug(tc, "name[" + i + "]:  " + name);
                        if (name.indexOf("Password") != -1 || name.indexOf("password") != -1) {
                            Tr.debug(tc, "value[" + i + "]: " + "XXXXXX");
                        } else {
                            Tr.debug(tc, "value[" + i + "]: " + a.getValue().toString());
                        }
                    }
                    if (a.getName().equals("properties")) {
                        ArrayList customPropsArray = (ArrayList)cs.getAttribute(this.session, matches[0], "properties");
                        for (int ii = 0; ii < customPropsArray.size(); ++ii) {
                            AttributeList customAttrs = (AttributeList)customPropsArray.get(ii);
                            for (int j = 0; j < customAttrs.size(); ++j) {
                                Attribute c = (Attribute)customAttrs.get(j);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "c = " + c.toString());
                                }
                                if (c.getValue() == null) continue;
                                if (c.getName().equals("name")) {
                                    cNameProps.add(c.getValue().toString());
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "cNameProps:add: " + c.getValue().toString());
                                    continue;
                                }
                                if (!c.getName().equals("value")) continue;
                                cValueProps.add(c.getValue().toString());
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "cValueProps:add: " + c.getValue().toString());
                            }
                        }
                    }
                    userRegProps.setProperty(a.getName(), a.getValue().toString());
                }
                String[] hostProps = new String[10];
                String[] portProps = new String[10];
                Properties searchProps = new Properties();
                if (this.registryType.equals(ldapUR)) {
                    int hostIndex = 0;
                    int portIndex = 0;
                    ArrayList hosts = (ArrayList)cs.getAttribute(this.session, matches[0], "hosts");
                    for (int i = 0; i < hosts.size(); ++i) {
                        AttributeList hostAttrs = (AttributeList)hosts.get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, " hostAttrs.size = " + hostAttrs.size());
                        }
                        for (int j = 0; j < hostAttrs.size(); ++j) {
                            Attribute h = (Attribute)hostAttrs.get(j);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "h = " + h.toString());
                            }
                            if (h.getValue() == null) continue;
                            if (h.getName().equals("host")) {
                                hostProps[hostIndex++] = h.getValue().toString();
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "host[" + (hostIndex - 1) + "]: " + h.getValue().toString());
                                continue;
                            }
                            if (!h.getName().equals("port")) continue;
                            portProps[portIndex++] = h.getValue().toString();
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "port[" + (portIndex - 1) + "]: " + h.getValue().toString());
                        }
                    }
                    ArrayList searchFilters = (ArrayList)cs.getAttribute(this.session, matches[0], "searchFilter");
                    for (int i = 0; i < searchFilters.size(); ++i) {
                        Attribute sa = (Attribute)searchFilters.get(i);
                        if (sa.getValue() == null) continue;
                        searchProps.setProperty(sa.getName(), sa.getValue().toString());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "name[" + i + "]:  " + sa.getName());
                        Tr.debug(tc, "value[" + i + "]: " + sa.getValue().toString());
                    }
                }
                Properties props = null;
                if (this.registryType.equals(wimUR)) {
                    String className = userRegProps.getProperty("registryClassName");
                    props = new Properties();
                    props.setProperty("CustUserRegImplClass", className);
                } else if (this.registryType.equals(customUR)) {
                    String className = userRegProps.getProperty("customRegistryClassName");
                    props = new Properties();
                    props.setProperty("CustUserRegImplClass", className);
                    for (int i = 0; i < cNameProps.size(); ++i) {
                        props.put((String)cNameProps.get(i), (String)cValueProps.get(i));
                    }
                } else if (this.registryType.equals(ldapUR)) {
                    props = new Properties();
                    props.setProperty("security.registry.ldap.searchTimeLimit", userRegProps.getProperty("searchTimeout"));
                    props.setProperty("LDAP.server.pwd", userRegProps.getProperty("serverPassword"));
                    props.setProperty("com.ibm.ssl.remotePort", portProps[0]);
                    props.setProperty("com.ibm.ssl.remoteHost", hostProps[0]);
                    if (this.ldapServerType != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ldapServerType = " + this.ldapServerType);
                        }
                        Properties ldapProps = null;
                        try {
                            InputStream is = this.getClass().getResourceAsStream(ldapPropsFile);
                            ldapProps = new Properties();
                            ldapProps.load(is);
                        }
                        catch (IOException e) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "IOException opening ldapPropsFile");
                            }
                            e.printStackTrace();
                            result.setResult(new Boolean(false));
                            String msg = this.getMsg(resBundle, "security.admintask.ExceptionValidAdminName", null);
                            result.setException(new CommandException(e, msg));
                            return;
                        }
                        if (ldapProps != null) {
                            int ldapServerTypeValue = 0;
                            if (this.ldapServerType.equalsIgnoreCase("IBM_DIRECTORY_SERVER")) {
                                ldapServerTypeValue = 0;
                            } else if (this.ldapServerType.equalsIgnoreCase("SECUREWAY")) {
                                ldapServerTypeValue = 1;
                            } else if (this.ldapServerType.equalsIgnoreCase("IPLANET")) {
                                ldapServerTypeValue = 2;
                            } else if (this.ldapServerType.equalsIgnoreCase("NETSCAPE")) {
                                ldapServerTypeValue = 3;
                            } else if (this.ldapServerType.equalsIgnoreCase("DOMINO502")) {
                                ldapServerTypeValue = 4;
                            } else if (this.ldapServerType.equalsIgnoreCase("NDS")) {
                                ldapServerTypeValue = 5;
                            } else if (this.ldapServerType.equalsIgnoreCase("ACTIVE_DIRECTORY")) {
                                ldapServerTypeValue = 6;
                            } else if (this.ldapServerType.equalsIgnoreCase("CUSTOM")) {
                                ldapServerTypeValue = 7;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "ldapServerTypeValue = " + ldapServerTypeValue);
                            }
                            switch (ldapServerTypeValue) {
                                case 0: {
                                    props.setProperty("user.filter", ldapProps.getProperty("ibm_dir_server.user.filter"));
                                    props.setProperty("group.filter", ldapProps.getProperty("ibm_dir_server.group.filter"));
                                    props.setProperty("user.idmap", ldapProps.getProperty("ibm_dir_server.user.idmap"));
                                    props.setProperty("group.idmap", ldapProps.getProperty("ibm_dir_server.group.idmap"));
                                    props.setProperty("groupmember.idmap", ldapProps.getProperty("ibm_dir_server.groupmember.idmap"));
                                    break;
                                }
                                case 1: {
                                    props.setProperty("user.filter", ldapProps.getProperty("secureway.user.filter"));
                                    props.setProperty("group.filter", ldapProps.getProperty("secureway.group.filter"));
                                    props.setProperty("user.idmap", ldapProps.getProperty("secureway.user.idmap"));
                                    props.setProperty("group.idmap", ldapProps.getProperty("secureway.group.idmap"));
                                    props.setProperty("groupmember.idmap", ldapProps.getProperty("secureway.groupmember.idmap"));
                                    break;
                                }
                                case 2: {
                                    props.setProperty("user.filter", ldapProps.getProperty("iplanet.user.filter"));
                                    props.setProperty("group.filter", ldapProps.getProperty("iplanet.group.filter"));
                                    props.setProperty("user.idmap", ldapProps.getProperty("iplanet.user.idmap"));
                                    props.setProperty("group.idmap", ldapProps.getProperty("iplanet.group.idmap"));
                                    props.setProperty("groupmember.idmap", ldapProps.getProperty("iplanet.groupmember.idmap"));
                                    break;
                                }
                                case 3: {
                                    props.setProperty("user.filter", ldapProps.getProperty("netscape.user.filter"));
                                    props.setProperty("group.filter", ldapProps.getProperty("netscape.group.filter"));
                                    props.setProperty("user.idmap", ldapProps.getProperty("netscape.user.idmap"));
                                    props.setProperty("group.idmap", ldapProps.getProperty("netscape.group.idmap"));
                                    props.setProperty("groupmember.idmap", ldapProps.getProperty("netscape.groupmember.idmap"));
                                    break;
                                }
                                case 4: {
                                    props.setProperty("user.filter", ldapProps.getProperty("domino50.user.filter"));
                                    props.setProperty("group.filter", ldapProps.getProperty("domino50.group.filter"));
                                    props.setProperty("user.idmap", ldapProps.getProperty("domino50.user.idmap"));
                                    props.setProperty("group.idmap", ldapProps.getProperty("domino50.group.idmap"));
                                    props.setProperty("groupmember.idmap", ldapProps.getProperty("domino50.groupmember.idmap"));
                                    break;
                                }
                                case 6: {
                                    props.setProperty("user.filter", ldapProps.getProperty("actived.user.filter"));
                                    props.setProperty("group.filter", ldapProps.getProperty("actived.group.filter"));
                                    props.setProperty("user.idmap", ldapProps.getProperty("actived.user.idmap"));
                                    props.setProperty("group.idmap", ldapProps.getProperty("actived.group.idmap"));
                                    props.setProperty("groupmember.idmap", ldapProps.getProperty("actived.groupmember.idmap"));
                                    break;
                                }
                                case 5: {
                                    props.setProperty("user.filter", ldapProps.getProperty("edirectory.user.filter"));
                                    props.setProperty("group.filter", ldapProps.getProperty("edirectory.group.filter"));
                                    props.setProperty("user.idmap", ldapProps.getProperty("edirectory.user.idmap"));
                                    props.setProperty("group.idmap", ldapProps.getProperty("edirectory.group.idmap"));
                                    props.setProperty("groupmember.idmap", ldapProps.getProperty("edirectory.groupmember.idmap"));
                                    break;
                                }
                            }
                        }
                    } else {
                        props.setProperty("groupmember.idmap", searchProps.getProperty("groupMemberIdMap"));
                        props.setProperty("user.filter", searchProps.getProperty("userFilter"));
                        props.setProperty("group.idmap", searchProps.getProperty("groupIdMap"));
                        props.setProperty("group.filter", searchProps.getProperty("groupFilter"));
                        props.setProperty("user.idmap", searchProps.getProperty("userIdMap"));
                    }
                    props.setProperty("security.registry.ldap.reuseConn", userRegProps.getProperty("reuseConnection"));
                    props.setProperty("dirType", userRegProps.getProperty("type"));
                    if (userRegProps.getProperty("sslEnabled").equals("true")) {
                        props.put("sslEnabled", Boolean.TRUE);
                        String sslConf = userRegProps.getProperty("sslConfig");
                        if (sslConf != null) {
                            props.put("LDAP.validation", "true");
                            props.put("security.registry.ldap.SSLAlias", sslConf);
                        }
                    } else {
                        props.put("sslEnabled", Boolean.FALSE);
                    }
                    props.setProperty("ldap.basedn", userRegProps.getProperty("baseDN"));
                    if (userRegProps.getProperty("bindDN") != null && userRegProps.getProperty("bindDN").length() > 0) {
                        props.setProperty("java.naming.security.principal", userRegProps.getProperty("bindDN"));
                    }
                    if (userRegProps.getProperty("bindPassword") != null && userRegProps.getProperty("bindPassword").length() > 0) {
                        props.setProperty("java.naming.security.credentials", userRegProps.getProperty("bindPassword"));
                    }
                    props.setProperty("LDAP.server.id", userRegProps.getProperty("serverId"));
                    props.setProperty("LDAP.server.realm", userRegProps.getProperty("realm"));
                    props.setProperty("CustUserRegImplClass", "com.ibm.ws.security.registry.ldap.LdapRegistryImpl");
                    if (searchProps.getProperty("certificateMapMode").equals("EXACT_DN")) {
                        props.setProperty("certificate.map.mode", "exactDNMode");
                    } else if (searchProps.getProperty("certificateMapMode").equals("CERTIFICATE_FILTER")) {
                        props.setProperty("certificate.map.mode", "filterDescriptorMode");
                    } else {
                        props.setProperty("certificate.map.mode", searchProps.getProperty("certificateMapMode"));
                    }
                    String ldapProtocol = "ldap://";
                    StringBuffer ldapUrl = new StringBuffer();
                    Integer portN = new Integer(389);
                    if (portProps[0] != null) {
                        portN = new Integer(portProps[0]);
                    }
                    if (hostProps[0].indexOf(":") != -1) {
                        ldapUrl.append(ldapProtocol).append("[" + hostProps[0] + "]");
                    } else {
                        ldapUrl.append(ldapProtocol).append(hostProps[0]);
                    }
                    if (portN != null && portN > 0) {
                        ldapUrl.append(":" + portN);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ldapUrl = " + ldapUrl.toString());
                    }
                    props.setProperty("java.naming.provider.url", ldapUrl.toString());
                } else if (this.registryType.equals(localOSUR)) {
                    props = new Properties();
                    props.setProperty("security.activeUserRegistryType", "LOCALOS");
                    for (int i = 0; i < cNameProps.size(); ++i) {
                        props.put((String)cNameProps.get(i), (String)cValueProps.get(i));
                    }
                    Tr.debug(tc, "local properties = " + props);
                }
                if (props != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "props = " + props.toString());
                }
                if (this.registryType.equals(wimUR)) {
                    try {
                        UserRegistryValidator urV;
                        Result userResult;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "sessionId = " + this.session.toString());
                        }
                        if ((userResult = (urV = new UserRegistryValidator(this.session.toString())).getUsers(this.adminUser, 100)).getList().isEmpty()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "user " + this.adminUser + " not found in WIM UR");
                            }
                            result.setResult(new Boolean(false));
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "user " + this.adminUser + " found in WIM UR");
                            }
                            result.setResult(new Boolean(true));
                        }
                        break block98;
                    }
                    catch (Exception we) {
                        we.printStackTrace();
                        result.setResult(new Boolean(false));
                        String msg = this.getMsg(resBundle, "security.admintask.ExceptionValidAdminName", null);
                        result.setException(new CommandException(we, msg));
                        return;
                    }
                }
                result.setResult(new Boolean(true));
                int count = 0;
                String method2 = "getUsers";
                try {
                    String processName = AdminServiceFactory.getAdminService().getProcessName();
                    ObjectName on = new ObjectName("WebSphere:type=SecurityAdmin,process=" + processName + ",*");
                    Iterator it = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
                    if (!it.hasNext()) {
                        result.setResult(new Boolean(false));
                        return;
                    }
                    on = (ObjectName)it.next();
                    Result results = (Result)AdminServiceFactory.getAdminService().invoke(on, method2, new Object[]{this.adminUser, new Integer(100), props}, new String[]{"java.lang.String", "java.lang.Integer", "java.util.Properties"});
                    if (results != null && results.getList() != null) {
                        count = results.getList().size();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "count = " + count);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "results or results.getList() was null");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    result.setResult(new Boolean(false));
                    String msg = this.getMsg(resBundle, "security.admintask.ExceptionValidAdminName", null);
                    result.setException(new CommandException(ex, msg));
                    return;
                }
                if (count == 0) {
                    result.setResult(new Boolean(false));
                } else {
                    result.setResult(new Boolean(true));
                }
            }
            catch (Exception e) {
                result.setResult(new Boolean(false));
                String msg = this.getMsg(resBundle, "security.admintask.ExceptionValidAdminName", null);
                result.setException(new CommandException(e, msg));
                return;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

