/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class SetGlobalSecurity
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(SetGlobalSecurity.class, "SetGlobalSecurity", "com.ibm.ws.security.admintasks");
    Boolean globalSecEnabled = new Boolean(false);

    public SetGlobalSecurity(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public SetGlobalSecurity(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.globalSecEnabled = (Boolean)this.getParameter("enabled");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        String cellNameQualifier = "_Websphere_Config_Data_Display_Name";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session s = this.getConfigSession();
            ObjectName cellName = cs.resolve(s, "Cell=")[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell = " + cellName.toString());
            }
            if (cellName != null) {
                security2 = cs.queryConfigObjects(s, cellName, pattern, null)[0];
            }
            AttributeList attrList = new AttributeList();
            attrList.add(new Attribute("enabled", this.globalSecEnabled));
            cs.setAttributes(s, security2, attrList);
            result.setResult(new Boolean(true));
        }
        catch (Throwable th) {
            String msg = this.getMsg(resBundle, "security.admintask.ExceptionSetGlobalSec", null);
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

