/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class IsAppSecurityEnabled
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(IsAppSecurityEnabled.class, "IsAppSecurityEnabled", "com.ibm.ws.security.admintasks");
    final String isEnabledKey = "isEnabled";

    public IsAppSecurityEnabled(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public IsAppSecurityEnabled(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        String cellNameQualifier = "_Websphere_Config_Data_Display_Name";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session s = this.getConfigSession();
            ObjectName cellName = cs.resolve(s, "Cell=")[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell = " + cellName.toString());
            }
            if (cellName != null) {
                security2 = cs.queryConfigObjects(s, cellName, pattern, null)[0];
            }
            int index1 = cellName.toString().indexOf("_Websphere_Config_Data_Display_Name");
            String subStr = cellName.toString().substring(index1);
            int index2 = subStr.indexOf(",");
            subStr = subStr.substring(0, index2);
            int index3 = subStr.indexOf("=");
            subStr = subStr.substring(index3 + 1);
            WorkSpace ws = WorkspaceHelper.getWorkspace((Session)s);
            RepositoryContext cellC = AppUtils.findContext("cells", subStr, null, null, ws, true);
            URI uri = URI.createURI("security.xml");
            Resource res = cellC.getResourceSet().getResource(uri, true);
            Security contents = (Security)res.getContents().get(0);
            boolean isEnabled = contents.isAppEnabled();
            if (isEnabled) {
                result.setResult(new Boolean(true));
            } else {
                result.setResult(new Boolean(false));
            }
        }
        catch (Throwable th) {
            String msg = this.getMsg(resBundle, "security.admintask.ExceptionIsAppSecEnabled", null);
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

