/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.security.Result;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.wim.registry.util.UserRegistryValidator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ApplyWizardSettings
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ApplyWizardSettings.class, "ApplyWizardSettings", "com.ibm.ws.security.admintasks");
    Boolean secureAdmin = new Boolean(true);
    Boolean secureApps = new Boolean(false);
    Boolean secureLocalResources = new Boolean(false);
    String defaultPort = "389";
    String ltpaPassword = null;
    String userRegistryType = null;
    String customRegistryClass = null;
    String[] customPropName = new String[10];
    String[] customPropValue = new String[10];
    String[] customPropReq = new String[10];
    int numberCustomProps = 0;
    String ldapServerType = null;
    String ldapHostName = null;
    String ldapPort = null;
    String ldapBaseDN = null;
    String ldapBindDN = null;
    String ldapBindPassword = null;
    String adminName = null;
    String adminPassword = null;
    Boolean ignoreCase = null;
    static final String ldapUR = "LDAPUserRegistry";
    static final String wimUR = "WIMUserRegistry";
    static final String customUR = "CustomUserRegistry";
    static final String localOSUR = "LocalOSUserRegistry";
    static String ldapPropsFile = "/com/ibm/websphere/security/ldap/LdapConfig.properties";

    public ApplyWizardSettings(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ApplyWizardSettings(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public boolean validUserRegType(String userRegType) {
        return userRegType.equalsIgnoreCase(ldapUR) || userRegType.equalsIgnoreCase(wimUR) || userRegType.equalsIgnoreCase(customUR) || userRegType.equalsIgnoreCase(localOSUR);
    }

    public boolean validLdapServerType(String ldapServerType) {
        return ldapServerType.equalsIgnoreCase("IBM_DIRECTORY_SERVER") || ldapServerType.equalsIgnoreCase("IPLANET") || ldapServerType.equalsIgnoreCase("NETSCAPE") || ldapServerType.equalsIgnoreCase("NDS") || ldapServerType.equalsIgnoreCase("DOMINO502") || ldapServerType.equalsIgnoreCase("SECUREWAY") || ldapServerType.equalsIgnoreCase("ACTIVE_DIRECTORY") || ldapServerType.equalsIgnoreCase("CUSTOM");
    }

    public boolean validateNoOtherWIMFlavorsExist() {
        block8: {
            try {
                ConfigService cs = ConfigServiceFactory.getConfigService();
                Session s = this.getConfigSession();
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                AdminCommand getUserCmd = commandMgr.createCommand("getIdMgrDefaultRealm");
                getUserCmd.setConfigSession(s);
                getUserCmd.execute();
                CommandResult cmdResult = getUserCmd.getCommandResult();
                if (cmdResult.isSuccessful()) {
                    if (cmdResult.getResult() != null) {
                        String realmName = cmdResult.getResult().toString();
                        getUserCmd = commandMgr.createCommand("getIdMgrRepositoriesForRealm");
                        getUserCmd.setParameter("name", realmName);
                        getUserCmd.setConfigSession(s);
                        getUserCmd.execute();
                        cmdResult = getUserCmd.getCommandResult();
                        if (cmdResult.isSuccessful()) {
                            List listIds = (List)cmdResult.getResult();
                            if (listIds.size() != 1) {
                                return false;
                            }
                            Object o = listIds.get(0);
                            if (o.toString().indexOf("InternalFileRepository") == -1) {
                                return false;
                            }
                        }
                    }
                    break block8;
                }
                return false;
            }
            catch (Throwable th) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, th.toString());
                    Tr.debug(tc, th.getMessage());
                }
                return false;
            }
        }
        return true;
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        this.secureApps = (Boolean)this.getParameter("secureApps");
        this.secureLocalResources = (Boolean)this.getParameter("secureLocalResources");
        this.userRegistryType = (String)this.getParameter("userRegistryType");
        if (!this.validUserRegType(this.userRegistryType)) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidUserRegType", null);
            throw new CommandValidationException(msg);
        }
        if (this.userRegistryType.equals(wimUR) && !this.validateNoOtherWIMFlavorsExist()) {
            String msg = this.getMsg(resBundle, "security.admintask.FoundOtherWIMFlavors", null);
            throw new CommandValidationException(msg);
        }
        this.customRegistryClass = (String)this.getParameter("customRegistryClass");
        String customProps = (String)this.getParameter("customProps");
        if (customProps != null) {
            StringTokenizer st = new StringTokenizer(customProps, ";= ");
            int index = 0;
            while (st.hasMoreTokens()) {
                this.customPropName[index] = st.nextToken();
                this.customPropValue[index] = st.nextToken();
                ++index;
            }
            this.numberCustomProps = index;
            if (tc.isDebugEnabled()) {
                for (int i = 0; i < index; ++i) {
                    Tr.debug(tc, "customPropName[" + i + "] = " + this.customPropName[i]);
                    Tr.debug(tc, "customPropValue[" + i + "] = " + this.customPropValue[i]);
                }
            }
        }
        this.ldapServerType = (String)this.getParameter("ldapServerType");
        if (this.ldapServerType != null && !this.validLdapServerType(this.ldapServerType)) {
            String msg = this.getMsg(resBundle, "security.admintask.InvalidLDAPServerType", null);
            throw new CommandValidationException(msg);
        }
        this.ldapHostName = (String)this.getParameter("ldapHostName");
        this.ldapPort = (String)this.getParameter("ldapPort");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "port=begin" + this.ldapPort + "end");
        }
        if (this.ldapPort == null || this.ldapPort == "" || this.ldapPort.length() == 0) {
            this.ldapPort = this.defaultPort;
        }
        this.ldapBaseDN = (String)this.getParameter("ldapBaseDN");
        this.ldapBindDN = (String)this.getParameter("ldapBindDN");
        this.ldapBindPassword = (String)this.getParameter("ldapBindPassword");
        this.adminName = (String)this.getParameter("adminName");
        this.adminPassword = (String)this.getParameter("adminPassword");
        this.ignoreCase = (Boolean)this.getParameter("ignoreCase");
        if (this.ignoreCase == null) {
            this.ignoreCase = new Boolean(false);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "secureApps: " + this.secureApps.toString());
            Tr.debug(tc, "secureLocalResources: " + this.secureLocalResources.toString());
            Tr.debug(tc, "userRegistryType: " + this.userRegistryType);
            if (this.customRegistryClass != null) {
                Tr.debug(tc, "customRegistryClass: " + this.customRegistryClass);
            }
            if (this.ldapServerType != null) {
                Tr.debug(tc, "ldapServerType: " + this.ldapServerType);
            }
            if (this.ldapHostName != null) {
                Tr.debug(tc, "ldapHostName: " + this.ldapHostName);
            }
            if (this.ldapPort != null) {
                Tr.debug(tc, "ldapPort: " + this.ldapPort);
            }
            if (this.ldapBaseDN != null) {
                Tr.debug(tc, "ldapBaseDN: " + this.ldapBaseDN);
            }
            if (this.ldapBindDN != null) {
                Tr.debug(tc, "ldapBindDN: " + this.ldapBindDN);
            }
            if (this.ldapBindPassword != null) {
                Tr.debug(tc, "ldapBindPassword: XXXXXXX");
            }
            Tr.debug(tc, "adminName: " + this.adminName);
            if (this.adminPassword != null) {
                Tr.debug(tc, "adminPassword: XXXXXXX");
            }
            if (this.ignoreCase != null && (this.ignoreCase.booleanValue() || !this.ignoreCase.booleanValue())) {
                Tr.debug(tc, "ignoreCase: " + this.ignoreCase.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void afterStepsExecuted() {
        cellNameQualifier = "_Websphere_Config_Data_Display_Name";
        ipcFactory = null;
        propertiesFactory = null;
        if (ApplyWizardSettings.tc.isEntryEnabled()) {
            Tr.entry(ApplyWizardSettings.tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        security = null;
        securityProperties = null;
        result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (ApplyWizardSettings.tc.isDebugEnabled()) {
                Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
            }
            return;
        }
        cs = ConfigServiceFactory.getConfigService();
        s = this.getConfigSession();
        cProps = new Properties();
        try {
            block140: {
                block141: {
                    pattern = ConfigServiceHelper.createObjectName(null, "Security");
                    propertiesPattern = ConfigServiceHelper.createObjectName(null, "properties");
                    cellName = cs.resolve(s, "Cell=")[0];
                    if (ApplyWizardSettings.tc.isDebugEnabled()) {
                        Tr.debug(ApplyWizardSettings.tc, "cell = " + cellName.toString());
                    }
                    if (cellName != null) {
                        security = cs.queryConfigObjects(s, cellName, pattern, null)[0];
                    }
                    if (!this.userRegistryType.equals("LDAPUserRegistry")) break block141;
                    commandMgr = CommandMgr.getCommandMgr();
                    getUserCmd = commandMgr.createCommand("validateLDAPConnection");
                    getUserCmd.setParameter("hostname", this.ldapHostName);
                    getUserCmd.setParameter("port", new Integer(Integer.parseInt(this.ldapPort)));
                    getUserCmd.setParameter("sslEnabled", new Boolean(false));
                    getUserCmd.setParameter("type", this.ldapServerType);
                    getUserCmd.setParameter("baseDN", this.ldapBaseDN);
                    if (this.ldapBindDN != null) {
                        getUserCmd.setParameter("bindDN", this.ldapBindDN);
                    }
                    if (this.ldapBindPassword != null) {
                        getUserCmd.setParameter("bindPassword", this.ldapBindPassword);
                    }
                    getUserCmd.setConfigSession(s);
                    getUserCmd.execute();
                    cmdResult = getUserCmd.getCommandResult();
                    if (!cmdResult.isSuccessful()) ** GOTO lbl54
                    if (((Boolean)cmdResult.getResult()).booleanValue()) {
                        if (ApplyWizardSettings.tc.isDebugEnabled()) {
                            Tr.debug(ApplyWizardSettings.tc, "Successfully connected to LDAP Server");
                        }
                    } else {
                        if (ApplyWizardSettings.tc.isDebugEnabled()) {
                            Tr.debug(ApplyWizardSettings.tc, "Could not successfully connect to LDAP");
                        }
                        msg = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionLDAPConnect", null);
                        result.addWarnings(msg);
                        result.setResult(new Boolean(false));
                        result.setException(new CommandException(msg));
                        if (ApplyWizardSettings.tc.isEntryEnabled()) {
                            Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                        }
                        return;
lbl54:
                        // 1 sources

                        if (ApplyWizardSettings.tc.isDebugEnabled()) {
                            Tr.debug(ApplyWizardSettings.tc, "Could not successfully connect to LDAP");
                        }
                        msg = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionLDAPConnect", null);
                        msg = msg.concat(": ");
                        if (cmdResult.getMessages().size() > 0) {
                            msgs = cmdResult.getMessages().toArray();
                            if (ApplyWizardSettings.tc.isDebugEnabled()) {
                                Tr.debug(ApplyWizardSettings.tc, " msgs size = " + msgs.length);
                            }
                            msg = msg.concat((String)msgs[1]);
                        }
                        result.addWarnings(msg);
                        result.setResult(new Boolean(false));
                        result.setException(new CommandException(msg));
                        if (ApplyWizardSettings.tc.isEntryEnabled()) {
                            Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                        }
                        return;
                    }
                }
                attrLTPAList = new AttributeList();
                attrSecurityList = new AttributeList();
                attrURList = new AttributeList();
                hostAttrs = new AttributeList();
                newPropAttrs = new AttributeList();
                searchFilterAttrList = new AttributeList();
                matchesSearch = null;
                matchesLTPA = null;
                matchesURAttrs = null;
                matchesHosts = null;
                aList = new String[]{"properties"};
                props = new Properties();
                authMech = (ArrayList)cs.getAttribute(s, security, "authMechanisms");
                for (i = 0; i < authMech.size(); ++i) {
                    authAttrs = (AttributeList)authMech.get(i);
                    authObj = ConfigServiceHelper.getAttributeValue(authAttrs, "_Websphere_Config_Data_Type");
                    if (!authObj.toString().equals("LTPA")) continue;
                    attrLTPAList.add(new Attribute("password", this.ltpaPassword));
                    matchesLTPA = cs.queryConfigObjects(s, null, ConfigServiceHelper.createObjectName(authAttrs), null);
                }
                attrSecurityList.add(new Attribute("enabled", this.secureAdmin));
                attrSecurityList.add(new Attribute("appEnabled", this.secureApps));
                attrSecurityList.add(new Attribute("enforceJava2Security", this.secureLocalResources));
                urs = (ArrayList)cs.getAttribute(s, security, "userRegistries");
                for (i = 0; i < urs.size(); ++i) {
                    urAttrs = (AttributeList)urs.get(i);
                    urObj = ConfigServiceHelper.getAttributeValue(urAttrs, "_Websphere_Config_Data_Type");
                    if (!urObj.toString().equals(this.userRegistryType)) continue;
                    matchesURAttrs = cs.queryConfigObjects(s, null, ConfigServiceHelper.createObjectName(urAttrs), null);
                    attrSecurityList.add(new Attribute("activeUserRegistry", matchesURAttrs[0]));
                }
                if (this.userRegistryType.equals("LDAPUserRegistry")) {
                    props.setProperty("security.registry.ldap.reuseConn", "true");
                    props.put("sslEnabled", Boolean.FALSE);
                    props.setProperty("CustUserRegImplClass", "com.ibm.ws.security.registry.ldap.LdapRegistryImpl");
                    props.setProperty("certificate.map.mode", "exactDNMode");
                    ldapProtocol = "ldap://";
                    ldapUrl = new StringBuffer();
                    portN = new Integer(389);
                    if (this.ldapPort != null) {
                        portN = new Integer(this.ldapPort);
                    }
                    if (this.ldapHostName.indexOf(":") != -1) {
                        ldapUrl.append(ldapProtocol).append("[" + this.ldapHostName + "]");
                    } else {
                        ldapUrl.append(ldapProtocol).append(this.ldapHostName);
                    }
                    if (portN != null && portN > 0) {
                        ldapUrl.append(":" + portN);
                    }
                    if (ApplyWizardSettings.tc.isDebugEnabled()) {
                        Tr.debug(ApplyWizardSettings.tc, "ldapUrl = " + ldapUrl.toString());
                    }
                    props.setProperty("java.naming.provider.url", ldapUrl.toString());
                    if (this.ldapServerType != null) {
                        attrURList.add(new Attribute("type", this.ldapServerType));
                        props.setProperty("dirType", this.ldapServerType);
                    }
                    if (this.ldapBaseDN != null) {
                        attrURList.add(new Attribute("baseDN", this.ldapBaseDN));
                        props.setProperty("ldap.basedn", this.ldapBaseDN);
                    }
                    if (this.ldapBindDN != null) {
                        attrURList.add(new Attribute("bindDN", this.ldapBindDN));
                        props.setProperty("java.naming.security.principal", this.ldapBindDN);
                    }
                    if (this.ldapBindPassword != null) {
                        attrURList.add(new Attribute("bindPassword", this.ldapBindPassword));
                        props.setProperty("java.naming.security.credentials", this.ldapBindPassword);
                    }
                    if (this.ldapHostName != null && this.ldapPort != null) {
                        realmName = new String(this.ldapHostName + ":" + this.ldapPort);
                        attrURList.add(new Attribute("realm", realmName));
                        props.setProperty("LDAP.server.realm", realmName);
                        hosts = (ArrayList)cs.getAttribute(s, matchesURAttrs[0], "hosts");
                        for (i = 0; i < hosts.size(); ++i) {
                            hostAttrs = (AttributeList)hosts.get(i);
                            ConfigServiceHelper.setAttributeValue(hostAttrs, "host", this.ldapHostName);
                            ConfigServiceHelper.setAttributeValue(hostAttrs, "port", new Integer(this.ldapPort));
                            matchesHosts = cs.queryConfigObjects(s, null, ConfigServiceHelper.createObjectName(hostAttrs), null);
                        }
                    }
                } else {
                    if (this.userRegistryType.equals("LocalOSUserRegistry")) {
                        props.setProperty("security.activeUserRegistryType", "LOCALOS");
                        try {
                            processName = AdminServiceFactory.getAdminService().getProcessName();
                            objName = new ObjectName("WebSphere:type=SecurityAdmin,process=" + processName + ",*");
                            it = AdminServiceFactory.getAdminService().queryNames(objName, null).iterator();
                            if (!it.hasNext()) {
                                Tr.error(ApplyWizardSettings.tc, "security.ctr.nombean.error");
                                msg = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionProcessingWizardSettings", null);
                                result.addWarnings(msg);
                                result.setResult(new Boolean(false));
                                result.setException(new CommandException(msg));
                                if (ApplyWizardSettings.tc.isEntryEnabled()) {
                                    Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                                }
                                return;
                            }
                            objName = (ObjectName)it.next();
                            retValue = (String)AdminServiceFactory.getAdminService().invoke(objName, "getRealm", new Object[]{props}, new String[]{"java.util.Properties"});
                            attrURList.add(new Attribute("realm", retValue));
                        }
                        catch (Exception ex) {
                            Tr.error(ApplyWizardSettings.tc, "security.ctr.mbean.exception", new Object[]{ex});
                            msg = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionProcessingWizardSettings", null);
                            result.addWarnings(msg);
                            result.setResult(new Boolean(false));
                            result.setException(new CommandException(msg));
                            if (ApplyWizardSettings.tc.isEntryEnabled()) {
                                Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                            }
                            return;
                        }
                    }
                    if (this.userRegistryType.equals("WIMUserRegistry")) {
                        attrURList.add(new Attribute("realm", "defaultWIMFileBasedRealm"));
                    } else if (this.userRegistryType.equals("CustomUserRegistry")) {
                        if (this.customRegistryClass != null) {
                            attrURList.add(new Attribute("customRegistryClassName", this.customRegistryClass));
                        }
                        try {
                            processName = AdminServiceFactory.getAdminService().getProcessName();
                            objName = new ObjectName("WebSphere:type=SecurityAdmin,process=" + processName + ",*");
                            it = AdminServiceFactory.getAdminService().queryNames(objName, null).iterator();
                            if (!it.hasNext()) {
                                Tr.error(ApplyWizardSettings.tc, "security.ctr.nombean.error");
                                msg = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionProcessingWizardSettings", null);
                                result.addWarnings(msg);
                                result.setResult(new Boolean(false));
                                result.setException(new CommandException(msg));
                                if (ApplyWizardSettings.tc.isEntryEnabled()) {
                                    Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                                }
                                return;
                            }
                            objName = (ObjectName)it.next();
                            retValue = (String)AdminServiceFactory.getAdminService().invoke(objName, "getRealm", new Object[]{cProps}, new String[]{"java.util.Properties"});
                            attrURList.add(new Attribute("realm", retValue));
                            if (ApplyWizardSettings.tc.isDebugEnabled()) {
                                Tr.debug(ApplyWizardSettings.tc, "realm = " + retValue);
                            }
                        }
                        catch (Exception ex) {
                            Tr.error(ApplyWizardSettings.tc, "security.ctr.mbean.exception", new Object[]{ex});
                            msg = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionProcessingWizardSettings", null);
                            result.addWarnings(msg);
                            result.setResult(new Boolean(false));
                            result.setException(new CommandException(msg));
                            if (ApplyWizardSettings.tc.isEntryEnabled()) {
                                Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                            }
                            return;
                        }
                        attrURList.add(new Attribute("ignoreCase", this.ignoreCase));
                    }
                }
                if (this.userRegistryType.equals("LDAPUserRegistry")) {
                    searchFilterAttrList = (AttributeList)cs.getAttribute(s, matchesURAttrs[0], "searchFilter");
                    if (ApplyWizardSettings.tc.isDebugEnabled()) {
                        Tr.debug(ApplyWizardSettings.tc, "searchFilterAttrList = " + searchFilterAttrList.toString());
                    }
                    ldapProps = null;
                    try {
                        is = this.getClass().getResourceAsStream(ApplyWizardSettings.ldapPropsFile);
                        ldapProps = new Properties();
                        ldapProps.load(is);
                    }
                    catch (IOException e) {
                        if (ApplyWizardSettings.tc.isDebugEnabled()) {
                            Tr.debug(ApplyWizardSettings.tc, "IOException opening ldapPropsFile");
                        }
                        e.printStackTrace();
                        result.setResult(new Boolean(false));
                        msg = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionProcessingWizardSettings", null);
                        result.setException(new CommandException(e, msg));
                        return;
                    }
                    if (ldapProps != null) {
                        ldapServerTypeValue = 0;
                        if (this.ldapServerType.equalsIgnoreCase("IBM_DIRECTORY_SERVER")) {
                            ldapServerTypeValue = 0;
                        } else if (this.ldapServerType.equalsIgnoreCase("SECUREWAY")) {
                            ldapServerTypeValue = 1;
                        } else if (this.ldapServerType.equalsIgnoreCase("IPLANET")) {
                            ldapServerTypeValue = 2;
                        } else if (this.ldapServerType.equalsIgnoreCase("NETSCAPE")) {
                            ldapServerTypeValue = 3;
                        } else if (this.ldapServerType.equalsIgnoreCase("DOMINO502")) {
                            ldapServerTypeValue = 4;
                        } else if (this.ldapServerType.equalsIgnoreCase("NDS")) {
                            ldapServerTypeValue = 5;
                        } else if (this.ldapServerType.equalsIgnoreCase("ACTIVE_DIRECTORY")) {
                            ldapServerTypeValue = 6;
                        } else if (this.ldapServerType.equalsIgnoreCase("CUSTOM")) {
                            ldapServerTypeValue = 7;
                        }
                        if (ApplyWizardSettings.tc.isDebugEnabled()) {
                            Tr.debug(ApplyWizardSettings.tc, "ldapServerTypeValue = " + ldapServerTypeValue);
                        }
                        switch (ldapServerTypeValue) {
                            case 0: {
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "userFilter", ldapProps.getProperty("ibm_dir_server.user.filter"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupFilter", ldapProps.getProperty("ibm_dir_server.group.filter"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "userIdMap", ldapProps.getProperty("ibm_dir_server.user.idmap"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupIdMap", ldapProps.getProperty("ibm_dir_server.group.idmap"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupMemberIdMap", ldapProps.getProperty("ibm_dir_server.groupmember.idmap"));
                                props.setProperty("user.filter", ldapProps.getProperty("ibm_dir_server.user.filter"));
                                props.setProperty("group.filter", ldapProps.getProperty("ibm_dir_server.group.filter"));
                                props.setProperty("user.idmap", ldapProps.getProperty("ibm_dir_server.user.idmap"));
                                props.setProperty("group.idmap", ldapProps.getProperty("ibm_dir_server.group.idmap"));
                                props.setProperty("groupmember.idmap", ldapProps.getProperty("ibm_dir_server.groupmember.idmap"));
                                break;
                            }
                            case 1: {
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "userFilter", ldapProps.getProperty("secureway.user.filter"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupFilter", ldapProps.getProperty("secureway.group.filter"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "userIdMap", ldapProps.getProperty("secureway.user.idmap"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupIdMap", ldapProps.getProperty("secureway.group.idmap"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupMemberIdMap", ldapProps.getProperty("secureway.groupmember.idmap"));
                                props.setProperty("user.filter", ldapProps.getProperty("secureway.user.filter"));
                                props.setProperty("group.filter", ldapProps.getProperty("secureway.group.filter"));
                                props.setProperty("user.idmap", ldapProps.getProperty("secureway.user.idmap"));
                                props.setProperty("group.idmap", ldapProps.getProperty("secureway.group.idmap"));
                                props.setProperty("groupmember.idmap", ldapProps.getProperty("secureway.groupmember.idmap"));
                                break;
                            }
                            case 2: {
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "userFilter", ldapProps.getProperty("iplanet.user.filter"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupFilter", ldapProps.getProperty("iplanet.group.filter"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "userIdMap", ldapProps.getProperty("iplanet.user.idmap"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupIdMap", ldapProps.getProperty("iplanet.group.idmap"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupMemberIdMap", ldapProps.getProperty("iplanet.groupmember.idmap"));
                                props.setProperty("user.filter", ldapProps.getProperty("iplanet.user.filter"));
                                props.setProperty("group.filter", ldapProps.getProperty("iplanet.group.filter"));
                                props.setProperty("user.idmap", ldapProps.getProperty("iplanet.user.idmap"));
                                props.setProperty("group.idmap", ldapProps.getProperty("iplanet.group.idmap"));
                                props.setProperty("groupmember.idmap", ldapProps.getProperty("iplanet.groupmember.idmap"));
                                break;
                            }
                            case 3: {
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "userFilter", ldapProps.getProperty("netscape.user.filter"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupFilter", ldapProps.getProperty("netscape.group.filter"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "userIdMap", ldapProps.getProperty("netscape.user.idmap"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupIdMap", ldapProps.getProperty("netscape.group.idmap"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupMemberIdMap", ldapProps.getProperty("netscape.groupmember.idmap"));
                                props.setProperty("user.filter", ldapProps.getProperty("netscape.user.filter"));
                                props.setProperty("group.filter", ldapProps.getProperty("netscape.group.filter"));
                                props.setProperty("user.idmap", ldapProps.getProperty("netscape.user.idmap"));
                                props.setProperty("group.idmap", ldapProps.getProperty("netscape.group.idmap"));
                                props.setProperty("groupmember.idmap", ldapProps.getProperty("netscape.groupmember.idmap"));
                                break;
                            }
                            case 4: {
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "userFilter", ldapProps.getProperty("domino50.user.filter"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupFilter", ldapProps.getProperty("domino50.group.filter"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "userIdMap", ldapProps.getProperty("domino50.user.idmap"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupIdMap", ldapProps.getProperty("domino50.group.idmap"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupMemberIdMap", ldapProps.getProperty("domino50.groupmember.idmap"));
                                props.setProperty("user.filter", ldapProps.getProperty("domino50.user.filter"));
                                props.setProperty("group.filter", ldapProps.getProperty("domino50.group.filter"));
                                props.setProperty("user.idmap", ldapProps.getProperty("domino50.user.idmap"));
                                props.setProperty("group.idmap", ldapProps.getProperty("domino50.group.idmap"));
                                props.setProperty("groupmember.idmap", ldapProps.getProperty("domino50.groupmember.idmap"));
                                break;
                            }
                            case 6: {
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "userFilter", ldapProps.getProperty("actived.user.filter"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupFilter", ldapProps.getProperty("actived.group.filter"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "userIdMap", ldapProps.getProperty("actived.user.idmap"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupIdMap", ldapProps.getProperty("actived.group.idmap"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupMemberIdMap", ldapProps.getProperty("actived.groupmember.idmap"));
                                props.setProperty("user.filter", ldapProps.getProperty("actived.user.filter"));
                                props.setProperty("group.filter", ldapProps.getProperty("actived.group.filter"));
                                props.setProperty("user.idmap", ldapProps.getProperty("actived.user.idmap"));
                                props.setProperty("group.idmap", ldapProps.getProperty("actived.group.idmap"));
                                props.setProperty("groupmember.idmap", ldapProps.getProperty("actived.groupmember.idmap"));
                                break;
                            }
                            case 5: {
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "userFilter", ldapProps.getProperty("edirectory.user.filter"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupFilter", ldapProps.getProperty("edirectory.group.filter"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "userIdMap", ldapProps.getProperty("edirectory.user.idmap"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupIdMap", ldapProps.getProperty("edirectory.group.idmap"));
                                ConfigServiceHelper.setAttributeValue(searchFilterAttrList, "groupMemberIdMap", ldapProps.getProperty("edirectory.groupmember.idmap"));
                                props.setProperty("user.filter", ldapProps.getProperty("edirectory.user.filter"));
                                props.setProperty("group.filter", ldapProps.getProperty("edirectory.group.filter"));
                                props.setProperty("user.idmap", ldapProps.getProperty("edirectory.user.idmap"));
                                props.setProperty("group.idmap", ldapProps.getProperty("edirectory.group.idmap"));
                                props.setProperty("groupmember.idmap", ldapProps.getProperty("edirectory.groupmember.idmap"));
                                break;
                            }
                        }
                    }
                    if (ApplyWizardSettings.tc.isDebugEnabled()) {
                        Tr.debug(ApplyWizardSettings.tc, "searchFilterAttrList = " + searchFilterAttrList.toString());
                    }
                    matchesSearch = cs.queryConfigObjects(s, null, ConfigServiceHelper.createObjectName(searchFilterAttrList), null);
                }
                if (props != null && ApplyWizardSettings.tc.isDebugEnabled()) {
                    Tr.debug(ApplyWizardSettings.tc, "props = " + props.toString());
                }
                if (this.userRegistryType.equals("CustomUserRegistry")) {
                    for (i = 0; i < this.numberCustomProps; ++i) {
                        cProps.put(this.customPropName[i], this.customPropValue[i]);
                    }
                    cProps.put("CustUserRegImplClass", this.customRegistryClass);
                    if (ApplyWizardSettings.tc.isDebugEnabled()) {
                        Tr.debug(ApplyWizardSettings.tc, "cProps = " + cProps.toString());
                    }
                    count = 0;
                    method = "getUsers";
                    try {
                        processName = AdminServiceFactory.getAdminService().getProcessName();
                        on = new ObjectName("WebSphere:type=SecurityAdmin,process=" + processName + ",*");
                        it = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
                        if (!it.hasNext()) {
                            result.setResult(new Boolean(false));
                            msg = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.AdminNotFoundInReg", null);
                            result.addWarnings(msg);
                            result.setResult(new Boolean(false));
                            result.setException(new CommandException(msg));
                            if (ApplyWizardSettings.tc.isEntryEnabled()) {
                                Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                            }
                            return;
                        }
                        on = (ObjectName)it.next();
                        results = (Result)AdminServiceFactory.getAdminService().invoke(on, method, new Object[]{this.adminName, new Integer(100), cProps}, new String[]{"java.lang.String", "java.lang.Integer", "java.util.Properties"});
                        count = results.getList().size();
                        if (ApplyWizardSettings.tc.isDebugEnabled()) {
                            Tr.debug(ApplyWizardSettings.tc, "count = " + count);
                        }
                        if (count == 0) {
                            msg = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.AdminNotFoundInReg", null);
                            result.addWarnings(msg);
                            result.setResult(new Boolean(false));
                            result.setException(new CommandException(msg));
                            if (ApplyWizardSettings.tc.isEntryEnabled()) {
                                Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                            }
                            return;
                        }
                        break block140;
                    }
                    catch (Exception ex) {
                        msg = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.AdminNotFoundInReg", null);
                        result.addWarnings(msg);
                        result.setResult(new Boolean(false));
                        result.setException(new CommandException(msg));
                        if (ApplyWizardSettings.tc.isEntryEnabled()) {
                            Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                        }
                        return;
                    }
                }
                if (this.userRegistryType.equals("WIMUserRegistry")) {
                    try {
                        if (ApplyWizardSettings.tc.isDebugEnabled()) {
                            Tr.debug(ApplyWizardSettings.tc, "sessionId = " + s.toString());
                        }
                        if ((userResult = (urV = new UserRegistryValidator(s.toString())).getUsers(this.adminName, 100)).getList().isEmpty()) {
                            if (ApplyWizardSettings.tc.isDebugEnabled()) {
                                Tr.debug(ApplyWizardSettings.tc, "user " + this.adminName + " not found in WIM UR");
                            }
                            try {
                                commandMgr = CommandMgr.getCommandMgr();
                                getUserCmd = commandMgr.createCommand("addFileRegistryAccount");
                                getUserCmd.setConfigSession(s);
                                getUserCmd.setParameter("userId", this.adminName);
                                getUserCmd.setParameter("password", this.adminPassword);
                                getUserCmd.execute();
                                cmdResult = getUserCmd.getCommandResult();
                                if (cmdResult.isSuccessful()) {
                                    if (!ApplyWizardSettings.tc.isDebugEnabled()) ** GOTO lbl519
                                    Tr.debug(ApplyWizardSettings.tc, "user " + this.adminName + " added to WIM UR");
                                }
                                if (ApplyWizardSettings.tc.isDebugEnabled()) {
                                    Tr.debug(ApplyWizardSettings.tc, "(1) user " + this.adminName + " not added toWIM UR");
                                }
                                if (ApplyWizardSettings.tc.isDebugEnabled()) {
                                    Tr.debug(ApplyWizardSettings.tc, "cmdResult.getException().getMessage() = " + cmdResult.getException().getMessage());
                                }
                                if (cmdResult.getException() == null || cmdResult.getException().getMessage() == null || cmdResult.getException().getMessage().indexOf("CWWIM4501E") != -1) ** GOTO lbl519
                                msg = this.getMsg(ApplyWizardSettings.resBundle, "security.profiletask.failAddingAdminToWim", null);
                                result.addWarnings(msg);
                                result.setResult(new Boolean(false));
                                result.setException(new CommandException(msg));
                                if (ApplyWizardSettings.tc.isEntryEnabled()) {
                                    Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                                }
                                return;
                            }
                            catch (Exception e) {
                                if (ApplyWizardSettings.tc.isDebugEnabled()) {
                                    Tr.debug(ApplyWizardSettings.tc, "exception = " + e.getMessage().toString());
                                }
                                result.setResult(new Boolean(false));
                                msg = this.getMsg(ApplyWizardSettings.resBundle, "security.profiletask.failAddingAdminToWim", null);
                                result.setException(new CommandException(e, msg));
                                if (ApplyWizardSettings.tc.isEntryEnabled()) {
                                    Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                                }
                                return;
                            }
                        }
                        if (!ApplyWizardSettings.tc.isDebugEnabled()) ** GOTO lbl519
                        Tr.debug(ApplyWizardSettings.tc, "user " + this.adminName + " found in WIM UR");
                    }
                    catch (Exception we) {
                        we.printStackTrace();
                        result.setResult(new Boolean(false));
                        msg = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionValidAdminName", null);
                        result.setException(new CommandException(we, msg));
                        return;
                    }
                } else {
                    count = 0;
                    method = "getUsers";
                    try {
                        processName = AdminServiceFactory.getAdminService().getProcessName();
                        on = new ObjectName("WebSphere:type=SecurityAdmin,process=" + processName + ",*");
                        it = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
                        if (!it.hasNext()) {
                            result.setResult(new Boolean(false));
                            return;
                        }
                        on = (ObjectName)it.next();
                        results = (Result)AdminServiceFactory.getAdminService().invoke(on, method, new Object[]{this.adminName, new Integer(100), props}, new String[]{"java.lang.String", "java.lang.Integer", "java.util.Properties"});
                        if (results != null && results.getList() != null) {
                            count = results.getList().size();
                            if (ApplyWizardSettings.tc.isDebugEnabled()) {
                                Tr.debug(ApplyWizardSettings.tc, "count = " + count);
                            }
                        } else if (ApplyWizardSettings.tc.isDebugEnabled()) {
                            Tr.debug(ApplyWizardSettings.tc, "results or results.getList() was null");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        result.setResult(new Boolean(false));
                        msg = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionValidAdminName", null);
                        result.setException(new CommandException(ex, msg));
                        return;
                    }
                    if (count == 0) {
                        msg = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.AdminNotFoundInReg", null);
                        result.addWarnings(msg);
                        result.setResult(new Boolean(false));
                        result.setException(new CommandException(msg));
                        if (ApplyWizardSettings.tc.isEntryEnabled()) {
                            Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                        }
                        return;
                    }
                }
            }
            if (System.getProperty("os.name").equalsIgnoreCase("z/os")) {
                propertiesList = (ArrayList)cs.getAttribute(s, security, "properties");
                attrSAFProp = new AttributeList();
                if (ApplyWizardSettings.tc.isDebugEnabled() && propertiesList != null) {
                    Tr.debug(ApplyWizardSettings.tc, "propertiesList.size = " + propertiesList.size());
                }
                for (i = 0; i < propertiesList.size(); ++i) {
                    propertyAttrs = (AttributeList)propertiesList.get(i);
                    propObj = ConfigServiceHelper.getAttributeValue(propertyAttrs, "_Websphere_Config_Data_Type");
                    propNameObj = ConfigServiceHelper.getAttributeValue(propertyAttrs, "name");
                    propValueObj = ConfigServiceHelper.getAttributeValue(propertyAttrs, "value");
                    if (ApplyWizardSettings.tc.isDebugEnabled()) {
                        Tr.debug(ApplyWizardSettings.tc, "propNameObj = " + propNameObj.toString());
                        Tr.debug(ApplyWizardSettings.tc, "propObj = " + propObj.toString());
                    }
                    if (!propNameObj.toString().equals("com.ibm.security.SAF.authorization")) continue;
                    if (ApplyWizardSettings.tc.isDebugEnabled()) {
                        Tr.debug(ApplyWizardSettings.tc, "found SAF auth");
                    }
                    matchesSAFProp = cs.queryConfigObjects(s, null, ConfigServiceHelper.createObjectName(propertyAttrs), null);
                    for (j = 0; j < matchesSAFProp.length; ++j) {
                        if (!ApplyWizardSettings.tc.isDebugEnabled()) continue;
                        Tr.debug(ApplyWizardSettings.tc, "matchesSAFProp = " + matchesSAFProp[j].toString());
                    }
                    ConfigServiceHelper.setAttributeValue(propertyAttrs, "name", propNameObj);
                    ConfigServiceHelper.setAttributeValue(propertyAttrs, "value", "false");
                    cs.setAttributes(s, matchesSAFProp[0], propertyAttrs);
                    break;
                }
            }
            cs.setAttributes(s, matchesLTPA[0], attrLTPAList);
            cs.setAttributes(s, security, attrSecurityList);
            if (this.userRegistryType.equals("LDAPUserRegistry")) {
                cs.setAttributes(s, (ObjectName)matchesHosts[0], hostAttrs);
                cs.setAttributes(s, matchesSearch[0], searchFilterAttrList);
            }
            if (this.userRegistryType.equals("CustomUserRegistry") && this.numberCustomProps != 0) {
                propsC = (ArrayList)cs.getAttribute(s, matchesURAttrs[0], "properties");
                cs.unsetAttributes(s, matchesURAttrs[0], aList);
                for (i = 0; i < this.numberCustomProps; ++i) {
                    ConfigServiceHelper.setAttributeValue(newPropAttrs, "name", this.customPropName[i]);
                    ConfigServiceHelper.setAttributeValue(newPropAttrs, "value", this.customPropValue[i]);
                    cs.addElement(s, matchesURAttrs[0], "properties", newPropAttrs, -1);
                }
            }
            cs.setAttributes(s, matchesURAttrs[0], attrURList);
            commandMgr = CommandMgr.getCommandMgr();
            getUserCmd = commandMgr.createCommand("setUseRegistryServerId");
            getUserCmd.setConfigSession(s);
            getUserCmd.setParameter("userRegistryType", this.userRegistryType);
            getUserCmd.setParameter("useRegistryServerId", new Boolean(false));
            getUserCmd.execute();
            cmdResult = getUserCmd.getCommandResult();
            if (!cmdResult.isSuccessful()) ** GOTO lbl581
            if (((Boolean)cmdResult.getResult()).booleanValue()) {
                if (ApplyWizardSettings.tc.isDebugEnabled()) {
                    Tr.debug(ApplyWizardSettings.tc, "Successfully set useRegistryServerId to false");
                }
            } else {
                if (ApplyWizardSettings.tc.isDebugEnabled()) {
                    Tr.debug(ApplyWizardSettings.tc, "Could not successfully set useRegistryServerId to false");
                }
                msg = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionUseRegistryServerId", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                cs.discard(s);
                if (ApplyWizardSettings.tc.isEntryEnabled()) {
                    Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                }
                return;
lbl581:
                // 1 sources

                if (ApplyWizardSettings.tc.isDebugEnabled()) {
                    Tr.debug(ApplyWizardSettings.tc, "Could not successfully set useRegistryServerId to false");
                }
                msg = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionUseRegistryServerId", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                result.setException(new CommandException(msg));
                if (ApplyWizardSettings.tc.isEntryEnabled()) {
                    Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
                }
                return;
            }
            getUserCmd = commandMgr.createCommand("addAdminIdToUserRegObj");
            getUserCmd.setConfigSession(s);
            getUserCmd.setParameter("adminUser", this.adminName);
            getUserCmd.setParameter("registryType", this.userRegistryType);
            getUserCmd.execute();
            cmdResult = getUserCmd.getCommandResult();
            if (!cmdResult.isSuccessful()) ** GOTO lbl607
            if (((Boolean)cmdResult.getResult()).booleanValue()) {
                if (ApplyWizardSettings.tc.isDebugEnabled()) {
                    Tr.debug(ApplyWizardSettings.tc, "Successfully set adminId in user registry object");
                }
            } else {
                if (ApplyWizardSettings.tc.isDebugEnabled()) {
                    Tr.debug(ApplyWizardSettings.tc, "Could not successfully set adminId in user registry object");
                }
                msg = this.getMsg(ApplyWizardSettings.resBundle, "security.profiletask.FailedAddAdminId", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                return;
lbl607:
                // 1 sources

                if (ApplyWizardSettings.tc.isDebugEnabled()) {
                    Tr.debug(ApplyWizardSettings.tc, "Could not successfully set adminId in user registry object");
                }
                msg = this.getMsg(ApplyWizardSettings.resBundle, "security.profiletask.FailedAddAdminId", null);
                result.addWarnings(msg);
                result.setResult(new Boolean(false));
                return;
            }
            result.setResult(new Boolean(true));
        }
        catch (Throwable th) {
            if (ApplyWizardSettings.tc.isDebugEnabled()) {
                Tr.debug(ApplyWizardSettings.tc, th.toString());
                Tr.debug(ApplyWizardSettings.tc, th.getMessage());
            }
            msg = this.getMsg(ApplyWizardSettings.resBundle, "security.admintask.ExceptionProcessingWizardSettings", null);
            msg = msg.concat(": ");
            msg = msg.concat(th.getMessage());
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
            result.setException(new CommandException(msg));
        }
        if (ApplyWizardSettings.tc.isEntryEnabled()) {
            Tr.exit(ApplyWizardSettings.tc, "afterStepsExecuted");
        }
    }
}

