/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.types;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.ConfigNameCache;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.types.FIPSTSHelper;
import com.ibm.ws.scripting.types.HTTPTransportTSHelper;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class WebContainerTSHelper
extends FIPSTSHelper {
    private static TraceComponent tc = Tr.register(WebContainerTSHelper.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");

    public WebContainerTSHelper(AdminConfigClient configClient, AbstractShell shell, Hashtable table, ConfigNameCache cache) {
        super(configClient, shell, table, cache);
        this.reset();
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        this.msgId = "SECURITY_NONFIPS_PROVIDER";
        this.validationType = "sslConfig";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public AttributeList attributeListUpdate(AttributeList input, ObjectName on, boolean create) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeListUpdate");
        }
        try {
            this.validate(input, on);
        }
        catch (AdminException ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        catch (ConnectorException ce) {
            this._shell.setLastException(ce);
            throw new ScriptingException(ce.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeListUpdate");
        }
        return input;
    }

    protected boolean validate(AttributeList input, ObjectName on) throws ScriptingException, AdminException, ConnectorException {
        ArrayList transports;
        boolean warning;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            warning = false;
            transports = null;
            try {
                transports = (ArrayList)ConfigServiceHelper.getAttributeValue(input, "transports");
            }
            catch (AttributeNotFoundException anfe) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Ex - " + anfe.toString());
            }
        }
        if (transports != null) {
            HTTPTransportTSHelper transportHelper = (HTTPTransportTSHelper)this.getTSHelper("HTTPTransport");
            transportHelper.setMessageId("SECURITY_NONFIPS_PROVIDER");
            transportHelper.setValidationType("sslConfig");
            for (int j = 0; j < transports.size(); ++j) {
                String attr;
                AttributeList attrList;
                block9: {
                    attrList = (AttributeList)transports.get(j);
                    attr = null;
                    try {
                        attr = (String)ConfigServiceHelper.getAttributeValue(attrList, "_Websphere_Config_Data_Type");
                    }
                    catch (AttributeNotFoundException anfe) {
                        if (!tc.isDebugEnabled()) break block9;
                        Tr.debug(tc, "Ex - " + anfe.toString());
                    }
                }
                if (attr != null && attr.equals("HTTPTransport") && (warning = transportHelper.validate(attrList, on))) break;
            }
            transportHelper.reset();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate - " + warning);
        }
        return warning;
    }
}

