/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.types;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.ConfigNameCache;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.types.FIPSTSHelper;
import com.ibm.ws.scripting.types.PropertyTSHelper;
import com.ibm.ws.scripting.types.SSLConfigTSHelper;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class SecurityTSHelper
extends FIPSTSHelper {
    private static TraceComponent tc = Tr.register(SecurityTSHelper.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    public static final int FIPS_NOT_SET = 0;
    public static final int FIPS_TRUE = 1;
    public static final int FIPS_FALSE = 2;
    private int foundUseFIPS = 1;

    public SecurityTSHelper(AdminConfigClient configClient, AbstractShell shell, Hashtable table, ConfigNameCache cache) {
        super(configClient, shell, table, cache);
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        this.msgId = "SECURITY_NONFIPS_PROVIDER";
        this.validationType = "com.ibm.ssl.contextProvider";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public AttributeList attributeListUpdate(AttributeList input, ObjectName on, boolean create) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeListUpdate");
        }
        try {
            this.validate(input, on);
        }
        catch (AdminException ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        catch (ConnectorException ce) {
            this._shell.setLastException(ce);
            throw new ScriptingException(ce.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeListUpdate");
        }
        return input;
    }

    protected boolean validate(AttributeList input, ObjectName on) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate - " + on);
        }
        boolean warning = false;
        ArrayList repertoire = null;
        int FIPSFound = this.validateFIPSProperty(input, on);
        if (FIPSFound == 0 || FIPSFound == 1) {
            block11: {
                try {
                    repertoire = (ArrayList)ConfigServiceHelper.getAttributeValue(input, "repertoire");
                }
                catch (AttributeNotFoundException anfe) {
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "Ex - " + anfe.toString());
                }
            }
            if (repertoire != null) {
                SSLConfigTSHelper sslHelper = (SSLConfigTSHelper)this.getTSHelper("SSLConfig");
                sslHelper.setMessageId(this.msgId);
                sslHelper.setValidationType(this.validationType);
                for (int j = 0; j < repertoire.size(); ++j) {
                    AttributeList repList = null;
                    Object ob = repertoire.get(j);
                    if (ob instanceof ObjectName) {
                        AttributeList attrList = this.getAttributeListFromON((ObjectName)ob);
                        if (attrList != null) {
                            repList = attrList;
                        }
                    } else if (ob instanceof AttributeList) {
                        repList = (AttributeList)ob;
                    }
                    warning = sslHelper.validate(repList, on);
                    if (warning) break;
                }
                sslHelper.reset();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate - " + warning);
        }
        return warning;
    }

    protected int validateFIPSProperty(AttributeList input, ObjectName scope) throws ScriptingException, AdminException, ConnectorException {
        int ret;
        boolean warning;
        ArrayList arlist;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validateFIPSProperty - " + scope);
            }
            arlist = null;
            warning = false;
            ret = 0;
            try {
                arlist = (ArrayList)ConfigServiceHelper.getAttributeValue(input, "properties");
            }
            catch (AttributeNotFoundException anfe) {
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "Ex - " + anfe.toString());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "arlist: " + arlist);
        }
        if (arlist != null) {
            PropertyTSHelper propHelper = (PropertyTSHelper)this.getTSHelper("Property");
            for (int i = 0; i < arlist.size(); ++i) {
                AttributeList aList = null;
                Object ob = arlist.get(i);
                if (ob instanceof ObjectName) {
                    AttributeList attrList = this.getAttributeListFromON((ObjectName)ob);
                    if (attrList != null) {
                        aList = attrList;
                    }
                } else if (ob instanceof AttributeList) {
                    aList = (AttributeList)ob;
                }
                ret = this.checkFIPSProperty(aList);
                if (ret != 0) break;
            }
            if (ret == this.foundUseFIPS) {
                String configId;
                propHelper.setMessageId("SECURITY_NONFIPS_SSL");
                propHelper.setValidationType("com.ibm.ssl.contextProvider");
                propHelper.setSkipFIPSCheck(true);
                warning = propHelper.matchSSLConfig("lookThroughAllSSLConfig", scope);
                propHelper.setSkipFIPSCheck(false);
                propHelper.reset();
                if (!warning && scope != null && (configId = this.getConfigPath(scope)).indexOf("/servers/") == -1) {
                    warning = this.checkServerSSLConfig(scope);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateFIPSProperty - " + ret);
        }
        return ret;
    }

    public int checkFIPSProperty(AttributeList input) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkFIPSProperty");
        }
        int found = 0;
        String nameFound = new String();
        String valueFound = new String();
        for (int j = 0; j < input.size(); ++j) {
            String aName = ((Attribute)input.get(j)).getName();
            Object aVal = ((Attribute)input.get(j)).getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name: " + aName);
            }
            if (aName.equals("name")) {
                nameFound = (String)aVal;
            }
            if (!aName.equals("value")) continue;
            valueFound = (String)aVal;
        }
        if (nameFound.equals("com.ibm.security.useFIPS")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found matching useFIPS property, value: " + valueFound);
            }
            found = valueFound.equals("true") ? 1 : 2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkFIPSProperty - " + found);
        }
        return found;
    }

    public boolean checkServerSSLConfig(ObjectName scope) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkServerSSLConfig");
        }
        boolean warning = false;
        ObjectName[] serverList = this.getObjectNameListForType("Server", null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverList: " + serverList);
        }
        if (serverList != null) {
            for (int i = 0; i < serverList.length; ++i) {
                ObjectName[] secList = this.getObjectNameListForType("Security", serverList[i]);
                if (secList != null) {
                    AttributeList aList;
                    for (int j = 0; j < secList.length && !(warning = this.validate(aList = this.getAttributeListFromON(secList[j]), secList[i])); ++j) {
                    }
                }
                if (warning) break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkServerSSLConfig - " + warning);
        }
        return warning;
    }
}

