/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.types;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.ConfigNameCache;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.types.FIPSTSHelper;
import com.ibm.ws.scripting.types.SecureSocketLayerTSHelper;
import java.util.Hashtable;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class SSLConfigTSHelper
extends FIPSTSHelper {
    private static TraceComponent tc = Tr.register(SSLConfigTSHelper.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");

    public SSLConfigTSHelper(AdminConfigClient configClient, AbstractShell shell, Hashtable table, ConfigNameCache cache) {
        super(configClient, shell, table, cache);
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        this.msgId = "SECURITY_NONFIPS_PROVIDER";
        this.validationType = "com.ibm.ssl.contextProvider";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public AttributeList attributeListUpdate(AttributeList input, ObjectName on, boolean create) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeListUpdate");
        }
        try {
            this.validate(input, on);
        }
        catch (AdminException ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        catch (ConnectorException ce) {
            this._shell.setLastException(ce);
            throw new ScriptingException(ce.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeListUpdate");
        }
        return input;
    }

    protected boolean validate(AttributeList input, ObjectName on) throws ScriptingException, AdminException, ConnectorException {
        AttributeList ssl2;
        Object object;
        boolean warning;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            warning = false;
            object = null;
            ssl2 = null;
            try {
                object = ConfigServiceHelper.getAttributeValue(input, "setting");
            }
            catch (AttributeNotFoundException anfe) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "Ex - " + anfe.toString());
            }
        }
        if (object != null) {
            AttributeList attrList = null;
            if (object instanceof ObjectName) {
                attrList = this.getAttributeListFromON((ObjectName)object);
                if (attrList != null) {
                    ssl2 = attrList;
                }
            } else if (object instanceof AttributeList) {
                ssl2 = (AttributeList)object;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ssl: " + ssl2);
            }
            if (ssl2 != null) {
                SecureSocketLayerTSHelper sslHelper = (SecureSocketLayerTSHelper)this.getTSHelper("SecureSocketLayer");
                sslHelper.setMessageId(this.msgId);
                sslHelper.setValidationType(this.validationType);
                warning = sslHelper.validate(ssl2, on);
                sslHelper.reset();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate - " + warning);
        }
        return warning;
    }
}

