/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.types;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.ConfigNameCache;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.types.FIPSTSHelper;
import com.ibm.ws.scripting.types.SSLConfigTSHelper;
import com.ibm.ws.scripting.types.SecurityTSHelper;
import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class PropertyTSHelper
extends FIPSTSHelper {
    private static TraceComponent tc = Tr.register(PropertyTSHelper.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private boolean skipFIPSCheck;
    private boolean create;

    public PropertyTSHelper(AdminConfigClient configClient, AbstractShell shell, Hashtable table, ConfigNameCache cache) {
        super(configClient, shell, table, cache);
        this.reset();
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        this.msgId = "SECURITY_NONFIPS_PROVIDER";
        this.validationType = "all";
        this.create = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public AttributeList attributeListUpdate(AttributeList input, ObjectName on, boolean create) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeListUpdate");
        }
        try {
            this.create = create;
            this.validate(input, on);
        }
        catch (AdminException ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        catch (ConnectorException ce) {
            this._shell.setLastException(ce);
            throw new ScriptingException(ce.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeListUpdate");
        }
        return input;
    }

    protected boolean validate(AttributeList input, ObjectName on) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        boolean ret = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validationType: " + this.validationType);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "messageId: " + this.msgId);
        }
        if (this.validationType.equals("all") || this.validationType.equals("com.ibm.ssl.contextProvider")) {
            ret = this.checkProviderProperty(input, on);
        }
        if (!ret && (this.validationType.equals("all") || this.validationType.equals("sslConfig"))) {
            ret = this.checkSSLConfigProperty(input, on);
        }
        if (!ret && (this.validationType.equals("all") || this.validationType.equals("com.ibm.security.useFIPS"))) {
            ret = this.checkFIPSProperty(input, true, on);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate - " + ret);
        }
        return ret;
    }

    private boolean checkProviderProperty(AttributeList input, ObjectName on) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkProviderProperty");
        }
        boolean warning = false;
        Hashtable nameValue = this.getNameValuePropertyValues(input, on, true);
        String nameFound = (String)nameValue.get("name");
        String valueFound = (String)nameValue.get("value");
        if (nameFound.equals("com.ibm.ssl.contextProvider")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found matching contextProvider");
            }
            if (!valueFound.trim().equals("") && !valueFound.trim().equals("IBMJSSEFIPS")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "not using IBMJSSEFIPS provider");
                }
                if (this.skipFIPSCheck || this.isFIPSEnabled(on)) {
                    if (this.validationType.equals("all")) {
                        this.msgId = "SECURITY_NONFIPS_PROVIDER";
                    }
                    warning = true;
                    String msg = this._shell.getFormattedMessage(this.msgId, new Object[0], "SSL provider is not IBMJSSEFIPS. FIPS approved cryptographic algorithms may not be used.");
                    System.out.println(msg);
                    Tr.warning(tc, this.msgId);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkProviderProperty - " + warning);
        }
        return warning;
    }

    private boolean checkSSLConfigProperty(AttributeList input, ObjectName on) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkSSLConfigProperty");
        }
        boolean warning = false;
        Hashtable nameValue = this.getNameValuePropertyValues(input, on, true);
        String nameFound = (String)nameValue.get("name");
        String valueFound = (String)nameValue.get("value");
        if (nameFound.equals("sslConfig")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found matching sslConfig");
            }
            this.msgId = "SECURITY_NONFIPS_PROVIDER";
            warning = this.matchSSLConfig(valueFound, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkSSLConfigProperty - " + warning);
        }
        return warning;
    }

    public boolean checkFIPSProperty(AttributeList input, boolean searchSSLConfig, ObjectName scope) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkFIPSProperty");
        }
        boolean warning = false;
        Hashtable nameValue = this.getNameValuePropertyValues(input, scope, true);
        String nameFound = (String)nameValue.get("name");
        String valueFound = (String)nameValue.get("value");
        if (nameFound.equals("com.ibm.security.useFIPS")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found matching useFIPS property");
            }
            if (valueFound.equals("true")) {
                if (searchSSLConfig) {
                    this.msgId = "SECURITY_NONFIPS_SSL";
                    this.validationType = "com.ibm.ssl.contextProvider";
                    this.skipFIPSCheck = true;
                    warning = this.matchSSLConfig("lookThroughAllSSLConfig", null, scope);
                    this.skipFIPSCheck = false;
                    if (!warning && scope != null && this.getConfigPath(scope).indexOf("/servers/") == -1) {
                        SecurityTSHelper securityHelper = (SecurityTSHelper)this.getTSHelper("Security");
                        securityHelper.setMessageId("SECURITY_NONFIPS_SSL");
                        securityHelper.setValidationType("com.ibm.ssl.contextProvider");
                        warning = securityHelper.checkServerSSLConfig(scope);
                        securityHelper.reset();
                    }
                } else {
                    warning = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkFIPSProperty - " + warning);
        }
        return warning;
    }

    public boolean matchSSLConfig(String matchingAlias, ObjectName scope) throws ScriptingException, AdminException, ConnectorException {
        return this.matchSSLConfig(matchingAlias, scope, null);
    }

    public boolean matchSSLConfig(String matchingAlias, ObjectName scope, ObjectName matchingON) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "matchSSLConfig", new Object[]{matchingAlias, scope});
        }
        boolean warning = false;
        ObjectName[] oList = this.getObjectNameListForType("SSLConfig", scope);
        if (oList != null) {
            String matchingConfigPath = new String();
            if (matchingON != null) {
                matchingConfigPath = this.getConfigPath(matchingON);
            } else if (scope != null) {
                matchingConfigPath = this.getConfigPath(scope);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "matchinfConfigPath: " + matchingConfigPath);
            }
            SSLConfigTSHelper sslHelper = (SSLConfigTSHelper)this.getTSHelper("SSLConfig");
            sslHelper.setMessageId(this.msgId);
            sslHelper.setValidationType("com.ibm.ssl.contextProvider");
            for (int i = 0; i < oList.length; ++i) {
                AttributeList aList;
                String alias;
                block14: {
                    alias = null;
                    if (!matchingConfigPath.equals("") && !matchingConfigPath.equals(this.getConfigPath(oList[i]))) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Skipping " + oList[i]);
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing " + oList[i]);
                    }
                    if ((aList = this.getAttributeListFromON(oList[i])) == null) continue;
                    try {
                        alias = (String)ConfigServiceHelper.getAttributeValue(aList, "alias");
                    }
                    catch (AttributeNotFoundException ex) {
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug(tc, ex.toString());
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "alias: " + alias);
                }
                if (!matchingAlias.equals("lookThroughAllSSLConfig") && (alias == null || !alias.equals(matchingAlias))) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found matching SSL config");
                }
                if (warning = sslHelper.validate(aList, oList[i])) break;
            }
            sslHelper.reset();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "matchSSLConfig - " + warning);
        }
        return warning;
    }

    public void setSkipFIPSCheck(boolean skipFIPS) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSkipFIPSCheck - " + skipFIPS);
        }
        this.skipFIPSCheck = skipFIPS;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSkipFIPSCheck");
        }
    }

    private Hashtable getNameValuePropertyValues(AttributeList input, ObjectName on, boolean recursive) throws ScriptingException, AdminException, ConnectorException {
        AttributeList aList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNameValuePropertyValues");
        }
        Hashtable<String, String> ret = new Hashtable<String, String>();
        String nameFound = new String();
        String valueFound = new String();
        for (int j = 0; j < input.size(); ++j) {
            String aName = ((Attribute)input.get(j)).getName();
            Object aVal = ((Attribute)input.get(j)).getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name: " + aName);
            }
            if (aName.equals("name")) {
                nameFound = (String)aVal;
            }
            if (!aName.equals("value")) continue;
            valueFound = (String)aVal;
        }
        if (!this.create && recursive && (!nameFound.equals("") && valueFound.equals("") || nameFound.equals("") && !valueFound.equals("")) && (aList = this.getAttributeListFromON(on)) != null) {
            Hashtable values = this.getNameValuePropertyValues(aList, on, false);
            if (nameFound.equals("")) {
                nameFound = (String)values.get("name");
            }
            if (valueFound.equals("")) {
                valueFound = (String)values.get("value");
            }
        }
        ret.put("name", nameFound);
        ret.put("value", valueFound);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNameValuePropertyValues - " + nameFound + " " + valueFound);
        }
        return ret;
    }
}

