/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.types;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.ConfigNameCache;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.types.FIPSTSHelper;
import com.ibm.ws.scripting.types.PropertyTSHelper;
import java.util.Hashtable;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class IIOPTransportTSHelper
extends FIPSTSHelper {
    private static TraceComponent tc = Tr.register(IIOPTransportTSHelper.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");

    public IIOPTransportTSHelper(AdminConfigClient configClient, AbstractShell shell, Hashtable table, ConfigNameCache cache) {
        super(configClient, shell, table, cache);
        this.reset();
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        this.msgId = "SECURITY_NONFIPS_PROVIDER";
        this.validationType = "sslConfig";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public AttributeList attributeListUpdate(AttributeList input, ObjectName on, boolean create) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeListUpdate");
        }
        try {
            this.validate(input, on);
        }
        catch (AdminException ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        catch (ConnectorException ce) {
            this._shell.setLastException(ce);
            throw new ScriptingException(ce.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeListUpdate");
        }
        return input;
    }

    protected boolean validate(AttributeList input, ObjectName on) throws ScriptingException, AdminException, ConnectorException {
        String aVal;
        boolean warning;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            warning = false;
            aVal = null;
            try {
                aVal = (String)ConfigServiceHelper.getAttributeValue(input, "sslConfig");
            }
            catch (AttributeNotFoundException anfe) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Ex - " + anfe.toString());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "aVal: " + aVal);
        }
        if (aVal != null) {
            PropertyTSHelper propHelper = (PropertyTSHelper)this.getTSHelper("Property");
            propHelper.setMessageId("SECURITY_NONFIPS_PROVIDER");
            propHelper.setValidationType("sslConfig");
            warning = propHelper.matchSSLConfig(aVal, null);
            propHelper.reset();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate - " + warning);
        }
        return warning;
    }
}

