/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.types;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.ConfigNameCache;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.types.BaseTSHelper;
import com.ibm.ws.scripting.types.SecurityTSHelper;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public abstract class FIPSTSHelper
extends BaseTSHelper {
    private static TraceComponent tc = Tr.register(FIPSTSHelper.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    protected static final String ALL_PROVIDER = "lookThroughAllSSLConfig";
    protected static final String DOMAIN = "WebSphere";
    protected static final String PROVIDER_MSG_ID = "SECURITY_NONFIPS_PROVIDER";
    protected static final String SSLCONFIG_MSG_ID = "SECURITY_NONFIPS_PROVIDER";
    protected static final String FIPS_MSG_ID = "SECURITY_NONFIPS_SSL";
    protected static final String PROVIDER_VALIDATION = "com.ibm.ssl.contextProvider";
    protected static final String SSLCONFIG_VALIDATION = "sslConfig";
    protected static final String FIPS_VALIDATION = "com.ibm.security.useFIPS";
    protected static final String ALL_VALIDATION = "all";
    protected String msgId = "SECURITY_NONFIPS_PROVIDER";
    protected String validationType = "com.ibm.ssl.contextProvider";
    protected Hashtable helperTable;
    protected ConfigNameCache nameCache;

    public FIPSTSHelper(AdminConfigClient configClient, AbstractShell shell, Hashtable table, ConfigNameCache cache) {
        super(configClient, shell);
        this.helperTable = table;
        this.nameCache = cache;
    }

    public abstract void reset();

    protected abstract boolean validate(AttributeList var1, ObjectName var2) throws ScriptingException, AdminException, ConnectorException;

    protected AttributeList getAttributeListFromON(ObjectName ON) {
        AttributeList attrList;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAttributeListFromON - " + ON);
            }
            attrList = null;
            try {
                attrList = this._proxy.getAttributes(this._client.getCurrentSession(), ON, null, false);
            }
            catch (ConfigServiceException ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ex.toString());
                }
            }
            catch (ConnectorException ex1) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, ex1.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeListFromON");
        }
        return attrList;
    }

    protected boolean isFIPSEnabled(ObjectName scope) throws ScriptingException, AdminException, ConnectorException {
        ObjectName[] oList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFIPSEnabled");
        }
        boolean ret = false;
        int isFIPSSet = 0;
        String matchingSecurityXML = this.getConfigPath(scope);
        ObjectName securityON = null;
        if (matchingSecurityXML != null && (oList = this.getObjectNameListForType("Security", null)) != null) {
            String aSecurityXML;
            int i;
            for (i = 0; i < oList.length; ++i) {
                aSecurityXML = this.getConfigPath(oList[i]);
                if (!matchingSecurityXML.equals(aSecurityXML)) continue;
                securityON = oList[i];
                break;
            }
            if (securityON != null) {
                isFIPSSet = this.checkFIPS(securityON);
            }
            if (isFIPSSet == 0 && matchingSecurityXML.indexOf("/servers/") > 0) {
                securityON = null;
                for (i = 0; i < oList.length; ++i) {
                    aSecurityXML = this.getConfigPath(oList[i]);
                    if (aSecurityXML.indexOf("/servers/") != -1) continue;
                    securityON = oList[i];
                    break;
                }
                if (securityON != null) {
                    isFIPSSet = this.checkFIPS(securityON);
                }
            }
        }
        if (isFIPSSet == 1) {
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFIPSEnabled - " + ret);
        }
        return ret;
    }

    protected void setValidationType(String vType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setValidationType - " + vType);
        }
        this.validationType = vType;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setValidationType");
        }
    }

    protected void setMessageId(String msgId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMessageId - " + msgId);
        }
        this.msgId = msgId;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMessageId");
        }
    }

    protected FIPSTSHelper getTSHelper(String tsType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTSHelper - " + tsType);
        }
        FIPSTSHelper helper = (FIPSTSHelper)this.helperTable.get(tsType);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTSHelper - " + helper);
        }
        return helper;
    }

    protected ObjectName[] getObjectNameListForType(String type, ObjectName scope) throws ScriptingException, AdminException, ConnectorException {
        ObjectName[] oList;
        block14: {
            ObjectName typeON;
            ObjectName scopeON;
            block13: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getObjectNameListForType", new Object[]{type, scope});
                }
                scopeON = null;
                typeON = null;
                oList = null;
                Hashtable scopeTable = null;
                Hashtable<String, String> table = new Hashtable<String, String>();
                if (scope != null) {
                    scopeTable = scope.getKeyPropertyList();
                    String displayName = scope.getKeyProperty("_Websphere_Config_Data_Display_Name");
                    String configId = scope.getKeyProperty("_Websphere_Config_Data_Id");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "displayName: " + displayName + " configId: " + configId);
                    }
                    StringBuffer fullConfigId = new StringBuffer();
                    if (displayName != null) {
                        fullConfigId.append(fullConfigId);
                    }
                    fullConfigId.append("(");
                    fullConfigId.append(configId);
                    fullConfigId.append(")");
                    String objectType = this.nameCache.getType(fullConfigId.toString());
                    scopeTable.put("_Websphere_Config_Data_Type", objectType);
                }
                table.put("_Websphere_Config_Data_Type", type);
                try {
                    typeON = new ObjectName(DOMAIN, table);
                    if (scopeTable != null) {
                        scopeON = new ObjectName(DOMAIN, scopeTable);
                    }
                }
                catch (MalformedObjectNameException ex) {
                    if (!tc.isDebugEnabled()) break block13;
                    Tr.debug(tc, ex.toString());
                }
            }
            if (typeON != null) {
                try {
                    oList = this._proxy.queryConfigObjects(this._client.getCurrentSession(), scopeON, typeON, null);
                }
                catch (ConfigServiceException ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, ex.toString());
                    }
                }
                catch (ConnectorException ex1) {
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, ex1.toString());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectNameListForType - " + oList);
        }
        return oList;
    }

    protected String getConfigPath(ObjectName on) {
        int sep;
        String configId;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigPath - " + on);
        }
        String configPath = null;
        if (on != null && (configId = on.getKeyProperty("_Websphere_Config_Data_Id")) != null && (sep = configId.lastIndexOf("#")) > 0) {
            configPath = configId.substring(0, sep);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigPath - " + configPath);
        }
        return configPath;
    }

    private int checkFIPS(ObjectName securityON) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkFIPS - " + securityON);
        }
        int isFIPSSet = 0;
        AttributeList aList = this.getAttributeListFromON(securityON);
        if (aList != null) {
            ArrayList arList;
            block12: {
                arList = null;
                try {
                    arList = (ArrayList)ConfigServiceHelper.getAttributeValue(aList, "properties");
                }
                catch (AttributeNotFoundException ex) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, ex.toString());
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "arList: " + arList);
            }
            if (arList != null) {
                SecurityTSHelper secHelper = (SecurityTSHelper)this.getTSHelper("Security");
                for (int j = 0; j < arList.size(); ++j) {
                    AttributeList list = null;
                    Object ob = arList.get(j);
                    if (ob instanceof ObjectName) {
                        AttributeList attrList = this.getAttributeListFromON((ObjectName)ob);
                        if (attrList != null) {
                            list = attrList;
                        }
                    } else if (ob instanceof AttributeList) {
                        list = (AttributeList)ob;
                    }
                    isFIPSSet = secHelper.checkFIPSProperty(list);
                    if (isFIPSSet != 0) break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkFIPS - " + isFIPSSet);
        }
        return isFIPSSet;
    }
}

