/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.compat;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.beans.PropertyEditorSupport;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public abstract class StringEditor
extends PropertyEditorSupport {
    private static TraceComponent tc = Tr.register(StringEditor.class, null, "com.ibm.ws.scripting.resources.wscpMessage");

    public abstract String getAsText();

    public abstract void setAsText(String var1) throws IllegalArgumentException;

    public abstract void setValue(Object var1);

    public abstract Object getValue();

    protected String getString(StringTokenizer strtok, String next) throws IllegalArgumentException {
        String value;
        try {
            if (next.equals(" ")) {
                next = this.skipSpaces(strtok);
            }
            if (next.equals("{")) {
                value = "";
                int nested = 1;
                while (nested > 0) {
                    next = strtok.nextToken("{}");
                    if (next.equals("{")) {
                        ++nested;
                    } else if (next.equals("}")) {
                        --nested;
                    }
                    if (nested <= 0) continue;
                    value = value + next;
                }
            } else {
                if (next.equals("}")) {
                    Tr.event(tc, "Unexpected '}' found");
                    Object[] parms = new Object[]{};
                    String msg = "WSCP_EXC_UNEXPECTED_CLOSING_BRACE" + parms + " Unexpected '}' found";
                    throw new IllegalArgumentException(msg);
                }
                if (next.equals("\"")) {
                    StringBuffer buf = new StringBuffer();
                    boolean foundEnd = false;
                    while (strtok.hasMoreTokens()) {
                        next = strtok.nextToken();
                        if (next.equals("\"")) {
                            foundEnd = true;
                            break;
                        }
                        buf.append(next);
                    }
                    if (!foundEnd) {
                        Object[] parms = new Object[]{};
                        String msg = "WSCP_EXC_CLOSING_QUOTE " + parms + " Expected \" not found";
                        throw new IllegalArgumentException(msg);
                    }
                    value = buf.toString();
                } else {
                    value = next;
                }
            }
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalArgumentException();
        }
        Tr.exit(tc, "getString -> " + value);
        return value;
    }

    protected String skipSpaces(StringTokenizer strtok) throws IllegalArgumentException {
        String next;
        try {
            while ((next = strtok.nextToken()) != null && next.equals(" ")) {
            }
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalArgumentException();
        }
        return next;
    }

    protected String getStringForJython(StringTokenizer strtok, String next) throws IllegalArgumentException {
        String value;
        Tr.entry(tc, "getStringForJython");
        try {
            if (next.equals(" ")) {
                next = this.skipSpaces(strtok);
            }
            if (next.equals("[")) {
                value = "";
                int nested = 1;
                while (nested > 0) {
                    next = strtok.nextToken("[]");
                    if (next.equals("[")) {
                        ++nested;
                    } else if (next.equals("]")) {
                        --nested;
                    }
                    if (nested <= 0) continue;
                    value = value + next;
                }
            } else {
                if (next.equals("]")) {
                    Tr.event(tc, "Unexpected ']' found");
                    Object[] parms = new Object[]{};
                    String msg = "WSCP_EXC_UNEXPECTED_CLOSING_BRACE" + parms + " Unexpected ']' found";
                    throw new IllegalArgumentException(msg);
                }
                if (next.equals("\"")) {
                    StringBuffer buf = new StringBuffer();
                    boolean foundEnd = false;
                    while (strtok.hasMoreTokens()) {
                        next = strtok.nextToken();
                        if (next.equals("\"")) {
                            foundEnd = true;
                            break;
                        }
                        buf.append(next);
                    }
                    if (!foundEnd) {
                        Object[] parms = new Object[]{};
                        String msg = "WSCP_EXC_CLOSING_QUOTE " + parms + " Expected \" not found";
                        throw new IllegalArgumentException(msg);
                    }
                    value = buf.toString();
                } else {
                    value = next;
                }
            }
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalArgumentException();
        }
        Tr.exit(tc, "getStringForJython -> " + value);
        return value;
    }
}

