/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.adminCommand;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.ws.scripting.adminCommand.AdminCmd;
import com.ibm.ws.scripting.adminCommand.AdminCmdController;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class AdminCmdReadOnlyCommand {
    private static TraceComponent tc = Tr.register(AdminCmdReadOnlyCommand.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");

    public static boolean isReadOnlyCommand(AdminCommand adminCmd) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isReadOnlyCommand", new Object[]{adminCmd});
        }
        boolean isReadOnly = true;
        CommandMetadata cmdMetadata = adminCmd.getCommandMetadata();
        if (cmdMetadata instanceof TaskCommandMetadata) {
            EList steps = ((TaskCommandMetadata)cmdMetadata).getSteps();
            if (steps.size() == 0) {
                isReadOnly = false;
            }
            if (steps != null) {
                for (int i = 0; i < steps.size(); ++i) {
                    CommandStepMetadata stepMetadata = (CommandStepMetadata)steps.get(i);
                    if (AdminCmdReadOnlyCommand._areParametersReadOnly(stepMetadata.getParameters())) continue;
                    isReadOnly = false;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "step parameters are not all readonly");
                    break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isReadOnlyCommand", new Boolean(isReadOnly));
        }
        return isReadOnly;
    }

    public static void displayCmd(AdminCommand adminCmd, AdminCmdController controller, boolean displayTitle) throws Throwable {
        String[] stepNames;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "displayCmd", new Object[]{adminCmd, controller, new Boolean(displayTitle)});
        }
        if (displayTitle) {
            System.out.println(controller.getMetadataTitle(adminCmd.getCommandMetadata()) + " (" + adminCmd.getName() + ")");
            System.out.println(AdminCmd.nl);
            System.out.println(controller.getMetadataDescription(adminCmd.getCommandMetadata()));
            System.out.println(AdminCmd.nl);
        }
        if (adminCmd instanceof TaskCommand && (stepNames = ((TaskCommand)adminCmd).listCommandSteps()) != null) {
            for (int i = 0; i < stepNames.length; ++i) {
                CommandStep step = ((TaskCommand)adminCmd).getCommandStep(stepNames[i]);
                int rows = step.getNumberOfRows();
                if (rows > 0) {
                    System.out.println(controller.getMetadataTitle(step.getCommandMetadata()) + " (" + stepNames[i] + ")");
                    System.out.println(AdminCmd.nl);
                    System.out.println(controller.getMetadataDescription(step.getCommandMetadata()));
                    System.out.println(AdminCmd.nl);
                }
                for (int j = 0; j < rows; ++j) {
                    controller.promptParameters(step, step.getCommandMetadata(), true, j);
                    System.out.println(AdminCmd.nl);
                }
                System.out.println(AdminCmd.nl);
            }
        }
    }

    private static boolean _areParametersReadOnly(List paramMetadataList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_areParametersReadOnly", new Object[]{paramMetadataList});
        }
        boolean isReadOnly = true;
        if (paramMetadataList != null) {
            for (int i = 0; i < paramMetadataList.size(); ++i) {
                ParameterMetadata paramMetadata = (ParameterMetadata)paramMetadataList.get(i);
                if (paramMetadata.isReadonly()) continue;
                isReadOnly = false;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "parameter " + paramMetadata + " is not read only");
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_areParametersReadOnly", new Boolean(isReadOnly));
        }
        return isReadOnly;
    }
}

