/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.adminCommand;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.adminCommand.AdminCmdClient;
import com.ibm.ws.scripting.adminCommand.AdminCmdController;
import com.ibm.ws.scripting.adminCommand.AdminCmdHelp;
import com.ibm.ws.scripting.adminCommand.AdminCmdInterfaceGenerator;
import com.ibm.ws.security.util.AccessController;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;

public class AdminCmdProxyHandler
implements InvocationHandler {
    private static TraceComponent tc = Tr.register(AdminCmdProxyHandler.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    AdminCmdClient adminCmdSupport;
    AdminCmdHelp adminCmdHelp;
    AdminCmdController adminCmdController;

    public AdminCmdProxyHandler(AdminCmdClient cmdClient) throws ScriptingException {
        this.adminCmdSupport = cmdClient;
        this.adminCmdHelp = new AdminCmdHelp(this.adminCmdSupport);
        this.adminCmdController = new AdminCmdController(this.adminCmdSupport);
    }

    public Object invoke(Object proxy, Method method2, Object[] args) throws ScriptingException, Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke", new Object[]{method2.getName(), args});
        }
        if (method2.getName().equals("toString")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke");
            }
            return this.toString();
        }
        if (method2.getName().equals("help")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke");
            }
            return this.adminCmdHelp.help(args);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke");
        }
        if (!this.isDmgrOrAdminAgent()) {
            return this.adminCmdController.processCmd(method2.getName(), args);
        }
        return this.processCmdWithPrivilege(method2.getName(), args);
    }

    private Object processCmdWithPrivilege(String name, Object[] args) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processCmdWithPrivilege", new Object[]{name, args});
        }
        Object obj = null;
        final String nameFinal = name;
        final Object[] argsFinal = args;
        final AdminCmdController adminCmdControllerFinal = this.adminCmdController;
        try {
            obj = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    try {
                        return adminCmdControllerFinal.processCmd(nameFinal, argsFinal);
                    }
                    catch (Throwable e) {
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Excpetion", e);
            }
            throw new Exception(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processCmdWithPrivilege", obj);
        }
        return obj;
    }

    private boolean isDmgrOrAdminAgent() {
        Boolean res;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isDmgrOrAdminAgent");
            }
            res = new Boolean(false);
            try {
                res = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        try {
                            return AdminCmdProxyHandler.this.isDmgrOrAdminAgentPriv();
                        }
                        catch (Throwable e) {
                            return new Boolean(false);
                        }
                    }
                });
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Excpetion", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDmgrOrAdminAgent", res);
        }
        return res;
    }

    private Boolean isDmgrOrAdminAgentPriv() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isDmgrOrAdminAgentPriv");
        }
        Boolean ret = new Boolean(false);
        AdminService as = AdminServiceFactory.getAdminService();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "adminservice", as);
        }
        if (as != null) {
            String serverType = as.getServerType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverType", serverType);
            }
            if (serverType != null && (serverType.equals("DEPLOYMENT_MANAGER") || serverType.equals("ADMIN_AGENT"))) {
                ret = new Boolean(true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDmgrOrAdminAgentPriv", ret);
        }
        return ret;
    }

    public String toString() {
        return AdminCmdInterfaceGenerator.CLASS_NAME;
    }

    public String help(Object proxy, Object[] args) {
        return "No help is available";
    }
}

