/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.adminCommand;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.ws.scripting.adminCommand.AdminCmdController;
import com.ibm.ws.scripting.adminCommand.AdminCmdInteractivePrompt;
import java.util.Enumeration;
import java.util.Vector;

public class AdminCmdInteractiveStepsPrompt
extends AdminCmdInteractivePrompt {
    private static TraceComponent tc = Tr.register(AdminCmdInteractiveStepsPrompt.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private TaskCommand taskCmd;
    private CommandStep selectStep = null;
    private CommandStep lastStep = null;
    private String defaultSelection;
    private String completeStepMsg = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_TASK_COMPLETE", new Object[0], "End of task");
    private boolean selectStepFound;
    private boolean hasRequiredSteps;
    private boolean _isAsyncProcess = false;
    private Vector selectionIndex;

    public AdminCmdInteractiveStepsPrompt(AdminCmdController adminCmdController) {
        super(adminCmdController);
    }

    public AdminCmdInteractiveStepsPrompt(AdminCmdController adminCmdController, boolean isAsyncProcess) {
        super(adminCmdController);
        this._isAsyncProcess = isAsyncProcess;
    }

    protected void setAdminCommand(AdminCommand adminCmd) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAdminCommand");
        }
        this.taskCmd = (TaskCommand)adminCmd;
        this.lastStep = null;
        this.selectStepFound = false;
        this.hasRequiredSteps = false;
        this.defaultSelection = select;
        String[] steps = this.taskCmd.listCommandSteps();
        this.selectStep = this.taskCmd.gotoStep(steps[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAdminCommand");
        }
    }

    protected String getTitle() {
        return this.getMetadataTitle(this.taskCmd.getCommandMetadata());
    }

    protected String getDescription() throws Throwable {
        return this.getMetadataDescription(this.taskCmd.getCommandMetadata());
    }

    protected boolean isLoopDone(String answer) {
        if (answer == null) {
            answer = this.defaultSelection;
        }
        return answer != null && !answer.equalsIgnoreCase(finish) && !answer.equalsIgnoreCase(cancel) && !answer.equalsIgnoreCase(kontinue);
    }

    protected String getStepTitles() throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStepTitles");
        }
        StringBuffer buf = new StringBuffer();
        this.hasRequiredSteps = false;
        this.selectStepFound = false;
        String[] steps = this.taskCmd.listCommandSteps();
        for (int i = 0; i < steps.length; ++i) {
            CommandStep cmdStep = this.taskCmd.getCommandStep(steps[i]);
            if (!cmdStep.isEnabled()) {
                buf.append("   (");
            } else if (this.selectStep != null && this.selectStep.getName().equals(steps[i])) {
                this.selectStepFound = true;
                if (cmdStep.isRequired()) {
                    buf.append("-> " + "*");
                    this.hasRequiredSteps = true;
                } else {
                    buf.append("->  ");
                }
            } else if (cmdStep.isRequired()) {
                buf.append("   " + "*");
                this.hasRequiredSteps = true;
            } else {
                buf.append("    ");
            }
            buf.append(i + 1);
            buf.append(". ");
            buf.append(this.getMetadataTitle(cmdStep.getCommandMetadata()));
            buf.append(" (");
            buf.append(steps[i]);
            buf.append(")");
            if (!cmdStep.isEnabled()) {
                buf.append(")");
            }
            buf.append(AdminCmdController.nl);
        }
        if (!this.taskCmd.hasNextStep() && !this.selectStepFound) {
            buf.append("->  ");
            buf.append(this.completeStepMsg);
            buf.append(AdminCmdController.nl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStepTitles - " + buf.toString());
        }
        return buf.toString();
    }

    protected String getSelectionMenu() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSelectionMenu");
        }
        StringBuffer selectionBuf = new StringBuffer();
        this.selectionIndex = new Vector();
        this.defaultSelection = select;
        if (this.selectStepFound) {
            selectionBuf.append(selectSelection);
            selectionBuf.append(AdminCmdController.nl);
            this.selectionIndex.addElement(select);
        }
        if (this.taskCmd.hasNextStep()) {
            selectionBuf.append(nextSelection);
            selectionBuf.append(AdminCmdController.nl);
            this.selectionIndex.addElement(next);
        } else if (!this.selectStepFound) {
            this.defaultSelection = previous;
        }
        if (this.taskCmd.hasPreviousStep()) {
            selectionBuf.append(previousSelection);
            selectionBuf.append(AdminCmdController.nl);
            this.selectionIndex.addElement(previous);
        }
        if (!this.hasRequiredSteps) {
            if (this._isAsyncProcess && this.selectStepFound) {
                selectionBuf.append(kontinueSelection);
                selectionBuf.append(AdminCmdController.nl);
                this.selectionIndex.addElement(kontinue);
                this.defaultSelection = kontinue;
            } else {
                selectionBuf.append(finishSelection);
                selectionBuf.append(AdminCmdController.nl);
                this.selectionIndex.addElement(finish);
                this.defaultSelection = finish;
            }
        }
        if (!this._isAsyncProcess) {
            selectionBuf.append(cancelSelection);
            selectionBuf.append(AdminCmdController.nl);
            this.selectionIndex.addElement(cancel);
        }
        selectionBuf.append(helpSelection);
        selectionBuf.append(AdminCmdController.nl);
        this.selectionIndex.addElement(help);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSelectionMenu - " + selectionBuf.toString());
        }
        return selectionBuf.toString();
    }

    protected String getSelectionPrompt() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSelectionPrompt");
        }
        StringBuffer selectionIndexBuf = new StringBuffer();
        if (!this.selectionIndex.isEmpty()) {
            Enumeration e = this.selectionIndex.elements();
            while (e.hasMoreElements()) {
                if (selectionIndexBuf.length() != 0) {
                    selectionIndexBuf.append(", ");
                }
                selectionIndexBuf.append((String)e.nextElement());
            }
        }
        String promptMsg = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_STEP_REPEAT_PROMPT", new Object[]{selectionIndexBuf.toString(), this.defaultSelection}, "Select [" + selectionIndexBuf.toString() + "] : [" + this.defaultSelection + "] ");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSelectionPrompt - " + promptMsg);
        }
        return promptMsg;
    }

    protected String getDefaultSelection() {
        return this.defaultSelection;
    }

    protected boolean validateAnswer(String answer) {
        if (answer == null) {
            answer = this.defaultSelection;
        }
        return answer != null && (this.selectionIndex.contains(answer.toUpperCase()) || this.selectionIndex.contains(answer.toLowerCase()));
    }

    protected boolean processSelection(String selection) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSelection", new Object[]{selection});
        }
        boolean ret = true;
        if (selection == null) {
            selection = this.defaultSelection;
        }
        if (selection != null && selection.equalsIgnoreCase(select)) {
            this._adminCmdController.processSelectStep(this.taskCmd, this.selectStep, this._isAsyncProcess);
            this.lastStep = this.selectStep;
            this.selectStep = this.getNextStep();
        } else if (selection != null && selection.equalsIgnoreCase(next)) {
            this.lastStep = this.selectStep;
            this.selectStep = this.getNextStep();
        } else if (selection != null && selection.equalsIgnoreCase(previous)) {
            selection = previous;
            this.selectStep = !this.selectStepFound ? this.lastStep : this.getPreviousStep();
        } else if (selection != null && selection.equalsIgnoreCase(finish)) {
            selection = finish;
        } else if (selection != null && selection.equalsIgnoreCase(kontinue)) {
            selection = kontinue;
        } else if (selection.equalsIgnoreCase(cancel)) {
            ret = false;
        } else if (selection.equalsIgnoreCase(help)) {
            this._adminCmdController.processStepsHelp(this.taskCmd);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSelection");
        }
        return ret;
    }

    private CommandStep getNextStep() throws Throwable {
        CommandStep retStep = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextStep");
        }
        if (this.taskCmd.hasNextStep()) {
            retStep = this.taskCmd.nextStep();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextStep - " + retStep);
        }
        return retStep;
    }

    private CommandStep getPreviousStep() throws Throwable {
        CommandStep retStep = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPreviousStep");
        }
        if (this.taskCmd.hasPreviousStep()) {
            retStep = this.taskCmd.previousStep();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPreviousStep - " + retStep);
        }
        return retStep;
    }
}

