/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.adminCommand;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandGroupMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CustomProperties;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.adminCommand.AdminCmd;
import com.ibm.ws.scripting.adminCommand.AdminCmdClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.PatternSyntaxException;
import org.eclipse.emf.common.util.EList;

public class AdminCmdHelp
extends AdminCmd {
    private static TraceComponent tc = Tr.register(AdminCmdHelp.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private String nl = System.getProperty("line.separator");
    private AdminCmdClient _adminCmdClient;
    private int argIndex;

    public AdminCmdHelp(AdminCmdClient cmdClient) {
        this._adminCmdClient = cmdClient;
    }

    public String help(Object[] args) throws ScriptingException, CommandException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "help", new Object[]{args});
        }
        String msg = "";
        if (args == null || args.length == 0) {
            msg = this.getGeneralHelp();
        } else {
            this.argIndex = 0;
            while (this.argIndex < args.length) {
                String argValue = (String)args[this.argIndex];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "arg: " + argValue);
                }
                if (argValue.equalsIgnoreCase("-commands")) {
                    msg = msg + this.getCommandsGeneralHelp(args);
                    break;
                }
                if (argValue.equalsIgnoreCase("-commandGroups")) {
                    msg = msg + this.getCommandGroupsGeneralHelp(args);
                    break;
                }
                msg = msg + this.getCommandHelp(args);
                msg = msg + this.nl + this.nl;
                ++this.argIndex;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "help");
        }
        return msg.toString();
    }

    private String getGeneralHelp() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGeneralHelp");
        }
        String msg = this._adminCmdClient.getShell().getFormattedMessage("WASX8001I", new Object[0], "General help for AdminTask");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGeneralHelp");
        }
        return msg;
    }

    private String getCommandsGeneralHelp(Object[] args) throws ScriptingException, CommandException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandsGeneralHelp");
        }
        String ret = null;
        String pattern = null;
        if (args.length > 1) {
            pattern = (String)args[1];
            Tr.debug(tc, "pattern: " + pattern);
        }
        Collection cmdMetas = this._adminCmdClient.getCommandMgr().getAllCommandMetadata();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Collection: " + cmdMetas);
        }
        ArrayList<CommandMetadata> matchMetadatas = new ArrayList<CommandMetadata>();
        if (pattern != null) {
            for (CommandMetadata cmdMetadata : cmdMetas) {
                String cmdName = cmdMetadata.getName();
                if (cmdName == null) continue;
                try {
                    if (!cmdName.matches(pattern) && !this.wildcardMatches(pattern, cmdName)) continue;
                    Tr.debug(tc, "cmd name matches pattern: " + cmdName);
                    matchMetadatas.add(cmdMetadata);
                }
                catch (PatternSyntaxException e) {
                    if (!this.wildcardMatches(pattern, cmdName)) continue;
                    matchMetadatas.add(cmdMetadata);
                }
            }
        }
        Tr.debug(tc, "matchMetadatas size: " + matchMetadatas.size());
        Object[] sortedCmdMetadata = new Object[]{};
        if (pattern != null && matchMetadatas.size() == 0) {
            ret = this._adminCmdClient.getShell().getFormattedMessage("WASX8024I", new Object[]{pattern}, "Cannot find the specified pattern: " + pattern);
        } else {
            if (pattern == null) {
                sortedCmdMetadata = this.sortCollection(cmdMetas);
            }
            if (matchMetadatas.size() > 0) {
                sortedCmdMetadata = this.sortCollection(matchMetadatas);
            }
            StringBuffer msg = new StringBuffer();
            for (int i = 0; i < sortedCmdMetadata.length; ++i) {
                msg.append(this.getCommandDescriptionHelp((CommandMetadata)sortedCmdMetadata[i]));
            }
            ret = this._adminCmdClient.getShell().getFormattedMessage("WASX8004I", new Object[]{msg.toString()}, "Available commands:\n" + msg.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandsGeneralHelp");
        }
        return ret;
    }

    private String getCommandDescriptionHelp(CommandMetadata cmdMetadata) throws ScriptingException, CommandException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandDescriptionHelp", new Object[]{cmdMetadata.getName()});
        }
        StringBuffer msg = new StringBuffer();
        Tr.debug(tc, "command name " + cmdMetadata.getName());
        if (cmdMetadata.getName() != null && !cmdMetadata.isPrivate()) {
            msg.append(cmdMetadata.getName());
            msg.append(" - ");
            msg.append(this.getMetadataDescription(cmdMetadata));
            msg.append(this.nl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandDescriptionHelp");
        }
        return msg.toString();
    }

    private Object[] sortCollection(Collection cols) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sortCollection");
        }
        Object[] colArray = cols.toArray();
        for (int i = 0; i < colArray.length; ++i) {
            for (int j = i + 1; j < colArray.length; ++j) {
                Object temp;
                if (colArray[j] instanceof CommandMetadata && colArray[i] instanceof CommandMetadata) {
                    if (((CommandMetadata)colArray[j]).getName() == null || ((CommandMetadata)colArray[i]).getName() == null || ((CommandMetadata)colArray[j]).getName().compareTo(((CommandMetadata)colArray[i]).getName()) >= 0) continue;
                    temp = colArray[j];
                    colArray[j] = colArray[i];
                    colArray[i] = temp;
                    continue;
                }
                if (!(colArray[j] instanceof CommandGroupMetadata) || !(colArray[i] instanceof CommandGroupMetadata) || ((CommandGroupMetadata)colArray[j]).getName() == null || ((CommandGroupMetadata)colArray[i]).getName() == null || ((CommandGroupMetadata)colArray[j]).getName().compareTo(((CommandGroupMetadata)colArray[i]).getName()) >= 0) continue;
                temp = colArray[j];
                colArray[j] = colArray[i];
                colArray[i] = temp;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sortCollection");
        }
        return colArray;
    }

    private String getCommandGroupsGeneralHelp(Object[] args) throws ScriptingException, CommandException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandGroupsGeneralHelp");
        }
        String ret = null;
        String pattern = null;
        if (args.length > 1) {
            pattern = (String)args[1];
            Tr.debug(tc, "pattern: " + pattern);
        }
        Collection cmdGroupMetas = this._adminCmdClient.getCommandMgr().getAllCommandGroupMetadata();
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "Collection: " + cmdGroupMetas);
        }
        ArrayList<CommandGroupMetadata> matchGroupMetadatas = new ArrayList<CommandGroupMetadata>();
        if (pattern != null) {
            for (CommandGroupMetadata cmdGroupMetadata : cmdGroupMetas) {
                String cmdGroupName = cmdGroupMetadata.getName();
                if (cmdGroupName == null) continue;
                try {
                    if (!cmdGroupName.matches(pattern) && !this.wildcardMatches(pattern, cmdGroupName)) continue;
                    Tr.debug(tc, "cmd group name matches pattern: " + cmdGroupName);
                    matchGroupMetadatas.add(cmdGroupMetadata);
                }
                catch (PatternSyntaxException e) {
                    if (!this.wildcardMatches(pattern, cmdGroupName)) continue;
                    matchGroupMetadatas.add(cmdGroupMetadata);
                }
            }
        }
        Tr.debug(tc, "matchGroupMetadatas size: " + matchGroupMetadatas.size());
        Object[] sortedCmdGroupMetadata = new Object[]{};
        if (pattern != null && matchGroupMetadatas.size() == 0) {
            ret = this._adminCmdClient.getShell().getFormattedMessage("WASX8024I", new Object[]{pattern}, "Cannot find the specified pattern: " + pattern);
        } else {
            if (pattern == null) {
                sortedCmdGroupMetadata = this.sortCollection(cmdGroupMetas);
            }
            if (matchGroupMetadatas.size() > 0) {
                sortedCmdGroupMetadata = this.sortCollection(matchGroupMetadatas);
            }
            StringBuffer msg = new StringBuffer();
            for (int i = 0; i < sortedCmdGroupMetadata.length; ++i) {
                msg.append(this.getCommandGroupDescriptionHelp((CommandGroupMetadata)sortedCmdGroupMetadata[i]));
            }
            ret = this._adminCmdClient.getShell().getFormattedMessage("WASX8005I", new Object[]{msg.toString()}, "Available command groups:\n" + msg.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandGroupsGeneralHelp");
        }
        return ret;
    }

    private String getCommandGroupDescriptionHelp(CommandGroupMetadata cmdGroupMetadata) throws ScriptingException, CommandException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandDescriptionHelp", new Object[]{cmdGroupMetadata.getName()});
        }
        StringBuffer msg = new StringBuffer();
        Tr.debug(tc, "command name " + cmdGroupMetadata.getName());
        if (cmdGroupMetadata.getName() != null) {
            msg.append(cmdGroupMetadata.getName());
            msg.append(" - ");
            msg.append(this.getMetadataDescription(cmdGroupMetadata));
            msg.append(this.nl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandGroupsDescriptionHelp - " + msg.toString());
        }
        return msg.toString();
    }

    private String getCommandHelp(Object[] args) throws ScriptingException, CommandException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandHelp", new Object[]{args});
        }
        CommandMgr cmdMgr = this._adminCmdClient.getCommandMgr();
        String msg = "";
        boolean err = false;
        String name = (String)args[this.argIndex];
        if (cmdMgr.listCommandGroups().contains(name)) {
            msg = this.getCommandGroupDetailHelp(name);
        } else if (cmdMgr.listCommands().contains(name)) {
            if (args.length == this.argIndex + 1) {
                msg = this.getCommandDetailHelp(name);
            } else {
                CommandMetadata cmdMetadata = null;
                try {
                    cmdMetadata = this._adminCmdClient.getCommandMgr().getCommandMetadata(name);
                }
                catch (CommandNotFoundException cnfe) {
                    this._adminCmdClient.getShell().setLastException(cnfe);
                    throw new ScriptingException(this._adminCmdClient.getShell().getFormattedMessage("WASX8003E", new Object[]{name}, "Invalid help command argument: " + name));
                }
                if (cmdMetadata instanceof TaskCommandMetadata && this.isStepInTask((TaskCommandMetadata)cmdMetadata, (String)args[this.argIndex + 1])) {
                    msg = this.getCommandDetailStep((TaskCommandMetadata)cmdMetadata, (String)args[this.argIndex + 1]);
                    ++this.argIndex;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Advancing argument index to skip step");
                    }
                } else {
                    msg = this.getCommandDetailHelp(name);
                }
            }
        } else {
            this._adminCmdClient.getShell().setAndThrowScriptingException("WASX8003E", "Invalid help command argument: " + name, new Object[]{name});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandHelp");
        }
        return msg;
    }

    private String getCommandGroupDetailHelp(String groupName) throws ScriptingException, CommandException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandGroupDetailHelp", new Object[]{groupName});
        }
        StringBuffer msg = new StringBuffer();
        CommandGroupMetadata cmdGroupMetadata = null;
        try {
            cmdGroupMetadata = this._adminCmdClient.getCommandMgr().getCommandGroupMetadata(groupName);
        }
        catch (CommandNotFoundException cnfe) {
            this._adminCmdClient.getShell().setAndThrowScriptingException("WASX8002E", "Invalid command name: " + groupName, new Object[]{groupName});
        }
        String desc = this.getMetadataDescription(cmdGroupMetadata);
        Collection cmds = this._adminCmdClient.getCommandMgr().listCommands(groupName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Collection: " + cmds);
        }
        Object[] sortedCmds = this.sortCollection(cmds);
        Arrays.sort(sortedCmds);
        for (int i = 0; i < sortedCmds.length; ++i) {
            String cmdName = (String)sortedCmds[i];
            try {
                CommandMetadata cmdMetadata = this._adminCmdClient.getCommandMgr().getCommandMetadata(cmdName);
                msg.append(this.getCommandDescriptionHelp(cmdMetadata));
                continue;
            }
            catch (ScriptingException se) {
                if (se.toString().indexOf("WASX8002E") >= 0) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Ignore invalid command: " + cmdName);
                    continue;
                }
                throw se;
            }
        }
        String ret = this._adminCmdClient.getShell().getFormattedMessage("WASX8007I", new Object[]{groupName, desc, msg.toString()}, "Group command: " + groupName + "\n" + msg.toString());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandGroupDetailHelp");
        }
        return ret;
    }

    public String getCommandDetailHelp(String cmdName) throws ScriptingException, CommandException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandDetailHelp", new Object[]{cmdName});
        }
        CommandMetadata cmdMetadata = null;
        String isTargetRequired = "";
        try {
            cmdMetadata = this._adminCmdClient.getCommandMgr().getCommandMetadata(cmdName);
        }
        catch (CommandNotFoundException cnfe) {
            this._adminCmdClient.getShell().setAndThrowScriptingException("WASX8002E", "Invalid command name: " + cmdName, new Object[]{cmdName});
        }
        String desc = this.getMetadataDescription(cmdMetadata);
        String targetDesc = cmdMetadata.getTargetObjectDescription();
        int targetRequirement = this.getTargetObjectRequired(cmdMetadata);
        if (targetRequirement == 1) {
            isTargetRequired = "*";
        }
        if (targetRequirement == 2) {
            targetDesc = "  " + this._adminCmdClient.getShell().getFormattedMessage("ADMINTASK_NONE", new Object[0], "None");
        }
        String paramDesc = this.getCommandParameters(cmdMetadata);
        String stepDesc = cmdMetadata instanceof TaskCommandMetadata ? this.getTaskCommandMetaSteps((TaskCommandMetadata)cmdMetadata) : "  " + this._adminCmdClient.getShell().getFormattedMessage("ADMINTASK_NONE", new Object[0], "None");
        String msg = this._adminCmdClient.getShell().getFormattedMessage("WASX8006I", new Object[]{cmdName, desc, isTargetRequired, targetDesc, paramDesc, stepDesc}, "Command: " + cmdName + "\nDescription: " + desc + "\nTarget object: " + targetDesc + "\nArguments: " + paramDesc + "\nSteps: " + stepDesc);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandDetailHelp");
        }
        return msg;
    }

    private boolean isStepInTask(TaskCommandMetadata taskMetadata, String stepName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isStepInTask", new Object[]{stepName});
        }
        boolean isStep = false;
        EList steps = taskMetadata.getSteps();
        if (steps != null) {
            Iterator iter = steps.iterator();
            while (iter.hasNext()) {
                if (!((CommandStepMetadata)iter.next()).getName().equals(stepName)) continue;
                isStep = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isStepInTask - " + isStep);
        }
        return isStep;
    }

    private String getCommandParameters(CommandMetadata cmdMetadata) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandParameters");
        }
        EList parameterList = cmdMetadata.getParameters();
        StringBuffer paramDesc = new StringBuffer();
        if (parameterList.isEmpty()) {
            paramDesc.append("  ");
            paramDesc.append(this._adminCmdClient.getShell().getFormattedMessage("ADMINTASK_NONE", new Object[0], "None"));
            paramDesc.append(this.nl);
        } else {
            for (ParameterMetadata paramMetadata : parameterList) {
                boolean isPrivate = false;
                EList customProps = paramMetadata.getCustom();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "customProps: " + customProps);
                }
                if (customProps != null && customProps.size() > 0) {
                    for (int i = 0; i < customProps.size(); ++i) {
                        CustomProperties customProp = (CustomProperties)customProps.get(i);
                        if ("private".equalsIgnoreCase(customProp.getKey())) {
                            EList value = customProp.getValue();
                            for (int j = 0; j < value.size(); ++j) {
                                if (!"true".equalsIgnoreCase((String)value.get(j))) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "private parameter: " + paramMetadata.getName());
                                }
                                isPrivate = true;
                                break;
                            }
                        }
                        if (isPrivate) break;
                    }
                }
                if (isPrivate) continue;
                paramDesc.append("  ");
                if (paramMetadata.isRequired()) {
                    paramDesc.append("*");
                }
                paramDesc.append(paramMetadata.getName());
                paramDesc.append(" - ");
                paramDesc.append(this.getMetadataDescription(paramMetadata));
                paramDesc.append(this.nl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandParameters");
        }
        return paramDesc.toString();
    }

    private String getTaskCommandMetaSteps(TaskCommandMetadata taskMetadata) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTaskCommandMetaSteps");
        }
        StringBuffer msg = new StringBuffer();
        EList steps = taskMetadata.getSteps();
        if (steps == null) {
            msg.append(this._adminCmdClient.getShell().getFormattedMessage("ADMINTASK_NONE", new Object[0], "None"));
        } else {
            for (CommandStepMetadata stepMetadata : steps) {
                msg.append("   ");
                msg.append(stepMetadata.getName());
                msg.append(" - ");
                msg.append(this.getMetadataDescription(stepMetadata));
                msg.append(this.nl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTaskCommandMetaSteps");
        }
        return msg.toString();
    }

    private String getCommandDetailStep(TaskCommandMetadata taskMetadata, String stepName) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandDetailStep", new Object[]{taskMetadata.getName(), stepName});
        }
        String msg = null;
        EList steps = taskMetadata.getSteps();
        CommandStepMetadata foundStepMetadata = null;
        if (steps != null) {
            for (CommandStepMetadata stepMetadata : steps) {
                if (!stepMetadata.getName().equals(stepName)) continue;
                foundStepMetadata = stepMetadata;
                break;
            }
        }
        if (foundStepMetadata != null) {
            msg = this.getCommandDetailStep(foundStepMetadata, stepName);
        } else {
            this._adminCmdClient.getShell().setAndThrowScriptingException("WASX8003E", "Invalid help command argument: " + stepName, new Object[]{stepName});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandDetailStep");
        }
        return msg;
    }

    public String getCommandDetailStep(CommandStepMetadata stepMetadata, String stepName) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandDetailStep");
        }
        String stepDesc = this.getMetadataDescription(stepMetadata);
        String collectionDesc = stepMetadata.isTable() ? this._adminCmdClient.getShell().getFormattedMessage("ADMINTASK_COLLECTION_YES", new Object[0], "Yes") : this._adminCmdClient.getShell().getFormattedMessage("ADMINTASK_COLLECTION_NO", new Object[0], "No");
        String paramDesc = this.getCommandParameters(stepMetadata);
        String msg = this._adminCmdClient.getShell().getFormattedMessage("WASX8013I", new Object[]{stepName, stepDesc, collectionDesc, paramDesc}, "Help for " + stepName + ":\n\nDescription: " + stepDesc + "\n\nCollection: " + collectionDesc + "\n\nArguments:\n" + paramDesc);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandDetailStep");
        }
        return msg;
    }

    private boolean wildcardMatches(String pattern, String text) {
        text = text + '\u0000';
        pattern = pattern + '\u0000';
        pattern = pattern.toLowerCase();
        text = text.toLowerCase();
        int N = pattern.length();
        boolean[] states = new boolean[N + 1];
        boolean[] old = new boolean[N + 1];
        old[0] = true;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            states = new boolean[N + 1];
            for (int j = 0; j < N; ++j) {
                char p = pattern.charAt(j);
                if (old[j] && p == '*') {
                    old[j + 1] = true;
                }
                if (old[j] && p == c) {
                    states[j + 1] = true;
                }
                if (old[j] && p == '.') {
                    states[j + 1] = true;
                }
                if (old[j] && p == '*') {
                    states[j] = true;
                }
                if (!old[j] || p != '*') continue;
                states[j + 1] = true;
            }
            old = states;
        }
        return states[N];
    }
}

