/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminAppClient;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.ExtensionHelper;
import com.ibm.ws.scripting.HelpSupport;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.adminCommand.AdminCmdClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class WasxShell
extends AbstractShell {
    private static final String TRACE_PROP = "com.ibm.ws.scripting.traceString";
    private static final String TRACE_FILE_PROP = "com.ibm.ws.scripting.traceFile";
    private static final String WSADMIN_PROPERTIES = "com.ibm.ws.scripting.wsadminprops";
    private static final String APPEND_TRACE_PROP = "com.ibm.ws.scripting.appendTrace";
    private static TraceComponent tc = Tr.register(WasxShell.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static AbstractShell _shell = null;
    private AdminConfigClient configObject = null;
    private static AdminClient _client = null;
    private Thread shutdownHook_Thread = null;
    private AdminAppClient appObject = null;
    private AdminCmdClient cmdObject = null;
    private static final String PROFILES_PROP = "com.ibm.ws.scripting.profiles";

    public WasxShell() {
        this.bundle = ResourceBundle.getBundle("com.ibm.ws.scripting.resources.wscpMessage", Locale.getDefault());
        this.prompt = "wsadmin>";
        this.shutdownInit();
    }

    public static AbstractShell getShell() {
        if (_shell == null) {
            _shell = new WasxShell();
        }
        return _shell;
    }

    public Object executeCommand(String command) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeCommands");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeCommands");
        }
        return null;
    }

    protected boolean parseAndValidateInput(String[] argv) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseAndValidateInput");
        }
        boolean retval = true;
        boolean processingScriptParms = false;
        String internalLang = null;
        for (int i = 0; i < argv.length; ++i) {
            if (processingScriptParms) {
                this.scriptParms.add(argv[i]);
                continue;
            }
            if (argv[i].equalsIgnoreCase("-javaoption")) {
                ++i;
                continue;
            }
            if (argv[i].regionMatches(true, 0, "-help", 0, argv[i].length()) || argv[i].equals("-?")) {
                this.showHelp();
                retval = false;
                break;
            }
            if (argv[i].equalsIgnoreCase("-c")) {
                if (i + 1 < argv.length) {
                    this.commands.add(argv[++i].trim());
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "DASH_C_NEEDS_FOLLOWING_COMMAND", "\"-c\" must be followed by a command.");
                retval = false;
                break;
            }
            if (argv[i].equalsIgnoreCase("-f")) {
                if (i + 1 < argv.length) {
                    this.targetScript = argv[++i].trim();
                    continue;
                }
                returnCode = this.issueMessage(new Object[]{"-f"}, "OPTION_NEEDS_FOLLOWING_FILENAME", "\"-f\" must be followed by a file name.");
                retval = false;
                break;
            }
            if (argv[i].equalsIgnoreCase("-p")) {
                if (i + 1 < argv.length) {
                    this.propfiles.add(argv[++i].trim());
                    continue;
                }
                returnCode = this.issueMessage(new Object[]{"-p"}, "OPTION_NEEDS_FOLLOWING_FILENAME", "\"-p\" must be followed by a file name.");
                retval = false;
                break;
            }
            if (argv[i].equalsIgnoreCase("-profile")) {
                if (i + 1 < argv.length) {
                    this.profiles.add(argv[++i].trim());
                    continue;
                }
                returnCode = this.issueMessage(new Object[]{"-profile"}, "OPTION_NEEDS_FOLLOWING_FILENAME", "\"-profile\" must be followed by a file name.");
                retval = false;
                break;
            }
            if (argv[i].equalsIgnoreCase("-internalLang")) {
                if (i + 1 >= argv.length) continue;
                internalLang = argv[++i];
                continue;
            }
            if (argv[i].equalsIgnoreCase("-lang")) {
                if (i + 1 >= argv.length) {
                    returnCode = this.issueMessage(new Object[0], "DASH_LANG_NEEDS_FOLLOWING_LANGUAGE", "\"-lang\" must be followed by a language identifier.");
                    retval = false;
                    break;
                }
                this.lang = argv[++i];
                continue;
            }
            if (argv[i].equalsIgnoreCase("-conntype")) {
                if (i + 1 < argv.length) {
                    ++i;
                    if ((i = this.processConnType(argv, i)) >= 0) continue;
                    retval = false;
                    break;
                }
                returnCode = this.issueMessage(new Object[0], "DASH_CONNTYPE_NEEDS_FOLLOWING_CONN", "-conntype must be followed by connection type information.");
                retval = false;
                break;
            }
            if (argv[i].equalsIgnoreCase("-host")) {
                if (i + 1 < argv.length) {
                    this.argHost = argv[++i];
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "HOST_REQUIRES_ARG", "The \"-host\" option requires a host name.");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-ipchost")) {
                if (i + 1 < argv.length) {
                    this.argIPCHost = argv[++i];
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "IPCHOST_REQUIRES_ARG", "The \"-ipchost\" option requires a host name.");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-port")) {
                if (i + 1 < argv.length) {
                    this.argPort = argv[++i];
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "PORT_REQUIRES_ARG", "The \"-port\" option requires a port number.");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-user") || argv[i].equalsIgnoreCase("-username")) {
                if (i + 1 < argv.length) {
                    this.argUser = argv[++i];
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "USER_REQUIRES_ARG", "The \"-user\" option requires a userid.");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-password")) {
                if (i + 1 < argv.length) {
                    this.argPassword = argv[++i];
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "PASSWORD_REQUIRES_ARG", "The \"-password\" option requires a password.");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-wsadmin_classpath")) {
                if (i + 1 < argv.length) {
                    this.argClasspath = argv[++i].trim();
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "CLASSPATH_REQUIRES_ARG", "WASX7299E: \"-wsadmin_classpath\" option must be followed by a classpath.");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-jobid")) {
                if (i + 1 < argv.length) {
                    this.jobid = argv[++i].trim();
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "JOB_ID_REQUIRES_ARG", "WASX7445E: \"-jobId\" option must be followed by a job ID string.");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-tracefile")) {
                if (i + 1 < argv.length) {
                    this.logfile = argv[++i].trim();
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "TRACE_FILE_REQUIRES_ARG", "WASX7446E: \"-tracefile\" option must be followed by a file path.");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-appendtrace")) {
                if (i + 1 < argv.length) {
                    this.appendtrace = argv[++i].trim();
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "APPEND_TRACE_REQUIRES_ARG", "WASX7447E: \"-appendtrace\" option must be followed by a 'true' or 'false'.");
                continue;
            }
            if (argv[i].equals("--")) {
                processingScriptParms = true;
                continue;
            }
            this.scriptParms.add(argv[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseAndValidateInput");
        }
        if (retval) {
            if (this.lang == null && internalLang != null) {
                this.lang = internalLang;
            }
            if (this.lang != null) {
                if (internalLang != null && !internalLang.equalsIgnoreCase(this.lang)) {
                    returnCode = this.issueMessage(new Object[0], "WASX7395E", "You have used both -lang and -internalLang options. However, they do not have the same value. Use either -lang or -internalLang option.");
                    retval = false;
                } else if (internalLang == null && !this.lang.equalsIgnoreCase("jacl") && !this.lang.equalsIgnoreCase("jython")) {
                    returnCode = this.issueMessage(new Object[]{this.lang}, "LANGUAGE_NOT_SUPPORTED", "Language \"" + this.lang + "\" is not supported.");
                    retval = false;
                } else if (!BSFManager.isLanguageRegistered(this.lang)) {
                    returnCode = this.issueMessage(new Object[]{this.lang}, "LANGUAGE_NOT_REGISTERED", "Language \"" + this.lang + "\" is not registered to BSF.");
                    retval = false;
                }
            }
        }
        return retval;
    }

    protected boolean declareBeans(Object defaultbean) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "declareBeans");
        }
        if (this.mgr == null) {
            return false;
        }
        try {
            if (defaultbean != null) {
                this.mgr.declareBean("AdminControl", defaultbean, defaultbean.getClass());
            }
            HelpSupport help = null;
            try {
                help = new HelpSupport(this);
            }
            catch (ScriptingException se) {
                returnCode = this.retcodeFromMessage(se.getMessage());
            }
            if (help != null) {
                this.mgr.declareBean("Help", help, help.getClass());
            } else {
                Tr.debug(tc, "Help is null");
            }
            if (this.configObject == null) {
                this.configObject = new AdminConfigClient(this);
            }
            if (this.configObject != null) {
                this.mgr.declareBean("AdminConfig", this.configObject, this.configObject.getClass());
            } else {
                Tr.debug(tc, "Config is null");
            }
            if (this.appObject == null) {
                this.appObject = new AdminAppClient(this);
            }
            this.mgr.declareBean("AdminApp", this.appObject, this.appObject.getClass());
            if (this.cmdObject == null) {
                this.cmdObject = new AdminCmdClient(this, help, this.mgr);
            } else {
                this.cmdObject.setMgr(this.mgr);
            }
            this.cmdObject.generateAdminCmds();
            ExtensionHelper.processRegisterBeansInExtensions(this.mgr);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "declareBeans");
            }
            return true;
        }
        catch (Exception bsfe) {
            returnCode = this.logAndIssueMessage(new Object[]{"AdminControl", bsfe}, "EXCEPTION_DECLARING_BEAN", "BSFException received declaring \"AdminControl\": " + bsfe, bsfe);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "declareBeans");
            }
            return false;
        }
    }

    protected void executeProfiles() {
        block26: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "executeProfiles");
            }
            if (this.lang != null && this.lang.equalsIgnoreCase("jython")) {
                if (this.argClasspath != null) {
                    System.setProperty("java.class.path", this.saveClasspath);
                }
                Tr.debug(tc, "Set wsadmin objects as a builtin namespace");
                try {
                    this.mgr.exec("jython", "", -1, -1, "from org.python.core import __builtin__");
                    this.mgr.exec("jython", "", -1, -1, "__builtin__.Help = Help");
                    this.mgr.exec("jython", "", -1, -1, "__builtin__.AdminControl = AdminControl");
                    this.mgr.exec("jython", "", -1, -1, "__builtin__.AdminConfig = AdminConfig");
                    this.mgr.exec("jython", "", -1, -1, "__builtin__.AdminApp = AdminApp");
                    this.mgr.exec("jython", "", -1, -1, "__builtin__.AdminTask = AdminTask");
                }
                catch (Exception e) {
                    Tr.debug(tc, "fail to set wsadmin objects as a builtin namespace");
                }
            }
            String propfileProfiles = System.getProperty(PROFILES_PROP);
            int profileIndex = 0;
            if (propfileProfiles != null) {
                propfileProfiles = this.normalizeFQPathName(propfileProfiles);
                StringTokenizer tok = new StringTokenizer(propfileProfiles, File.pathSeparator, false);
                while (tok.hasMoreTokens()) {
                    String prof = tok.nextToken();
                    this.profiles.add(profileIndex, prof);
                    ++profileIndex;
                }
            }
            InputStreamReader in = null;
            if (this.profiles.size() <= 0) break block26;
            for (int i = 0; i < this.profiles.size(); ++i) {
                String profileName;
                block28: {
                    block29: {
                        String profLang;
                        block27: {
                            profileName = (String)this.profiles.get(i);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "processing profile: " + profileName);
                            }
                            profLang = null;
                            try {
                                profLang = BSFManager.getLangFromFilename(profileName);
                            }
                            catch (BSFException bsfe) {
                                if (this.lang == null) {
                                    returnCode = this.issueMessage(new Object[]{profileName}, "CANNOT_FIND_LANG", "Cannot determine scripting language for file: \"" + profileName + "\" -- please specify \"-lang\" option on the command line.");
                                    return;
                                }
                                profLang = this.lang;
                            }
                            if (this.lang != null) break block27;
                            this.lang = profLang;
                            break block28;
                        }
                        if (this.lang.equalsIgnoreCase(profLang)) break block28;
                        if (i >= profileIndex) break block29;
                        File file = new File(profileName);
                        String parent = file.getParent();
                        String sep = File.separator;
                        String name = file.getName();
                        int ext = name.lastIndexOf(".");
                        if (ext <= -1) break block28;
                        StringBuffer buf = new StringBuffer();
                        buf.append(parent);
                        buf.append(sep);
                        buf.append(name.substring(0, ext));
                        if (this.lang.equalsIgnoreCase("jacl")) {
                            buf.append(".jacl");
                        } else if (this.lang.equalsIgnoreCase("jython")) {
                            buf.append(".py");
                        }
                        profileName = buf.toString();
                        if (!tc.isDebugEnabled()) break block28;
                        Tr.debug(tc, "converted profile name: " + profileName);
                        break block28;
                    }
                    returnCode = this.issueMessage(new Object[]{profileName, this.lang}, "WASX7227W", "Profile " + profileName + " is in the wrong language and will not be executed; language used is " + this.lang);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "using language: " + this.lang);
                }
                try {
                    if (this.zos) {
                        String profileEncoding = System.getProperty("profile.encoding");
                        if (profileEncoding != null) {
                            in = new InputStreamReader((InputStream)new FileInputStream(profileName), profileEncoding);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "using encoding: " + profileEncoding);
                            }
                        } else {
                            in = new FileReader(profileName);
                        }
                    } else {
                        in = new FileReader(profileName);
                    }
                    String scriptString = this.getSanitizedScriptString(in);
                    this.mgr.exec(this.lang, profileName, 0, 0, scriptString);
                    continue;
                }
                catch (FileNotFoundException fnfe) {
                    returnCode = this.logAndIssueMessage(new Object[]{profileName}, "FILE_NOT_FOUND", "Cannot find file \"" + profileName + "\"", fnfe);
                    continue;
                }
                catch (IOException ioe) {
                    returnCode = this.logAndIssueMessage(new Object[]{profileName, ioe}, "ERROR_READING_FILE", "Cannot read file \"" + profileName + "\"", ioe);
                    continue;
                }
                catch (BSFException bsfe) {
                    String msg = this.getStringFromException(bsfe);
                    this.logException(bsfe, msg);
                    returnCode = this.issueMessage(new Object[]{profileName, msg}, "ERROR_RUNNING_FILE", "Problem running file \"" + profileName + "\"");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeProfiles");
        }
    }

    protected void showHelp() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showHelp");
        }
        Object[] args = new Object[]{};
        String msg = this.getFormattedMessage("GENERAL_HELP", args, "Syntax: wsadmin [options]");
        System.out.println(msg);
        returnCode = this.retcodeFromMessage(msg);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showHelp");
        }
    }

    protected String getTargetScript() {
        return this.targetScript;
    }

    protected void initializePropFileSet() {
        String tmp1;
        String tmp;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializePropFileSet");
        }
        URL systemPropfile = Thread.currentThread().getContextClassLoader().getResource("wsadmin.properties");
        InputStream is = null;
        if (systemPropfile != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attempting to use resource from classloader");
            }
            try {
                is = systemPropfile.openStream();
                System.getProperties().load(is);
                this.loadedPropfiles.add(systemPropfile.getFile());
            }
            catch (IOException ioe) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "caught exception: " + ioe.toString());
                }
                systemPropfile = null;
            }
        }
        if (systemPropfile == null) {
            String sysfile;
            File propFile;
            String root;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attempting to use user.install.root/properties");
            }
            if ((root = System.getProperty("user.install.root")) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attempting to use was.install.root/properties");
                }
                root = System.getProperty("was.install.root");
            }
            if ((propFile = new File(sysfile = root + File.separator + "properties" + File.separator + "wsadmin.properties")).canRead()) {
                try {
                    System.getProperties().load(new FileInputStream(propFile));
                }
                catch (FileNotFoundException fnfe) {
                    returnCode = this.issueMessage(new Object[]{sysfile}, "FILE_NOT_FOUND", "Cannot find file " + sysfile);
                }
                catch (IOException ioe) {
                    returnCode = this.issueMessage(new Object[]{sysfile, ioe}, "EXCEPTION_LOADING_PROPERTIES_FILE", "Exception received while loading properties file; exception information: " + ioe);
                }
                this.loadedPropfiles.add(propFile.getAbsolutePath());
            }
        }
        if ((tmp = System.getProperty("user.home")) == null) {
            tmp = File.separator;
        } else if (!tmp.endsWith(File.separator)) {
            tmp = tmp + File.separator;
        }
        tmp = tmp + "wsadmin.properties";
        File propFile = new File(tmp);
        if (propFile.canRead()) {
            try {
                System.getProperties().load(new FileInputStream(propFile));
            }
            catch (FileNotFoundException fnfe) {
                returnCode = this.logAndIssueMessage(new Object[]{tmp}, "FILE_NOT_FOUND", "Cannot find file " + tmp, fnfe);
            }
            catch (IOException ioe) {
                returnCode = this.issueMessage(new Object[]{tmp, ioe}, "EXCEPTION_LOADING_PROPERTIES_FILE", "Exception received while loading properties file; exception information: " + ioe);
            }
            this.loadedPropfiles.add(propFile.getAbsolutePath());
        }
        if ((tmp1 = System.getProperty(WSADMIN_PROPERTIES)) != null && tmp1.length() > 0) {
            propFile = new File(tmp1);
            try {
                System.getProperties().load(new FileInputStream(propFile));
            }
            catch (FileNotFoundException fnfe) {
                returnCode = this.logAndIssueMessage(new Object[]{tmp1}, "FILE_NOT_FOUND", "Cannot find file " + tmp1, fnfe);
            }
            catch (IOException ioe) {
                returnCode = this.issueMessage(new Object[]{tmp1, ioe}, "EXCEPTION_LOADING_PROPERTIES_FILE", "Exception received while loading properties file; exception information: " + ioe);
            }
            this.loadedPropfiles.add(propFile.getAbsolutePath());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializePropFileSet");
        }
    }

    protected int retcodeFromMessage(String msg) {
        int ret = 0;
        if (msg.startsWith("WASX")) {
            String intpart = msg.substring(4, 8);
            try {
                ret = Integer.parseInt(intpart);
                ret %= 256;
            }
            catch (NumberFormatException nfe) {
                ret = -1;
            }
        }
        return ret;
    }

    protected void setTrace() {
        String spec = System.getProperty(TRACE_PROP);
        Object appendfile = null;
        if (this.logfile == null) {
            this.logfile = System.getProperty(TRACE_FILE_PROP);
        }
        boolean writeToFile = true;
        if (this.logfile != null && !ManagerAdmin.isLogFileWriteable(this.logfile)) {
            String location = new File(this.logfile).getAbsolutePath();
            returnCode = this.issueMessage(new Object[]{location}, "TRACEFILE_NOT_WRITTABLE", "WASX7448E: The trace file cannot be written to location \"" + location + "\" Please specify a different location with -tracefile option.");
            writeToFile = false;
        }
        if (writeToFile) {
            String traceOutput = null;
            traceOutput = this.logfile != null ? "named file" : "stdout";
            if (this.appendtrace == null) {
                this.appendtrace = System.getProperty(APPEND_TRACE_PROP);
            }
            if (this.appendtrace != null && this.appendtrace.trim().equalsIgnoreCase("true")) {
                ManagerAdmin.configureClientTrace(spec, traceOutput, this.logfile, false, null, false);
            } else {
                ManagerAdmin.configureClientTrace(spec, traceOutput, this.logfile, true, null, false);
            }
        }
    }

    protected void welcome() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "welcome");
        }
        Object[] args = new Object[]{};
        String msg = new String();
        if (this.lang == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "welcome -- no lang.");
            }
            return;
        }
        if (this.lang.equalsIgnoreCase("jacl")) {
            msg = this.getFormattedMessage("JACL_WELCOME_HELP", args, "For help, enter: \"$Help help\"");
        } else if (this.lang.equalsIgnoreCase("javascript")) {
            msg = this.getFormattedMessage("JAVASCRIPT_WELCOME_HELP", args, "For help, enter: \"Help.help()");
        } else if (this.lang.equalsIgnoreCase("jython")) {
            msg = this.getFormattedMessage("JYTHON_WELCOME_HELP", args, "For help, enter: \"Help.help()");
        }
        System.out.println(msg);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "welcome");
        }
    }

    protected boolean timeToGo() {
        boolean ret = true;
        try {
            if (this.configObject != null) {
                ret = !this.configObject.hasChanges();
            }
        }
        catch (ScriptingException se) {
            Tr.audit(tc, "WASX7331I", new Object[]{se.toString()});
        }
        return ret;
    }

    protected void leaving(boolean autosave) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "leaving");
        }
        boolean changes = true;
        try {
            if (Thread.currentThread().equals(this.shutdownHook_Thread) && this.connProps != null && this.connProps.getProperty("type").equalsIgnoreCase("RMI")) {
                String secFlag = this.connProps.getProperty("securityEnabled");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "security flag is " + secFlag);
                }
                if (secFlag != null && secFlag.equalsIgnoreCase("true")) {
                    _client = AdminClientFactory.createAdminClient(this.connProps);
                }
            }
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "leaving: connect to adminservice fail" + e);
            }
            return;
        }
        if (this.configObject != null) {
            try {
                this.configObject.checkService();
            }
            catch (Exception e) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "leaving; config service not running");
                }
                return;
            }
            try {
                changes = this.configObject.hasChanges();
                if (changes) {
                    if (autosave) {
                        this.configObject.save();
                    } else {
                        String script = this.getTargetScript();
                        if (script != null) {
                            Object[] args = new Object[]{script};
                            Tr.audit(tc, "WASX7309W", args);
                            String msg = this.getFormattedMessage("WASX7309W", args, "No \"save\" was performed before the script " + script + " exited; configuration changes will not be saved.");
                            System.out.println(msg);
                        } else {
                            Object[] args = new Object[]{};
                            Tr.audit(tc, "WASX7341W", args);
                            String msg = this.getFormattedMessage("WASX7341W", args, "No \"save\" was performed before the interactive session exited; configuration changes will not be saved.");
                            System.out.println(msg);
                        }
                    }
                }
                this.configObject.reset();
            }
            catch (Exception e) {
                this.setLastException(e);
                String msg = this.getStringFromException(null);
                this.logException(null, msg);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "leaving");
        }
    }

    public static void main(String[] argv) {
        AbstractShell shell = WasxShell.getShell();
        shell.run(argv);
        System.exit(returnCode);
    }

    public void shutdownInit() {
        this.shutdownHook_Thread = new Thread(){

            public void run() {
                WasxShell.this.leaving(false);
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook_Thread);
    }
}

