/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminControlClient;
import com.ibm.ws.scripting.DataSourceCfgHelperProxy;
import com.ibm.ws.scripting.ScriptingException;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;

public class TestConnectionCommand {
    private static TraceComponent tc = Tr.register(TestConnectionCommand.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static final String DATA_STORE_HELPER_PROP = "dataStoreHelperClass";
    private static final String NODE_PROP = "local.node";
    private static final String USER_PROP = "user";
    private static final String PASSWORD_PROP = "password";
    private DataSourceCfgHelperProxy dataSourceCfgHelper = null;
    private AbstractShell _shell = null;
    private AdminClient _client = null;
    private String user = null;
    private String password = null;
    private String configId = null;
    private String implClass = null;
    private String classpath = null;
    private Properties cmdLineProps = null;
    private List supportedProps = null;
    private String type = null;
    private String displayName = null;
    private AttributeList dsAttrList = null;
    private AttributeList providerAttrList = null;

    public TestConnectionCommand(AdminClient client, AbstractShell shell, AdminControlClient control, String id) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TestConnectionCommand");
        }
        this._client = client;
        this._shell = shell;
        this.configId = id;
        this.dataSourceCfgHelper = new DataSourceCfgHelperProxy(this._shell, this._client, control, this.configId);
        if (this.dataSourceCfgHelper == null || !this.dataSourceCfgHelper.isRunning()) {
            this._shell.setAndThrowScriptingException("WASX7215E", "Cannot test: helper not running", new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TestConnectionCommand");
        }
    }

    public Object invoke() throws ScriptingException {
        String ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "testConnection - " + this.configId);
        }
        try {
            Integer result = this.dataSourceCfgHelper.testConnection(this.configId);
            ret = result == 0 ? this._shell.getString("WASX7217I", "Connection to provided data source was successful.") : this._shell.getString("WASX7388E", "Connection to provided data source failed.");
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "testConnection - " + this.configId);
        }
        return ret;
    }
}

