/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.AdminControlClient;
import com.ibm.ws.scripting.ConfigHelper;
import com.ibm.ws.scripting.ScriptingException;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;

public class StopServerCommand {
    private static TraceComponent tc = Tr.register(StopServerCommand.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static final String stopAction = "stop";
    private static final String stopImmediateAction = "stopImmediate";
    private static final String terminateAction = "terminate";
    private static final int MAX_WAIT = 1800000;
    private AbstractShell _shell = null;
    private AdminClient _client = null;
    private ConfigService cfgService = null;
    private AdminConfigClient cfgClient = null;
    private AdminControlClient ctrlClient = null;
    private ConfigHelper cfgHelper = null;
    private ResourceBundle _bundle = null;
    private String serverName = null;
    private String nodeName = null;
    private String domain = null;
    private boolean immediate = false;
    private boolean terminate = false;
    private String connectedProcessType = null;
    private boolean isOverload = false;
    private int statusTimeout = 0;
    private Integer statusPort = null;
    private ServerSocket statusSocket = null;
    private NotificationFilterSupport myFilter = null;

    public StopServerCommand(AdminClient client, AbstractShell shell, AdminControlClient control) throws ScriptingException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "StopServerCommand");
        }
        this._client = client;
        this._shell = shell;
        this.cfgService = AdminConfigClient.getConfigService();
        this.cfgClient = AdminConfigClient.getInstance();
        this.ctrlClient = control;
        this.cfgHelper = this.cfgClient.getConfigHelper();
        this._bundle = this._shell.getBundle();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "StopServerCommand");
        }
    }

    public void setServerName(String sName) {
        this.serverName = sName;
    }

    public void setNodeName(String nName) {
        this.nodeName = nName;
        if (!(this.nodeName == null || this.nodeName.indexOf(" ") < 0 || this.nodeName.startsWith("\"") || this.nodeName.endsWith("\"") || this.nodeName.startsWith("{") || this.nodeName.endsWith("}"))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding quotes to \"" + this.nodeName + "\"");
            }
            this.nodeName = "\"" + this.nodeName + "\"";
        }
    }

    public void setImmediateMode(String imm) {
        if (imm != null && imm.equalsIgnoreCase("immediate")) {
            this.immediate = true;
        }
    }

    public void setActionMode(String action) {
        if (action != null) {
            if (action.equalsIgnoreCase("immediate")) {
                this.immediate = true;
            } else if (action.equalsIgnoreCase(terminateAction)) {
                this.terminate = true;
            }
        }
    }

    public void setConnectedProcessType(String type) {
        this.connectedProcessType = type;
    }

    public void setDomain(String dom) {
        this.domain = dom;
    }

    public void setIsOverload(boolean overload) {
        this.isOverload = overload;
    }

    public Object invoke() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke - " + this.serverName + " " + this.nodeName + " " + this.isOverload);
        }
        String ret = null;
        int status = 0;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invoke stop server using connected type " + this.connectedProcessType);
        }
        try {
            ObjectName on;
            String oName;
            if (this.terminate) {
                String naName;
                if ("UnManagedProcess".equals(this.connectedProcessType) || "ManagedProcess".equals(this.connectedProcessType) || this.connectedProcessType.equals("unknown")) {
                    this._shell.setAndThrowScriptingException("WASX7254E", "stopServer action not supported when process type is " + this.connectedProcessType, new Object[]{"stopServer", this.connectedProcessType});
                }
                if ("DeploymentManager".equals(this.connectedProcessType) || "NodeAgent".equals(this.connectedProcessType)) {
                    naName = this.ctrlClient.completeObjectName(this.domain + ":node=" + this.nodeName + ",type=NodeAgent,*");
                    if (naName == null || naName.trim().length() == 0) {
                        this._shell.setAndThrowScriptingException("WASX7346E", "stopServer action not supported when nodeAgent cannot be located for server " + this.serverName + " of " + "ManagedProcess", new Object[]{this.serverName, "ManagedProcess"});
                    } else {
                        ObjectName oName2 = this.ctrlClient.makeObjectName(naName);
                        String pName = oName2.getKeyProperty("process");
                        if (pName.equals(this.serverName)) {
                            this._shell.setAndThrowScriptingException("WASX7480E", "stopServer terminate action only supported for Managed Processes", new Object[]{terminateAction, "NodeAgent"});
                        }
                    }
                }
                naName = ret = this.stopManagedProcess(this.nodeName, null, terminateAction);
                return naName;
            }
            boolean resolveOverload = this.isOverload;
            while (true) {
                String usedName = "";
                if (this.serverName.indexOf(",") < 0) {
                    if (this.nodeName != null && this.nodeName.trim().length() != 0) {
                        usedName = "node=" + this.nodeName + ",";
                    }
                    usedName = usedName + "type=Server,process=" + this.serverName + ",*";
                } else {
                    usedName = usedName + this.serverName;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "usedName is " + usedName);
                }
                oName = this.ctrlClient.completeObjectName(usedName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "oName is " + oName);
                }
                if (oName != null && oName.length() != 0) break;
                boolean error = true;
                if (resolveOverload) {
                    resolveOverload = false;
                    if (this.nodeName.equalsIgnoreCase("immediate")) {
                        this.immediate = true;
                        this.nodeName = null;
                        error = false;
                    }
                }
                if (!error) continue;
                this._shell.setAndThrowScriptingException("WASX7252E", "Cannot find server " + this.serverName, new Object[]{this.serverName});
            }
            String action = null;
            action = this.immediate ? stopImmediateAction : stopAction;
            String processType = this.ctrlClient.getAttribute(oName, "processType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processType is " + processType);
            }
            if ((on = this.ctrlClient.makeObjectName(oName)) != null) {
                this.nodeName = on.getKeyProperty("node");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName is " + this.nodeName);
            }
            if (!"ManagedProcess".equals(processType)) {
                this.statusPort = this.getFreePort();
                boolean needToWaitForCallback = this.sendWaitStop(on, action);
                String msg = null;
                if (!action.equals(stopImmediateAction)) {
                    msg = this._shell.getFormattedMessage("WASX7337I", new Object[]{this.serverName}, "Invoked stop for server \"" + this.serverName + ";\" Waiting for stop completion.");
                    System.out.println(msg);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "needToWaitForCallback " + needToWaitForCallback);
                }
                status = needToWaitForCallback ? this.waitForServer() : 0;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "got status " + status);
                }
                if (status == 0) {
                    msg = this._shell.getFormattedMessage("WASX7264I", new Object[]{this.serverName, this.nodeName}, "Stop completed for server " + this.serverName + " on node " + this.nodeName);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Stop OK for server " + this.serverName);
                    }
                } else {
                    msg = this._shell.getFormattedMessage("WASX7265W", new Object[]{this.serverName, this.nodeName}, "Stop not completed for server " + this.serverName + " on node " + this.nodeName + ".  The stop process may have timed out.");
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Stop not complete for server " + this.serverName + ", possibly timeout.");
                    }
                }
                ret = msg;
            } else if (on != null) {
                ret = this.stopManagedProcess(this.nodeName, oName, action);
            }
        }
        catch (ScriptingException se) {
            throw se;
        }
        catch (Exception ae) {
            this._shell.setLastException(ae);
            throw new ScriptingException(ae.toString());
        }
        finally {
            if (this.statusSocket != null) {
                try {
                    this.statusSocket.close();
                }
                catch (IOException x) {}
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke - " + this.serverName);
        }
        return ret;
    }

    private Integer getFreePort() throws SocketException, IOException {
        Integer port = null;
        this.statusSocket = new ServerSocket(0);
        this.statusSocket.setSoTimeout(this.statusTimeout);
        port = new Integer(this.statusSocket.getLocalPort());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "got statusport: " + port);
        }
        return port;
    }

    private int waitForServer() {
        Socket acceptedSocket = null;
        boolean statusReceived = false;
        boolean timedOut = false;
        int result = 0;
        while (!statusReceived && !timedOut) {
            try {
                acceptedSocket = this.statusSocket.accept();
            }
            catch (InterruptedIOException e) {
                acceptedSocket = null;
                timedOut = true;
            }
            catch (IOException ioe) {
                Tr.audit(tc, "WASX7338E", new Object[]{this.serverName, ioe.toString()});
                acceptedSocket = null;
                statusReceived = true;
                result = -10;
            }
            if (acceptedSocket == null || (result = this.getStatus(acceptedSocket)) != 0) continue;
            statusReceived = true;
        }
        if (!statusReceived) {
            result = -11;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int getStatus(Socket s) {
        FilterInputStream dataInput;
        InputStream socketInput;
        int status;
        block10: {
            status = -10;
            socketInput = null;
            dataInput = null;
            socketInput = s.getInputStream();
            dataInput = new DataInputStream(socketInput);
            status = ((DataInputStream)dataInput).readInt();
            try {
                dataInput.close();
                socketInput.close();
                break block10;
            }
            catch (IOException e) {
                Tr.audit(tc, "WASX7338E", new Object[]{this.serverName, e.toString()});
            }
            break block10;
            catch (IOException e) {
                int n;
                try {
                    Tr.audit(tc, "WASX7338E", new Object[]{this.serverName, e.toString()});
                    n = -10;
                }
                catch (Throwable throwable) {
                    try {
                        dataInput.close();
                        socketInput.close();
                    }
                    catch (IOException e2) {
                        Tr.audit(tc, "WASX7338E", new Object[]{this.serverName, e2.toString()});
                    }
                    dataInput = null;
                    socketInput = null;
                    throw throwable;
                }
                try {
                    dataInput.close();
                    socketInput.close();
                }
                catch (IOException e3) {
                    Tr.audit(tc, "WASX7338E", new Object[]{this.serverName, e3.toString()});
                }
                dataInput = null;
                socketInput = null;
                return n;
            }
        }
        dataInput = null;
        socketInput = null;
        return status;
    }

    private boolean sendWaitStop(ObjectName ON, String action) throws Exception {
        boolean needToWaitForCallback = true;
        boolean rethrow = false;
        String[] signature = new String[]{"java.lang.Boolean", "java.lang.Integer"};
        Object[] params = new Object[]{new Boolean(true), this.statusPort};
        try {
            if (action.equals(stopImmediateAction)) {
                String name = ON.toString();
                this.ctrlClient.invoke(name, action);
                needToWaitForCallback = false;
            } else {
                String connectedServerHost = this.ctrlClient.getHost();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "connectedServer Host: " + connectedServerHost);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "connectedProcessType: " + this.connectedProcessType);
                }
                if ("AdminAgent".equals(this.connectedProcessType)) {
                    Object[] params2 = new Object[]{connectedServerHost, this.statusPort};
                    String[] signature2 = new String[]{"java.lang.String", "java.lang.Integer"};
                    this.ctrlClient.invoke_jmx(ON, action, params2, signature2);
                } else {
                    this.ctrlClient.invoke_jmx(ON, action, params, signature);
                }
            }
        }
        catch (Exception e1) {
            try {
                this.ctrlClient.isAlive();
                rethrow = true;
                throw e1;
            }
            catch (Exception e2) {
                if (rethrow) {
                    throw e2;
                }
                needToWaitForCallback = false;
            }
        }
        return needToWaitForCallback;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String stopManagedProcess(String nodeName, String oName, String action) throws Exception {
        String ret;
        block20: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stopManagedProcess: nodeName " + nodeName + " action " + action);
            }
            ObjectName nodeAgentName = null;
            ret = null;
            try {
                String msg;
                block22: {
                    block21: {
                        String naName = this.ctrlClient.completeObjectName(this.domain + ":node=" + nodeName + ",type=NodeAgent,*");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "naName is " + naName);
                        }
                        if (naName == null || naName.trim().length() == 0) {
                            this._shell.setAndThrowScriptingException("WASX7346E", "stopServer action not supported when nodeAgent cannot be located for server " + this.serverName + " of " + "ManagedProcess" + " process type", new Object[]{this.serverName, "ManagedProcess"});
                        }
                        nodeAgentName = new ObjectName(naName);
                        this.myFilter = new NotificationFilterSupport();
                        this.myFilter.enableType("websphere.process.stopped");
                        this.myFilter.enableType("websphere.process.failed");
                        this.myFilter.enableType("websphere.process.not.monitored");
                        this._client.addNotificationListener(nodeAgentName, this.ctrlClient, (NotificationFilter)this.myFilter, null);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "About to invoke stopServer " + action + " for server " + this.serverName);
                        }
                        if (this.terminate) {
                            this.ctrlClient.invoke(naName, action, this.serverName);
                        } else {
                            this.ctrlClient.invoke(oName, action);
                        }
                        msg = this._shell.getFormattedMessage("WASX7337I", new Object[]{this.serverName}, "Invoked stop for server \"" + this.serverName + ";\" Waiting for stop completion.");
                        System.out.println(msg);
                        Vector<String> types2 = new Vector<String>();
                        types2.addElement("websphere.process.stopped");
                        types2.addElement("websphere.process.failed");
                        types2.addElement("websphere.process.not.monitored");
                        boolean done = this.ctrlClient.waitForCompletion(types2, 1800000);
                        if (!done) break block21;
                        if (this.ctrlClient.isProcessMonitored()) {
                            msg = this._shell.getFormattedMessage("WASX7264I", new Object[]{this.serverName, nodeName}, "Stop completed for server " + this.serverName + " on node " + nodeName);
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Stop OK for server " + this.serverName);
                            }
                            break block22;
                        } else {
                            msg = this._shell.getFormattedMessage("WASX7443I", new Object[]{this.serverName, nodeName}, "Server " + this.serverName + " on node " + nodeName + " is not being monitored. Please verify that the server has stopped before continuing.");
                        }
                        break block22;
                    }
                    msg = this._shell.getFormattedMessage("WASX7265W", new Object[]{this.serverName, nodeName}, "Stop not completed for server " + this.serverName + " on node " + nodeName + ".  The stop process may have timed out.");
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Server stop not complete; possibly timed out.");
                    }
                }
                ret = msg;
                if (nodeAgentName == null) break block20;
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (nodeAgentName == null) throw throwable;
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "removing notif list. in finally");
                        }
                        this._client.removeNotificationListener(nodeAgentName, this.ctrlClient);
                        throw throwable;
                    }
                    catch (Exception e2) {
                        this._shell.setLastException(e2);
                        throw new ScriptingException(e2.toString());
                    }
                }
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removing notif list. in finally");
                }
                this._client.removeNotificationListener(nodeAgentName, this.ctrlClient);
            }
            catch (Exception e) {
                this._shell.setLastException(e);
                throw new ScriptingException(e.toString());
            }
        }
        if (!tc.isEntryEnabled()) return ret;
        Tr.exit(tc, "stopManagedProcess");
        return ret;
    }
}

