/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.scripting.ConfigHelper;
import com.ibm.ws.scripting.ScriptingException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ObjectNameHelper {
    private static TraceComponent tc = Tr.register(ConfigHelper.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static ResourceBundle bundle = ResourceBundle.getBundle("com.ibm.ws.scripting.resources.wscpMessage", Locale.getDefault());
    private static String DOMAIN = "WebSphere";

    public static String getListingName(ObjectName on) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getListingName");
        }
        String ret = null;
        if (on != null) {
            String displayName = on.getKeyProperty("_Websphere_Config_Data_Display_Name");
            String configId = on.getKeyProperty("_Websphere_Config_Data_Id");
            ret = displayName != null ? displayName + "(" + configId + ")" : "(" + configId + ")";
            if (ret.indexOf(" ") >= 0) {
                ret = "\"" + ret + "\"";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getListingName");
        }
        return ret;
    }

    public static Hashtable parseObjectIdString(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseObjectIdString: " + name);
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (name != null) {
            if (name.startsWith("\"") && name.endsWith("\"")) {
                name = name.substring(1, name.length() - 1);
            }
            String displayName = null;
            String configId = null;
            if (!name.endsWith(")")) {
                throw new ScriptingException(ObjectNameHelper.getFormattedMessage("WASX7077E", "incomplete config id", new Object[]{name}));
            }
            int end = name.lastIndexOf("(");
            if (end < 0) {
                throw new ScriptingException(ObjectNameHelper.getFormattedMessage("WASX7078E", "missing config id", new Object[]{name}));
            }
            int start = name.indexOf("(");
            if (start != end) {
                if (name.indexOf("cells/") > 0) {
                    end = name.lastIndexOf("(cells/");
                } else if (name.indexOf("templates/") > 0) {
                    end = name.lastIndexOf("(templates/");
                }
            }
            configId = name.substring(end + 1, name.length() - 1);
            if (end > 0) {
                displayName = name.substring(0, end);
            }
            table.put("_Websphere_Config_Data_Id", configId);
            if (displayName != null) {
                table.put("_Websphere_Config_Data_Display_Name", displayName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseObjectIdString:");
        }
        return table;
    }

    public static ObjectName stringToObjectName(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToObjectName: " + name);
        }
        ObjectName ret = null;
        Hashtable table = ObjectNameHelper.parseObjectIdString(name);
        if (table.size() > 0) {
            try {
                ret = new ObjectName(DOMAIN, table);
            }
            catch (MalformedObjectNameException ex) {
                throw new ScriptingException(ObjectNameHelper.getFormattedMessage("MALFORMED_OBJECT_NAME", "Malformed object name", new Object[]{table.toString()}));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToObjectName:");
        }
        return ret;
    }

    public static ObjectName makeObjectName(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeObjectName");
        }
        ObjectName tempON = null;
        try {
            if (name == null || name.trim().equals("")) {
                throw new ScriptingException(ObjectNameHelper.getFormattedMessage("MALFORMED_OBJECT_NAME", "Malformed object name", new Object[]{name}));
            }
            if (name.startsWith("\"") && name.endsWith("\"")) {
                name = name.substring(1, name.length() - 1);
            }
            if (name != null && name.indexOf("=") > 0) {
                if (name.indexOf(":") < 0) {
                    name = DOMAIN + ":" + name;
                }
                tempON = new ObjectName(name);
            } else {
                tempON = ObjectNameHelper.stringToObjectName(name);
            }
        }
        catch (MalformedObjectNameException mone) {
            throw new ScriptingException(ObjectNameHelper.getFormattedMessage("MALFORMED_OBJECT_NAME", "Malformed object name", new Object[]{name}));
        }
        catch (Exception ae) {
            throw new ScriptingException(ae.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeObjectName");
        }
        return tempON;
    }

    public static String getFormattedMessage(String key, String defaultString, Object[] args) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFormattedMessage");
        }
        if (key == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage - default");
            }
            return defaultString;
        }
        try {
            String result = bundle.getString(key);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage");
            }
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage - default");
            }
            return MessageFormat.format(defaultString, args);
        }
        catch (NullPointerException npe) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage - default");
            }
            return defaultString;
        }
    }
}

