/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.scripting.ConfigHelper;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.compat.StringPropertiesEditor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class LanguageUtilities {
    public static String OPENOPTIONSYNTAX = "(";
    public static String CLOSEOPTIONSYNTAX = ")";
    protected static StringBuffer debugbuf = null;
    protected static String staticText = null;
    private static TraceComponent tc = Tr.register(LanguageUtilities.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private ResourceBundle bundle = null;
    protected String nl = System.getProperty("line.separator");

    public LanguageUtilities(ResourceBundle b) {
        this.bundle = b;
    }

    protected Properties stringToProperties(String valueStr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToProperties");
        }
        if (valueStr == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stringToProperties");
            }
            return new Properties();
        }
        StringPropertiesEditor ed = new StringPropertiesEditor();
        try {
            ed.setAsText(valueStr);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stringToProperties");
            }
        }
        return (Properties)ed.getValue();
    }

    public String propertiesToString(Properties input) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propertiesToString");
        }
        if (input == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "propertiesToString");
            }
            return new String();
        }
        StringPropertiesEditor ed = new StringPropertiesEditor();
        ed.setValue(input);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertiesToString");
        }
        return ed.getAsText();
    }

    public Properties stringToPropertiesForAdminTask(String valueStr, boolean isBraceSupported) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToProperties");
        }
        if (valueStr == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stringToProperties");
            }
            return new Properties();
        }
        StringPropertiesEditor ed = new StringPropertiesEditor();
        try {
            ed.setAsText(valueStr);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stringToProperties");
            }
        }
        return (Properties)ed.getValue();
    }

    public String propertiesToStringForAdminTask(Properties input) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propertiesToString");
        }
        if (input == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "propertiesToString");
            }
            return new String();
        }
        StringPropertiesEditor ed = new StringPropertiesEditor();
        ed.setValue(input);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertiesToString");
        }
        return ed.getAsText();
    }

    public String attributeListToString(AttributeList alist) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeListToString");
        }
        StringBuffer buf = new StringBuffer();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "size of list is " + alist.size());
        }
        for (int i = 0; i < alist.size(); ++i) {
            buf.append("\"");
            buf.append(((Attribute)alist.get(i)).getName());
            buf.append("=");
            buf.append(((Attribute)alist.get(i)).getValue());
            buf.append("\"");
            if (i >= alist.size() - 1) continue;
            buf.append(", ");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeListToString -- returning " + buf.toString());
        }
        return buf.toString();
    }

    public String setToString(Collection input) {
        return this.setToString(input, true);
    }

    public String setToString(Collection input, boolean sorting) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setToString");
        }
        StringBuffer buf = new StringBuffer();
        if (input == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setToString");
            }
            return new String();
        }
        Object[] array = input.toArray();
        if (sorting) {
            this.sortArray(array);
        }
        for (int i = 0; i < array.length; ++i) {
            String part = array[i].toString();
            buf.append("\"" + part + "\"");
            if (i >= array.length - 1) continue;
            buf.append(", ");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setToString");
        }
        return buf.toString();
    }

    public String[] stringToStringArray(String input) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToStringArray - input " + input);
        }
        String[] result = null;
        if (input != null) {
            StringTokenizer tok = new StringTokenizer(input, ",");
            result = new String[tok.countTokens()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = tok.nextToken().trim();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "found token: \"" + result[i] + "\"");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToStringArray", result.toString());
        }
        return result;
    }

    public Hashtable optionsToHashtable(String options) {
        if (tc.isEntryEnabled()) {
            if (options.toLowerCase().indexOf("password") == -1 && options.toLowerCase().indexOf("pwd") == -1 && options.toLowerCase().indexOf("passwd") == -1) {
                Tr.entry(tc, "optionsToHashtable -- " + options);
            } else {
                String[] optionsArray = options.split(" ");
                StringBuffer buf = new StringBuffer();
                boolean passwordFlag = false;
                for (int i = 0; i < optionsArray.length; ++i) {
                    String temp = optionsArray[i];
                    if (!(temp.toLowerCase().indexOf("password") == -1 && temp.toLowerCase().indexOf("pwd") == -1 && temp.toLowerCase().indexOf("passwd") == -1 || passwordFlag)) {
                        passwordFlag = true;
                        buf.append(temp);
                    } else if (passwordFlag) {
                        buf.append("*****");
                        passwordFlag = false;
                    } else {
                        buf.append(temp);
                    }
                    buf.append(" ");
                }
                Tr.entry(tc, "optionsToHashtable -- " + buf.toString());
            }
        }
        debugbuf = new StringBuffer();
        staticText = options;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        options = this.cleanAttributeString(options);
        StringTokenizer strtok = new StringTokenizer(options, this.getTokenizerString(), true);
        String next = "";
        String key = null;
        Object value = null;
        try {
            if (strtok.hasMoreTokens()) {
                next = strtok.nextToken();
                debugbuf.append(next);
            }
            do {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Top: next: \"" + next + "\"");
                }
                if (next.trim().equals("")) {
                    try {
                        next = this.skipSpaces(strtok);
                    }
                    catch (IllegalArgumentException e) {
                        break;
                    }
                }
                if (!next.startsWith("-")) {
                    this.throwIllegalArgException("WASX7122E", "-", key, value, options);
                }
                while (next.startsWith("-")) {
                    key = next.substring(1);
                    next = this.addOptionValue(strtok, key, ht);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "added option value...");
                }
                if (!strtok.hasMoreTokens()) continue;
                next = strtok.nextToken(this.getTokenizerString());
                debugbuf.append(next);
                if (!next.equals(" ")) continue;
                try {
                    next = this.skipSpaces(strtok);
                }
                catch (IllegalArgumentException e) {
                    break;
                }
                debugbuf.append(next);
            } while (strtok.hasMoreTokens());
            if (next.startsWith("-")) {
                key = next.substring(1);
                ht.put(key, new String());
            }
        }
        catch (NoSuchElementException nsee) {
            nsee.printStackTrace();
            throw new IllegalArgumentException(nsee.getMessage());
        }
        finally {
            debugbuf = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "optionsToHashtable");
        }
        return ht;
    }

    protected String addOptionValue(StringTokenizer strtok, String key, Hashtable ht) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addOptionValue: " + key);
        }
        Object result = new String();
        ArrayList<List> listval = new ArrayList<List>();
        String next = new String();
        try {
            while (strtok.hasMoreTokens()) {
                next = strtok.nextToken();
                debugbuf.append(next);
                if (next.equals(" ")) {
                    try {
                        next = this.skipSpaces(strtok);
                        debugbuf.append(next);
                    }
                    catch (IllegalArgumentException e) {
                        break;
                    }
                }
                if (!next.startsWith("-") || key.equals("target")) {
                    String val;
                    if (key.equals("target") && next.startsWith("-")) {
                        if (next.toLowerCase().startsWith("-websphere")) {
                            String temp = this.getString(strtok, next);
                            result = temp;
                            next = temp.substring(1);
                            continue;
                        }
                    } else if (!next.equals("{")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "value not a list");
                        }
                        val = this.getString(strtok, next);
                        result = val;
                    } else {
                        if (strtok.hasMoreTokens()) {
                            next = strtok.nextToken();
                        }
                        debugbuf.append(next);
                        if (next.equals(" ")) {
                            next = this.skipSpaces(strtok);
                            debugbuf.append(next);
                        }
                        if (!next.equals("{")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "val is not a list but starts with a {");
                            }
                            val = this.getString(strtok, "{", false);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "val is " + val);
                            }
                            result = next + val;
                            if (key.equals("delete") && tc.isDebugEnabled()) {
                                Tr.debug(tc, "delete option is provided");
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "result is " + result);
                            }
                            next = "}";
                        } else {
                            while (next.equals("{")) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "value a list");
                                }
                                List l = this.getList(strtok);
                                listval.add(l);
                                if (!strtok.hasMoreTokens()) break;
                                next = strtok.nextToken(this.getTokenizerString());
                                debugbuf.append(next);
                                if (next.equals(" ")) {
                                    next = this.skipSpaces(strtok);
                                    debugbuf.append(next);
                                }
                                if (!next.equals("}")) continue;
                                break;
                            }
                            result = listval;
                        }
                    }
                }
                break;
            }
        }
        catch (NoSuchElementException nsee) {
            nsee.printStackTrace();
            throw new IllegalArgumentException(nsee.getMessage());
        }
        if (key.equals("custom")) {
            Object value = ht.get(key);
            Vector<String> customValue = value == null ? new Vector<String>() : (Vector<String>)value;
            customValue.addElement((String)result);
            ht.put(key, customValue);
        } else {
            ht.put(key, result);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "next: " + next);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addOptionValue: " + result);
        }
        return next;
    }

    public List getList(StringTokenizer strtok) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getList");
        }
        ArrayList<String> lst = new ArrayList<String>();
        String next = null;
        try {
            while (strtok.hasMoreTokens()) {
                String element;
                next = strtok.nextToken(this.getTokenizerString());
                debugbuf.append(next);
                if (next.equals(" ")) {
                    next = this.skipSpaces(strtok);
                    debugbuf.append(next);
                }
                if (next.equals(this.getOpenNestedAttribute())) {
                    element = this.getString(strtok, next);
                    lst.add(element);
                    continue;
                }
                if (!next.equals(this.getCloseNestedAttribute())) {
                    element = this.getString(strtok, next);
                    lst.add(element);
                    continue;
                }
                break;
            }
        }
        catch (NoSuchElementException nsee) {
            nsee.printStackTrace();
            throw new IllegalArgumentException(nsee.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getList - next is " + next);
        }
        return lst;
    }

    public Hashtable stringToHashtable(String text) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToHashtable string: " + text);
        }
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        boolean outermost = false;
        if (debugbuf == null) {
            outermost = true;
            debugbuf = new StringBuffer();
            staticText = text;
        }
        if (!text.startsWith("{") || !text.endsWith("}")) {
            text = "{" + text + "}";
        }
        StringTokenizer strtok = new StringTokenizer(text, "{} ", true);
        try {
            while (strtok.hasMoreTokens()) {
                String next = strtok.nextToken(this.getTokenizerString());
                debugbuf.append(next);
                if (next.equals("{")) {
                    String key = this.getString(strtok, " ");
                    String value = this.getString(strtok, " ");
                    while (strtok.hasMoreTokens()) {
                        next = strtok.nextToken();
                        debugbuf.append(next);
                        if (next.equals(" ")) continue;
                    }
                    if (!next.equals("}")) {
                        Tr.event(tc, "Expected '}' not found");
                        this.throwIllegalArgException("WASX7122E", next, key, value, text);
                    }
                    if (value.startsWith("{")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New key: " + key + " (table)");
                        }
                        Hashtable embedded = this.stringToHashtable(value);
                        ht.put(key, embedded);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "size of table is now " + ht.size());
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New key: " + key + " = " + value);
                    }
                    ht.put(key, value);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "size of table is now " + ht.size());
                    continue;
                }
                if (next.equals(" ")) continue;
                this.throwIllegalArgException("WASX7121E", next, "", "", text);
            }
        }
        catch (NoSuchElementException nsee) {
            nsee.printStackTrace();
            throw new IllegalArgumentException();
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        finally {
            if (outermost) {
                debugbuf = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToHashtable");
        }
        return ht;
    }

    public AttributeList stringToAttributeList(String text) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToAttributeList string: " + text);
        }
        boolean outermost = false;
        if (debugbuf == null) {
            outermost = true;
            debugbuf = new StringBuffer();
            staticText = text;
        }
        AttributeList al = new AttributeList();
        StringTokenizer strtok = new StringTokenizer(text, "{} ", true);
        try {
            while (strtok.hasMoreTokens()) {
                String next = strtok.nextToken(this.getTokenizerString());
                debugbuf.append(next);
                if (next.equals("{")) {
                    String key = this.getString(strtok, " ");
                    String value = this.getString(strtok, " ");
                    while (strtok.hasMoreTokens()) {
                        next = strtok.nextToken();
                        debugbuf.append(next);
                        if (next.equals(" ")) continue;
                    }
                    if (!next.equals("}")) {
                        Tr.event(tc, "debugbuf is \"" + debugbuf.toString() + "\"");
                        this.throwIllegalArgException("WASX7122E", "}", key, value, text);
                    }
                    if (value.startsWith("{{") && value.endsWith("}}")) {
                        ArrayList arl = this.createArrayList(value);
                        al.add(new Attribute(key, arl));
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "size of list is now " + al.size());
                        continue;
                    }
                    if (value.startsWith("{") && value.endsWith("}")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New attribute: " + key + " (list)");
                        }
                        AttributeList embeddedAL = this.stringToAttributeList(value);
                        al.add(new Attribute(key, embeddedAL));
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "size of list is now " + al.size());
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New attribute: " + key + " = " + value);
                    }
                    al.add(new Attribute(key, value));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "size of list is now " + al.size());
                    continue;
                }
                if (next.equals(" ")) continue;
                Tr.event(tc, "debugbuf is \"" + debugbuf.toString() + "\"");
                this.throwIllegalArgException("WASX7121E", next, "", "", text);
            }
        }
        catch (NoSuchElementException nsee) {
            nsee.printStackTrace();
            throw new IllegalArgumentException();
        }
        finally {
            if (outermost) {
                debugbuf = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToAttributeList");
        }
        return al;
    }

    public ArrayList stringToArrayList(String text) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToArrayList string: " + text);
        }
        boolean outermost = false;
        StringTokenizer strtok = null;
        StringBuffer buf = new StringBuffer();
        String input = text;
        if (debugbuf == null) {
            outermost = true;
            debugbuf = new StringBuffer();
            staticText = text;
        }
        ArrayList<String> al = new ArrayList<String>();
        if (text.startsWith("{") && text.endsWith("}")) {
            input = text.substring(1, text.length() - 1);
        }
        strtok = input.indexOf("{") >= 0 ? new StringTokenizer(text, "{} ", true) : new StringTokenizer(input, " ", true);
        try {
            while (strtok.hasMoreTokens()) {
                String element;
                String next = strtok.nextToken(this.getTokenizerString());
                debugbuf.append(next);
                if (next.equals(" ")) {
                    next = this.skipSpaces(strtok);
                    debugbuf.append(next);
                }
                if (next.equals(this.getOpenNestedAttribute())) {
                    element = this.getString(strtok, next);
                    al.add(element);
                    continue;
                }
                if (next.equals(this.getCloseNestedAttribute())) {
                    break;
                }
                element = this.getString(strtok, next);
                if (element.toString().indexOf(" ") != -1) {
                    element = "\"" + element + "\"";
                }
                al.add(element);
            }
        }
        catch (NoSuchElementException nsee) {
            nsee.printStackTrace();
            throw new IllegalArgumentException();
        }
        finally {
            if (outermost) {
                debugbuf = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToArrayList");
        }
        return al;
    }

    public List stringToList(String text) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToList string: " + text);
        }
        boolean outermost = false;
        StringTokenizer strtok = null;
        StringBuffer buf = new StringBuffer();
        String input = text;
        if (debugbuf == null) {
            outermost = true;
            debugbuf = new StringBuffer();
            staticText = text;
        }
        ArrayList<String> al = new ArrayList<String>();
        if (text.startsWith("{") && text.endsWith("}")) {
            input = text.substring(1, text.length() - 1);
        }
        strtok = input.indexOf("{") >= 0 ? new StringTokenizer(text, "{} ", true) : new StringTokenizer(input, " ", true);
        try {
            while (strtok.hasMoreTokens()) {
                String element;
                String next = strtok.nextToken(this.getTokenizerString());
                debugbuf.append(next);
                if (next.equals(" ")) {
                    next = this.skipSpaces(strtok);
                    debugbuf.append(next);
                }
                if (next.equals(this.getOpenNestedAttribute())) {
                    element = this.getString(strtok, next);
                    al.add(element);
                    continue;
                }
                if (next.equals(this.getCloseNestedAttribute())) {
                    break;
                }
                element = this.getString(strtok, next);
                if (element.toString().indexOf(" ") != -1) {
                    element = "\"" + element + "\"";
                }
                al.add(element);
            }
        }
        catch (NoSuchElementException nsee) {
            nsee.printStackTrace();
            throw new IllegalArgumentException();
        }
        finally {
            if (outermost) {
                debugbuf = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToList");
        }
        return al;
    }

    public String[] createArgSettingCommands(Collection scriptParms) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createArgSettingCommands");
        }
        String list = this.setToString(scriptParms, false);
        String[] commands = new String[2];
        StringBuffer buf = new StringBuffer();
        buf.append("argv = '");
        buf.append(list);
        buf.append("';");
        commands[0] = buf.toString();
        commands[1] = new String("argc = " + scriptParms.size() + ";");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createArgSettingCommands");
        }
        return commands;
    }

    public String getOpenNestedAttribute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOpenNestedAttribute");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOpenNestedAttribute");
        }
        return "\"";
    }

    public String getCloseNestedAttribute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCloseNestedAttribute");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCloseNestedAttribute");
        }
        return "\"";
    }

    public String getTokenizerString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenizerString");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenizerString");
        }
        return "{}\" ";
    }

    public String addQuotes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQuotes");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQuotes");
        }
        return "\"";
    }

    public String removeQuotes(String str) {
        String data;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeQuotes");
        }
        if ((data = new String(str)).startsWith("\"") && data.endsWith("\"")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removing quotes from \"" + data + "\"");
            }
            data = data.substring(1, data.length() - 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeQuotes");
        }
        return data;
    }

    public boolean isStringWithQuotes(String data) {
        boolean ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isStringWithQuote");
        }
        boolean bl = ret = data.startsWith("\"") && data.endsWith("\"");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isStringWithQuote - " + ret);
        }
        return ret;
    }

    public String attributeToString(String name, String val) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeToString", new Object[]{name, val});
        }
        StringBuffer buf = new StringBuffer();
        buf.append("\"");
        buf.append(name);
        buf.append("=");
        buf.append(val);
        buf.append("\"");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeToString " + buf.toString());
        }
        return buf.toString();
    }

    public String arrayListToString(ArrayList list, ConfigHelper configHelper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "arrayListToString ");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("\"");
        for (int j = 0; j < list.size(); ++j) {
            Object val = list.get(j);
            if (val != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Type of value is " + val.getClass().getName());
                }
                if (val instanceof ObjectName) {
                    buf.append(configHelper.getListingName((ObjectName)val));
                } else {
                    buf.append(val.toString());
                }
            } else {
                buf.append("\"\"");
            }
            if (j + 1 >= list.size()) continue;
            buf.append(" ");
        }
        buf.append("\"");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "arrayListToString " + buf.toString());
        }
        return buf.toString();
    }

    public String stringArrayToString(Object oval) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringArrayToString");
        }
        String sval = null;
        if (oval == null) {
            sval = "\"\"";
        } else if (oval instanceof List) {
            StringBuffer buf = new StringBuffer();
            List l = (List)oval;
            for (int i = 0; i < l.size(); ++i) {
                buf.append(l.get(i).toString());
                if (i >= l.size() - 1) continue;
                buf.append(";");
            }
            buf.append("\"");
            sval = buf.toString();
        } else {
            sval = oval.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringArrayToString " + sval);
        }
        return sval;
    }

    public String integerArrayToString(Object oval) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "integerArrayToString");
        }
        String sval = null;
        if (oval == null) {
            sval = "\"\"";
        } else if (oval instanceof List) {
            StringBuffer buf = new StringBuffer();
            List l = (List)oval;
            for (int i = 0; i < l.size(); ++i) {
                buf.append(l.get(i).toString());
                if (i >= l.size() - 1) continue;
                buf.append(" ");
            }
            sval = buf.toString();
        } else {
            sval = oval.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringArrayToString " + sval);
        }
        return sval;
    }

    public String cleanAttributeString(String attr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanAttributeString");
        }
        if (tc.isEntryEnabled()) {
            if (attr.toLowerCase().indexOf("password") == -1 && attr.toLowerCase().indexOf("pwd") == -1 && attr.toLowerCase().indexOf("passwd") == -1) {
                Tr.exit(tc, "cleanAttributeString -- " + attr);
            } else {
                String[] attrArray = attr.split(" ");
                StringBuffer buf = new StringBuffer();
                boolean passwordFlag = false;
                for (int i = 0; i < attrArray.length; ++i) {
                    String temp = attrArray[i];
                    if (!(temp.toLowerCase().indexOf("password") == -1 && temp.toLowerCase().indexOf("pwd") == -1 && temp.toLowerCase().indexOf("passwd") == -1 || passwordFlag)) {
                        passwordFlag = true;
                        buf.append(temp);
                    } else if (passwordFlag) {
                        buf.append("*****");
                        passwordFlag = false;
                    } else {
                        buf.append(temp);
                    }
                    buf.append(" ");
                }
                Tr.exit(tc, "cleanAttributeString -- " + buf.toString());
            }
        }
        return attr;
    }

    protected ArrayList createArrayList(String text) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createArrayList string: " + text);
        }
        ArrayList<AttributeList> al = new ArrayList<AttributeList>();
        StringBuffer buf = new StringBuffer();
        StringTokenizer strtok = new StringTokenizer(text, this.getOpenNestedAttribute() + this.getCloseNestedAttribute() + " ", true);
        while (true) {
            int nestlevel = 0;
            if (!strtok.hasMoreTokens()) break;
            String next = strtok.nextToken();
            debugbuf.append(next);
            if (next.equals(" ")) {
                next = this.skipSpaces(strtok);
                debugbuf.append(next);
            }
            if (next.equals(this.getOpenNestedAttribute())) {
                ++nestlevel;
            } else {
                Tr.warning(tc, "TBD - do something here!");
            }
            boolean foundList = false;
            while (strtok.hasMoreTokens()) {
                next = strtok.nextToken();
                debugbuf.append(next);
                buf.append(next);
                if (next.equals(this.getOpenNestedAttribute())) {
                    ++nestlevel;
                    continue;
                }
                if (!next.equals(this.getCloseNestedAttribute()) || --nestlevel != 0) continue;
                buf.deleteCharAt(buf.length() - 1);
                foundList = true;
                break;
            }
            if (!foundList) break;
            AttributeList attrl = this.stringToAttributeList(buf.toString());
            buf = new StringBuffer();
            al.add(attrl);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "size of ArrayList is now " + al.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createArrayList");
        }
        return al;
    }

    protected String getString(StringTokenizer strtok, String next) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getString next: \"" + next + "\"");
        }
        String value = this.getString(strtok, next, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getString -> " + value);
        }
        return value;
    }

    protected String getString(StringTokenizer strtok, String next, boolean trim) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getString next: \"" + next + "\"");
        }
        String value = null;
        try {
            if (next.equals(" ")) {
                next = this.skipSpaces(strtok);
                debugbuf.append(next);
            }
            if (next.equals("{")) {
                value = "";
                int nested = 1;
                while (nested > 0) {
                    next = strtok.nextToken("{}");
                    debugbuf.append(next);
                    if (next.equals("{")) {
                        ++nested;
                    } else if (next.equals("}")) {
                        --nested;
                    }
                    if (nested <= 0) continue;
                    value = value + next;
                }
            } else if (next.equals("}")) {
                Tr.event(tc, "Unexpected '}' found");
                this.throwIllegalArgException("WASX7123E", "}", "", "", next);
            } else if (next.equals("\"")) {
                StringBuffer buf = new StringBuffer();
                boolean foundEnd = false;
                while (strtok.hasMoreTokens()) {
                    next = strtok.nextToken();
                    debugbuf.append(next);
                    if (next.equals("\"")) {
                        foundEnd = true;
                        break;
                    }
                    buf.append(next);
                }
                if (!foundEnd) {
                    this.throwIllegalArgException("WASX7122E", "\"", "", "", next);
                }
                value = buf.toString();
            } else {
                value = next;
            }
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalArgumentException(nsee.getMessage());
        }
        if (trim) {
            value = value.trim();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getString -> " + value);
        }
        return value;
    }

    protected String skipSpaces(StringTokenizer strtok) throws IllegalArgumentException {
        String next;
        try {
            while ((next = strtok.nextToken()) != null && next.equals(" ")) {
                debugbuf.append(next);
            }
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalArgumentException(nsee.getMessage());
        }
        return next;
    }

    protected void throwIllegalArgException(String key, String subst, String type, String value, String input) {
        String msg = null;
        String result = this.bundle.getString(key);
        Object[] args = null;
        if (debugbuf != null) {
            int len = debugbuf.length();
            StringBuffer tb = new StringBuffer();
            if (staticText != null) {
                for (int i = 0; i < len - 1; ++i) {
                    tb.append(" ");
                }
                tb.append("^");
            } else {
                staticText = "Attribute=" + type + " had invalid value=" + value + " for input parameter=" + input;
            }
            args = new Object[]{subst, this.nl + staticText + this.nl + tb.toString()};
        }
        msg = MessageFormat.format(result, args);
        debugbuf = null;
        throw new IllegalArgumentException(msg);
    }

    protected void sortArray(Object[] values) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sortArray");
        }
        for (int i = 0; i < values.length; ++i) {
            for (int j = i + 1; j < values.length; ++j) {
                if (values[j].toString().compareTo(values[i].toString()) >= 0) continue;
                Object temp = values[j];
                values[j] = values[i];
                values[i] = temp;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sortArray");
        }
    }

    public String objectArrayToString(Object[] attrs) {
        return attrs.toString();
    }

    public String buildAdminCmdString(String scriptingObject, String cmdName, String targetObject, String params, String steps) {
        return scriptingObject + " " + targetObject + " " + OPENOPTIONSYNTAX + params + " " + steps + CLOSEOPTIONSYNTAX;
    }

    public Object stringToObjectArray(String inputString, Class objectClass) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToObjectArray");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToObjectArray");
        }
        return new Object();
    }

    public String hashtableToString(Hashtable input, boolean verbose) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hashtableToString");
        }
        StringBuffer buf = new StringBuffer();
        if (input != null) {
            Enumeration keys = input.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Object value = input.get(key);
                buf.append(key);
                buf.append(this.nl);
                if (!verbose) continue;
                buf.append(value);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hashtableToString");
        }
        return buf.toString();
    }

    public String hashtableToStringForAdminTask(Hashtable input) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hashtableToStringForAdminTask");
        }
        String ret = null;
        Enumeration keys = input.keys();
        StringBuffer buf = new StringBuffer();
        while (keys.hasMoreElements()) {
            int index;
            buf.append("{");
            String key = (String)keys.nextElement();
            buf.append(key);
            buf.append(" ");
            Object value = input.get(key);
            if (value instanceof Hashtable) {
                Tr.debug(tc, "value is Hashtable");
                String val = this.hashtableToStringForAdminTask((Hashtable)value);
                buf.append(val);
            } else if (value instanceof ObjectName) {
                buf.append((ObjectName)value);
            } else if (value.toString().indexOf(" ") > 0) {
                buf.append("{");
                buf.append(value.toString());
                buf.append("}");
            } else {
                buf.append(value.toString());
            }
            buf.append("}");
            buf.append(" ");
            ret = buf.toString();
            while ((index = ret.indexOf(this.nl)) != -1) {
                ret = ret.replace(this.nl, " ");
            }
        }
        if (input.size() > 1) {
            ret = "[ " + ret + " ]";
        }
        Tr.debug(tc, "Return string " + ret);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hashtableToStringForAdminTask");
        }
        return ret;
    }

    public String arrayListToStringForAdminTask(ArrayList list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "arrayListToStringForAdminTask");
        }
        StringBuffer buf = new StringBuffer();
        Object attrList = null;
        for (int j = 0; j < list.size(); ++j) {
            Object val = list.get(j);
            if (val == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Type of value is " + val.getClass().getName());
            }
            if (!(val instanceof List)) continue;
            ArrayList temp = (ArrayList)val;
            buf.append("{");
            for (int i = 0; i < temp.size(); ++i) {
                attrList = temp.get(i);
                if (attrList != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Type of attrList is " + attrList.getClass().getName());
                    }
                    if (attrList instanceof ObjectName) {
                        buf.append((ObjectName)attrList);
                    } else {
                        String attrValue = attrList.toString();
                        if (attrValue.indexOf(" ") != -1) {
                            buf.append("\"");
                            buf.append(attrValue);
                            buf.append("\"");
                        } else {
                            buf.append(attrList.toString());
                        }
                    }
                }
                buf.append(" ");
            }
            buf.append("}");
            buf.append(" ");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "arrayListToStringForAdminTask" + buf.toString());
        }
        return buf.toString();
    }

    public String listToStringForAdminTask(ArrayList list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listToStringForAdminTask");
        }
        StringBuffer buf = new StringBuffer();
        Object attrList = null;
        for (int j = 0; j < list.size(); ++j) {
            Object val = list.get(j);
            if (val != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Type of value is " + val.getClass().getName());
                }
                if (val instanceof List) {
                    ArrayList temp = (ArrayList)val;
                    buf.append("{");
                    for (int i = 0; i < temp.size(); ++i) {
                        attrList = temp.get(i);
                        if (attrList != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Type of attrList is " + attrList.getClass().getName());
                            }
                            if (attrList instanceof ObjectName) {
                                buf.append((ObjectName)attrList);
                            } else {
                                String attrValue = attrList.toString();
                                if (attrValue.indexOf(" ") != -1) {
                                    buf.append("\"");
                                    buf.append(attrValue);
                                    buf.append("\"");
                                } else {
                                    buf.append(attrList.toString());
                                }
                            }
                        }
                        buf.append(" ");
                    }
                    buf.append("}");
                    buf.append(" ");
                } else {
                    buf.append(val.toString());
                }
            }
            if (j + 1 >= list.size()) continue;
            buf.append(" ");
        }
        String finalString = "{" + buf.toString() + "}";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listToStringForAdminTask" + buf.toString());
        }
        return finalString;
    }

    public Attribute stringToAttribute(String text) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToAttribute: " + text);
        }
        boolean outermost = false;
        if (debugbuf == null) {
            outermost = true;
            debugbuf = new StringBuffer();
            staticText = text;
        }
        StringTokenizer strtok = new StringTokenizer(text, " ", true);
        String key = strtok.nextToken(this.getTokenizerString());
        debugbuf.append(key);
        String value = this.getString(strtok, " ");
        debugbuf.append(value);
        Attribute attr = new Attribute(key, value);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToAttributeList", attr.toString());
        }
        return attr;
    }
}

