/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.scripting.StringHandler;
import com.ibm.ws.scripting.ConfigHelper;
import com.ibm.ws.scripting.HandlerRegistry;
import com.ibm.ws.scripting.LanguageUtilities;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.compat.StringPropertiesEditor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class JythonUtilities
extends LanguageUtilities {
    public static String OPENOPTIONSYNTAX = "[";
    public static String CLOSEOPTIONSYNTAX = "]";
    private static TraceComponent tc = Tr.register(JythonUtilities.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static final String IS_A_NULL = "$$WebSphere_Null_Value$$";
    private static final String openAttributeListSyntax = "[";
    private static final String closeAttributeListSyntax = "]";
    private static final String emptyAttributeListSyntax = "[]";
    private static final String tokenizerString = "[]\"' ";

    public JythonUtilities(ResourceBundle b) {
        super(b);
    }

    public String setToString(Collection input) {
        return this.setToString(input, true);
    }

    public String setToString(Collection input, boolean sorting) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setToString");
        }
        StringBuffer buf = new StringBuffer();
        if (input == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setToString");
            }
            return new String();
        }
        Object[] array = input.toArray();
        if (sorting) {
            this.sortArray(array);
        }
        for (int i = 0; i < array.length; ++i) {
            String part = array[i].toString();
            buf.append(part);
            if (i >= array.length - 1) continue;
            buf.append(this.nl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setToString");
        }
        return buf.toString();
    }

    public String getOpenNestedAttribute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOpenNestedAttribute");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOpenNestedAttribute");
        }
        return openAttributeListSyntax;
    }

    public String getCloseNestedAttribute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCloseNestedAttribute");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCloseNestedAttribute");
        }
        return closeAttributeListSyntax;
    }

    public String getTokenizerString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenizerString");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenizerString");
        }
        return tokenizerString;
    }

    public String addQuotes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQuotes");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQuotes");
        }
        return "'";
    }

    public String removeQuotes(String str) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeQuotes");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeQuotes");
        }
        return str;
    }

    public boolean isStringWithQuotes(String data) {
        boolean ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isStringWithQuote");
        }
        boolean bl = ret = data.startsWith("\"") && data.endsWith("\"") || data.startsWith("'") && data.endsWith("'");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isStringWithQuote - " + ret);
        }
        return ret;
    }

    public String attributeToString(String name, String val) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeToString", new Object[]{name, val});
        }
        StringBuffer buf = new StringBuffer();
        buf.append(openAttributeListSyntax);
        buf.append(name);
        buf.append(" ");
        if (val == null || val.equals("")) {
            buf.append(emptyAttributeListSyntax);
        } else {
            if (!(val.indexOf(" ") <= 0 || val.startsWith("\"") || val.endsWith("\"") || val.startsWith(openAttributeListSyntax) || val.endsWith(closeAttributeListSyntax))) {
                val = "\"" + val + "\"";
            }
            buf.append(val);
        }
        buf.append(closeAttributeListSyntax);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeToString " + buf.toString());
        }
        return buf.toString();
    }

    public String arrayListToString(ArrayList list, ConfigHelper configHelper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "arrayListToString ");
        }
        StringBuffer buf = new StringBuffer();
        buf.append(openAttributeListSyntax);
        for (int j = 0; j < list.size(); ++j) {
            Object val = list.get(j);
            if (val != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Type of value is " + val.getClass().getName());
                }
                if (val instanceof ObjectName) {
                    buf.append(configHelper.getListingName((ObjectName)val));
                } else {
                    buf.append(val.toString());
                }
            } else {
                buf.append(emptyAttributeListSyntax);
            }
            if (j + 1 >= list.size()) continue;
            buf.append(" ");
        }
        buf.append(closeAttributeListSyntax);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "arrayListToString " + buf.toString());
        }
        return buf.toString();
    }

    public String stringArrayToString(Object oval) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringArrayToString");
        }
        String sval = null;
        if (oval == null) {
            sval = emptyAttributeListSyntax;
        } else if (oval instanceof List) {
            StringBuffer buf = new StringBuffer();
            List l = (List)oval;
            for (int i = 0; i < l.size(); ++i) {
                buf.append(l.get(i).toString());
                if (i >= l.size() - 1) continue;
                buf.append(";");
            }
            sval = buf.toString();
        } else {
            sval = oval.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringArrayToString " + sval);
        }
        return sval;
    }

    public String integerArrayToString(Object oval) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "integerArrayToString");
        }
        String sval = null;
        if (oval == null) {
            sval = emptyAttributeListSyntax;
        } else if (oval instanceof List) {
            StringBuffer buf = new StringBuffer();
            List l = (List)oval;
            for (int i = 0; i < l.size(); ++i) {
                buf.append(l.get(i).toString());
                if (i >= l.size() - 1) continue;
                buf.append(" ");
            }
            sval = buf.toString();
        } else {
            sval = oval.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "integerArrayToString " + sval);
        }
        return sval;
    }

    public AttributeList stringToAttributeList(String input) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToAttributeList string: " + input);
        }
        boolean outermost = false;
        String text = null;
        if (input != null) {
            text = input.trim();
        }
        if (debugbuf == null) {
            outermost = true;
            debugbuf = new StringBuffer();
        }
        AttributeList al = new AttributeList();
        StringTokenizer strtok = new StringTokenizer(text, "[] \"'", true);
        try {
            while (strtok.hasMoreTokens()) {
                String next = strtok.nextToken("[] \"'");
                debugbuf.append(next);
                if (next.equals(openAttributeListSyntax)) {
                    String key = this.getString(strtok, " ");
                    String value = this.getString(strtok, " ");
                    while (strtok.hasMoreTokens()) {
                        next = strtok.nextToken();
                        debugbuf.append(next);
                        if (next.equals(" ")) continue;
                    }
                    if (!next.equals(closeAttributeListSyntax)) {
                        Tr.event(tc, "debugbuf is \"" + debugbuf.toString() + "\"");
                        this.throwIllegalArgException("WASX7122E", closeAttributeListSyntax, key, value, input);
                    }
                    if (value.startsWith("[[") && value.endsWith("]]")) {
                        ArrayList arl = this.createArrayList(value);
                        al.add(new Attribute(key, arl));
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "size of list is now " + al.size());
                        continue;
                    }
                    if (value.startsWith(openAttributeListSyntax)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New attribute: " + key + " (list)");
                        }
                        AttributeList embeddedAL = this.stringToAttributeList(value);
                        al.add(new Attribute(key, embeddedAL));
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "size of list is now " + al.size());
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New attribute: " + key + " = " + value);
                    }
                    al.add(new Attribute(key, value));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "size of list is now " + al.size());
                    continue;
                }
                if (next.equals(" ")) continue;
                Tr.event(tc, "debugbuf is \"" + debugbuf.toString() + "\"");
                this.throwIllegalArgException("WASX7480E", next, "", "", input);
            }
        }
        catch (NoSuchElementException nsee) {
            nsee.printStackTrace();
            throw new IllegalArgumentException();
        }
        finally {
            if (outermost) {
                debugbuf = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToAttributeList");
        }
        return al;
    }

    public String[] stringToStringArray(String inputString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToStringArray");
        }
        String[] result = null;
        StringTokenizer strtok = null;
        ArrayList<String> alist = new ArrayList<String>();
        if (inputString != null) {
            String input = inputString.trim();
            if (input.startsWith(openAttributeListSyntax) && input.endsWith(closeAttributeListSyntax)) {
                input = input.substring(1, inputString.length() - 1);
            }
            if (input.indexOf(" ") >= 0 && input.indexOf(";") >= 0 && !input.startsWith("\"") && !input.endsWith("\"")) {
                input = "\"" + input + "\"";
            }
            strtok = new StringTokenizer(input, "[] ", true);
            String next = null;
            int nesting = 0;
            StringBuffer buf = new StringBuffer();
            while (strtok.hasMoreTokens()) {
                next = strtok.nextToken();
                if (next.equals(openAttributeListSyntax)) {
                    ++nesting;
                } else if (next.equals(closeAttributeListSyntax)) {
                    --nesting;
                }
                buf.append(next);
                if (buf.toString().startsWith("\"") && !next.endsWith("\"")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "buf to string:" + buf.toString());
                }
                String newone = buf.toString().trim();
                if (nesting == 0) {
                    if (!newone.equals("")) {
                        if (newone.startsWith("\"") && newone.endsWith("\"") && newone.lastIndexOf("\"") <= newone.indexOf("\"", 1) || newone.startsWith("'") && newone.endsWith("'") || newone.startsWith(openAttributeListSyntax) && newone.endsWith(closeAttributeListSyntax)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "removing quotes from \"" + newone + "\"");
                            }
                            newone = newone.substring(1, newone.length() - 1);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding " + newone);
                        }
                        alist.add(newone);
                    }
                    buf = new StringBuffer();
                    continue;
                }
                if (newone.indexOf("Ljava") <= 0) continue;
                alist.add(newone);
            }
            ArrayList<String> aVal = new ArrayList<String>();
            StringBuffer buf1 = new StringBuffer();
            StringTokenizer tok = null;
            for (int i = 0; i < alist.size(); ++i) {
                String val = (String)alist.get(i);
                Tr.debug(tc, "val: " + val);
                if (val.indexOf(";") >= 0 && val.indexOf("Ljava") < 0) {
                    tok = new StringTokenizer(val, ";", false);
                    while (tok.hasMoreTokens()) {
                        next = tok.nextToken();
                        aVal.add(next);
                    }
                    continue;
                }
                if (val.indexOf(" ") >= 0) {
                    Tr.debug(tc, "val with space: " + val);
                    if (val.indexOf("\"") >= 0) {
                        String[] tempVal = val.split(" ");
                        for (int j = 0; j < tempVal.length; ++j) {
                            String t1 = tempVal[j];
                            if (t1.startsWith("\"") && t1.endsWith("\"")) {
                                t1 = t1.substring(1, t1.length() - 1);
                                aVal.add(t1);
                            } else if (t1.startsWith("\"")) {
                                buf1.append(t1);
                                buf1.append(" ");
                            } else if (t1.endsWith("\"")) {
                                buf1.append(t1);
                            } else {
                                aVal.add(t1);
                            }
                            if (!buf1.toString().startsWith("\"") || !buf1.toString().endsWith("\"")) continue;
                            String t2 = buf1.substring(1, buf1.length() - 1);
                            buf1 = new StringBuffer();
                            aVal.add(t2);
                        }
                        continue;
                    }
                    aVal.add(val);
                    continue;
                }
                aVal.add(val);
            }
            result = new String[aVal.size()];
            for (int j = 0; j < aVal.size(); ++j) {
                result[j] = (String)aVal.get(j);
                Tr.debug(tc, "result[j] " + result[j]);
                if (result[j].startsWith("\"") && result[j].endsWith("\"")) {
                    result[j] = result[j].substring(1, result[j].length() - 1);
                    continue;
                }
                if (result[j].startsWith("\"")) {
                    result[j] = result[j].substring(1, result[j].length());
                    continue;
                }
                if (!result[j].endsWith("\"")) continue;
                result[j] = result[j].substring(0, result[j].length() - 1);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToStringArray");
        }
        return result;
    }

    public ArrayList stringToArrayList(String text) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToArrayList string: " + text);
        }
        boolean outermost = false;
        StringTokenizer strtok = null;
        StringBuffer buf = new StringBuffer();
        String input = text;
        if (debugbuf == null) {
            outermost = true;
            debugbuf = new StringBuffer();
            staticText = text;
        }
        ArrayList<String> al = new ArrayList<String>();
        if (text.startsWith(openAttributeListSyntax) && text.endsWith(closeAttributeListSyntax)) {
            input = text.substring(1, text.length() - 1);
        }
        strtok = input.indexOf(openAttributeListSyntax) >= 0 ? new StringTokenizer(text, "[] ", true) : new StringTokenizer(input, " ", true);
        try {
            while (strtok.hasMoreTokens()) {
                String element;
                String next = strtok.nextToken(this.getTokenizerString());
                debugbuf.append(next);
                if (next.equals(" ")) {
                    next = this.skipSpaces(strtok);
                    debugbuf.append(next);
                }
                if (next.equals(this.getOpenNestedAttribute())) {
                    element = this.getString(strtok, next);
                    al.add(element);
                    continue;
                }
                if (next.equals(this.getCloseNestedAttribute())) {
                    break;
                }
                element = this.getString(strtok, next);
                al.add(element);
            }
        }
        catch (NoSuchElementException nsee) {
            nsee.printStackTrace();
            throw new IllegalArgumentException();
        }
        finally {
            if (outermost) {
                debugbuf = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToArrayList");
        }
        return al;
    }

    public List stringToList(String text) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToList string: " + text);
        }
        boolean outermost = false;
        StringTokenizer strtok = null;
        StringBuffer buf = new StringBuffer();
        String input = text;
        if (debugbuf == null) {
            outermost = true;
            debugbuf = new StringBuffer();
            staticText = text;
        }
        ArrayList<String> al = new ArrayList<String>();
        if (text.startsWith(openAttributeListSyntax) && text.endsWith(closeAttributeListSyntax)) {
            input = text.substring(1, text.length() - 1);
        }
        strtok = input.indexOf(openAttributeListSyntax) >= 0 ? new StringTokenizer(text, "[] ", true) : new StringTokenizer(input, " ", true);
        try {
            while (strtok.hasMoreTokens()) {
                String element;
                String next = strtok.nextToken(this.getTokenizerString());
                debugbuf.append(next);
                if (next.equals(" ")) {
                    next = this.skipSpaces(strtok);
                    debugbuf.append(next);
                }
                if (next.equals(this.getOpenNestedAttribute())) {
                    element = this.getString(strtok, next);
                    al.add(element);
                    continue;
                }
                if (next.equals(this.getCloseNestedAttribute())) {
                    break;
                }
                element = this.getString(strtok, next);
                al.add(element);
            }
        }
        catch (NoSuchElementException nsee) {
            nsee.printStackTrace();
            throw new IllegalArgumentException();
        }
        finally {
            if (outermost) {
                debugbuf = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToList");
        }
        return al;
    }

    public String attributeListToString(AttributeList alist) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeListToString " + alist.toString());
        }
        ArrayList<Properties> sortedList = new ArrayList<Properties>();
        StringBuffer temp = new StringBuffer();
        for (int i = 0; i < alist.size(); ++i) {
            Object o;
            Properties prop = new Properties();
            if (tc.isDebugEnabled()) {
                try {
                    o = alist.get(i);
                    Tr.debug(tc, "Class of Attribute " + i + " is " + o.getClass().getName());
                    Tr.debug(tc, "name of attr is " + ((Attribute)alist.get(i)).getName());
                    Object oo = ((Attribute)alist.get(i)).getValue();
                    if (oo != null) {
                        Tr.debug(tc, "Class of value is " + oo.getClass().getName());
                    }
                }
                catch (Exception e) {
                    Tr.debug(tc, "caught " + e);
                }
            }
            if ((o = ((Attribute)alist.get(i)).getValue()) != null) {
                prop.setProperty(((Attribute)alist.get(i)).getName(), o.toString());
                sortedList.add(i, prop);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Attribute null; skipping: " + ((Attribute)alist.get(i)).getName());
        }
        temp.append(openAttributeListSyntax);
        for (int j = 0; j < sortedList.size(); ++j) {
            Properties p = (Properties)sortedList.get(j);
            temp.append(this.propertiesToString(p));
            temp.append(" ");
        }
        temp.append(closeAttributeListSyntax);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeListToString " + temp.toString());
        }
        return temp.toString();
    }

    public String cleanAttributeString(String attr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanAttributeString");
        }
        if (attr != null && attr.startsWith(openAttributeListSyntax) && attr.endsWith(closeAttributeListSyntax)) {
            attr = attr.substring(1, attr.length() - 1);
        }
        if (tc.isEntryEnabled()) {
            if (attr.toLowerCase().indexOf("password") == -1 && attr.toLowerCase().indexOf("pwd") == -1) {
                Tr.exit(tc, "cleanAttributeString -- " + attr);
            } else {
                String[] attrArray = attr.split(" ");
                StringBuffer buf = new StringBuffer();
                boolean passwordFlag = false;
                for (int i = 0; i < attrArray.length; ++i) {
                    String temp = attrArray[i];
                    if (!(temp.toLowerCase().indexOf("password") == -1 && temp.toLowerCase().indexOf("pwd") == -1 && temp.toLowerCase().indexOf("passwd") == -1 || passwordFlag)) {
                        passwordFlag = true;
                        buf.append(temp);
                    } else if (passwordFlag) {
                        buf.append("*****");
                        passwordFlag = false;
                    } else {
                        buf.append(temp);
                    }
                    buf.append(" ");
                }
                Tr.exit(tc, "cleanAttributeString -- " + buf.toString());
            }
        }
        return attr;
    }

    protected String getString(StringTokenizer strtok, String next) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getString next: \"" + next + "\"");
        }
        String value = null;
        try {
            if (next.equals(" ")) {
                next = this.skipSpaces(strtok);
                debugbuf.append(next);
            }
            if (next.equals(openAttributeListSyntax)) {
                value = "";
                int nested = 1;
                while (nested > 0) {
                    next = strtok.nextToken(emptyAttributeListSyntax);
                    debugbuf.append(next);
                    if (next.equals(openAttributeListSyntax)) {
                        ++nested;
                    } else if (next.equals(closeAttributeListSyntax)) {
                        --nested;
                    }
                    if (nested <= 0) continue;
                    value = value + next;
                }
            } else if (next.equals(closeAttributeListSyntax)) {
                Tr.event(tc, "Unexpected ']' found");
                this.throwIllegalArgException("WASX7123E", closeAttributeListSyntax, "", "", next);
            } else if (next.equals("\"") || next.equals("'")) {
                String saveQuote = next;
                StringBuffer buf = new StringBuffer();
                boolean foundEnd = false;
                while (strtok.hasMoreTokens()) {
                    next = strtok.nextToken();
                    debugbuf.append(next);
                    if (next.equals(saveQuote)) {
                        foundEnd = true;
                        break;
                    }
                    buf.append(next);
                }
                if (!foundEnd) {
                    this.throwIllegalArgException("WASX7122E", "\"", "", "", next);
                }
                value = buf.toString();
            } else {
                value = next;
            }
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalArgumentException(nsee.getMessage());
        }
        if (value.indexOf(" ") > 0 || value.trim().length() == 0) {
            value = value.trim();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getString -> " + value);
        }
        return value;
    }

    protected String addOptionValue(StringTokenizer strtok, String key, Hashtable ht) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addOptionValue: " + key);
        }
        Object result = new String();
        ArrayList<List> listval = new ArrayList<List>();
        String next = new String();
        try {
            while (strtok.hasMoreTokens()) {
                next = strtok.nextToken();
                debugbuf.append(next);
                if (next.equals(" ")) {
                    try {
                        next = this.skipSpaces(strtok);
                        debugbuf.append(next);
                    }
                    catch (IllegalArgumentException e) {
                        break;
                    }
                }
                if (!next.startsWith("-") || key.equals("target")) {
                    String val;
                    if (key.equals("target") && next.startsWith("-")) {
                        if (next.toLowerCase().startsWith("-websphere")) {
                            String temp = this.getString(strtok, next);
                            result = temp;
                            next = temp.substring(1);
                            continue;
                        }
                    } else if (!next.equals(openAttributeListSyntax)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "value not a list");
                        }
                        val = this.getString(strtok, next);
                        result = val;
                    } else {
                        if (strtok.hasMoreTokens()) {
                            next = strtok.nextToken();
                        }
                        debugbuf.append(next);
                        if (next.equals(" ")) {
                            next = this.skipSpaces(strtok);
                            debugbuf.append(next);
                        }
                        if (!next.equals(openAttributeListSyntax)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "val is not a list but starts with a [");
                            }
                            val = this.getString(strtok, openAttributeListSyntax);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "val is " + val);
                            }
                            if (next.startsWith("-") && val != null) {
                                result = next + " " + val;
                                Tr.debug(tc, "result " + result);
                            } else {
                                result = next + val;
                            }
                            if (key.equals("delete") && tc.isDebugEnabled()) {
                                Tr.debug(tc, "delete option is provided");
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "result is " + result);
                            }
                            next = closeAttributeListSyntax;
                        } else {
                            while (next.equals(openAttributeListSyntax)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "value a list");
                                }
                                List l = this.getList(strtok);
                                listval.add(l);
                                if (!strtok.hasMoreTokens()) break;
                                next = strtok.nextToken(tokenizerString);
                                debugbuf.append(next);
                                if (next.equals(" ")) {
                                    next = this.skipSpaces(strtok);
                                    debugbuf.append(next);
                                }
                                if (!next.equals(closeAttributeListSyntax)) continue;
                                break;
                            }
                            result = listval;
                        }
                    }
                }
                break;
            }
        }
        catch (NoSuchElementException nsee) {
            nsee.printStackTrace();
            throw new IllegalArgumentException(nsee.getMessage());
        }
        if (key.equals("custom")) {
            Object value = ht.get(key);
            Vector<String> customValue = value == null ? new Vector<String>() : (Vector<String>)value;
            customValue.addElement((String)result);
            ht.put(key, customValue);
        } else {
            ht.put(key, result);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "next: " + next);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addOptionValue: " + result);
        }
        return next;
    }

    public String propertiesToString(Properties input) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propertiesToString");
        }
        if (input == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "propertiesToString");
            }
            return new String();
        }
        StringBuffer buffer = new StringBuffer();
        if (input.size() > 1) {
            buffer.append(openAttributeListSyntax);
            buffer.append(" ");
        }
        Enumeration<Object> vEnum = input.keys();
        while (vEnum.hasMoreElements()) {
            buffer.append(openAttributeListSyntax);
            String key = (String)vEnum.nextElement();
            String val = input.getProperty(key);
            if (key.indexOf(" ") > 0) {
                buffer.append(openAttributeListSyntax);
                buffer.append(key);
                buffer.append(closeAttributeListSyntax);
            } else {
                buffer.append(key);
            }
            buffer.append(" ");
            if (val.indexOf(" ") > 0) {
                buffer.append(openAttributeListSyntax);
                buffer.append(val);
                buffer.append(closeAttributeListSyntax);
            } else {
                buffer.append(val);
            }
            buffer.append(closeAttributeListSyntax);
            if (input.size() <= 1) continue;
            buffer.append(" ");
        }
        if (input.size() > 1) {
            buffer.append(closeAttributeListSyntax);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertiesToString");
        }
        return buffer.toString();
    }

    public Properties stringToPropertiesForAdminTask(String valueStr, boolean isBraceSupported) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToPropertiesForAdminTask");
        }
        if (valueStr == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stringToProperties");
            }
            return new Properties();
        }
        StringPropertiesEditor ed = new StringPropertiesEditor();
        if (!valueStr.startsWith(openAttributeListSyntax) && valueStr.endsWith(closeAttributeListSyntax)) {
            valueStr = openAttributeListSyntax + valueStr + closeAttributeListSyntax;
        }
        try {
            ed.setAsTextForJython(valueStr, isBraceSupported);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stringToProperties");
            }
        }
        return (Properties)ed.getValue();
    }

    public String objectArrayToString(Object[] attrs) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "objectArrayToString");
        }
        StringBuffer ret = new StringBuffer();
        ret.append(openAttributeListSyntax);
        boolean deleteFlag = false;
        for (int i = 0; i < attrs.length; ++i) {
            String str = attrs[i].toString();
            if (str.trim().startsWith(openAttributeListSyntax) && str.trim().endsWith(closeAttributeListSyntax)) {
                StringTokenizer strtok;
                if (deleteFlag) {
                    strtok = new StringTokenizer(str, "][ ,", true);
                    deleteFlag = false;
                } else {
                    strtok = new StringTokenizer(str, "] ,", true);
                }
                boolean inString = false;
                while (strtok.hasMoreTokens()) {
                    String next = strtok.nextToken();
                    if ((next.trim().startsWith("\"") || next.trim().startsWith("'")) && (next.trim().endsWith("\"") || next.trim().endsWith("'")) && next.trim().indexOf("-") != -1) {
                        next = next.substring(1, next.length() - 1);
                    }
                    if (next.trim().startsWith(openAttributeListSyntax) && !next.trim().endsWith(closeAttributeListSyntax) && str.trim().endsWith("]]")) {
                        ret.append(" ");
                        ret.append(openAttributeListSyntax);
                        next = next.substring(1);
                        if (next.trim().startsWith("'") && next.trim().endsWith("'")) {
                            next = next.substring(1, next.length() - 1);
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "next: " + next);
                    }
                    if (next.trim().equals(",")) {
                        while ((next = strtok.nextToken()) != null && next.equals(" ")) {
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "next: " + next);
                        }
                        if (next.trim().startsWith("u'") || next.trim().startsWith("u\"")) {
                            next = next.substring(2, next.length() - 1);
                            Tr.debug(tc, "unicode string: next " + next);
                            StringBuffer buf1 = new StringBuffer();
                            buf1.append("\"");
                            if (!next.startsWith("\\u")) {
                                buf1.append(next.substring(0, next.indexOf("\\u")));
                                next = next.substring(next.indexOf("\\u"), next.length());
                            }
                            StringTokenizer strtok1 = new StringTokenizer(next, "\\u");
                            while (strtok1.hasMoreTokens()) {
                                String nextToken = strtok1.nextToken();
                                String nonUnicodeString = null;
                                if (nextToken.length() > 4) {
                                    nonUnicodeString = nextToken.substring(4, nextToken.length());
                                    Tr.debug(tc, "nonUnicodeString: " + nonUnicodeString);
                                    nextToken = nextToken.substring(0, 4);
                                } else {
                                    nextToken = nextToken.substring(0, nextToken.length());
                                }
                                Tr.debug(tc, "nextToken " + nextToken);
                                char dec = (char)Integer.parseInt(nextToken, 16);
                                buf1.append(dec);
                                if (nonUnicodeString == null) continue;
                                buf1.append(nonUnicodeString);
                            }
                            buf1.append("\"");
                            Tr.debug(tc, "buf1 " + buf1.toString());
                            next = buf1.toString();
                        }
                        if (next.trim().startsWith(openAttributeListSyntax)) {
                            ret.append(" ");
                            inString = false;
                        } else if (next.trim().startsWith("\"") || next.trim().startsWith("'")) {
                            inString = true;
                            ret.append(" ");
                        } else {
                            try {
                                if (inString) {
                                    ret.append(",");
                                } else {
                                    Integer.parseInt(next.trim());
                                    ret.append(" ");
                                }
                            }
                            catch (NumberFormatException ex) {
                                ret.append(",");
                            }
                        }
                    }
                    ret.append(next);
                }
                ret.append(" ");
                continue;
            }
            if (str.equals("-delete")) {
                deleteFlag = true;
            }
            try {
                Integer.parseInt(str.trim());
                ret.append(str);
                ret.append(" ");
                continue;
            }
            catch (NumberFormatException ex) {
                if (str.indexOf("Ljava") > 0) {
                    ret.append(str);
                    continue;
                }
                if (!str.trim().startsWith("-")) {
                    ret.append("\"");
                    ret.append(str);
                    ret.append("\"");
                    ret.append(" ");
                    continue;
                }
                ret.append(str);
                ret.append(" ");
            }
        }
        ret.append(closeAttributeListSyntax);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "objectArrayToString - " + ret.toString());
        }
        return ret.toString();
    }

    public String[] createArgSettingCommands(Collection scriptParms) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createArgSettingCommands");
        }
        Object[] array = scriptParms.toArray();
        StringBuffer params = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            String part = array[i].toString();
            params.append("'");
            params.append(part);
            params.append("'");
            if (i >= array.length - 1) continue;
            params.append(", ");
        }
        String[] commandArg = new String[2];
        StringBuffer buf = new StringBuffer();
        commandArg[0] = "import sys";
        buf.append("sys.argv = [");
        buf.append(params.toString());
        buf.append(closeAttributeListSyntax);
        commandArg[1] = buf.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createArgSettingCommands");
        }
        return commandArg;
    }

    public String buildAdminCmdString(String scriptingObject, String cmdName, String targetObject, String params, String steps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildAdminCmdString");
        }
        StringBuffer ret = new StringBuffer();
        ret.append(scriptingObject);
        ret.append(".");
        ret.append(cmdName);
        ret.append("(");
        if (targetObject != null && targetObject.length() > 0) {
            ret.append("'");
            ret.append(targetObject);
            ret.append("'");
        }
        if (params != null && params.length() > 0 || steps != null && steps.length() > 0) {
            if (targetObject != null && targetObject.length() > 0) {
                ret.append(", ");
            }
            ret.append("'");
            ret.append(OPENOPTIONSYNTAX);
        }
        if (params != null && params.length() > 0) {
            ret.append(params);
            if (steps != null) {
                ret.append(" ");
            }
        }
        if (steps != null && steps.length() > 0) {
            ret.append(steps);
        }
        if (params != null && params.length() > 0 || steps != null && steps.length() > 0) {
            ret.append(CLOSEOPTIONSYNTAX);
            ret.append("'");
        }
        ret.append(")");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildAdminCmdString - " + ret.toString());
        }
        return ret.toString();
    }

    public Object stringToObjectArray(String inputString, Class objectClass) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToObjectArray");
        }
        Object result = null;
        if (inputString != null) {
            String input = inputString.trim();
            if (input.startsWith(openAttributeListSyntax) && input.endsWith(closeAttributeListSyntax)) {
                input = input.substring(1, inputString.length() - 1);
            }
            ArrayList<String> alist = new ArrayList<String>();
            Class<?> elementType = null;
            if (!objectClass.isArray()) {
                return new Object();
            }
            elementType = objectClass.getComponentType();
            StringTokenizer strtok = new StringTokenizer(input, "[] ", true);
            String next = null;
            int nesting = 0;
            StringBuffer buf = new StringBuffer();
            while (strtok.hasMoreTokens()) {
                next = strtok.nextToken();
                if (next.equals(openAttributeListSyntax)) {
                    ++nesting;
                } else if (next.equals(closeAttributeListSyntax)) {
                    --nesting;
                }
                buf.append(next);
                if (buf.toString().startsWith("\"") && !next.endsWith("\"")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "buf to string:" + buf.toString());
                }
                if (nesting != 0) continue;
                String newone = buf.toString().trim();
                if (!newone.equals("")) {
                    if (newone.startsWith("\"") && newone.endsWith("\"") || newone.startsWith(openAttributeListSyntax) && newone.endsWith(closeAttributeListSyntax)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "removing quotes from \"" + newone + "\"");
                        }
                        newone = newone.substring(1, newone.length() - 1);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding " + newone);
                    }
                    alist.add(newone);
                }
                buf = new StringBuffer();
            }
            StringHandler handler = HandlerRegistry.getHandler(elementType);
            if (handler != null) {
                result = Array.newInstance(elementType, alist.size());
                for (int i = 0; i < alist.size(); ++i) {
                    try {
                        Array.set(result, i, handler.formValidObject((String)alist.get(i), elementType, "jython"));
                        continue;
                    }
                    catch (com.ibm.websphere.scripting.ScriptingException ex) {
                        throw new ScriptingException(ex.toString());
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToObjectArray");
        }
        return result;
    }

    public String arrayListToStringForAdminTask(ArrayList list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "arrayListToStringForAdminTask");
        }
        StringBuffer buf = new StringBuffer();
        Object attrList = null;
        for (int j = 0; j < list.size(); ++j) {
            Object val = list.get(j);
            if (val == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Type of value is " + val.getClass().getName());
            }
            if (!(val instanceof List)) continue;
            ArrayList temp = (ArrayList)val;
            buf.append(openAttributeListSyntax);
            for (int i = 0; i < temp.size(); ++i) {
                attrList = temp.get(i);
                if (attrList != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Type of attrList is " + attrList.getClass().getName());
                    }
                    if (attrList instanceof ObjectName) {
                        buf.append((ObjectName)attrList);
                    } else {
                        String attrValue = attrList.toString();
                        if (attrValue.indexOf(" ") != -1) {
                            buf.append("\"");
                            buf.append(attrValue);
                            buf.append("\"");
                        } else {
                            buf.append(attrList.toString());
                        }
                    }
                }
                buf.append(" ");
            }
            buf.append(closeAttributeListSyntax);
            buf.append(" ");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "arrayListToStringForAdminTask" + buf.toString());
        }
        return buf.toString();
    }

    public String listToStringForAdminTask(ArrayList list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listToStringForAdminTask");
        }
        StringBuffer buf = new StringBuffer();
        Object attrList = null;
        for (int j = 0; j < list.size(); ++j) {
            Object val = list.get(j);
            if (val != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Type of value is " + val.getClass().getName());
                }
                if (val instanceof List) {
                    ArrayList temp = (ArrayList)val;
                    buf.append(openAttributeListSyntax);
                    for (int i = 0; i < temp.size(); ++i) {
                        attrList = temp.get(i);
                        if (attrList != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Type of attrList is " + attrList.getClass().getName());
                            }
                            if (attrList instanceof ObjectName) {
                                buf.append((ObjectName)attrList);
                            } else {
                                String attrValue = attrList.toString();
                                if (attrValue.indexOf(" ") != -1) {
                                    buf.append("\"");
                                    buf.append(attrValue);
                                    buf.append("\"");
                                } else {
                                    buf.append(attrList.toString());
                                }
                            }
                        }
                        buf.append(" ");
                    }
                    buf.append(closeAttributeListSyntax);
                    buf.append(" ");
                } else {
                    buf.append(val.toString());
                }
            }
            if (j + 1 >= list.size()) continue;
            buf.append(" ");
        }
        String finalString = openAttributeListSyntax + buf.toString() + closeAttributeListSyntax;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listToStringForAdminTask" + buf.toString());
        }
        return finalString;
    }

    public Hashtable stringToHashtable(String text) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToHashtable string: " + text);
        }
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        boolean outermost = false;
        if (debugbuf == null) {
            outermost = true;
            debugbuf = new StringBuffer();
            staticText = text;
        }
        if (!text.startsWith(openAttributeListSyntax) || !text.endsWith(closeAttributeListSyntax)) {
            text = openAttributeListSyntax + text + closeAttributeListSyntax;
        }
        StringTokenizer strtok = new StringTokenizer(text, "[] ", true);
        try {
            while (strtok.hasMoreTokens()) {
                String next = strtok.nextToken(this.getTokenizerString());
                debugbuf.append(next);
                if (next.equals(openAttributeListSyntax)) {
                    String key = this.getString(strtok, " ");
                    String value = this.getString(strtok, " ");
                    while (strtok.hasMoreTokens()) {
                        next = strtok.nextToken();
                        debugbuf.append(next);
                        if (next.equals(" ")) continue;
                    }
                    if (!next.equals(closeAttributeListSyntax)) {
                        Tr.event(tc, "Expected ']' not found");
                        this.throwIllegalArgException("WASX7122E", next, key, value, text);
                    }
                    if (value.startsWith(openAttributeListSyntax)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New key: " + key + " (table)");
                        }
                        Hashtable embedded = this.stringToHashtable(value);
                        ht.put(key, embedded);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "size of table is now " + ht.size());
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New key: " + key + " = " + value);
                    }
                    ht.put(key, value);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "size of table is now " + ht.size());
                    continue;
                }
                if (next.equals(" ")) continue;
                this.throwIllegalArgException("WASX7480E", next, "", "", text);
            }
        }
        catch (NoSuchElementException nsee) {
            nsee.printStackTrace();
            throw new IllegalArgumentException();
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        finally {
            if (outermost) {
                debugbuf = null;
            }
        }
        Tr.debug(tc, "hashtable " + ht.toString());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToHashtable");
        }
        return ht;
    }

    public String hashtableToStringForAdminTask(Hashtable input) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hashtableToStringForAdminTask" + input);
        }
        String ret = null;
        Enumeration keys = input.keys();
        StringBuffer buf = new StringBuffer();
        while (keys.hasMoreElements()) {
            int index;
            buf.append(openAttributeListSyntax);
            String key = (String)keys.nextElement();
            buf.append(key);
            buf.append(" ");
            Object value = input.get(key);
            if (value instanceof Hashtable) {
                Tr.debug(tc, "value is Hashtable");
                String val = this.hashtableToStringForAdminTask((Hashtable)value);
                buf.append(val);
            } else if (value instanceof ObjectName) {
                buf.append((ObjectName)value);
            } else if (value.toString().indexOf(" ") > 0) {
                buf.append(openAttributeListSyntax);
                buf.append(value.toString());
                buf.append(closeAttributeListSyntax);
            } else {
                buf.append(value.toString());
            }
            buf.append(closeAttributeListSyntax);
            buf.append(" ");
            ret = buf.toString();
            while ((index = ret.indexOf(this.nl)) != -1) {
                ret = ret.replace(this.nl, " ");
            }
        }
        if (input.size() > 1) {
            ret = "[ " + ret + " ]";
        }
        Tr.debug(tc, "Return string " + ret);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hashtableToStringForAdminTask");
        }
        return ret;
    }

    public Attribute stringToAttribute(String input) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToAttribute: " + input);
        }
        boolean outermost = false;
        String text = null;
        if (input != null) {
            text = input.trim();
        }
        if (debugbuf == null) {
            outermost = true;
            debugbuf = new StringBuffer();
        }
        Attribute attr = null;
        if (!text.startsWith(openAttributeListSyntax) || !text.endsWith(closeAttributeListSyntax)) {
            text = openAttributeListSyntax + text + closeAttributeListSyntax;
        }
        StringTokenizer strtok = new StringTokenizer(text, "[] \"'", true);
        try {
            while (strtok.hasMoreTokens()) {
                String next = strtok.nextToken("[] \"'");
                debugbuf.append(next);
                if (next.equals(openAttributeListSyntax)) {
                    String key = this.getString(strtok, " ");
                    String value = this.getString(strtok, " ");
                    while (strtok.hasMoreTokens()) {
                        next = strtok.nextToken();
                        debugbuf.append(next);
                        if (next.equals(" ")) continue;
                    }
                    if (!next.equals(closeAttributeListSyntax)) {
                        Tr.event(tc, "debugbuf is \"" + debugbuf.toString() + "\"");
                        this.throwIllegalArgException("WASX7122E", closeAttributeListSyntax, key, value, input);
                    }
                    if (value.startsWith("[[") && value.endsWith("]]")) {
                        ArrayList arl = this.createArrayList(value);
                        attr = new Attribute(key, arl);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "size of list is now " + attr.toString());
                        continue;
                    }
                    if (value.startsWith(openAttributeListSyntax)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New attribute: " + key + " (list)");
                        }
                        Attribute embeddedAL = this.stringToAttribute(value);
                        attr = new Attribute(key, embeddedAL);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "size of list is now " + attr.toString());
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New attribute: " + key + " = " + value);
                    }
                    attr = new Attribute(key, value);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "size of list is now " + attr.toString());
                    continue;
                }
                if (next.equals(" ")) continue;
                Tr.event(tc, "debugbuf is \"" + debugbuf.toString() + "\"");
                this.throwIllegalArgException("WASX7480E", next, "", "", input);
            }
        }
        catch (NoSuchElementException nsee) {
            nsee.printStackTrace();
            throw new IllegalArgumentException();
        }
        finally {
            if (outermost) {
                debugbuf = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToAttribute", attr.toString());
        }
        return attr;
    }
}

