/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.scripting.StringHandler;
import com.ibm.ws.scripting.ConfigHelper;
import com.ibm.ws.scripting.HandlerRegistry;
import com.ibm.ws.scripting.LanguageUtilities;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.compat.StringPropertiesEditor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class JaclUtilities
extends LanguageUtilities {
    public static String OPENOPTIONSYNTAX = "{";
    public static String CLOSEOPTIONSYNTAX = "}";
    private static TraceComponent tc = Tr.register(JaclUtilities.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static final String IS_A_NULL = "$$WebSphere_Null_Value$$";

    public JaclUtilities(ResourceBundle b) {
        super(b);
    }

    public Properties stringToProperties(String input) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToProperties");
        }
        if (input == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stringToProperties");
            }
            return new Properties();
        }
        StringPropertiesEditor ed = new StringPropertiesEditor();
        Tr.debug(tc, "input: " + input);
        if (!input.startsWith("{") && input.endsWith("}")) {
            input = "{" + input + "}";
        }
        try {
            ed.setAsText(input);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stringToProperties");
            }
        }
        return (Properties)ed.getValue();
    }

    public String propertiesToString(Properties input) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propertiesToString");
        }
        if (input == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "propertiesToString");
            }
            return new String();
        }
        StringPropertiesEditor ed = new StringPropertiesEditor();
        ed.setValue(input);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertiesToString");
        }
        return ed.getAsText();
    }

    public String propertiesToStringForAdminTask(Properties input) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propertiesToStringForAdminTask");
        }
        StringBuffer buffer = new StringBuffer();
        if (input.size() > 1) {
            buffer.append(OPENOPTIONSYNTAX);
            buffer.append(" ");
        }
        Enumeration<Object> vEnum = input.keys();
        while (vEnum.hasMoreElements()) {
            buffer.append(OPENOPTIONSYNTAX);
            String key = (String)vEnum.nextElement();
            String val = input.getProperty(key);
            buffer.append(key);
            buffer.append(" ");
            buffer.append(val);
            buffer.append(CLOSEOPTIONSYNTAX);
            if (input.size() <= 1) continue;
            buffer.append(" ");
        }
        if (input.size() > 1) {
            buffer.append(CLOSEOPTIONSYNTAX);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertiesToString");
        }
        return buffer.toString();
    }

    public String attributeListToString(AttributeList alist) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeListToString " + alist.toString());
        }
        ArrayList<Properties> sortedList = new ArrayList<Properties>();
        StringBuffer temp = new StringBuffer();
        for (int i = 0; i < alist.size(); ++i) {
            Object o;
            Properties prop = new Properties();
            if (tc.isDebugEnabled()) {
                try {
                    o = alist.get(i);
                    Tr.debug(tc, "Class of Attribute " + i + " is " + o.getClass().getName());
                    Tr.debug(tc, "name of attr is " + ((Attribute)alist.get(i)).getName());
                    Object oo = ((Attribute)alist.get(i)).getValue();
                    if (oo != null) {
                        Tr.debug(tc, "Class of value is " + oo.getClass().getName());
                    }
                }
                catch (Exception e) {
                    Tr.debug(tc, "caught " + e);
                }
            }
            if ((o = ((Attribute)alist.get(i)).getValue()) != null) {
                prop.setProperty(((Attribute)alist.get(i)).getName(), o.toString());
                sortedList.add(i, prop);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Attribute null; skipping: " + ((Attribute)alist.get(i)).getName());
        }
        for (int j = 0; j < sortedList.size(); ++j) {
            Properties p = (Properties)sortedList.get(j);
            temp.append(this.propertiesToString(p));
            temp.append(" ");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeListToString " + temp.toString());
        }
        return temp.toString();
    }

    public String setToString(Collection input) {
        return this.setToString(input, true);
    }

    public String setToString(Collection input, boolean sorting) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setToString");
        }
        StringBuffer buf = new StringBuffer();
        if (input == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setToString");
            }
            return new String();
        }
        Object[] array = input.toArray();
        if (sorting) {
            this.sortArray(array);
        }
        for (int i = 0; i < array.length; ++i) {
            String part = array[i].toString();
            if (!(part.indexOf(" ") < 0 || part.startsWith("\"") || part.endsWith("\"") || part.startsWith("{") || part.endsWith("}"))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding quotes to \"" + part + "\"");
                }
                part = "\"" + part + "\"";
            }
            buf.append(part);
            if (i >= array.length - 1) continue;
            buf.append(this.nl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setToString");
        }
        return buf.toString();
    }

    public String[] stringToStringArray(String input) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToStringArray");
        }
        String[] result = null;
        ArrayList<String> alist = new ArrayList<String>();
        StringTokenizer strtok = null;
        if (input != null) {
            if ((input = input.trim()).indexOf(" ") >= 0 && input.indexOf(";") >= 0 && !input.startsWith("\"") && !input.endsWith("\"")) {
                input = "\"" + input + "\"";
            }
            strtok = new StringTokenizer(input, "{} ", true);
            String next = null;
            int nesting = 0;
            StringBuffer buf = new StringBuffer();
            boolean varSubst = false;
            while (strtok.hasMoreTokens()) {
                next = strtok.nextToken();
                if (next.equals("$")) {
                    varSubst = true;
                    buf.append(next);
                    continue;
                }
                if (next.equals("{")) {
                    ++nesting;
                } else if (next.equals("}")) {
                    --nesting;
                }
                buf.append(next);
                if (buf.toString().startsWith("\"") && !next.endsWith("\"")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "buf to string:" + buf.toString());
                }
                String newone = buf.toString().trim();
                if (nesting == 0 && !varSubst) {
                    if (!newone.equals("")) {
                        if (newone.startsWith("\"") && newone.endsWith("\"") && newone.lastIndexOf("\"") <= newone.indexOf("\"", 1) || newone.startsWith("{") && newone.endsWith("}")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "removing quotes from \"" + newone + "\"");
                            }
                            newone = newone.substring(1, newone.length() - 1);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding " + newone);
                        }
                        alist.add(newone);
                    }
                    buf = new StringBuffer();
                    continue;
                }
                if (nesting != 0 || !varSubst) continue;
                alist.add(buf.toString());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding " + buf.toString());
                }
                varSubst = false;
                buf = new StringBuffer();
            }
            ArrayList<String> aVal = new ArrayList<String>();
            StringBuffer buf1 = new StringBuffer();
            StringTokenizer tok = null;
            for (int i = 0; i < alist.size(); ++i) {
                String val = (String)alist.get(i);
                Tr.debug(tc, "val: " + val);
                if (val.indexOf("Ljava") >= 0 && !val.endsWith(";")) {
                    val = val + ";";
                }
                if (val.indexOf(";") >= 0 && val.indexOf("Ljava") < 0) {
                    tok = new StringTokenizer(val, ";", false);
                    while (tok.hasMoreTokens()) {
                        next = tok.nextToken();
                        aVal.add(next);
                    }
                    continue;
                }
                if (val.indexOf(" ") >= 0) {
                    if (val.indexOf("\"") >= 0) {
                        String[] tempVal = val.split(" ");
                        for (int j = 0; j < tempVal.length; ++j) {
                            String t1 = tempVal[j];
                            if (t1.startsWith("\"") && t1.endsWith("\"")) {
                                t1 = t1.substring(1, t1.length() - 1);
                                aVal.add(t1);
                            } else if (t1.startsWith("\"")) {
                                buf1.append(t1);
                                buf1.append(" ");
                            } else if (t1.endsWith("\"")) {
                                buf1.append(t1);
                            } else {
                                aVal.add(t1);
                            }
                            if (!buf1.toString().startsWith("\"") || !buf1.toString().endsWith("\"")) continue;
                            String t2 = buf1.substring(1, buf1.length() - 1);
                            buf1 = new StringBuffer();
                            aVal.add(t2);
                        }
                        continue;
                    }
                    aVal.add(val);
                    continue;
                }
                aVal.add(val);
            }
            result = new String[aVal.size()];
            for (int j = 0; j < aVal.size(); ++j) {
                result[j] = (String)aVal.get(j);
                Tr.debug(tc, "result[j] " + result[j]);
                if (result[j].startsWith("\"") && result[j].endsWith("\"")) {
                    result[j] = result[j].substring(1, result[j].length() - 1);
                    continue;
                }
                if (result[j].startsWith("\"")) {
                    result[j] = result[j].substring(1, result[j].length());
                    continue;
                }
                if (!result[j].endsWith("\"")) continue;
                result[j] = result[j].substring(0, result[j].length() - 1);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToStringArray");
        }
        return result;
    }

    public String[] createArgSettingCommands(Collection scriptParms) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createArgSettingCommands");
        }
        String list = this.setToString(scriptParms, false);
        String[] commands = new String[2];
        StringBuffer buf = new StringBuffer();
        buf.append("set argv {");
        buf.append(list);
        buf.append("}");
        commands[0] = buf.toString();
        commands[1] = new String("set argc " + scriptParms.size());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createArgSettingCommands");
        }
        return commands;
    }

    public String getOpenNestedAttribute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOpenNestedAttribute");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOpenNestedAttribute");
        }
        return "{";
    }

    public String getCloseNestedAttribute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCloseNestedAttribute");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCloseNestedAttribute");
        }
        return "}";
    }

    public String getTokenizerString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenizerString");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenizerString");
        }
        return "{}\" ";
    }

    public String addQuotes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQuotes");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQuotes");
        }
        return "";
    }

    public String removeQuotes(String str) {
        String data;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeQuotes");
        }
        if ((data = new String(str)).startsWith("\"") && data.endsWith("\"") || data.startsWith("{") && data.endsWith("}")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removing quotes from \"" + data + "\"");
            }
            data = data.substring(1, data.length() - 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeQuotes");
        }
        return data;
    }

    public boolean isStringWithQuotes(String data) {
        boolean ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isStringWithQuote");
        }
        boolean bl = ret = data.startsWith("\"") && data.endsWith("\"") || data.startsWith("{") && data.endsWith("}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isStringWithQuote - " + ret);
        }
        return ret;
    }

    public String attributeToString(String name, String val) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeToString", new Object[]{name, val});
        }
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        buf.append(name);
        buf.append(" ");
        if (val == null || val.equals("")) {
            buf.append("{}");
        } else if (val.indexOf(" ") >= 0) {
            if (!(val.startsWith("\"") || val.endsWith("\"") || val.startsWith("{") || val.endsWith("}"))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding quotes to \"" + val + "\"");
                }
                buf.append("\"");
                buf.append(val);
                buf.append("\"");
            } else {
                buf.append(val);
            }
        } else {
            buf.append(val);
        }
        buf.append("}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeToString " + buf.toString());
        }
        return buf.toString();
    }

    public String arrayListToString(ArrayList list, ConfigHelper configHelper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "arrayListToString ");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        for (int j = 0; j < list.size(); ++j) {
            Object val = list.get(j);
            if (val != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Type of value is " + val.getClass().getName());
                }
                if (val instanceof ObjectName) {
                    buf.append(configHelper.getListingName((ObjectName)val));
                } else {
                    buf.append(val.toString());
                }
            } else {
                buf.append("{}");
            }
            if (j + 1 >= list.size()) continue;
            buf.append(" ");
        }
        buf.append("}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "arrayListToString " + buf.toString());
        }
        return buf.toString();
    }

    public String stringArrayToString(Object oval) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringArrayToString ");
        }
        String sval = null;
        if (oval == null) {
            sval = "{}";
        } else if (oval instanceof List) {
            StringBuffer buf = new StringBuffer();
            List l = (List)oval;
            for (int i = 0; i < l.size(); ++i) {
                sval = l.get(i).toString();
                if (sval.indexOf(" ") >= 0) {
                    if (!(sval.startsWith("\"") || sval.endsWith("\"") || sval.startsWith("{") || sval.endsWith("}"))) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "adding quotes to \"" + sval + "\"");
                        }
                        buf.append("\"");
                        buf.append(sval);
                        buf.append("\"");
                    } else {
                        buf.append(sval);
                    }
                } else {
                    buf.append(sval);
                }
                if (i >= l.size() - 1) continue;
                buf.append(";");
            }
            sval = buf.toString();
        } else {
            sval = oval.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringArrayToString " + sval);
        }
        return sval;
    }

    public String integerArrayToString(Object oval) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "integerArrayToString");
        }
        String sval = null;
        if (oval == null) {
            sval = "{}";
        } else if (oval instanceof List) {
            StringBuffer buf = new StringBuffer();
            List l = (List)oval;
            for (int i = 0; i < l.size(); ++i) {
                buf.append(l.get(i).toString());
                if (i >= l.size() - 1) continue;
                buf.append(" ");
            }
            sval = buf.toString();
        } else {
            sval = oval.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "integerArrayToString " + sval);
        }
        return sval;
    }

    public String buildAdminCmdString(String scriptingObject, String cmdName, String targetObject, String params, String steps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildAdminCmdString");
        }
        StringBuffer ret = new StringBuffer();
        ret.append("$");
        ret.append(scriptingObject);
        ret.append(" ");
        ret.append(cmdName);
        ret.append(" ");
        if (targetObject != null && targetObject.length() > 0) {
            ret.append(targetObject);
            ret.append(" ");
        }
        if (params != null && params.length() > 0 || steps != null && steps.length() > 0) {
            ret.append(OPENOPTIONSYNTAX);
        }
        if (params != null && params.length() > 0) {
            ret.append(params);
            if (steps != null) {
                ret.append(" ");
            }
        }
        if (steps != null && steps.length() > 0) {
            ret.append(steps);
        }
        if (params != null && params.length() > 0 || steps != null && steps.length() > 0) {
            ret.append(CLOSEOPTIONSYNTAX);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildAdminCmdString - " + ret.toString());
        }
        return ret.toString();
    }

    public Object stringToObjectArray(String inputString, Class objectClass) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToObjectArray");
        }
        Object result = null;
        ArrayList<String> alist = new ArrayList<String>();
        Class<?> elementType = null;
        if (!objectClass.isArray()) {
            return new Object();
        }
        elementType = objectClass.getComponentType();
        String input = inputString;
        if (input.startsWith("{") && input.endsWith("}")) {
            input = input.substring(1, input.length() - 1);
        }
        if (input != null) {
            StringTokenizer strtok = new StringTokenizer(input, "{} ", true);
            String next = null;
            int nesting = 0;
            StringBuffer buf = new StringBuffer();
            while (strtok.hasMoreTokens()) {
                next = strtok.nextToken();
                if (next.equals("{")) {
                    ++nesting;
                } else if (next.equals("}")) {
                    --nesting;
                }
                buf.append(next);
                if (buf.toString().startsWith("\"") && !next.endsWith("\"")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "buf to string:" + buf.toString());
                }
                if (nesting != 0) continue;
                String newone = buf.toString().trim();
                if (!newone.equals("")) {
                    if (newone.startsWith("\"") && newone.endsWith("\"") || newone.startsWith("{") && newone.endsWith("}")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "removing quotes from \"" + newone + "\"");
                        }
                        newone = newone.substring(1, newone.length() - 1);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding " + newone);
                    }
                    alist.add(newone);
                }
                buf = new StringBuffer();
            }
            StringHandler handler = HandlerRegistry.getHandler(elementType);
            if (handler != null) {
                result = Array.newInstance(elementType, alist.size());
                for (int i = 0; i < alist.size(); ++i) {
                    try {
                        Array.set(result, i, handler.formValidObject((String)alist.get(i), elementType, "jacl"));
                        continue;
                    }
                    catch (com.ibm.websphere.scripting.ScriptingException ex) {
                        throw new ScriptingException(ex.toString());
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToObjectArray - " + result.toString());
        }
        return result;
    }

    public Attribute stringToAttribute(String text) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToAttribute string: " + text);
        }
        boolean outermost = false;
        if (debugbuf == null) {
            outermost = true;
            debugbuf = new StringBuffer();
            staticText = text;
        }
        StringTokenizer strtok = new StringTokenizer(text, "{} ", true);
        Attribute attr = null;
        try {
            while (strtok.hasMoreTokens()) {
                String next = strtok.nextToken(this.getTokenizerString());
                debugbuf.append(next);
                String key = next;
                String value = this.getString(strtok, " ");
                while (strtok.hasMoreTokens()) {
                    next = strtok.nextToken();
                    debugbuf.append(next);
                    if (next.equals(" ")) continue;
                }
                if (value.indexOf(" {") != -1) {
                    StringBuffer temp = new StringBuffer();
                    temp.append("{");
                    temp.append(value);
                    temp.append("}");
                    value = temp.toString();
                }
                attr = new Attribute(key, value);
            }
        }
        catch (NoSuchElementException nsee) {
            nsee.printStackTrace();
            throw new IllegalArgumentException();
        }
        finally {
            if (outermost) {
                debugbuf = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToAttribute", attr.toString());
        }
        return attr;
    }
}

