/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.scripting.AdminAppClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class FileTools {
    private static TraceComponent tc = Tr.register(AdminAppClient.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");

    public static boolean compareFileNames(File file1, File file2) {
        return file1.getName().equalsIgnoreCase(file2.getName());
    }

    public static void copyDirectory(File destinationDir, File sourceDir) throws FileNotFoundException, IOException {
        String[] children;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyDirectory");
        }
        if (sourceDir.isDirectory() && (children = sourceDir.list()) != null) {
            for (int i = 0; i < children.length; ++i) {
                File child = new File(sourceDir, children[i]);
                if (child.isFile()) {
                    FileTools.copyFile(new File(destinationDir, children[i]), child);
                    continue;
                }
                File destinationChild = new File(destinationDir, children[i]);
                if (!destinationChild.exists()) {
                    destinationChild.mkdir();
                }
                FileTools.copyDirectory(destinationChild, child);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyDirectory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File destinationFile, File sourceFile) throws FileNotFoundException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyFile");
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(sourceFile);
            int size = (int)sourceFile.length();
            boolean done = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "File length is " + size);
            }
            while (size > 210000000) {
                size /= 2;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "size is reduced to " + size);
            }
            while (!done) {
                out = new FileOutputStream(destinationFile, false);
                if (size == 0) {
                    done = true;
                    continue;
                }
                try {
                    byte[] data = new byte[size];
                    int bytesRead = in.read(data);
                    while (bytesRead != -1) {
                        out.write(data, 0, bytesRead);
                        bytesRead = in.read(data);
                    }
                    done = true;
                }
                catch (OutOfMemoryError ofme) {
                    size /= 2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "size is reduced to " + size);
                    }
                    out.close();
                }
            }
            out.flush();
            out.close();
            in.close();
        }
        finally {
            block25: {
                block24: {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) break block24;
                            Tr.debug(tc, "ignoring exception on input close.");
                        }
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block25;
                        Tr.debug(tc, "ignoring exception on output close.");
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile");
        }
    }

    public static void removeDirectory(File targetDir) {
        String[] children;
        if (targetDir.isDirectory() && (children = targetDir.list()) != null) {
            for (int i = 0; i < children.length; ++i) {
                File child = new File(targetDir, children[i]);
                if (child.isFile()) {
                    child.delete();
                    continue;
                }
                FileTools.removeDirectory(child);
            }
        }
        targetDir.delete();
    }

    public static void scanDirectory(File tree, String searchString, ArrayList result) {
        String[] children;
        if (tree.isDirectory() && (children = tree.list()) != null) {
            for (int i = 0; i < children.length; ++i) {
                File child = new File(tree, children[i]);
                if (!child.isDirectory()) continue;
                if (child.getName().equalsIgnoreCase(searchString)) {
                    result.add(child.getAbsolutePath());
                }
                FileTools.scanDirectory(child, searchString, result);
            }
        }
    }

    public static void scanFiles(File tree, ArrayList result) {
        String[] children;
        if (tree.isDirectory() && (children = tree.list()) != null) {
            for (int i = 0; i < children.length; ++i) {
                File child = new File(tree, children[i]);
                if (child.isFile()) {
                    result.add(child.getAbsolutePath());
                    continue;
                }
                FileTools.scanFiles(child, result);
            }
        }
    }
}

