/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.scripting.ScriptingExtension;
import com.ibm.websphere.scripting.StringHandler;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.scripting.HandlerRegistry;
import com.ibm.ws.scripting.ObjectNameHelper;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ExtensionHelper {
    private static TraceComponent tc = Tr.register(ExtensionHelper.class);
    private static ClassLoader legacyClassLoader;

    public static void processRegisterBeansInExtensions(BSFManager mgr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processRegisterBeansInExtensions");
        }
        Vector providers = ExtensionHelper.getScriptingExtension(true);
        for (ProviderInfo providerInfo : providers) {
            StringWriter sw;
            try {
                Class c = null;
                if (providerInfo.bundle != null) {
                    final Bundle bundle = providerInfo.bundle;
                    final String className = providerInfo.className.trim();
                    c = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return bundle.loadClass(className);
                        }
                    });
                } else {
                    c = providerInfo.classLoader.loadClass(providerInfo.className.trim());
                }
                ScriptingExtension provider = (ScriptingExtension)c.newInstance();
                mgr.declareBean(provider.getBeanName(), provider, provider.getClass());
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, "Registering provider object " + provider.getBeanName() + " with BSF");
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                System.out.println(ObjectNameHelper.getFormattedMessage("WASX7371E", "Exception locating the class for {0} provided in extension: {1}", new Object[]{providerInfo.className.trim(), e.toString()}));
                StringWriter sw2 = new StringWriter();
                e.printStackTrace(new PrintWriter(sw2));
                Tr.error(tc, "WASX7371E", new Object[]{providerInfo.className.trim(), sw2.toString()});
            }
            catch (BSFException ex) {
                System.out.println(ObjectNameHelper.getFormattedMessage("WASX7370E", "Exception registering bean {0} provided in extension: {1}", new Object[]{providerInfo.className.trim(), ex.toString()}));
                sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                Tr.error(tc, "WASX7370E", new Object[]{providerInfo.className.trim(), sw.toString()});
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println(ObjectNameHelper.getFormattedMessage("WASX7371E", "Exception locating the class for {0} provided in extension: {1}", new Object[]{providerInfo.className.trim(), cnfe.toString()}));
                sw = new StringWriter();
                cnfe.printStackTrace(new PrintWriter(sw));
                Tr.error(tc, "WASX7371E", new Object[]{providerInfo.className.trim(), sw.toString()});
            }
            catch (InstantiationException ie) {
                System.out.println("Exception instantiate the class for " + providerInfo.className);
                System.out.println(ObjectNameHelper.getFormattedMessage("WASX7372E", "Exception instantiating class {0} provided in extension: {1}", new Object[]{providerInfo.className.trim(), ie.toString()}));
                sw = new StringWriter();
                ie.printStackTrace(new PrintWriter(sw));
                Tr.error(tc, "WASX7372E", new Object[]{providerInfo.className.trim(), sw.toString()});
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processRegisterBeansInExtensions");
        }
    }

    public static void processRegisterHandlersInExtensions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processRegisterHandlersInExtensions");
        }
        Vector handlers = ExtensionHelper.getScriptingExtension(false);
        String currentClassName = null;
        for (HandlerInfo handler : handlers) {
            StringWriter sw;
            try {
                Class cImpl = null;
                currentClassName = handler.className.trim();
                if (handler.bundle != null) {
                    final Bundle bundle = handler.bundle;
                    final String className = currentClassName;
                    cImpl = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return bundle.loadClass(className);
                        }
                    });
                } else {
                    cImpl = handler.classLoader.loadClass(currentClassName);
                }
                StringHandler stringHandler = (StringHandler)cImpl.newInstance();
                Class cType = null;
                currentClassName = handler.typeName.trim();
                if (handler.bundle != null) {
                    final Bundle bundle = handler.bundle;
                    final String className = currentClassName;
                    cType = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return bundle.loadClass(className);
                        }
                    });
                } else {
                    cType = handler.classLoader.loadClass(currentClassName);
                }
                HandlerRegistry.registerHandler(stringHandler, cType);
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                System.out.println(ObjectNameHelper.getFormattedMessage("WASX7371E", "Exception locating the class for {0} provided in extension: {1}", new Object[]{currentClassName, e.toString()}));
                StringWriter sw2 = new StringWriter();
                e.printStackTrace(new PrintWriter(sw2));
                Tr.error(tc, "WASX7371E", new Object[]{currentClassName, sw2.toString()});
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println(ObjectNameHelper.getFormattedMessage("WASX7371E", "Exception locating the class for {0} provided in extension: {1}", new Object[]{handler.className.trim(), cnfe.toString()}));
                sw = new StringWriter();
                cnfe.printStackTrace(new PrintWriter(sw));
                Tr.error(tc, "WASX7371E", new Object[]{handler.className.trim(), sw.toString()});
            }
            catch (InstantiationException ie) {
                System.out.println(ObjectNameHelper.getFormattedMessage("WASX7372E", "Exception instantiating class {0} provided in extension: {1}", new Object[]{handler.className.trim(), ie.toString()}));
                sw = new StringWriter();
                ie.printStackTrace(new PrintWriter(sw));
                Tr.error(tc, "WASX7372E", new Object[]{handler.className.trim(), sw.toString()});
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processRegisterHandlersInExtensions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector getScriptingExtension(boolean beanProvider) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getScriptingExtension " + beanProvider);
        }
        Vector providers = ExtensionHelper.getEclipseScriptingExtensions(beanProvider);
        legacyClassLoader = Thread.currentThread().getContextClassLoader();
        if (!(legacyClassLoader instanceof ExtClassLoader)) {
            legacyClassLoader = ExtClassLoader.getInstance();
        }
        try {
            Enumeration<URL> e = null;
            try {
                e = legacyClassLoader.getResources("scripting-extension.xml");
            }
            catch (IOException ioe) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception loading helpers:" + ioe.toString());
                }
                ioe.printStackTrace();
            }
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            SAXParser parser2 = null;
            try {
                parser2 = saxFactory.newSAXParser();
            }
            catch (ParserConfigurationException pce) {
                pce.printStackTrace();
            }
            catch (SAXException se) {
                se.printStackTrace();
            }
            if (parser2 == null) {
                return providers;
            }
            ExtensionBeanHandler handler = new ExtensionBeanHandler();
            InputStream is = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing providers ...");
            }
            while (e.hasMoreElements()) {
                URL u = e.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Next provider URL: " + u.toString());
                }
                try {
                    is = u.openStream();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                try {
                    handler.setURL(u);
                    parser2.parse(is, (DefaultHandler)handler);
                    if (beanProvider) {
                        for (ProviderInfo providerInfo : handler.getProviders().values()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Next Provider Detail:" + providerInfo.toString());
                            }
                            providers.add(providerInfo);
                        }
                        continue;
                    }
                    for (HandlerInfo handlerInfo : handler.getHandlers().values()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Next Handler Detail:" + handlerInfo.toString());
                        }
                        providers.add(handlerInfo);
                    }
                }
                catch (SAXParseException parseException) {
                    StringWriter sw = new StringWriter();
                    parseException.printStackTrace(new PrintWriter(sw));
                    System.out.println(ObjectNameHelper.getFormattedMessage("EXTENSION_PARSER_EXCEPTION_MESSAGE", "{0} in {1} at line {2} column {3}:\n{4}", new Object[]{parseException.getMessage(), u.getFile(), new Integer(parseException.getLineNumber()), new Integer(parseException.getColumnNumber()), new String()}));
                    Tr.error(tc, "EXTENSION_PARSER_EXCEPTION_MESSAGE", new Object[]{parseException.getMessage(), u.getFile(), new Integer(parseException.getLineNumber()), new Integer(parseException.getColumnNumber()), sw.toString()});
                }
                catch (SAXException saxException) {
                    if (saxException.getException() != null) {
                        saxException.getException().printStackTrace();
                        continue;
                    }
                    saxException.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScriptingExtension");
        }
        return providers;
    }

    private static Vector getEclipseScriptingExtensions(boolean beanProvider) {
        Vector<Object> providers = new Vector<Object>();
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (registry == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to get eclipse extension registry");
            }
        } else {
            String epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".scripting-extension";
            IExtensionPoint extensionPoint = registry.getExtensionPoint(epid);
            if (extensionPoint == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to get extension point - " + epid);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing extension point - " + epid);
                }
                IExtension[] extensions = extensionPoint.getExtensions();
                for (int i = 0; i < extensions.length; ++i) {
                    IExtension extension2 = extensions[i];
                    String id = extension2.getNamespace();
                    Bundle bundle = Platform.getBundle((String)id);
                    ClassLoader bundleClassLoader = bundle.getClass().getClassLoader();
                    IConfigurationElement[] scriptingExtensionElements = extension2.getConfigurationElements();
                    if (scriptingExtensionElements.length != 1) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Invalid number of scriptingExtension elements - " + scriptingExtensionElements.length);
                        continue;
                    }
                    IConfigurationElement scriptingExtensionElement = scriptingExtensionElements[0];
                    if (!scriptingExtensionElement.getName().equals("scriptingExtension")) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Invalid element name - expecting <scriptingExtension>, got <" + scriptingExtensionElement.getName() + ">");
                        continue;
                    }
                    IConfigurationElement[] categoryElements = scriptingExtensionElement.getChildren();
                    block1: for (int j = 0; j < categoryElements.length; ++j) {
                        String className;
                        IConfigurationElement categoryElement = categoryElements[j];
                        if (categoryElement.getName().equals("beanProvider")) {
                            if (!beanProvider) continue;
                            IConfigurationElement[] beanImplClassElements = categoryElement.getChildren();
                            if (beanImplClassElements.length != 1) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Invalid number of beanImplClass elements - " + beanImplClassElements.length);
                                continue;
                            }
                            IConfigurationElement beanImplClassElement = beanImplClassElements[0];
                            if (!beanImplClassElement.getName().equals("beanImplClass")) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Invalid element name - expecting <beanImplClass>, got <" + beanImplClassElement.getName() + ">");
                                continue;
                            }
                            className = beanImplClassElement.getValue();
                            if (className == null) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Missing class name for <beanImplClass>");
                                continue;
                            }
                            ProviderInfo providerInfo = new ProviderInfo();
                            providerInfo.className = className;
                            providerInfo.bundle = bundle;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Next Provider Detail:" + providerInfo.toString());
                            }
                            providers.add(providerInfo);
                            continue;
                        }
                        if (categoryElement.getName().equals("typeHandler")) {
                            if (beanProvider) continue;
                            boolean foundTypeImplClass = false;
                            boolean foundTypeClass = false;
                            className = null;
                            String typeName = null;
                            IConfigurationElement[] typeHandlerChildren = categoryElement.getChildren();
                            for (int k = 0; k < typeHandlerChildren.length; ++k) {
                                IConfigurationElement typeHandlerChild = typeHandlerChildren[k];
                                if (typeHandlerChild.getName().equals("typeImplClass")) {
                                    if (foundTypeImplClass) {
                                        if (!tc.isDebugEnabled()) continue block1;
                                        Tr.debug(tc, "Duplicate element <typeImplClass>");
                                        continue block1;
                                    }
                                    foundTypeImplClass = true;
                                    className = typeHandlerChild.getValue();
                                    if (className != null) continue;
                                    if (!tc.isDebugEnabled()) continue block1;
                                    Tr.debug(tc, "Missing class name for <typeImplClass>");
                                    continue block1;
                                }
                                if (typeHandlerChild.getName().equals("typeClass")) {
                                    if (foundTypeClass) {
                                        if (!tc.isDebugEnabled()) continue block1;
                                        Tr.debug(tc, "Duplicate element <typeClass>");
                                        continue block1;
                                    }
                                    foundTypeClass = true;
                                    typeName = typeHandlerChild.getValue();
                                    if (typeName != null) continue;
                                    if (!tc.isDebugEnabled()) continue block1;
                                    Tr.debug(tc, "Missing type name for <typeClass>");
                                    continue block1;
                                }
                                if (!tc.isDebugEnabled()) continue block1;
                                Tr.debug(tc, "Invalid element name - expecting <typeImplClass> or <typeClass>, got <" + typeHandlerChild.getName() + ">");
                                continue block1;
                            }
                            if (!foundTypeImplClass) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Missing <typeImplClass> element");
                                continue;
                            }
                            if (!foundTypeClass) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Missing <typeClass> element");
                                continue;
                            }
                            HandlerInfo handlerInfo = new HandlerInfo();
                            handlerInfo.className = className;
                            handlerInfo.classLoader = bundleClassLoader;
                            handlerInfo.typeName = typeName;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Next Handler Detail:" + handlerInfo.toString());
                            }
                            providers.add(handlerInfo);
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Invalid element name - expecting <beanProvider> or <typeHandler>, but got <" + categoryElement.getName() + ">");
                    }
                }
            }
        }
        return providers;
    }

    static class ExtensionBeanHandler
    extends DefaultHandler {
        Locator locator;
        Map providers = new HashMap();
        Map handlers = new HashMap();
        ProviderInfo currentProvider;
        HandlerInfo currentHandler;
        URL currentURL;
        StringBuffer value = new StringBuffer();

        public void setURL(URL url) {
            this.currentURL = url;
        }

        public Map getProviders() {
            return this.providers;
        }

        public Map getHandlers() {
            return this.handlers;
        }

        public void startDocument() throws SAXException {
            this.providers.clear();
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.value.setLength(0);
            if (qName.equals("scriptingExtension")) {
                this.providers.clear();
                this.handlers.clear();
                this.currentProvider = null;
                this.currentHandler = null;
            }
            if (qName.equals("beanProvider")) {
                if (this.currentProvider != null) {
                    return;
                }
                this.currentProvider = new ProviderInfo();
            }
            if (qName.equals("typeHandler")) {
                if (this.currentHandler != null) {
                    return;
                }
                this.currentHandler = new HandlerInfo();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("beanProvider") || qName.equals("beanImplClass") ? this.currentProvider == null : (qName.equals("typeHandler") || qName.equals("typeImplClass") || qName.equals("typeClass")) && this.currentHandler == null) {
                return;
            }
            if (qName.equals("beanProvider")) {
                if (this.currentProvider.className != null) {
                    ProviderInfo pi = this.providers.put(this.currentProvider.className, this.currentProvider);
                    if (pi != null) {
                        System.out.println(ObjectNameHelper.getFormattedMessage("WASX7373W", "Duplicate implementation class entry, {0}, found in {1} at line {2}", new Object[]{this.currentProvider.className.trim(), this.currentURL, new Integer(this.locator.getLineNumber())}));
                    }
                } else {
                    System.out.println(ObjectNameHelper.getFormattedMessage("WASX7374W", "Missing element type {0} in {1} at line {2}. Skipping the {3} element.", new Object[]{"<beanImplClass>", this.currentURL, new Integer(this.locator.getLineNumber()), "<beanProvider>"}));
                }
                this.currentProvider = null;
            } else if (qName.equals("beanImplClass")) {
                if (this.currentProvider.className != null) throw new SAXParseException(ObjectNameHelper.getFormattedMessage("WASX7375E", "element type {0} is already defined", new Object[]{"<beanImplClass>"}), this.locator);
                this.currentProvider.className = this.value.toString();
                this.currentProvider.classLoader = legacyClassLoader;
            } else if (qName.equals("typeHandler")) {
                if (this.currentHandler.className != null && this.currentHandler.typeName != null) {
                    HandlerInfo pi = this.handlers.put(this.currentHandler.typeName, this.currentHandler);
                    if (pi != null) {
                        System.out.println(ObjectNameHelper.getFormattedMessage("WASX7377W", "Duplicate type handler class entry, {0}, found in {1} at line {2}", new Object[]{this.currentHandler.typeName.trim(), this.currentURL, new Integer(this.locator.getLineNumber())}));
                    }
                } else {
                    if (this.currentHandler.className == null) {
                        System.out.println(ObjectNameHelper.getFormattedMessage("WASX7374W", "Missing element type {0} in {1} at line {2}. Skipping the {3} element.", new Object[]{"<typeImplClass>", this.currentURL, new Integer(this.locator.getLineNumber()), "<typeHandler>"}));
                    }
                    if (this.currentHandler.typeName == null) {
                        System.out.println(ObjectNameHelper.getFormattedMessage("WASX7374W", "Missing element type {0} in {1} at line {2}. Skipping the {3} element.", new Object[]{"<typeClass>", this.currentURL, new Integer(this.locator.getLineNumber()), "<typeHandler>"}));
                    }
                }
                this.currentHandler = null;
            } else if (qName.equals("typeImplClass")) {
                if (this.currentHandler.className != null) throw new SAXParseException(ObjectNameHelper.getFormattedMessage("WASX7375E", "element type {0} is already defined", new Object[]{"<typeImplClass>"}), this.locator);
                this.currentHandler.className = this.value.toString();
                this.currentHandler.classLoader = legacyClassLoader;
            } else if (qName.equals("typeClass")) {
                if (this.currentHandler.typeName != null) throw new SAXParseException(ObjectNameHelper.getFormattedMessage("WASX7375E", "element type {0} is already defined", new Object[]{"<typeClass>"}), this.locator);
                this.currentHandler.typeName = this.value.toString();
            } else if (!qName.equals("scriptingExtension")) {
                throw new SAXParseException(ObjectNameHelper.getFormattedMessage("WASX7376E", "Invalid element end-tag: {0}", new Object[]{qName}), this.locator);
            }
            this.value.setLength(0);
        }

        public void warning(SAXParseException arg0) throws SAXException {
            this.currentProvider = null;
        }

        public void error(SAXParseException arg0) throws SAXException {
            this.currentProvider = null;
        }

        public void fatalError(SAXParseException arg0) throws SAXException {
            this.providers.clear();
            this.handlers.clear();
            this.currentProvider = null;
            this.currentHandler = null;
            throw arg0;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.value.append(ch, start, length);
        }

        public void setDocumentLocator(Locator arg0) {
            this.locator = arg0;
        }
    }

    static class HandlerInfo {
        public String className;
        public ClassLoader classLoader;
        public Bundle bundle;
        public String typeName;

        HandlerInfo() {
        }

        public String toString() {
            return "HandlerInfo{className=" + this.className + ", typeName=" + this.typeName + ", classLoader=" + this.classLoader.toString() + "}";
        }
    }

    static class ProviderInfo {
        public String className;
        public ClassLoader classLoader;
        public Bundle bundle;

        ProviderInfo() {
        }

        public String toString() {
            String classLoaderString = null;
            if (this.classLoader != null) {
                classLoaderString = this.classLoader.toString();
            }
            String bundleName = null;
            if (this.bundle != null) {
                bundleName = this.bundle.getSymbolicName();
            }
            return "ProviderInfo{className=" + this.className + ", classLoader=" + classLoaderString + ", bundle name=" + bundleName + "}";
        }
    }
}

