/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AttrInfo;
import com.ibm.ws.scripting.BaseAttrHelper;
import com.ibm.ws.scripting.ConfigHelper;
import com.ibm.ws.scripting.ConfigNameCache;
import com.ibm.ws.scripting.ScriptingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.management.Attribute;

public class EnumArrayAttrHelper
extends BaseAttrHelper {
    private static TraceComponent tc = Tr.register(EnumArrayAttrHelper.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");

    public EnumArrayAttrHelper(ConfigHelper configHelper, ConfigNameCache nameCache, AbstractShell shell) {
        super(configHelper, nameCache, shell);
    }

    public String formDisplayString(Attribute attr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formDisplayString");
        }
        StringBuffer buf = new StringBuffer();
        String attrName = attr.getName();
        buf.append(this._shell.getLangUtils().attributeToString(attrName, this.getStringValue(attr.getValue())));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formDisplayString - " + buf.toString());
        }
        return buf.toString();
    }

    public Attribute formValidAttribute(AttrInfo ai, Attribute attr) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formValidAttribute");
        }
        ArrayList<String> aList = new ArrayList<String>();
        Hashtable enuminfo = ai.enumInfo();
        String aName = attr.getName();
        String aVal = null;
        try {
            aVal = (String)attr.getValue();
        }
        catch (ClassCastException cce) {
            this.throwBadValException(aName, enuminfo);
        }
        StringTokenizer tok = new StringTokenizer(aVal, " ", false);
        while (tok.hasMoreTokens()) {
            String temp = tok.nextToken();
            String next = this.correctStringENUMToString(temp);
            if (enuminfo == null) continue;
            Integer eValue = (Integer)enuminfo.get(next);
            if (eValue == null) {
                this.throwBadValException(aName, enuminfo);
            }
            aList.add(next);
        }
        Attribute retattr = new Attribute(aName, aList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formValidAttribute");
        }
        return retattr;
    }

    public String correctStringENUMToString(String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "correctStringENUMToString");
        }
        if (value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "correctStringENUMToString");
        }
        return value;
    }

    public boolean isValid(String type, String attrName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValid");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValid");
        }
        return true;
    }

    private void throwBadValException(String aName, Hashtable enuminfo) throws ScriptingException {
        StringBuffer sdata = new StringBuffer();
        Enumeration keys = enuminfo.keys();
        while (keys.hasMoreElements()) {
            sdata.append(keys.nextElement());
            if (!keys.hasMoreElements()) continue;
            sdata.append(", ");
        }
        this._shell.setAndThrowScriptingException("WASX7087E", "Invalid value for attribute specified.", new Object[]{aName, sdata.toString()});
    }
}

