/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.AdminControlClient;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.TestConnectionCommand;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DataSourceCfgHelperProxy {
    private static TraceComponent tc = Tr.register(TestConnectionCommand.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private AbstractShell _shell = null;
    private AdminClient _client = null;
    private AdminControlClient _control = null;
    private String _node = null;
    private String _configId = null;
    private ObjectName dataSourceCfgHelperON = null;
    private AdminConfigClient _configClient = null;
    private String _app = null;
    private String _cluster = null;
    private String nl = System.getProperty("line.separator");
    private boolean isAppScope = false;
    private boolean isClusterScope = false;
    private Hashtable targetMap = null;
    public static String[] SIGNATURE_String = null;
    public static final String DATASOURCECFGHELPER_ON = "WebSphere:type=DataSourceCfgHelper";
    private static DataSourceCfgHelperProxy _self = null;

    public static DataSourceCfgHelperProxy getInstance() {
        return _self;
    }

    public DataSourceCfgHelperProxy(AbstractShell shell, AdminClient client, AdminControlClient control, String configId) throws ConnectorException, AdminException {
        int clusters;
        this._client = client;
        this._configId = configId;
        this._shell = shell;
        this._control = control;
        this._node = null;
        this._configClient = AdminConfigClient.getInstance();
        SIGNATURE_String = new String[1];
        DataSourceCfgHelperProxy.SIGNATURE_String[0] = "java.lang.String";
        int applications = this._configId.indexOf("/applications/");
        if (applications >= 0) {
            this.isAppScope = true;
        }
        if ((clusters = this._configId.indexOf("/clusters/")) >= 0) {
            this.isClusterScope = true;
        }
        if (this.isAppScope) {
            this.initAppScope();
        } else if (this.isClusterScope) {
            this.initClusterScope();
        } else {
            this.init();
        }
        _self = this;
    }

    public boolean isRunning() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRunning");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRunning");
        }
        return this.dataSourceCfgHelperON != null;
    }

    private void init() throws ScriptingException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        ObjectName tempON = null;
        try {
            String processName = "nodeagent";
            if (this._configId != null) {
                int servers;
                int nodes = this._configId.indexOf("/nodes/");
                if (nodes >= 0) {
                    int nodesEnd = this._configId.indexOf("/", nodes + 7);
                    if (nodesEnd < 0) {
                        nodesEnd = this._configId.indexOf(124, nodes + 7);
                    }
                    if (nodesEnd < 0) {
                        this._shell.setAndThrowScriptingException("WASX7306E", "Cannot test: node unknown", new Object[]{this._configId});
                    }
                    this._node = this._configId.substring(nodes + 7, nodesEnd);
                } else {
                    this._node = this._control.getNode();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node is " + this._node);
                }
                if ((servers = this._configId.indexOf("/servers/")) >= 0) {
                    int serverEnd = this._configId.indexOf(124, servers + 9);
                    if (serverEnd < 0) {
                        this._shell.setAndThrowScriptingException("WASX7306E", "Cannot test: node unknown", new Object[]{this._configId});
                    }
                    processName = this._configId.substring(servers + 9, serverEnd);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "server is " + processName);
                    }
                }
            }
            Set helpers = null;
            while (helpers == null && processName != null) {
                if (processName.equals("llllocal")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "using current process " + this._control.getProcessName());
                    }
                    tempON = new ObjectName("WebSphere:type=DataSourceCfgHelper,node=" + this._control.getNode() + ",process=" + this._control.getProcessName() + ",*");
                } else {
                    tempON = new ObjectName("WebSphere:type=DataSourceCfgHelper,node=" + this._node + ",process=" + processName + ",*");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "objectname is " + tempON);
                }
                helpers = this._client.queryNames(tempON, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "helpers are " + helpers);
                }
                if (helpers != null && !helpers.isEmpty()) {
                    Object[] onames = helpers.toArray();
                    for (int i = 0; i < onames.length; ++i) {
                        this.dataSourceCfgHelperON = (ObjectName)onames[i];
                    }
                    continue;
                }
                if (this._node == null || processName.equals("llllocal")) {
                    processName = null;
                    continue;
                }
                if (processName.equals("nodeagent")) {
                    processName = "llllocal";
                    helpers = null;
                    continue;
                }
                processName = "nodeagent";
                helpers = null;
            }
            if (this.dataSourceCfgHelperON != null && this.dataSourceCfgHelperON.getKeyProperty("version").equals("5.0")) {
                this._shell.setAndThrowScriptingException("WASX7387E", "TestConnection not supported when connection to 5.0 server", new Object[0]);
            }
        }
        catch (MalformedObjectNameException mone) {
            throw new ScriptingException(mone.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init - " + this.dataSourceCfgHelperON);
        }
    }

    public Integer testConnection(String configId) throws AdminException, ConnectorException {
        Integer ret;
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "testConnection");
            }
            ObjectName tempON = null;
            try {
                Object[] oarray = new Object[]{configId};
                String processName = "nodeagent";
                if ((this.isAppScope || this.isClusterScope) && this.targetMap != null) {
                    boolean isAllOK = true;
                    Enumeration nodes = this.targetMap.keys();
                    while (nodes.hasMoreElements()) {
                        this._node = (String)nodes.nextElement();
                        ArrayList pList = (ArrayList)this.targetMap.get(this._node);
                        for (int i = 0; pList != null && i < pList.size(); ++i) {
                            String msg;
                            processName = (String)pList.get(i);
                            Set helpers = null;
                            while (helpers == null && processName != null) {
                                if (processName.equals("llllocal")) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "using current process " + this._control.getProcessName());
                                    }
                                    this._node = this._control.getNode();
                                    processName = this._control.getProcessName();
                                }
                                tempON = new ObjectName("WebSphere:type=DataSourceCfgHelper,node=" + this._node + ",process=" + processName + ",*");
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "objectname is " + tempON);
                                }
                                helpers = this._client.queryNames(tempON, null);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "helpers are " + helpers);
                                }
                                if (helpers != null && !helpers.isEmpty()) {
                                    Object[] onames = helpers.toArray();
                                    for (int j = 0; j < onames.length; ++j) {
                                        this.dataSourceCfgHelperON = (ObjectName)onames[j];
                                    }
                                    continue;
                                }
                                if (this._node == null || processName.equals("llllocal")) {
                                    processName = null;
                                    continue;
                                }
                                if (processName.equals("nodeagent")) {
                                    processName = "llllocal";
                                    helpers = null;
                                    continue;
                                }
                                processName = "nodeagent";
                                helpers = null;
                            }
                            Integer subRet = (Integer)this._client.invoke(this.dataSourceCfgHelperON, "testConnection", oarray, SIGNATURE_String);
                            if (subRet == 0) {
                                msg = this._shell.getFormattedMessage("WASX7467I", new Object[]{this._node, processName}, "Connection to provided datasource on node " + this._node + " process " + processName + " was successful.");
                                System.out.println(msg);
                                continue;
                            }
                            msg = this._shell.getFormattedMessage("WASX7468E", new Object[]{this._node, processName}, "Connection to provided datasource on node " + this._node + " process " + processName + " failed.");
                            isAllOK = false;
                            System.out.println(msg);
                        }
                    }
                    ret = isAllOK ? new Integer(0) : new Integer(1);
                    break block17;
                }
                ret = (Integer)this._client.invoke(this.dataSourceCfgHelperON, "testConnection", oarray, SIGNATURE_String);
            }
            catch (JMException e) {
                throw new AdminException(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "testConnection");
        }
        return ret;
    }

    private void initAppScope() throws ScriptingException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initAppScope");
        }
        ObjectName tempON = null;
        this.targetMap = null;
        try {
            String processName = "nodeagent";
            if (this._configId != null) {
                int app;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DataSource config id is " + this._configId);
                }
                if ((app = this._configId.indexOf("/applications/")) >= 0) {
                    int appEnd = this._configId.indexOf(".ear");
                    if (appEnd < 0) {
                        this._shell.setAndThrowScriptingException("WASX7306E", "Cannot test: node unknown", new Object[]{this._configId});
                    }
                    this._app = this._configId.substring(app + 14, appEnd);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "application name is " + this._app);
                }
                this.targetMap = new Hashtable();
                String appId = this._configClient.getid("/Deployment:" + this._app);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "application config ID is " + appId);
                }
                String cResult = this._configClient.list("ClusteredTarget", appId);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cluster target string is " + cResult);
                }
                if (!cResult.equals("")) {
                    String[] cList = cResult.split(this.nl);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cluster target length is " + cList.length);
                    }
                    for (int i = 0; cList != null && i < cList.length; ++i) {
                        String cConfigID = cList[i];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "cluster config id is " + cConfigID);
                        }
                        String cName = this._configClient.showAttribute(cConfigID, "name");
                        String[] memberList = this._configClient.getid("/ServerCluster:" + cName + "/ClusterMember:/").split(this.nl);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "cluster member target list is " + memberList.toString());
                        }
                        for (int j = 0; memberList != null && j < memberList.length; ++j) {
                            ArrayList pList;
                            String mConfigID = memberList[j];
                            this._node = this._configClient.showAttribute(mConfigID, "nodeName");
                            processName = this._configClient.showAttribute(mConfigID, "memberName");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "cluster member config id is " + mConfigID);
                                Tr.debug(tc, "nodeName is " + this._node);
                                Tr.debug(tc, "serverName is " + processName);
                            }
                            if (!this.targetMap.containsKey(this._node)) {
                                pList = new ArrayList();
                                pList.add(processName);
                                this.targetMap.put(this._node, pList);
                                continue;
                            }
                            pList = (ArrayList)this.targetMap.get(this._node);
                            pList.add(processName);
                            this.targetMap.put(this._node, pList);
                        }
                    }
                }
                String sResult = this._configClient.list("ServerTarget", appId);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "server target string is " + sResult);
                }
                if (!sResult.equals("")) {
                    String[] sList = sResult.split(this.nl);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "server target length is " + sList.length);
                    }
                    for (int i = 0; sList != null && i < sList.length; ++i) {
                        ArrayList pList;
                        String sConfigID = sList[i];
                        this._node = this._configClient.showAttribute(sConfigID, "nodeName");
                        processName = this._configClient.showAttribute(sConfigID, "name");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "server config id is " + sConfigID);
                            Tr.debug(tc, "nodeName is " + this._node);
                            Tr.debug(tc, "serverName is " + processName);
                        }
                        if (!this.targetMap.containsKey(this._node)) {
                            pList = new ArrayList();
                            pList.add(processName);
                            this.targetMap.put(this._node, pList);
                            continue;
                        }
                        pList = (ArrayList)this.targetMap.get(this._node);
                        pList.add(processName);
                        this.targetMap.put(this._node, pList);
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TargetMap is " + this.targetMap.toString());
            }
            Set helpers = null;
            while (helpers == null && processName != null) {
                if (processName.equals("llllocal")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "using current process " + this._control.getProcessName());
                    }
                    tempON = new ObjectName("WebSphere:type=DataSourceCfgHelper,node=" + this._control.getNode() + ",process=" + this._control.getProcessName() + ",*");
                } else {
                    tempON = new ObjectName("WebSphere:type=DataSourceCfgHelper,node=" + this._node + ",process=" + processName + ",*");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "objectname is " + tempON);
                }
                helpers = this._client.queryNames(tempON, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "helpers are " + helpers);
                }
                if (helpers != null && !helpers.isEmpty()) {
                    Object[] onames = helpers.toArray();
                    for (int i = 0; i < onames.length; ++i) {
                        this.dataSourceCfgHelperON = (ObjectName)onames[i];
                    }
                    continue;
                }
                if (this._node == null || processName.equals("llllocal")) {
                    processName = null;
                    continue;
                }
                if (processName.equals("nodeagent")) {
                    processName = "llllocal";
                    helpers = null;
                    continue;
                }
                processName = "nodeagent";
                helpers = null;
            }
            if (this.dataSourceCfgHelperON != null && this.dataSourceCfgHelperON.getKeyProperty("version").equals("5.0")) {
                this._shell.setAndThrowScriptingException("WASX7387E", "TestConnection not supported when connection to 5.0 server", new Object[0]);
            }
        }
        catch (MalformedObjectNameException mone) {
            throw new ScriptingException(mone.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initAppScope - " + this.dataSourceCfgHelperON);
        }
    }

    private void initClusterScope() throws ScriptingException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initClusterScope");
        }
        ObjectName tempON = null;
        this.targetMap = null;
        try {
            String processName = "nodeagent";
            if (this._configId != null) {
                int cluster;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DataSource config id is " + this._configId);
                }
                if ((cluster = this._configId.indexOf("/clusters/")) >= 0) {
                    int clusterEnd = this._configId.indexOf(124);
                    if (clusterEnd < 0) {
                        this._shell.setAndThrowScriptingException("WASX7306E", "Cannot test: cluster unknown", new Object[]{this._configId});
                    }
                    this._cluster = this._configId.substring(cluster + 10, clusterEnd);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cluster name is " + this._cluster);
                }
                this.targetMap = new Hashtable();
                String clusterId = this._configClient.getid("/ServerCluster:" + this._cluster);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cluster config ID is " + clusterId);
                }
                String memResult = this._configClient.list("ClusterMember", clusterId);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cluster members string is " + memResult);
                }
                if (!memResult.equals("")) {
                    String[] memList = memResult.split(this.nl);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cluster members length is " + memList.length);
                    }
                    for (int i = 0; memList != null && i < memList.length; ++i) {
                        ArrayList pList;
                        String memConfigID = memList[i];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "cluster member config id is " + memConfigID);
                        }
                        this._node = this._configClient.showAttribute(memConfigID, "nodeName");
                        processName = this._configClient.showAttribute(memConfigID, "memberName");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "nodeName is " + this._node);
                            Tr.debug(tc, "serverName is " + processName);
                        }
                        if (!this.targetMap.containsKey(this._node)) {
                            pList = new ArrayList();
                            pList.add(processName);
                            this.targetMap.put(this._node, pList);
                            continue;
                        }
                        pList = (ArrayList)this.targetMap.get(this._node);
                        pList.add(processName);
                        this.targetMap.put(this._node, pList);
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TargetMap is " + this.targetMap.toString());
            }
            Set helpers = null;
            while (helpers == null && processName != null) {
                if (processName.equals("llllocal")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "using current process " + this._control.getProcessName());
                    }
                    tempON = new ObjectName("WebSphere:type=DataSourceCfgHelper,node=" + this._control.getNode() + ",process=" + this._control.getProcessName() + ",*");
                } else {
                    tempON = new ObjectName("WebSphere:type=DataSourceCfgHelper,node=" + this._node + ",process=" + processName + ",*");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "objectname is " + tempON);
                }
                helpers = this._client.queryNames(tempON, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "helpers are " + helpers);
                }
                if (helpers != null && !helpers.isEmpty()) {
                    Object[] onames = helpers.toArray();
                    for (int i = 0; i < onames.length; ++i) {
                        this.dataSourceCfgHelperON = (ObjectName)onames[i];
                    }
                    continue;
                }
                if (this._node == null || processName.equals("llllocal")) {
                    processName = null;
                    continue;
                }
                if (processName.equals("nodeagent")) {
                    processName = "llllocal";
                    helpers = null;
                    continue;
                }
                processName = "nodeagent";
                helpers = null;
            }
            if (this.dataSourceCfgHelperON != null && this.dataSourceCfgHelperON.getKeyProperty("version").equals("5.0")) {
                this._shell.setAndThrowScriptingException("WASX7387E", "TestConnection not supported when connection to 5.0 server", new Object[0]);
            }
        }
        catch (MalformedObjectNameException mone) {
            throw new ScriptingException(mone.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initClusterScope");
        }
    }
}

